/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WBCursorUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.PointerImageAttribute;
import com.elluminate.groupware.whiteboard.attributes.PointerImageData;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DDimension;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.PointerUIInterface;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class PointerToolModel
extends AbstractToolModel
implements Cloneable {
    static Cursor PRESSED_CURSOR = null;
    static final String WBD_NAME = "PointerTool";
    static final String POINTER_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.PointerUI";
    private boolean followmeMode = false;
    protected PointerImageAttribute image = null;
    private PointerImageData oldPointerImageData = null;
    private boolean visible = false;
    private PointerImageData pointerImageData = null;
    private Point mouseLocation = new Point(0, 0);
    private Point hotSpot = new Point(0, 0);

    public static Collection<String> getPointerNameList() {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = PointerImageAttribute.getPointerNames();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public PointerToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public PointerToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.image = new PointerImageAttribute(context);
        this.image.setPanelKey("pointerProperties");
        this.image.setQuickAttribute(false);
        this.toolNeedsInking = true;
        this.stroke.setPanelKey(null);
        this.stroke.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_IMAGEBORDER));
        this.stroke.setStroke(1.0f, 2, 2, 0.0f, null, 0.0f);
        this.color.setName("BorderColor");
        this.color.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_BORDERCOLOR));
        this.color.setPanelKey(null);
        this.registerIfClass("PointerToolModel");
        this.initialized = true;
        this.controllerPaneSelectable = false;
        this.objectExplorerSelectable = false;
        this.deleteOnDisconnect = true;
        this.image.setNeedsEditor(false);
        this.deselectOnDelete = true;
        if (context.getController() != null) {
            Cursor cursor = null;
            try {
                Dimension csize = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
                Image img = I18N.getImage("PointerToolModel.PRESSED_CURSOR");
                if (img != null) {
                    Point hotspot = new Point(0, 0);
                    cursor = WBCursorUtils.createCustomCursor(img, hotspot, "NO CURSOR");
                }
            }
            catch (Throwable ex1) {
                cursor = null;
            }
            if (cursor == null) {
                cursor = Cursor.getPredefinedCursor(1);
            }
            PRESSED_CURSOR = cursor;
        }
    }

    public PointerToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public PointerToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        this.mouseLocation = null;
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public PointerToolModel(WhiteboardContext context, byte[] imageData, String fileName, Rectangle area) {
        this(context);
        this.setTemplate(context);
        this.setBounds(area);
        this.evaluateBounds();
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        PointerToolModel newTool = null;
        String action = e == null ? this.getActionName() : e.getActionCommand();
        try {
            newTool = (PointerToolModel)this.clone(action);
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            newTool = new PointerToolModel(this.context);
        }
        return newTool;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        try {
            return (PointerToolModel)ancestor.clone();
        }
        catch (CloneNotSupportedException ex) {
            return this.toolFactory(screen, container, (ActionEvent)null, reciprocal);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.clone(this.getActionName());
    }

    public Object clone(String actionName) throws CloneNotSupportedException {
        PointerToolModel pointerToolModel = (PointerToolModel)super.clone();
        pointerToolModel.image = (PointerImageAttribute)this.image.clone();
        pointerToolModel.setActionName(actionName);
        pointerToolModel.registerIfClass("PointerToolModel");
        this.setUIInvalid(true);
        return pointerToolModel;
    }

    @Override
    public void setActionName(String actionName) {
        super.setActionName(actionName);
        this.image.setPointerImageName(actionName);
        this.cursor = null;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.addAttribute(this.image);
    }

    @Override
    public void setInConference(boolean inConference) {
        super.setInConference(inConference);
    }

    @Override
    public boolean createOnlyToScreen() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        boolean repaintImage = false;
        try {
            switch (e.getID()) {
                case 501: {
                    this.context.getController().repaint(this);
                    repaintImage = true;
                    this.mouseLocation = e.getPoint();
                    this.setLocation((double)e.getX() - (double)this.hotSpot.x, (double)e.getY() - (double)this.hotSpot.y);
                    this.visible = true;
                    this.context.getController().setCanvasCursor(PRESSED_CURSOR);
                    if (this.isConferenceNode()) {
                        response = 0;
                        break;
                    }
                    response = 6;
                    break;
                }
                case 502: {
                    this.followmeMode = e.getClickCount() >= 2;
                    this.mouseLocation = e.getPoint();
                    this.setLocation((double)e.getX() - (double)this.hotSpot.x, (double)e.getY() - (double)this.hotSpot.y);
                    this.context.getController().setCanvasCursor(this.getDrawingCursor());
                    break;
                }
                case 503: {
                    if (!this.followmeMode) {
                        this.context.getController().setCanvasCursor(this.getDrawingCursor());
                        break;
                    }
                }
                case 506: {
                    this.context.getController().repaint(this);
                    repaintImage = true;
                    this.mouseLocation = e.getPoint();
                    this.setLocation((double)e.getX() - (double)this.hotSpot.x, (double)e.getY() - (double)this.hotSpot.y);
                    this.context.getController().setCanvasCursor(PRESSED_CURSOR);
                    break;
                }
                case 500: {
                    this.context.getController().repaint(this);
                    repaintImage = true;
                    break;
                }
            }
        }
        catch (Exception ex) {
            response = 3;
        }
        if (repaintImage) {
            this.context.getController().repaint(this);
        }
        return response;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.notifyVisibleChange();
            return 3;
        }
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 0;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null && this.context.getController() != null) {
            this.toolUI = this.toolUIFactory(POINTER_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public void endCreating() {
        super.endCreating();
    }

    @Override
    public void quiesceTool() {
        this.toolComplete();
        this.context.getController().repaint(this);
    }

    @Override
    public void toolComplete() {
        this.initialized = false;
        if (this.getObjectID() != null) {
            if (this.isConferenceNode()) {
                this.context.getDataExporter().removeFromConference(this);
            }
            if (this.getParent() != null) {
                this.getParent().remove(this);
                this.delete();
            }
        }
    }

    private Cursor getPressedCursor() {
        return PRESSED_CURSOR;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer msg = new StringBuffer();
        msg.append(super.streamToString(istr));
        return msg.toString();
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.visible = true;
        return this;
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.visible = true;
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        return null;
    }

    @Override
    public void render(Graphics g) {
        if (this.color.getAlpha() > 0) {
            ((PointerUIInterface)((Object)this.getUI())).draw(g, this);
        }
    }

    public void setSize() {
        this.notifyVisibleChange();
        this.pointerImageData = this.image.getPointerImage();
        this.setSize(new DDimension(this.pointerImageData.getImage().getWidth(), this.pointerImageData.getImage().getHeight()));
        this.setUIInvalid(true);
        this.notifySizingChange();
    }

    public PointerImageData getPointerImageData() {
        PointerImageData pointerImageData = this.image.getPointerImage();
        if (this.oldPointerImageData != pointerImageData) {
            this.oldPointerImageData = pointerImageData;
            if (this.mouseLocation != null) {
                this.hotSpot = pointerImageData.getHotspot();
                this.setLocation(this.mouseLocation.x - this.hotSpot.x, this.mouseLocation.y - this.hotSpot.y);
                this.setSize();
            }
        }
        return pointerImageData;
    }

    public PointerImageAttribute getPointerImageAttribute() {
        return this.image;
    }

    @Override
    public void onAttributeChange(AbstractAttribute attribute) {
        super.onAttributeChange(attribute);
        this.getPointerImageData();
    }
}

