/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.PenToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.event.ActionEvent;

public class HighlightToolModel
extends PenToolModel
implements Cloneable {
    static final String TOOL_NAME = "HighlightTool";
    private static final float DEFAULT_OPACITY = 50.0f;

    public HighlightToolModel(WhiteboardContext context) {
        this(context, TOOL_NAME);
    }

    public HighlightToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.stroke.setName("HighlightStroke");
        this.stroke.setAlternateName("ToolStroke");
        this.stroke.setStroke(10.0f, 2, 2, 0.0f, null, 0.0f);
        this.color.setName("HighlightColor");
        this.color.setColor(Color.yellow, 127);
        this.color.setQuickAttribute(true);
        this.stroke.setQuickAttribute(true);
        this.registerIfClass("HighlightToolModel");
    }

    public HighlightToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context, TOOL_NAME);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public HighlightToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        try {
            return (HighlightToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            return new HighlightToolModel(this.context);
        }
    }

    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal) {
        return new HighlightToolModel(this.context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HighlightToolModel highlightToolModel = (HighlightToolModel)super.clone();
        highlightToolModel.registerIfClass("HighlightToolModel");
        return highlightToolModel;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }
}

