/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DDimension;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.GeometryUtils;
import com.elluminate.groupware.whiteboard.dataModel.NodeList;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeContainer;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.VisibleObject;
import com.elluminate.groupware.whiteboard.listeners.VisibleAttributeChangeListener;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.GroupToolChangeEvent;
import com.elluminate.groupware.whiteboard.tools.GroupToolChangeListener;
import com.elluminate.groupware.whiteboard.tools.SwingSupport;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Content;

public class GroupToolModel
extends AbstractToolModel
implements Cloneable,
WBNodeContainer,
VisibleAttributeChangeListener,
SwingSupport {
    static final String WBD_NAME = "GroupTool";
    static final String DISPLAY_NAME = "Group";
    private boolean adopting = false;
    Rectangle evaluateRect = new Rectangle();
    boolean changingToolSize = false;
    private double pasteOffset = 0.0;
    private int pasteGeneration = 0;
    private ArrayList groupToolListeners = new ArrayList();

    public GroupToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public GroupToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.nodeIsContainer = true;
        this.childList = this.toolList = new NodeList((WBNode)this, 0);
        this.color = null;
        this.stroke = null;
        this.hasFrame = false;
        this.registerIfClass("GroupToolModel");
    }

    public GroupToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public GroupToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        throw new RuntimeException("Should not regenerate a group tool");
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        if (reciprocal) {
            this.performReciprocalAction(container);
        } else if (!screen.selectedToolListIsEmpty()) {
            ActionUtilities.groupSelectedTools(screen, this.context);
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GroupToolModel groupToolModel = (GroupToolModel)super.clone();
        groupToolModel.registerIfClass("GroupToolModel");
        return groupToolModel;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
    }

    @Override
    public boolean createOnlyToScreen() {
        return true;
    }

    @Override
    public boolean unselectOnCreation() {
        return false;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        return 3;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 3;
    }

    @Override
    public AbstractUI getUI() {
        return null;
    }

    @Override
    public Cursor getDrawingCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean hasReciprocalAction() {
        return true;
    }

    boolean performReciprocalAction(WBNode container) {
        ScreenModel screen = container instanceof ScreenModel ? (ScreenModel)container : container.findScreenParent();
        ActionUtilities.ungroupSelectedTools(screen, this.context);
        return true;
    }

    public double getPasteOffset() {
        if (this.pasteGeneration != this.context.getToolClipboardGeneration()) {
            this.pasteOffset = 0.0;
        }
        return this.pasteOffset;
    }

    public void setPasteOffset(double pasteOffset) {
        this.pasteOffset = pasteOffset;
        this.pasteGeneration = this.context.getToolClipboardGeneration();
    }

    @Override
    protected void evaluateBounds() {
        boolean sizeSet = false;
        int xVMin = Integer.MAX_VALUE;
        int yVMin = Integer.MAX_VALUE;
        int xVMax = Integer.MIN_VALUE;
        int yVMax = Integer.MIN_VALUE;
        int xBMin = Integer.MAX_VALUE;
        int yBMin = Integer.MAX_VALUE;
        int xBMax = Integer.MIN_VALUE;
        int yBMax = Integer.MIN_VALUE;
        for (int i = 0; i < this.getChildCount(); ++i) {
            WBNode obj = this.getChildAt(i);
            if (!(obj instanceof VisibleObject)) continue;
            VisibleObject vObj = (VisibleObject)((Object)obj);
            Rectangle vRect = vObj.getVBounds();
            xVMin = Math.min(xVMin, vRect.x);
            yVMin = Math.min(yVMin, vRect.y);
            xVMax = Math.max(xVMax, vRect.x + vRect.width);
            yVMax = Math.max(yVMax, vRect.y + vRect.height);
            GeometryUtils.normalRectangle(vObj.getBounds(), this.evaluateRect);
            xBMin = Math.min(xBMin, this.evaluateRect.x);
            yBMin = Math.min(yBMin, this.evaluateRect.y);
            xBMax = Math.max(xBMax, this.evaluateRect.x + this.evaluateRect.width);
            yBMax = Math.max(yBMax, this.evaluateRect.y + this.evaluateRect.height);
            sizeSet = true;
        }
        if (sizeSet) {
            boolean changed = false;
            int width = xVMax - xVMin;
            int height = yVMax - yVMin;
            if (!this.isSameSizeLocation(this.visibleBounds, xVMin, yVMin, width, height)) {
                this.visibleBounds.setBounds(xVMin, yVMin, width, height);
                changed = true;
            }
            width = xBMax - xBMin;
            height = yBMax - yBMin;
            if (!this.isSameSizeLocation(this.toolRect.getBounds(), xBMin, yBMin, width, height)) {
                this.evaluateRect.setLocation(xBMin, yBMin);
                this.evaluateRect.setSize(width, height);
                this.toolRect.setBounds(this.evaluateRect);
                changed = true;
            }
            if (changed) {
                this.fireAttributeChange();
            }
        }
    }

    private boolean isSameSizeLocation(Rectangle rec, int x, int y, int width, int height) {
        Point location = rec.getLocation();
        return location.x == x && location.y == y && rec.getWidth() == (double)width && rec.getHeight() == (double)height;
    }

    public void makeShape() {
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        if (this.toolList != null) {
            Iterator iter = this.toolList.realIterator();
            while (iter.hasNext()) {
                AbstractToolModel tool = (AbstractToolModel)iter.next();
                WBElement toolElement = tool.objectToElement(element, progress);
                if (toolElement == null) continue;
                element.addContent((Content)toolElement);
            }
        }
        return element;
    }

    @Override
    public void add(WBNode node) {
        this.insert(node, -1);
    }

    @Override
    public void add(WBNode node, Object oldNode) {
        int index;
        if (this.isDeleted()) {
            // empty if block
        }
        if (oldNode instanceof WBNodeProxy) {
            index = this.toolList.indexOf(oldNode);
            if (index >= 0) {
                node.setNodeReplacingProxy(true);
                this.replaceTool(node, index);
                return;
            }
            Validator.logAlways("GroupToolModel.add(new, old): proxy cannot be found: " + WBUtils.objectName(oldNode));
        } else {
            if (oldNode != null) {
                Validator.logAlways("GroupToolModel.add: oldNode is not a proxy: " + WBUtils.objectName(oldNode) + "\n     newNode: " + WBUtils.objectName(node));
            }
            index = ((AbstractToolModel)node).getZOrder();
        }
        this.insert(node, index);
        node.setNodeReplacingProxy(false);
    }

    @Override
    public void insert(WBNode node, int index) {
        if (node instanceof ScreenModel) {
            throw new RuntimeException("Try to add Screen to tool.");
        }
        if (node.getObjectID() == null) {
            this.context.getObjectManager().setObjectInMap(node);
        }
        this.addTool(node, index);
    }

    @Override
    public void remove(WBNode node) {
        this.removeTool(node);
    }

    @Override
    public void render(Graphics g) {
        this.render(g, g, false);
    }

    @Override
    public void drawUI(Graphics g) {
        this.render(g, g, true);
    }

    @Override
    public void render(Graphics g, Graphics unscaledG) {
        this.render(g, unscaledG, false);
    }

    private void render(Graphics g, Graphics unscaledG, boolean draw) {
        Rectangle clipBounds = g.getClipBounds();
        Iterator iter = this.iterateContainer();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof VisibleObject) || clipBounds != null && !GeometryUtils.intersects(clipBounds, ((VisibleObject)object).getVBounds())) continue;
            if (draw && object instanceof SwingSupport) {
                ((SwingSupport)object).drawUI(g);
                continue;
            }
            ((VisibleObject)object).render(g, unscaledG);
        }
    }

    private void addTool(WBNode tool, int index) {
        this.adopting = false;
        tool.determineNodeReparenting();
        if (tool.isReparenting() && tool.getParent() != null) {
            this.adopting = true;
            tool.getBoardParent().remove(tool);
        }
        if (tool.isBackground()) {
            ArrayList<AbstractToolModel> removedTools = new ArrayList<AbstractToolModel>();
            for (AbstractToolModel curTool : this.toolList) {
                if (!curTool.isPartOfBackGround() || !BackgroundTool.hasSingleBackground()) continue;
                removedTools.add(curTool);
            }
            for (AbstractToolModel curTool : removedTools) {
                this.adopting = true;
                this.removeTool(curTool);
            }
        }
        if (index < 0 || index > this.toolList.size()) {
            this.toolList.add(tool);
        } else {
            this.toolList.add(index, tool);
        }
        tool.setParent(this);
        this.adopting = false;
        tool.setNodeReparenting(false);
        this.initialized = !this.toolList.isEmpty();
        this.evaluateBounds();
        tool.createPeer();
        this.fireGroupToolAdded(tool);
        if (tool instanceof VisibleObject) {
            this.notifySizingChange();
        }
    }

    private void removeTool(WBNode tool) {
        this.notifyVisibleChange();
        this.fireGroupToolRemoved(tool);
        if (tool instanceof AbstractToolModel && ((AbstractToolModel)tool).isSelected() && tool.getScreenParent() != null) {
            tool.getScreenParent().deSelectTool((AbstractToolModel)tool);
        }
        ScreenModel screenParent = this.findScreenParent();
        if (tool instanceof AbstractToolModel && screenParent != null) {
            screenParent.deSelectTool((AbstractToolModel)tool);
        }
        if (!tool.isReparenting() && tool.isConferenceNode() && this.findScreenParent() != null) {
            this.context.getDataExporter().removeFromConference(tool, tool.getOriginator());
        }
        int index = this.toolList.indexOf(tool);
        if (!this.toolList.remove(tool)) {
            Validator.logAlways("GroupTool.removeTool: tool not removed.");
        }
        this.initialized = !this.toolList.isEmpty();
        this.notifySizingChange();
        tool.setParent(null);
        tool.setRoot(null);
        tool.removePeer();
        if (!this.adopting && this.getChildCount() == 0) {
            this.setOriginator(tool.getOriginator());
            if (this.getParent() != null) {
                this.getParent().remove(this);
                this.setParent(null);
                this.removePeer();
            }
            this.delete();
        }
        this.context.fireDeletion(tool.getObjectID());
        this.context.getDataModel().fireNodeRemoved(tool, index, this);
    }

    private void replaceTool(WBNode tool, int index) {
        if (tool instanceof ScreenModel) {
            throw new RuntimeException("Try to replace Screen on tool.");
        }
        WBNode oldTool = (WBNode)this.toolList.get(index);
        oldTool.setParent(null);
        oldTool.setRoot(null);
        oldTool.removePeer();
        if (tool.isReparenting() && tool.getParent() != null) {
            tool.getBoardParent().remove(tool);
        }
        tool.setRoot(this.getRoot());
        this.toolList.set(index, tool);
        tool.setParent(this);
        tool.setNodeReparenting(false);
        this.evaluateBounds();
        tool.createPeer();
        if (tool instanceof VisibleObject) {
            this.notifySizingChange();
        }
    }

    @Override
    public void setSize(DDimension dDim) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WBNode obj = this.getChildAt(i);
            if (!(obj instanceof AbstractToolModel)) continue;
            AbstractToolModel tool = (AbstractToolModel)obj;
            double dX = tool.getLocation().getX() - this.toolRect.getLocation().getX();
            double dY = tool.getLocation().getY() - this.toolRect.getLocation().getY();
            double dW = dDim.getWidth() / tool.getSize().getWidth();
            double dH = dDim.getHeight() / tool.getSize().getHeight();
            tool.scaleTool(dW, dH);
            tool.moveTool(dX * dW, dY * dH);
        }
        this.toolRect.setSize(dDim);
    }

    @Override
    public void setLocation(DPoint dP) {
        this.setLocation(dP.getX(), dP.getY());
    }

    @Override
    public void setLocation(double x, double y) {
        this.notifyVisibleChange();
        double dX = x - this.toolRect.getLocation().getX();
        double dY = y - this.toolRect.getLocation().getY();
        for (int i = 0; i < this.getChildCount(); ++i) {
            WBNode object = this.getChildAt(i);
            if (!(object instanceof AbstractToolModel)) continue;
            ((AbstractToolModel)object).moveTool(dX, dY);
        }
        this.toolRect.setLocation(x, y);
    }

    @Override
    public void setRect(double x, double y, double w, double h) {
        this.notifyVisibleChange();
        this.changingToolSize = true;
        GeometryUtils.setToolSetRect(this.toolList, this.editStartRect, this.getOriginator(), x, y, w, h);
        this.changingToolSize = false;
        this.evaluateBounds();
        this.notifySizingChange();
    }

    @Override
    public void onVisibleAttributeChange(VisibleObject object) {
        if (!this.changingToolSize) {
            this.evaluateBounds();
        }
        if (this.getParent() instanceof VisibleAttributeChangeListener) {
            ((VisibleAttributeChangeListener)((Object)this.getParent())).onVisibleAttributeChange(object);
        }
    }

    @Override
    public boolean isEditing() {
        return this.editing;
    }

    @Override
    public void setEditing(boolean editing) {
        super.setEditing(editing);
        for (int i = 0; i < this.getChildCount(); ++i) {
            WBNode object = this.getChildAt(i);
            if (!(object instanceof AbstractToolModel)) continue;
            ((AbstractToolModel)object).setEditing(editing);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        for (int i = 0; i < this.getChildCount(); ++i) {
            WBNode object = this.getChildAt(i);
            if (!(object instanceof AbstractToolModel)) continue;
            ((AbstractToolModel)object).setSelected(selected);
        }
    }

    public void addGroupToolChangeListener(GroupToolChangeListener lst) {
        ArrayList<GroupToolChangeListener> newList = new ArrayList<GroupToolChangeListener>(this.groupToolListeners);
        if (!newList.contains(lst)) {
            newList.add(lst);
        }
        this.groupToolListeners = newList;
    }

    public void removeGroupToolChangeListener(GroupToolChangeListener lst) {
        ArrayList newList = new ArrayList(this.groupToolListeners);
        newList.remove(lst);
        this.groupToolListeners = newList;
    }

    private void fireGroupToolAdded(WBNode tool) {
        GroupToolChangeEvent gtce = new GroupToolChangeEvent(this, tool);
        for (GroupToolChangeListener gtcl : this.groupToolListeners) {
            try {
                gtcl.groupToolAdded(gtce);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireGroupToolRemoved", (Throwable)t, (boolean)true);
            }
        }
    }

    private void fireGroupToolRemoved(WBNode tool) {
        GroupToolChangeEvent gtce = new GroupToolChangeEvent(this, tool);
        for (GroupToolChangeListener gtcl : this.groupToolListeners) {
            try {
                gtcl.groupToolRemoved(gtce);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireGroupToolRemoved", (Throwable)t, (boolean)true);
            }
        }
    }
}

