/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.EllipseToolModel;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.event.ActionEvent;

public class FilledEllipseToolModel
extends EllipseToolModel {
    static final String FILLED_WBD_NAME = "FilledEllipseTool";

    public FilledEllipseToolModel(WhiteboardContext context) {
        this(context, FILLED_WBD_NAME);
    }

    public FilledEllipseToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.color.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.FILLEDSHAPE_COLORNAME));
        this.color.setPanelKey("filledShapeProperties");
        this.stroke.setPanelKey(null);
        this.fillColor = null;
        this.registerIfClass("FilledEllipseToolModel");
    }

    public FilledEllipseToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public FilledEllipseToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public boolean hasReciprocalAction() {
        return false;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        FilledEllipseToolModel filledEllpseToolModel;
        try {
            filledEllpseToolModel = (FilledEllipseToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            filledEllpseToolModel = new FilledEllipseToolModel(this.context);
        }
        filledEllpseToolModel.initialized = false;
        filledEllpseToolModel.setSize(1.0, 1.0);
        filledEllpseToolModel.setFilled(true);
        return filledEllpseToolModel;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilledEllipseToolModel ellipseToolModel = (FilledEllipseToolModel)super.clone();
        if (this.fillColor != null) {
            ellipseToolModel.fillColor = (ToolColor)this.fillColor.clone();
        }
        ellipseToolModel.registerIfClass("FilledEllipseToolModel");
        ellipseToolModel.setFilled(true);
        return ellipseToolModel;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.setFilled(true);
        return this;
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        FilledEllipseToolModel tool = (FilledEllipseToolModel)super.elementToObject(element, progress);
        this.setFilled(true);
        return tool;
    }
}

