/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel.flavors;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.util.ArrayList;

public class InternalNodeListFlavor
extends DataFlavor
implements Serializable {
    static final long serialVersionUID = 100L;
    public static final int JINX_ADDRESS_INDEX = 0;
    public static final int SESSION_INDEX = 1;
    public static final int HASH_INDEX = 2;
    public static final int FIRST_UID = 3;
    private long[] nodeUIDs = null;

    public InternalNodeListFlavor() {
        super(InternalNodeListFlavor.class, "Internal Tree Nodes");
    }

    public InternalNodeListFlavor(ArrayList<WBNode> nodes, WhiteboardContext context) throws ClassNotFoundException {
        this();
        this.nodeUIDs = new long[nodes.size() + 3];
        this.nodeUIDs[0] = context.getIDProcessor().getMyAddress().shortValue();
        this.nodeUIDs[1] = context.getConferenceUID();
        this.nodeUIDs[2] = context.hashCode();
        for (int i = 3; i < this.nodeUIDs.length; ++i) {
            this.nodeUIDs[i] = nodes.get(i - 3).getObjectID();
        }
    }

    public long[] getEncodedData() {
        return this.nodeUIDs;
    }

    public static boolean isSameSession(InternalNodeListFlavor internalNode, WhiteboardContext ourContext) {
        if (ourContext.getConferenceUID() != internalNode.nodeUIDs[1]) {
            return false;
        }
        int ourHash = ourContext.hashCode();
        return (long)ourHash == internalNode.nodeUIDs[2];
    }

    public static long[] translateUids(long[] encodedData, WhiteboardContext context) {
        long[] localizedUids = new long[encodedData.length - 3];
        short sourceAddress = (short)encodedData[0];
        for (int i = 3; i < encodedData.length; ++i) {
            short localClientId;
            short clientId = ObjectUID.decodeClientId(encodedData[i]);
            int sequenceNumber = ObjectUID.decodeSequence(encodedData[i]);
            try {
                localClientId = context.getIDProcessor().conferenceToLocal(clientId, sourceAddress);
            }
            catch (Exception ex) {
                localClientId = clientId;
            }
            localizedUids[i - 3] = ObjectUID.encodeUID(localClientId, sequenceNumber);
        }
        return localizedUids;
    }
}

