/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.util.log.LogSupport;
import java.util.zip.CRC32;

public class MediaID
implements Comparable {
    public static final long MEDIA_LENGTH_MASK = Integer.MAX_VALUE;
    public static final long MEDIA_CRC_MASK = 0xFFFFFFFFL;
    public static final long MEDIA_ID_FLAG = Long.MIN_VALUE;
    protected Long mediaCRC = new Long(0L);
    protected int mediaLength = -1;
    Long mediaIDLong = null;

    public MediaID(byte[] mediaObject) {
        if (mediaObject != null) {
            this.mediaCRC = new Long(this.calculateMediaHash(mediaObject));
            this.mediaLength = mediaObject.length;
        }
        this.calculateMediaIDLong();
    }

    public MediaID(int mediaLength, long mediaCRC) {
        this.mediaLength = mediaLength;
        this.mediaCRC = new Long(mediaCRC);
        this.calculateMediaIDLong();
    }

    public MediaID(Long mediaID) {
        this.mediaLength = (int)(mediaID >> 32 & Integer.MAX_VALUE);
        this.mediaCRC = new Long((long)(mediaID & 0xFFFFFFFFL));
        this.calculateMediaIDLong();
    }

    private void calculateMediaIDLong() {
        long len = (long)this.mediaLength << 32;
        this.mediaIDLong = new Long(len | this.mediaCRC | Long.MIN_VALUE);
    }

    public long getCRC() {
        return this.mediaCRC;
    }

    public int getLength() {
        return this.mediaLength;
    }

    public Long getMediaIDLong() {
        return this.mediaIDLong;
    }

    public long calculateMediaHash(byte[] mediaObject) {
        CRC32 mediaHasher = new CRC32();
        if (mediaObject != null) {
            mediaHasher.update(mediaObject);
        }
        return mediaHasher.getValue();
    }

    public boolean equals(Object o) {
        return o instanceof MediaID ? this.compareTo(o) == 0 : false;
    }

    public int hashCode() {
        return this.mediaCRC.hashCode();
    }

    public String toString() {
        return "MediaID: length=" + this.mediaLength + ", CRC=" + Long.toHexString(this.mediaCRC);
    }

    public int compareTo(Object o) {
        if (o instanceof MediaID) {
            if (this.mediaLength != ((MediaID)o).mediaLength) {
                return this.mediaLength - ((MediaID)o).mediaLength;
            }
            long result = this.mediaCRC - ((MediaID)o).mediaCRC;
            if (result < 0L) {
                return -1;
            }
            if (result > 0L) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException("Cannot compare '" + this.getClass().getName() + "' to '" + o.getClass().getName());
    }

    public static MediaID streamToObject(WBInputStream istr) throws Exception {
        int length = WBUtils.readInt(istr, "MediaID read length");
        long crc = (long)WBUtils.readInt(istr, "MediaID reads CRC") & 0xFFFFFFFFL;
        return new MediaID((int)((long)length & Integer.MAX_VALUE), crc);
    }

    public void objectToStream(WBOutputStream ostr) throws Exception {
        ostr.writeInt(this.mediaLength | Integer.MIN_VALUE);
        ostr.writeInt((int)(this.mediaCRC & 0xFFFFFFFFL));
    }

    public String objectToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer("MediaID: ");
        try {
            int length = (int)((long)WBUtils.readInt(istr, "MediaID read length") & Integer.MAX_VALUE);
            long crc = (long)WBUtils.readInt(istr, "MediaID reads CRC") & 0xFFFFFFFFL;
            buf.append("" + length + ", CRC=" + crc);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"objectToString", (Throwable)ex, (boolean)true);
        }
        return buf.toString();
    }
}

