/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActivityDisplay;
import com.elluminate.groupware.whiteboard.dataModel.MediaID;
import com.elluminate.groupware.whiteboard.dataModel.ModifiedByInformation;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.ShortList;
import com.elluminate.util.image.gif.ImageObject;
import com.elluminate.util.log.LogSupport;
import java.lang.ref.SoftReference;

public class MediaData
extends AbstractCommContainer
implements Comparable,
ModifiedByInformation {
    private byte[] mediaObject = null;
    private transient SoftReference mediaInstance = null;
    private MediaID mediaID = null;
    private Short modifiedById = ClientIdentification.CLIENT_LOCAL;

    public MediaData(WhiteboardContext context) {
        super(context, "_MediaData");
    }

    public MediaData(WhiteboardContext context, byte[] mediaObject) {
        this(context);
        this.setMedia(mediaObject);
    }

    public MediaData(WhiteboardContext context, MediaID mediaID) {
        this(context);
        this.mediaObject = null;
        this.mediaID = mediaID;
        this.mediaInstance = null;
    }

    public MediaData(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"MediaData", (Throwable)e, (boolean)true);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("MediaData cannot be cloned.");
    }

    public byte[] getMedia() {
        return this.mediaObject;
    }

    public void setMedia(byte[] mediaObject) {
        this.mediaObject = mediaObject;
        if (mediaObject == null) {
            this.mediaInstance = null;
        }
        this.mediaID = new MediaID(mediaObject);
        if (this.context.getController() == null && !this.context.getIDProcessor().getMyId().equals(ClientIdentification.SERVER_ID)) {
            this.mediaObject = new byte[0];
        }
    }

    public SoftReference getMediaInstance() {
        return this.mediaInstance;
    }

    public void setMediaInstance(ImageObject mediaInstance) {
        this.mediaInstance = new SoftReference<ImageObject>(mediaInstance);
    }

    public void remove(Long screenUID) {
        if (!this.context.getMediaCache().remove(this, screenUID)) {
            System.err.println("MediaData.179: media not in cache: " + this + ", screen: " + screenUID);
        }
    }

    public MediaID getMediaID() {
        return this.mediaID;
    }

    public int compareTo(Object o) {
        return this.mediaID.compareTo(((MediaData)o).getMediaID());
    }

    public boolean equals(Object o) {
        return o instanceof MediaData ? this.compareTo(o) == 0 : false;
    }

    public int hashCode() {
        return this.mediaID.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.mediaID == null) {
            buf.append(" null MediaID");
        } else {
            buf.append(this.mediaID.toString() + (this.mediaInstance != null ? " : MediaInstance" : " : no MediaInstance"));
            buf.append(", mediaObject: " + this.mediaObject + ", modifiedById: " + this.modifiedById);
        }
        return buf.toString();
    }

    @Override
    public Short getModfiedById() {
        return this.modifiedById;
    }

    @Override
    public void setModifiedById(Short modifiedById) {
        this.modifiedById = modifiedById;
        if (this.context.isClient() && this.context.getController() != null) {
            ((ActivityDisplay)((Object)this.context.getBean())).noteActivity(modifiedById, null);
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.modifiedById.shortValue());
        if (this.mediaObject == null) {
            ostr.writeInt(-1);
        } else {
            ostr.writeInt(this.mediaObject.length);
            ostr.write(this.mediaObject);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        Short modifier = ClientIdentification.NULL_CLIENT;
        super.streamToObject(istr);
        try {
            modifier = ShortList.get((short)WBUtils.readClientId(istr, "Template reads ModifiedById"));
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        if (!this.context.isClient()) {
            modifier = istr.getOriginatorId();
        }
        this.setModifiedById(modifier);
        int byteCount = WBUtils.readInt(istr, "MediaData reads data length");
        if (byteCount == -1) {
            this.mediaObject = null;
        } else {
            this.mediaObject = new byte[byteCount];
            int offset = 0;
            int read = 0;
            do {
                read = istr.read(this.mediaObject, offset, this.mediaObject.length - offset);
                offset += read;
            } while (read > 0);
            this.setMedia(this.mediaObject);
            istr.getContext().getMediaCache().define(this, istr.getOriginatorId());
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            StringBuffer msg = new StringBuffer();
            msg.append(super.streamToString(istr));
            int modifiedById = -1;
            try {
                modifiedById = WBUtils.readClientId(istr, "Template reads ModifiedById");
                if (!this.context.isClient()) {
                    modifiedById = istr.getOriginatorId().shortValue();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            msg.append(", modified by: " + modifiedById);
            int byteCount = WBUtils.readInt(istr, "MediaData string read data length");
            if (byteCount == -1) {
                Object mediaObject = null;
            } else {
                byte[] mediaObject = new byte[byteCount];
                int read = 0;
                int offset = 0;
                do {
                    read = istr.read(mediaObject, offset, mediaObject.length - offset);
                    offset += read;
                } while (read > 0);
            }
            msg.append(this.getName() + ": " + ", length=" + byteCount + ", CRC=" + this.getMediaID() + "\n");
            return msg.toString();
        }
        catch (Exception e) {
            return "streamToObjectID: " + e.getMessage();
        }
    }
}

