/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.StringsProperties;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.attributes.ScreenName;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DataModelListener;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenNameFormat;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.listeners.DeleteListener;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;

public class DataModel
implements DeleteListener {
    static final int MODEL_DEFAULT_SIZE = 5;
    static I18n i18n = I18n.create((Object)new Object(){});
    ScreenGroups screenGroups = null;
    DisplayModel displayModel = null;
    ScreenRoot privateRoot = null;
    ScreenRoot publicRoot = null;
    List<DataModelListener> listenerList = new ArrayList<DataModelListener>(1);
    WhiteboardContext context = null;

    public DataModel(WhiteboardContext context) {
        this.context = context;
        i18n = I18n.create((Object)context);
        context.addDeleteListener(this);
        this.addDataModelListener(context);
    }

    public void initializeScreenGroups() {
        try {
            ScreenModel scrn;
            this.screenGroups = new ScreenGroups(this.context);
            if (this.context.isClient()) {
                this.privateRoot = new ScreenRoot(i18n.getString((PropertiesEnum)StringsProperties.DATAMODEL_DEFAULTWORKGROUPNAME), this.context);
                this.privateRoot.setTemplate(this.context);
                this.context.getObjectManager().setObjectInMap(this.privateRoot);
                this.setPrivateRootACLs(this.privateRoot);
                this.addScreenGroup(this.privateRoot);
                ActionUtilities.createScreen(new ScreenName(this.context), this.context, null, this.privateRoot, 0, false);
                scrn = this.privateRoot.getScreenDelegate();
                this.setPrivateScreenACLs(scrn);
                scrn.getScreenNameAttribute().setASystemGeneratedScreenName(true);
                scrn.setScreenName(this.context.getDefaultWorkScreenName());
                this.privateRoot.setDeletable(false);
                this.privateRoot.setScreenSize(0, 0);
                this.privateRoot.getNextScreenSequence();
            } else {
                this.publicRoot = new ScreenRoot(this.context.getDefaultPublicGroupName(), this.context);
                this.publicRoot.setTemplate(this.context);
                this.context.getObjectManager().setObjectInMap(this.publicRoot);
                this.setPublicRootACLs(this.publicRoot);
                this.addScreenGroup(this.publicRoot);
                ActionUtilities.createScreen(new ScreenName(this.context), this.context, null, this.publicRoot, 0, false);
                scrn = this.publicRoot.getScreenDelegate();
                scrn.getScreenNameAttribute().setASystemGeneratedScreenName(true);
                scrn.setScreenName(this.context.getDefaultPublicScreenName());
                this.setPublicScreenACLs(scrn);
                this.publicRoot.setDeletable(false);
                this.publicRoot.setScreenSize(0, 0);
                this.publicRoot.getNextScreenSequence();
            }
            this.normalizeScreenNames(scrn.getRoot(), true);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"initializeScreenGroups", (Throwable)ex, (boolean)true);
        }
    }

    public void setPublicRootACLs(ScreenRoot root) {
        this.setPublicScreenACLs(root);
        root.setEditable(false);
        root.setPrivate(false);
        root.getACLTerm("disribution").setDefaultAllow(true);
        root.getACLTerm("edit background").addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        ACLTerm visibleACL = root.getACLTerm("visible");
        visibleACL.addDenyEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.NOT_CURRENT_GROUP, null, ACLEntry.ALL_ROLES));
        visibleACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        root.setRootACLs();
    }

    public void setPublicScreenACLs(ScreenModel scrn) {
        this.clearACL(scrn, "accessible");
        this.clearACL(scrn, "copy");
        ACLTerm createACL = this.clearACL(scrn, "create");
        createACL.addDenyEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
        createACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        ACLTerm deleteACL = this.clearACL(scrn, "delete");
        deleteACL.addDenyEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
        deleteACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        ACLTerm deleteOthersACL = this.clearACL(scrn, "delete others' tools");
        deleteOthersACL.addDenyEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
        deleteOthersACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        this.clearACL(scrn, "access tools");
        this.clearACL(scrn, "delete own tools");
        this.clearACL(scrn, "disribution");
        this.clearACL(scrn, "edit background");
        this.clearACL(scrn, "print");
        this.clearACL(scrn, "save");
        this.clearACL(scrn, "set access");
        this.clearACL(scrn, "visible");
        scrn.setScreenACLs();
    }

    public static void propagateScreenACLs(ScreenModel screen, boolean privateACL) {
        if (privateACL) {
            screen.getContext().getDataModel().setPrivateScreenACLs(screen);
        } else {
            screen.getContext().getDataModel().setPublicScreenACLs(screen);
        }
        screen.reEvaluateACLs();
        Iterator iter = screen.iterateScreens();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ScreenModel)) continue;
            DataModel.propagateScreenACLs((ScreenModel)obj, privateACL);
        }
    }

    private ACLTerm clearACL(ScreenModel screen, String aclName) {
        ACLTerm aclTerm = screen.getACLTerm(aclName);
        aclTerm.clearAll();
        return aclTerm;
    }

    public void setPrivateRootACLs(ScreenRoot root) {
        root.setEditable(false);
        root.setPrivate(true);
        ACLEntry groupCreator = new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.GROUP_CREATOR_ROLE);
        root.getACLTerm("set access").addDefiningEntry(groupCreator);
        root.getACLTerm("disribution").setDefaultAllow(false);
        root.getACLTerm("edit background").addDefiningEntry(groupCreator);
        root.getACLTerm("accessible").addDefiningEntry(ACLTerm.GROUP_CREATOR_ENTRY);
        root.setRootACLs();
    }

    public void setPrivateScreenACLs(ScreenModel scrn) {
        ACLTerm createACL = this.clearACL(scrn, "create");
        createACL.addDenyEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
        createACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.GROUP_CREATOR_ROLE));
        this.clearACL(scrn, "accessible");
        this.clearACL(scrn, "copy");
        ACLTerm deleteOthersACL = this.clearACL(scrn, "delete others' tools");
        deleteOthersACL.addDenyEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
        deleteOthersACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.CHAIR_ROLE));
        this.clearACL(scrn, "access tools");
        this.clearACL(scrn, "delete own tools");
        this.clearACL(scrn, "disribution");
        this.clearACL(scrn, "edit background");
        this.clearACL(scrn, "print");
        this.clearACL(scrn, "delete");
        this.clearACL(scrn, "save");
        this.clearACL(scrn, "set access");
        scrn.setScreenACLs();
    }

    @Override
    public void onDelete(Long id) {
        ScreenModel screen;
        RegisteredTemplate template = null;
        try {
            template = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(id);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"onDelete", (Throwable)ex, (boolean)true);
            return;
        }
        if (template instanceof AbstractToolModel && (screen = ((AbstractToolModel)template).findScreenParent()) != null) {
            screen.deSelectTool((AbstractToolModel)template);
        }
    }

    public WBNode getRoot() {
        return this.screenGroups;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = ((DisplayNode)path.getLastPathComponent()).getUserObject();
        if (obj instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)obj;
            if (newValue instanceof String && screen.isEditable()) {
                screen.setScreenNameLocal((String)newValue, false);
            }
        }
    }

    public ScreenRoot getPrivateScreens() {
        return this.privateRoot;
    }

    public ScreenRoot getPublicScreens() {
        if (this.publicRoot != null) {
            return this.publicRoot;
        }
        if (this.screenGroups != null) {
            Iterator iter = this.screenGroups.iterateScreens();
            while (iter.hasNext()) {
                ScreenModel screen = (ScreenModel)iter.next();
                if (screen.isPrivate() || !(screen instanceof ScreenRoot) || screen.canDelete()) continue;
                return (ScreenRoot)screen;
            }
        }
        return null;
    }

    public ScreenRoot getGroupRoot(Short groupId) {
        if (groupId.equals(ACLEntry.NULL_GROUP)) {
            return this.publicRoot;
        }
        Iterator iter = this.screenGroups.iterateScreens();
        while (iter.hasNext()) {
            ScreenRoot root = (ScreenRoot)iter.next();
            if (root.getGroupID() != groupId.shortValue()) continue;
            return root;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataModelListener(DataModelListener l) {
        DataModel dataModel = this;
        synchronized (dataModel) {
            ArrayList<DataModelListener> copy = new ArrayList<DataModelListener>(this.listenerList);
            copy.add(l);
            this.listenerList = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataModelListener(DataModelListener l) {
        DataModel dataModel = this;
        synchronized (dataModel) {
            ArrayList<DataModelListener> copy = new ArrayList<DataModelListener>(this.listenerList);
            copy.remove(l);
            this.listenerList = copy;
        }
    }

    public void fireNodeAdded(WBNode addedNode, WBNode parentNode) {
        for (DataModelListener listener : this.listenerList) {
            try {
                listener.nodeAdded(addedNode, parentNode);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireNodeAdded", (Throwable)t, (boolean)true);
            }
        }
    }

    public void fireNodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
        for (DataModelListener listener : this.listenerList) {
            try {
                listener.nodeRemoved(removedNode, removedIndex, parentNode);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireNodeRemoved", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScreenGroup(ScreenRoot model) {
        Debug.lockEnter((Object)this, (String)"DataModel.addScreenGroup", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this;
        synchronized (dataModel) {
            this.screenGroups.add(model);
            model.setInConference(true);
            model.setParent(this.screenGroups);
            this.context.getDataExporter().addToConference(model);
            this.fireNodeAdded(model, this.screenGroups);
        }
        Debug.lockLeave((Object)this, (String)"DataModel.addScreenGroup", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScreenGroup(ScreenRoot model) {
        Debug.lockEnter((Object)this, (String)"DataModel.removeScreenGroup", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this;
        synchronized (dataModel) {
            this.context.getDataExporter().removeFromConference(model);
            if (this.displayModel != null && model.getDisplayPeer() != null) {
                this.displayModel.removeNodeFromParent(model.getDisplayPeer());
            }
            int index = this.screenGroups.getIndex(model);
            this.screenGroups.remove(model);
            model.setParent(null);
            model.removePeer();
            this.fireNodeRemoved(model, index, this.screenGroups);
        }
        Debug.lockLeave((Object)this, (String)"DataModel.removeScreenGroup", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public DisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public void setDisplayModel(DisplayModel displayModel) {
        if (displayModel == null) {
            return;
        }
        this.displayModel = displayModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScreenModel(ScreenModel model) {
        Debug.lockEnter((Object)this, (String)"DataModel.removeScreenModel", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this;
        synchronized (dataModel) {
            model.getParent().remove(model);
        }
        Debug.lockLeave((Object)this, (String)"DataModel.removeScreenModel", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public void normalizeScreenNames(ScreenModel root) {
        this.normalizeScreenNames(root, this.context.isRenamingSystemGeneratedNames());
    }

    public void normalizeScreenNames(ScreenModel root, boolean rename) {
        if (!rename || !(root instanceof ScreenModel)) {
            return;
        }
        int index = 1;
        this.context.getDataExporter().blockCodecs();
        for (int i = 0; i < root.getScreenCount(); ++i) {
            index = this.normalizeScreenNames(root.getScreenAt(i), index, 0);
        }
        this.context.getDataExporter().unblockCodecs();
    }

    private int normalizeScreenNames(Object obj, int index, int level) {
        if (obj instanceof ScreenModel) {
            ScreenNameFormat format;
            String name;
            ScreenModel screen = (ScreenModel)obj;
            ScreenName screenName = screen.getScreenNameAttribute();
            boolean systemGenerated = screenName.isASystemGeneratedScreenName();
            systemGenerated &= false;
            if ((systemGenerated &= screen.getToolCount() == 0) && !(name = (format = ActionUtilities.getScreenNameFormat(screen, this.context)).format(index++)).equals(screenName.getScreenName())) {
                screen.setScreenName(name);
            }
            int childIndex = 1;
            for (int i = 0; i < screen.getScreenCount(); ++i) {
                childIndex = this.normalizeScreenNames(screen.getScreenAt(i), childIndex, level + 1);
            }
        }
        return index;
    }
}

