/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.attributes.ScreenName;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.I18nScreenNameFormat;
import com.elluminate.groupware.whiteboard.dataModel.NodeList;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.OrderedElement;
import com.elluminate.groupware.whiteboard.dataModel.PublicScreenNameFormat;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenNameFormat;
import com.elluminate.groupware.whiteboard.dataModel.ScreenPasteEntry;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.SimpleScreenNameFormat;
import com.elluminate.groupware.whiteboard.dataModel.StringsProperties;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.tools.ToolRenderer;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ActionUtilities {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static int nextScreenSequence = 1;
    public static final int AFTER = 1;
    public static final int AT_END = 2;
    public static final int BEFORE = 4;
    public static final int SWITCH_SUBTOPIC = 8;
    public static final int SUBTOPIC = 1;
    public static final int REPLACE = 16;

    private ActionUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScreenModel[] cutScreenTree(WhiteboardContext context, TreePath[] oldPaths, boolean forDelete, boolean canDeleteRoots) {
        if (oldPaths == null) {
            return new ScreenModel[0];
        }
        ScreenModel[] screens = new ScreenModel[oldPaths.length];
        TreePath[] paths = ActionUtilities.orderPaths(oldPaths, context);
        context.getDataExporter().blockCodecs();
        for (int i = 0; i < screens.length; ++i) {
            screens[i] = null;
            DisplayNode peer = (DisplayNode)paths[i].getLastPathComponent();
            DisplayModel displayModel = peer.getDisplayModel();
            ScreenModel screen = (ScreenModel)peer.whiteboardPeer();
            if (!screen.canDelete() || !canDeleteRoots && screen instanceof ScreenRoot) {
                if (context.getController() == null) continue;
                context.getDataExporter().unblockCodecs();
                ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTDELETE, new Object[]{screen.getScreenName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTDELETETITLE), (int)0);
                context.getDataExporter().blockCodecs();
                continue;
            }
            screen.setOriginator();
            if (context.isClient() && screen == context.getDataModel().getPrivateScreens()) {
                if (context.getController() == null) continue;
                context.getDataExporter().unblockCodecs();
                ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_PRIVATE), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_PRIVATE), (int)0);
                context.getDataExporter().blockCodecs();
                continue;
            }
            if (context.getController() != null && screen instanceof ScreenRoot && !forDelete) {
                if (context.getController() != null) {
                    context.getDataExporter().unblockCodecs();
                    ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTCUT, new Object[]{screen.getScreenName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTCUTTITLE), (int)0);
                    context.getDataExporter().blockCodecs();
                }
                screens[i] = null;
                continue;
            }
            Debug.lockEnter(null, (String)"ActionUtilities.cutScreenTree", (String)"DataModel", (Object)context.getDataModel());
            try {
                DataModel dataModel = context.getDataModel();
                synchronized (dataModel) {
                    if (displayModel == context.getDataModel().getDisplayModel()) {
                        screen.setOriginator();
                        screen.clearNodeReparenting();
                        if (screen instanceof ScreenRoot) {
                            context.getDataModel().removeScreenGroup((ScreenRoot)screen);
                        } else {
                            context.getDataModel().removeScreenModel(screen);
                        }
                    } else {
                        if (displayModel != null && peer != null) {
                            displayModel.removeNodeFromParent(peer);
                        }
                        screen.getParent().remove(screen);
                    }
                    screen.setParent(null);
                }
            }
            finally {
                Debug.lockLeave(null, (String)"ActionUtilities.cutScreenTree", (String)"DataModel", (Object)context.getDataModel());
            }
            screens[i] = screen;
        }
        context.getDataExporter().unblockCodecs();
        return screens;
    }

    public static boolean canCreateTree(WhiteboardContext context, TreePath[] paths) {
        boolean result = false;
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                DisplayNode peer = (DisplayNode)paths[i].getLastPathComponent();
                ScreenModel screen = (ScreenModel)peer.whiteboardPeer();
                if (!screen.canCreate()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static void cannotCreateTo(ScreenModel screen, WhiteboardContext context) {
        if (context.getController() == null) {
            LogSupport.message((String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTCREATETO, new Object[]{screen.getScreenName()}));
            return;
        }
        ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTCREATETO, new Object[]{screen.getScreenName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_CANNOTCREATETOTITLE), (int)0);
    }

    public static boolean canCutTree(WhiteboardContext context, TreePath[] paths) {
        boolean result = false;
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                DisplayNode peer = (DisplayNode)paths[i].getLastPathComponent();
                DisplayModel displayModel = peer.getDisplayModel();
                ScreenModel screen = (ScreenModel)peer.whiteboardPeer();
                if (!screen.canDelete()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractToolModel[] cutToolTree(WhiteboardContext context, AbstractToolModel[] tools, boolean forDelete) {
        if (tools == null) {
            return new AbstractToolModel[0];
        }
        ActionUtilities.sortToIndexOrder(tools);
        Debug.lockEnter(null, (String)"ActionUtilities.cutToolTree", (String)"DataModel", (Object)context.getDataModel());
        context.getDataExporter().blockCodecs();
        try {
            DataModel dataModel = context.getDataModel();
            synchronized (dataModel) {
                for (int i = 0; i < tools.length; ++i) {
                    if (tools[i] == null) continue;
                    tools[i].setOriginator();
                    tools[i].clearNodeReparenting();
                    ActionUtilities.unselectTool(tools[i]);
                    tools[i].getParent().remove(tools[i]);
                    if (!(tools[i] instanceof ToolRenderer)) continue;
                    ((ToolRenderer)((Object)tools[i])).removeRenderer();
                }
            }
        }
        catch (Exception ex) {
            LogSupport.message(ActionUtilities.class, (String)"cutToolTree", (String)Debug.getStackTrace((Throwable)ex));
        }
        finally {
            context.getDataExporter().unblockCodecs();
            Debug.lockLeave(null, (String)"ActionUtilities.cutToolTree", (String)"DataModel", (Object)context.getDataModel());
        }
        return tools;
    }

    private static void unselectTool(AbstractToolModel tool) {
        ScreenModel screen = tool.findScreenParent();
        if (screen != null) {
            screen.deSelectTool(tool);
            if (tool.isContainer()) {
                Iterator iter = tool.iterateTools();
                while (iter.hasNext()) {
                    Object object = iter.next();
                    if (!(object instanceof AbstractToolModel)) continue;
                    ActionUtilities.unselectTool((AbstractToolModel)object);
                }
            }
        }
    }

    public static void copyScreensToClipboard(TreePath[] pathsIn, WhiteboardContext context) {
        TreePath[] paths = ActionUtilities.orderPaths(pathsIn, context);
        ActionUtilities.copyScreensToClipboard(ActionUtilities.pathsToNodes(paths), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyScreensToClipboard(WBNode[] screens, WhiteboardContext context) {
        DataModel dataModel = context.getDataModel();
        synchronized (dataModel) {
            Object[] copiedScreens = ActionUtilities.copyScreens(screens, context);
            if (copiedScreens != null) {
                context.setScreenClipboard(copiedScreens);
            }
        }
    }

    public static ScreenModel[] copyScreens(TreePath[] pathsIn, WhiteboardContext context) {
        TreePath[] paths = ActionUtilities.orderPaths(pathsIn, context);
        return ActionUtilities.copyScreens(ActionUtilities.pathsToNodes(paths), context);
    }

    public static ScreenModel[] copyScreens(WBNode[] screens, WhiteboardContext context) {
        LinkedList<WBNode> newNodes = new LinkedList<WBNode>();
        if (screens == null || screens.length == 0) {
            ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_NOSCREENSTOCOPY), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_NOSCREENSTOCOPYTITLE), (int)1);
            return null;
        }
        WBNode[] nodes = ActionUtilities.pruneRootChildren(screens);
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof ScreenModel)) continue;
            try {
                WBNode clonedWBNode = (WBNode)nodes[i].clone();
                newNodes.add(clonedWBNode);
                if (clonedWBNode == null) continue;
                clonedWBNode.setInConference(false);
                clonedWBNode.propagateInConference();
                continue;
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
        }
        ScreenModel[] newScreens = new ScreenModel[newNodes.size()];
        newScreens = newNodes.toArray(newScreens);
        return newScreens;
    }

    @Deprecated
    public static void copySelectedTools(ScreenModel screen, WhiteboardContext context) {
        if (screen.selectedToolListIsEmpty() || !screen.canCopy()) {
            return;
        }
        Object[] tools = new AbstractToolModel[screen.getSelectedToolCount()];
        tools = screen.getSelectedToolList().toArray(tools);
        ActionUtilities.sortToIndexOrder((WBNode[])tools);
        try {
            for (int index = 0; index < tools.length; ++index) {
                if (!(tools[index] instanceof GroupToolModel)) {
                    // empty if block
                }
                tools[index].findScreenParent().deSelectTool((AbstractToolModel)tools[index]);
                tools[index] = (AbstractToolModel)((AbstractToolModel)tools[index]).clone();
            }
            for (int i = 0; i < tools.length; ++i) {
                if (tools[i] == null) continue;
                ((WBNode)tools[i]).setInConference(false);
                ((WBNode)tools[i]).propagateInConference();
            }
            context.setToolClipboard(tools);
            screen.setPasteOffset(10.0);
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities.class, (String)"copySelectedTools", (Throwable)ex, (boolean)true);
        }
    }

    public static void deleteScreens(TreePath[] pathsIn, WhiteboardContext context) {
        ActionUtilities.deleteScreens(ActionUtilities.pathsToNodes(pathsIn), context);
    }

    public static void deleteScreens(WBNode[] screensIn, WhiteboardContext context) {
        if (screensIn == null || screensIn.length == 0) {
            return;
        }
        ScreenModel[] screens = ActionUtilities.removeFixedScreenRoots(ActionUtilities.nodesToScreens(ActionUtilities.pruneRootChildren(screensIn)), true, context);
        context.getDataExporter().blockCodecs();
        for (int i = screens.length - 1; i >= 0; --i) {
            screens[i].setOriginator();
            if (screens[i] instanceof ScreenRoot) {
                context.getDataModel().removeScreenGroup((ScreenRoot)screens[i]);
            } else if (screens[i].getBoardParent() != null) {
                screens[i].getParent().remove(screens[i]);
            }
            screens[i].delete();
        }
        context.getDataExporter().unblockCodecs();
    }

    @Deprecated
    public static void cutSelectedTools(ScreenModel screen, WhiteboardContext context) {
        if (!screen.canCopy()) {
            return;
        }
        LinkedList<AbstractToolModel> toolList = ActionUtilities.getToolsEligibleForDeletion(screen);
        if (toolList.isEmpty()) {
            return;
        }
        AbstractToolModel[] cutTools = new AbstractToolModel[toolList.size()];
        cutTools = toolList.toArray(cutTools);
        context.setToolClipboard(ActionUtilities.cutToolTree(context, cutTools, true));
    }

    public static LinkedList<AbstractToolModel> getToolsEligibleForDeletion(ScreenModel screen) {
        LinkedList<AbstractToolModel> toolList = new LinkedList<AbstractToolModel>();
        if (screen.selectedToolListIsEmpty() || !screen.canDeleteOthersTools() && !screen.canDeleteOwnTools()) {
            return toolList;
        }
        for (AbstractToolModel tool : screen.getSelectedToolList()) {
            tool.setOriginator();
            if (ActionUtilities.toolTreeAllMine(tool)) {
                if (!screen.canDeleteOwnTools()) continue;
                toolList.add(tool);
                continue;
            }
            if (!screen.canDeleteOthersTools()) continue;
            toolList.add(tool);
        }
        return toolList;
    }

    public static boolean toolTreeAllMine(AbstractToolModel tool) {
        boolean result = ObjectUID.isMyNode(tool);
        for (int i = 0; result && i < tool.getToolCount(); ++i) {
            if (!(tool.getToolAt(i) instanceof AbstractToolModel)) continue;
            result &= ActionUtilities.toolTreeAllMine((AbstractToolModel)tool.getToolAt(i));
        }
        return result;
    }

    public static void deleteSelectedTools(ScreenModel screen, WhiteboardContext context) {
        LinkedList<AbstractToolModel> toolList = ActionUtilities.getToolsEligibleForDeletion(screen);
        if (toolList.isEmpty()) {
            screen.deSelectAllTools();
            return;
        }
        AbstractToolModel[] cutTools = new AbstractToolModel[toolList.size()];
        cutTools = toolList.toArray(cutTools);
        ActionUtilities.deleteToolList(cutTools, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteToolList(AbstractToolModel[] toolList, WhiteboardContext context) {
        ActionUtilities.cutToolTree(context, toolList, true);
        context.getDataExporter().blockCodecs();
        try {
            for (AbstractToolModel tool : toolList) {
                if (tool == null) continue;
                tool.delete();
            }
        }
        catch (Exception ex) {
            LogSupport.message(ActionUtilities.class, (String)"deleteToolList", (String)Debug.getStackTrace((Throwable)ex));
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteScreen(ScreenModel screen, WhiteboardContext context) {
        WBNode parent = screen.getParent();
        if (parent != null) {
            context.getDataExporter().blockCodecs();
            try {
                DataModel dataModel = context.getDataModel();
                synchronized (dataModel) {
                    if (screen.isConferenceNode()) {
                        screen.setOriginator();
                        screen.clearNodeReparenting();
                        if (screen instanceof ScreenRoot) {
                            context.getDataModel().removeScreenGroup((ScreenRoot)screen);
                        } else {
                            context.getDataModel().removeScreenModel(screen);
                        }
                    } else {
                        DisplayNode peer = screen.getDisplayPeer();
                        if (peer != null) {
                            peer.getDisplayModel().removeNodeFromParent(screen.getDisplayPeer());
                        }
                        screen.getParent().remove(screen);
                    }
                    screen.setParent(null);
                }
                screen.delete();
            }
            finally {
                Debug.lockLeave(null, (String)"ActionUtilities.cutScreenTree", (String)"DataModel", (Object)context.getDataModel());
            }
            context.getDataExporter().unblockCodecs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTool(AbstractToolModel tool, WhiteboardContext context) {
        WBNode parent = tool.getParent();
        if (parent != null) {
            context.getDataExporter().blockCodecs();
            try {
                parent.remove(tool);
                tool.delete();
            }
            catch (Exception ex) {
                LogSupport.message(ActionUtilities.class, (String)"deleteTool", (String)Debug.getStackTrace((Throwable)ex));
            }
            finally {
                context.getDataExporter().unblockCodecs();
            }
        }
    }

    public static void emptyToolClipboard(WhiteboardContext context) {
        AbstractToolModel[] tools = (AbstractToolModel[])context.getToolClipboard();
        for (int i = 0; i < tools.length; ++i) {
            if (tools[i] == null) continue;
            tools[i].setOriginator();
            tools[i].delete();
        }
        context.setToolClipboard(new AbstractToolModel[0]);
    }

    @Deprecated
    public static void pasteSelectedTools(ScreenModel screen, WhiteboardContext context) {
        WBNode[] tools = (WBNode[])context.getToolClipboard();
        ActionUtilities.pasteTools(screen, context, null, tools);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pasteTools(ScreenModel screen, WhiteboardContext context, DPoint mousePoint, WBNode[] tools) {
        boolean haveGroup = ActionUtilities.haveGroupSelected(context, tools);
        if (mousePoint != null) {
            DPoint topLeftCorner = new DPoint();
            for (int i = 0; i < tools.length; ++i) {
                DPoint thisLocation = ((AbstractToolModel)tools[i]).getNormalLocation();
                if (i == 0) {
                    topLeftCorner = thisLocation;
                    continue;
                }
                if (thisLocation.getX() < topLeftCorner.getX()) {
                    topLeftCorner.setX(thisLocation.getX());
                }
                if (!(thisLocation.getY() < topLeftCorner.getY())) continue;
                topLeftCorner.setX(thisLocation.getX());
            }
            mousePoint.setX(mousePoint.getX() - topLeftCorner.getX());
            mousePoint.setY(mousePoint.getY() - topLeftCorner.getY());
        }
        context.getDataExporter().blockCodecs();
        try {
            if (!haveGroup) {
                if (mousePoint == null) {
                    double pasteOffset = screen.getPasteOffset();
                    screen.setPasteOffset(pasteOffset + 10.0);
                    mousePoint = new DPoint(pasteOffset, pasteOffset);
                }
                ActionUtilities.addTools(screen, context, mousePoint, tools);
            } else {
                Iterator iter = screen.getSelectedToolListIterator();
                while (iter.hasNext()) {
                    double pasteOffset;
                    WBNode node = (WBNode)iter.next();
                    if (node instanceof GroupToolModel) {
                        if (mousePoint == null) {
                            pasteOffset = ((GroupToolModel)node).getPasteOffset();
                            ((GroupToolModel)node).setPasteOffset(pasteOffset + 10.0);
                            mousePoint = new DPoint(pasteOffset, pasteOffset);
                        }
                        ActionUtilities.addTools(node, context, mousePoint, tools);
                        continue;
                    }
                    if (!(node instanceof ScreenModel)) continue;
                    if (mousePoint == null) {
                        pasteOffset = ((ScreenModel)node).getPasteOffset();
                        ((ScreenModel)node).setPasteOffset(pasteOffset + 10.0);
                        mousePoint = new DPoint(pasteOffset, pasteOffset);
                    }
                    ActionUtilities.addTools(node, context, mousePoint, tools);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities.class, (String)"pasteTools", (Throwable)ex, (boolean)true);
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTools(WBNode node, WhiteboardContext context, DPoint offset, WBNode[] nodes) {
        context.getDataExporter().blockCodecs();
        try {
            for (int j = 0; j < nodes.length; ++j) {
                AbstractToolModel cloned;
                if (nodes[j].isBackground() && !node.findScreenParent().canEditBackground()) continue;
                if (BackgroundTool.hasSingleBackground() && nodes[j].isBackground()) {
                    cloned = new GroupToolModel(context);
                    NodeList toolList = nodes[j].toolList;
                    if (toolList != null) {
                        for (WBNode tool : toolList) {
                            cloned.add((WBNode)tool.clone());
                        }
                    }
                } else {
                    cloned = (AbstractToolModel)nodes[j].clone();
                }
                cloned.setOriginator();
                cloned.setNodeReparenting(false);
                if (node instanceof ScreenModel) {
                    if (cloned.isBackground()) {
                        cloned.setZOrder(node.firstNonBackground(0));
                    } else {
                        cloned.setZOrder(node.getChildCount(cloned));
                    }
                    node.add(cloned);
                } else {
                    node.insert(cloned, node.getChildCount());
                }
                if (cloned instanceof AbstractToolModel) {
                    cloned.moveTool(offset.getX(), offset.getY());
                }
                if (context.getController() == null) continue;
                context.getController().moveToolOnScreen(cloned, true);
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities.class, (String)"addTools", (Throwable)ex, (boolean)true);
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
    }

    public static boolean haveGroupSelected(ScreenModel screen, WhiteboardContext context) {
        boolean haveGroup = false;
        if (screen != null && !screen.getSelectedToolList().isEmpty()) {
            Iterator iter = screen.getSelectedToolListIterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof GroupToolModel) && !(object instanceof ScreenModel)) continue;
                haveGroup = true;
                break;
            }
        }
        return haveGroup;
    }

    public static boolean haveGroupSelected(WhiteboardContext context, WBNode[] tools) {
        boolean haveGroup = false;
        for (WBNode object : tools) {
            if (!(object instanceof GroupToolModel)) continue;
            haveGroup = true;
            break;
        }
        return haveGroup;
    }

    public static void groupSelectedTools(ScreenModel screen, WhiteboardContext context) {
        ActionUtilities.groupSelectedTools(screen, context, new GroupToolModel(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void groupSelectedTools(ScreenModel screen, WhiteboardContext context, GroupToolModel group) {
        if (screen.selectedToolListIsEmpty()) {
            return;
        }
        group.setOriginator();
        WBNode[] tools = new AbstractToolModel[screen.getSelectedToolList().size()];
        tools = screen.getSelectedToolList().toArray(tools);
        ActionUtilities.sortToIndexOrder(tools);
        context.getObjectManager().setObjectInMap(group);
        context.getDataExporter().blockCodecs();
        try {
            screen.setOriginator();
            screen.add(group);
            for (int i = 0; i < tools.length; ++i) {
                WBNode tool = tools[i];
                tool.setOriginator();
                group.add(tool);
            }
            DisplayNode screenPeer = screen.getDisplayPeer();
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities.class, (String)"groupSelectedTools", (Throwable)ex, (boolean)true);
        }
        finally {
            if (!group.isBackground()) {
                screen.selectTool(group);
            }
            context.getDataExporter().unblockCodecs();
        }
    }

    public static void sortToIndexOrder(WBNode[] nodes) {
        int i;
        TreeSet<OrderedElement> indexOrderMap = new TreeSet<OrderedElement>();
        for (i = 0; i < nodes.length; ++i) {
            Integer order = new Integer(nodes[i].getIndex());
            indexOrderMap.add(new OrderedElement(order, nodes[i]));
        }
        i = 0;
        Iterator iter = indexOrderMap.iterator();
        while (iter.hasNext()) {
            nodes[i++] = (AbstractToolModel)((OrderedElement)iter.next()).getElement();
        }
        indexOrderMap.clear();
    }

    public static boolean hasBackgrounds(ScreenModel screen) {
        if (screen != null && screen.getTools() != null) {
            for (WBNode node : screen.getTools()) {
                if (!node.isBackground()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSelectableTools(WhiteboardContext context, ScreenModel screen) {
        boolean chair = context.isChair();
        if (screen != null && screen.getTools() != null) {
            for (Object obj : screen.getTools()) {
                AbstractToolModel tool;
                if (!(obj instanceof AbstractToolModel) || !(tool = (AbstractToolModel)obj).isSelectable() || !chair && tool.isInBackground()) continue;
                return true;
            }
        }
        return false;
    }

    public static BackgroundTool getFirstBackground(ScreenModel screen) {
        if (screen != null && screen.getTools() != null) {
            for (AbstractToolModel tool : screen.getTools()) {
                if (tool.isBackground()) {
                    return (BackgroundTool)tool;
                }
                if (tool.isProxy()) continue;
                return null;
            }
        }
        return null;
    }

    public static boolean hasGroups(ScreenModel screen) {
        if (screen != null && screen.getTools() != null) {
            for (AbstractToolModel tool : screen.getTools()) {
                if (!(tool instanceof GroupToolModel) || tool.isBackground()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void groupSelectedToolsToBackground(ScreenModel screen, WhiteboardContext context) {
        if (screen.selectedToolListIsEmpty()) {
            return;
        }
        BackgroundTool background = ActionUtilities.getFirstBackground(screen);
        if (background != null && BackgroundTool.hasSingleBackground()) {
            context.getDataExporter().blockCodecs();
            try {
                WBNode[] tools = new AbstractToolModel[screen.getSelectedToolCount()];
                tools = screen.getSelectedToolList().toArray(tools);
                ActionUtilities.sortToIndexOrder(tools);
                for (int i = 0; i < tools.length; ++i) {
                    if (tools[i].isBackground()) continue;
                    tools[i].setOriginator();
                    background.add(tools[i]);
                }
            }
            finally {
                context.getDataExporter().unblockCodecs();
            }
        } else {
            ActionUtilities.groupSelectedTools(screen, context, new BackgroundTool(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBackgroundTool(int index, ImageToolModel tool, ScreenModel screen, WhiteboardContext context) {
        if (tool == null || !tool.isBackground()) {
            return;
        }
        tool.setOriginator();
        BackgroundTool background = ActionUtilities.getFirstBackground(screen);
        if (background != null && BackgroundTool.hasSingleBackground()) {
            context.getDataExporter().blockCodecs();
            try {
                background.insert(tool, index);
            }
            finally {
                context.getDataExporter().unblockCodecs();
            }
        }
        if (background == null) {
            BackgroundTool group = new BackgroundTool(context);
            group.setOriginator();
            context.getObjectManager().setObjectInMap(group);
            context.getDataExporter().blockCodecs();
            try {
                screen.setOriginator();
                screen.add(group);
                group.add(tool);
            }
            catch (Exception ex) {
                LogSupport.exception(ActionUtilities.class, (String)"addBackgroundTool", (Throwable)ex, (boolean)true);
            }
            finally {
                context.getDataExporter().unblockCodecs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBackgroundImage(WBImage image, WhiteboardContext context) {
        if (image == null || !image.isInBackground()) {
            return;
        }
        ScreenModel screen = context.getController().getScreen();
        int width = screen.getScreenSize().width;
        int height = screen.getScreenSize().height;
        ImageToolModel toolModel = ActionUtilities.createImageTool(context, image.getImage(), image.getDisplayName(), width, height, true);
        image.delete();
        toolModel.getImage().setSize(screen.getScreenSize());
        BackgroundTool background = null;
        context.getDataExporter().blockCodecs();
        try {
            while (BackgroundTool.hasSingleBackground() && screen.getBackgroundToolCount() > 1) {
                background = ActionUtilities.getFirstBackground(screen);
                screen.remove(background);
            }
            ActionUtilities.addBackgroundTool(0, toolModel, screen, context);
            background = ActionUtilities.getFirstBackground(screen);
            Iterator toolIter = background.iterateTools();
            LinkedList<WBNode> toolsToRemove = new LinkedList<WBNode>();
            while (toolIter.hasNext()) {
                WBNode node = (WBNode)toolIter.next();
                if (node == toolModel) continue;
                toolsToRemove.add(node);
            }
            for (WBNode node : toolsToRemove) {
                background.remove(node);
            }
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
    }

    public static void ungroupSelectedTools(ScreenModel screen, WhiteboardContext context) {
        Iterator iter = screen.getSelectedToolList().iterator();
        AbstractToolModel[] tools = new AbstractToolModel[screen.getSelectedToolList().size()];
        int i = 0;
        while (iter.hasNext()) {
            tools[i++] = (AbstractToolModel)iter.next();
        }
        ActionUtilities.ungroupTools(tools, screen, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ungroupTools(AbstractToolModel[] tools, ScreenModel screen, WhiteboardContext context) {
        try {
            context.getDataExporter().blockCodecs();
            for (int i = 0; i < tools.length; ++i) {
                int j;
                if (!(tools[i] instanceof GroupToolModel)) continue;
                GroupToolModel group = (GroupToolModel)tools[i];
                if (group.isSelected()) {
                    group.getScreenParent().deSelectTool(group);
                }
                WBNode newParent = group.getParent();
                group.setOriginator();
                int groupIndex = group.getIndex();
                WBNode[] groupedTools = new WBNode[group.getChildCount()];
                for (j = 0; j < groupedTools.length; ++j) {
                    groupedTools[j] = group.getChildAt(j);
                }
                for (j = 0; j < groupedTools.length; ++j) {
                    if (!(groupedTools[j] instanceof AbstractToolModel)) continue;
                    AbstractToolModel tool = (AbstractToolModel)groupedTools[j];
                    tool.setOriginator();
                    if (newParent instanceof ScreenModel) {
                        if (tool.isBackground()) {
                            tool.setZOrder(newParent.firstNonBackground(0));
                        } else {
                            tool.setZOrder(groupIndex++);
                        }
                        newParent.add(tool);
                    } else {
                        newParent.insert(tool, groupIndex++);
                    }
                    screen.selectTool(tool);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities.class, (String)"ungroupTools", (Throwable)ex, (boolean)true);
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
    }

    public static void createScreenGroup(ScreenModel root, WhiteboardContext context) {
        ActionUtilities.createScreenGroup(ActionUtilities.nextScreenName(root, context), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createScreenGroup(String screenGroupName, WhiteboardContext context) {
        context.getDataExporter().blockCodecs();
        try {
            ScreenRoot newRoot = new ScreenRoot(screenGroupName, context);
            context.getObjectManager().setObjectInMap(newRoot);
            newRoot.setOriginator();
            newRoot.getACLTerm("disribution").addAcceptEntry(new ACLEntry(context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
            newRoot.getACLTerm("edit background").addAcceptEntry(ACLTerm.CHAIR_ENTRY);
            newRoot.setEditable(true);
            context.getDataModel().setPublicRootACLs(newRoot);
            context.getDataModel().addScreenGroup(newRoot);
            ActionUtilities.createScreen(ActionUtilities.nextScreenNameObj(newRoot, context), context, null, newRoot, 0, false);
        }
        catch (Exception exception) {
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
    }

    public static Integer nextScreenSequence(ScreenModel parent) {
        ScreenModel root = parent.getRoot();
        if (root instanceof ScreenRoot) {
            return new Integer(((ScreenRoot)root).getNextScreenSequence());
        }
        return new Integer(0);
    }

    public static String nextScreenName(ScreenModel parent, WhiteboardContext context) {
        int index = 0;
        index = parent != null ? ActionUtilities.nextScreenSequence(parent) : nextScreenSequence++;
        return ActionUtilities.getScreenNameFormat(parent, context).format(index);
    }

    public static ScreenName nextScreenNameObj(ScreenModel parent, WhiteboardContext context) {
        return new ScreenName(context, ActionUtilities.nextScreenName(parent, context), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScreenModel newScreen(WhiteboardContext context, int count, int mode, boolean overrideCreateLimit) {
        ScreenModel result = null;
        int insertIndex = 0;
        ScreenModel screen = context.getController().getScreen();
        context.getDataExporter().blockCodecs();
        try {
            ScreenModel parentScreen;
            if (screen instanceof ScreenRoot) {
                parentScreen = screen;
            } else {
                parentScreen = (ScreenModel)screen.getParent();
                switch (mode) {
                    case 1: {
                        insertIndex = screen.getIndex() + 1;
                        break;
                    }
                    case 2: {
                        insertIndex = parentScreen.getChildCount();
                        break;
                    }
                    case 4: {
                        insertIndex = screen.getIndex();
                        break;
                    }
                    case 8: {
                        parentScreen = context.getController().getScreen();
                        insertIndex = parentScreen.getChildCount();
                        break;
                    }
                    default: {
                        Thread.dumpStack();
                        ScreenModel screenModel = result;
                        return screenModel;
                    }
                }
            }
            Dimension screenSize = context.getController().getScreen().getScreenSize();
            ActionUtilities.enforceSizeLimits(screenSize);
            for (int i = 0; i < count; ++i) {
                if (!overrideCreateLimit && !parentScreen.canCreate()) continue;
                screen = ActionUtilities.createScreen(ActionUtilities.nextScreenNameObj(parentScreen, context), context, screenSize, parentScreen, insertIndex++, overrideCreateLimit);
                if (result != null) continue;
                result = screen;
            }
        }
        catch (Exception ex) {
            LogSupport.message((String)Debug.getStackTrace((Throwable)ex));
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
        return result;
    }

    private static void enforceSizeLimits(Dimension screenSize) {
        if (screenSize.width < 50 || screenSize.height < 50 || screenSize.width > 4200 || screenSize.height > 4200) {
            screenSize.width = 1014;
            screenSize.height = 835;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScreenModel createScreen(ScreenName screenName, WhiteboardContext context, Dimension screenSize, ScreenModel parentScreen, int index, boolean overrideCreateLimit) {
        context.getDataExporter().blockCodecs();
        Debug.lockEnter(ActionUtilities.class, (String)"createScreen", (String)"DataModel", (Object)context.getDataModel());
        if (overrideCreateLimit || parentScreen.canCreate()) {
            DataModel dataModel = context.getDataModel();
            synchronized (dataModel) {
                ScreenModel screen = new ScreenModel(context, screenName);
                context.getObjectManager().setObjectInMap(screen);
                screen.setOriginator();
                if (screenSize != null) {
                    screen.setScreenSize(screenSize);
                }
                screen.setPrivate(parentScreen.isPrivate());
                if (parentScreen.isPrivate()) {
                    context.getDataModel().setPrivateScreenACLs(screen);
                } else {
                    context.getDataModel().setPublicScreenACLs(screen);
                }
                parentScreen.insert(screen, index);
                ScreenModel screenModel = screen;
                return screenModel;
            }
        }
        context.getDataExporter().unblockCodecs();
        ActionUtilities.cannotCreateTo(parentScreen, context);
        context.getDataExporter().blockCodecs();
        ScreenModel screenModel = null;
        return screenModel;
        finally {
            Debug.lockLeave(ActionUtilities.class, (String)"createScreen", (String)"DataModel", (Object)context.getDataModel());
            context.getDataExporter().unblockCodecs();
        }
    }

    public static LinkedList pasteScreens(TreePath[] receivers, WhiteboardContext context, int mode, ScreenModel[] screensToPaste) {
        if (screensToPaste == null || screensToPaste.length == 0) {
            if (context.getController() != null) {
                ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_NOSCREENSTOPASTE), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_NOSCREENSTOPASTETITLE), (int)1);
            }
            return new LinkedList();
        }
        TreePath[] paths = ActionUtilities.orderPaths(receivers, context);
        if (paths == null) {
            ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_NOSCREENSTOPASTETO), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_NOSCREENSTOPASTETOTITLE), (int)1);
            return new LinkedList();
        }
        ScreenModel[] receiverScreens = new ScreenModel[paths.length];
        for (int i = 0; i < receivers.length; ++i) {
            DisplayNode peer = (DisplayNode)paths[i].getLastPathComponent();
            receiverScreens[i] = (ScreenModel)peer.whiteboardPeer();
        }
        return ActionUtilities.pasteScreens(receiverScreens, context, mode, screensToPaste);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList pasteScreens(ScreenModel[] receivers, WhiteboardContext context, int mode, ScreenModel[] screensToPaste) {
        boolean index = false;
        ScreenModel clonedChild = null;
        ScreenPasteEntry entry2 = null;
        ScreenModel target = null;
        LinkedList<ScreenModel> pastedToTargets = new LinkedList<ScreenModel>();
        LinkedList pastedToList = ActionUtilities.determinePastedParents(receivers, context, mode);
        if (context.getController() != null && pastedToList.size() > 1 && ModalDialog.showConfirmDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_MULTIPASTE), (String)i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_MULTIPASTETITLE), (int)0) != 0) {
            return null;
        }
        HashSet pastedToScreens = new HashSet(pastedToList.size());
        pastedToScreens.clear();
        context.getDataExporter().blockCodecs();
        try {
            for (ScreenPasteEntry entry2 : pastedToList) {
                entry2.screen.setOriginator();
                entry2.screen.setNodeReparenting(false);
                target = null;
                try {
                    Debug.lockEnter(ActionUtilities.class, (String)"pasteScreens", (String)"DataModel", (Object)context.getDataModel());
                    DataModel dataModel = context.getDataModel();
                    synchronized (dataModel) {
                        ScreenModel thisScreen;
                        for (int j = 0; !(j >= screensToPaste.length || (thisScreen = screensToPaste[j]) instanceof ScreenRoot && (thisScreen = thisScreen.getScreenDelegate()) == null); ++j) {
                            if (thisScreen instanceof ScreenRoot) {
                                ScreenModel screenClone = new ScreenModel(thisScreen.getContext());
                                screenClone.setOriginator();
                                screenClone.setNodeReparenting(false);
                                screenClone.setScreenNameLocal(i18n.getString((PropertiesEnum)StringsProperties.ACTIONUTILITIES_DEFAULTSCREENROOTPROXY, new Object[]{thisScreen.getScreenName()}));
                                if (target == null) {
                                    target = screenClone;
                                }
                                Iterator rootIterator = thisScreen.iterateScreens();
                                while (rootIterator.hasNext()) {
                                    clonedChild = (ScreenModel)rootIterator.next();
                                    clonedChild = (ScreenModel)clonedChild.clone();
                                    clonedChild.setOriginator();
                                    clonedChild.setNodeReparenting(false);
                                    screenClone.add(clonedChild);
                                }
                                clonedChild = screenClone;
                            } else {
                                clonedChild = (ScreenModel)screensToPaste[j].clone();
                                if (target == null) {
                                    target = clonedChild;
                                }
                            }
                            clonedChild.setOriginator();
                            clonedChild.setNodeReparenting(false);
                            DataModel.propagateScreenACLs(clonedChild, entry2.screen.isPrivate());
                            entry2.screen.insert(clonedChild, entry2.index++);
                        }
                    }
                }
                finally {
                    Debug.lockLeave(ActionUtilities.class, (String)"pasteScreens", (String)"DataModel", (Object)context.getDataModel());
                }
                if (target == null) continue;
                pastedToTargets.add(target);
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities.class, (String)"pasteScreens", (Throwable)ex, (boolean)true);
        }
        finally {
            context.getDataExporter().unblockCodecs();
        }
        pastedToList.clear();
        return pastedToTargets;
    }

    public static LinkedList determinePastedParents(ScreenModel[] receivers, WhiteboardContext context, int mode) {
        ScreenPasteEntry entry2 = null;
        HashMap<ScreenModel, ScreenPasteEntry> pastedToScreens = new HashMap<ScreenModel, ScreenPasteEntry>(receivers.length, 0.75f);
        LinkedList<ScreenPasteEntry> pastedToList = new LinkedList<ScreenPasteEntry>();
        for (int i = 0; i < receivers.length; ++i) {
            ScreenModel screen = receivers[i];
            if (screen != null && screen.canCreate()) {
                int index;
                if (screen instanceof ScreenRoot) {
                    index = screen.getChildCount();
                } else {
                    switch (mode) {
                        case 1: {
                            index = screen.getIndex() + 1;
                            screen = (ScreenModel)screen.getParent();
                            break;
                        }
                        case 4: {
                            index = screen.getIndex();
                            screen = (ScreenModel)screen.getParent();
                            break;
                        }
                        case 2: {
                            screen = (ScreenModel)screen.getParent();
                            index = screen.getChildCount();
                            break;
                        }
                        case 8: {
                            index = screen.getChildCount();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Bad screen paste mode: " + mode);
                        }
                    }
                }
                if (screen == null) continue;
                if (!pastedToScreens.containsKey(screen)) {
                    entry2 = new ScreenPasteEntry(screen, index);
                    pastedToScreens.put(screen, entry2);
                    pastedToList.add(entry2);
                    continue;
                }
                entry2 = (ScreenPasteEntry)pastedToScreens.get(screen);
                if (mode == 1 && (entry2 == null || entry2.screen != screen)) {
                    for (ScreenPasteEntry entry2 : pastedToList) {
                        if (entry2.screen == screen) break;
                        entry2 = null;
                    }
                }
                if (entry2 == null) continue;
                entry2.index = index;
                continue;
            }
            if (screen == null) continue;
            ActionUtilities.cannotCreateTo(screen, context);
        }
        return pastedToList;
    }

    public static void duplicateScreensToGroups(WhiteboardContext context, ScreenModel[] screensToDuplicate, ScreenRoot[] groups) {
        if (groups == null || groups.length == 0) {
            ScreenGroups root = (ScreenGroups)context.getDataModel().getRoot();
            groups = new ScreenRoot[root.getChildCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = (ScreenRoot)root.getChildAt(i);
            }
        }
        for (int i = 0; i < groups.length; ++i) {
            ScreenModel[] screens;
            ScreenRoot grp = groups[i];
            if (grp.getGroupID() == 0 || (screens = ActionUtilities.cloneScreens(screensToDuplicate, "")) == null) continue;
            int operation = 2;
            ScreenModel relativeTo = grp;
            if (grp.getScreenCount() != 0) {
                operation = 4;
                relativeTo = (ScreenModel)grp.getScreenAt(0);
            }
            ActionUtilities.pasteScreens(new ScreenModel[]{relativeTo}, context, operation, screens);
        }
    }

    public static void duplicateScreensToMainGroup(WhiteboardContext context, ScreenModel[] screensToDuplicate) {
        ScreenRoot grp = context.getDataModel().getPublicScreens();
        ScreenModel[] screens = ActionUtilities.cloneScreens(screensToDuplicate, "");
        if (screens != null) {
            int operation = 2;
            ScreenRoot relativeTo = grp;
            ActionUtilities.pasteScreens(new ScreenModel[]{relativeTo}, context, operation, screens);
        }
    }

    private static ScreenModel[] cloneScreens(ScreenModel[] screens, String groupName) {
        try {
            ScreenModel[] cls = new ScreenModel[screens.length];
            for (int i = 0; i < screens.length; ++i) {
                ScreenModel screen = screens[i];
                cls[i] = (ScreenModel)screen.clone();
                boolean wasSystemGenerated = screen.getScreenNameAttribute().isASystemGeneratedScreenName();
                if (groupName == null || groupName.length() == 0) {
                    cls[i].setScreenNameLocal(cls[i].getScreenName(), wasSystemGenerated);
                    continue;
                }
                cls[i].setScreenNameLocal(groupName + " - " + cls[i].getScreenName(), false);
            }
            return cls;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public static void makeUserNames(ScreenModel clone, String prefix) {
        clone.getScreenNameAttribute().setASystemGeneratedScreenName(false);
        String name = clone.getScreenName();
        if (prefix == null || prefix.length() == 0 || name.startsWith(prefix + " - ") || clone instanceof ScreenRoot) {
            clone.setScreenNameLocal(name, false);
        } else {
            clone.setScreenNameLocal(prefix + " - " + name, false);
        }
        for (int i = 0; i < clone.getScreenCount(); ++i) {
            Object obj = clone.getScreenAt(i);
            if (!(obj instanceof ScreenModel) || obj instanceof ScreenRoot) continue;
            ActionUtilities.makeUserNames((ScreenModel)obj, prefix);
        }
    }

    public static WBNode[] pathsToNodes(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        LinkedList<WBNode> list = new LinkedList<WBNode>();
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null || !(paths[i].getLastPathComponent() instanceof DisplayNode)) continue;
            list.add(((DisplayNode)paths[i].getLastPathComponent()).whiteboardPeer());
        }
        WBNode[] nodes = new WBNode[list.size()];
        nodes = list.toArray(nodes);
        return nodes;
    }

    public static TreePath[] nodesToPaths(WBNode[] nodes) {
        if (nodes == null) {
            return null;
        }
        LinkedList<TreePath> paths = new LinkedList<TreePath>();
        for (int i = 0; i < nodes.length; ++i) {
            DisplayNode displayNode;
            if (nodes[i] == null || (displayNode = nodes[i].getDisplayPeer()) == null) continue;
            paths.add(new TreePath(displayNode.getPath()));
        }
        TreePath[] newPaths = new TreePath[paths.size()];
        newPaths = paths.toArray(newPaths);
        return newPaths;
    }

    public static ScreenModel[] nodesToScreens(WBNode[] nodes) {
        if (nodes == null) {
            return null;
        }
        LinkedList<ScreenModel> screenList = new LinkedList<ScreenModel>();
        for (int i = 0; i < nodes.length; ++i) {
            screenList.add((ScreenModel)nodes[i]);
        }
        ScreenModel[] screens = new ScreenModel[screenList.size()];
        screens = screenList.toArray(screens);
        return screens;
    }

    public static TreePath[] removeFixedScreenRoots(TreePath[] paths, boolean expand, WhiteboardContext context) {
        if (paths == null) {
            return null;
        }
        WBNode[] orderedNodes = ActionUtilities.pathsToNodes(ActionUtilities.orderPaths(paths, context));
        WBNode[] prunedNodes = ActionUtilities.pruneRootChildren(orderedNodes);
        ScreenModel[] screens = ActionUtilities.nodesToScreens(prunedNodes);
        return ActionUtilities.nodesToPaths(ActionUtilities.removeFixedScreenRoots(screens, expand, context));
    }

    public static ScreenModel[] removeFixedScreenRoots(ScreenModel[] screens, boolean expand, WhiteboardContext context) {
        if (screens == null) {
            return null;
        }
        LinkedList<ScreenModel> screensList = new LinkedList<ScreenModel>();
        for (int i = 0; i < screens.length; ++i) {
            if (screens[i] != context.getDataModel().getPublicScreens() && screens[i] != context.getDataModel().getPrivateScreens()) {
                screensList.add(screens[i]);
                continue;
            }
            if (!expand) continue;
            Iterator iter = screens[i].iterateScreens();
            while (iter.hasNext()) {
                WBNode node = (WBNode)iter.next();
                if (!(node instanceof ScreenModel)) continue;
                screensList.add((ScreenModel)node);
            }
        }
        ScreenModel[] newScreens = new ScreenModel[screensList.size()];
        newScreens = ActionUtilities.nodesToScreens(ActionUtilities.pruneRootChildren(screensList.toArray(newScreens)));
        return newScreens;
    }

    public static ScreenModel[] removeScreenRoots(ScreenModel[] screens, boolean expand, WhiteboardContext context) {
        if (screens == null) {
            return null;
        }
        LinkedList<ScreenModel> screensList = new LinkedList<ScreenModel>();
        for (int i = 0; i < screens.length; ++i) {
            if (screens[i] instanceof ScreenRoot) {
                if (!expand) continue;
                Iterator iter = screens[i].iterateScreens();
                while (iter.hasNext()) {
                    WBNode node = (WBNode)iter.next();
                    if (!(node instanceof ScreenModel)) continue;
                    screensList.add((ScreenModel)node);
                }
                continue;
            }
            screensList.add(screens[i]);
        }
        ScreenModel[] newScreens = new ScreenModel[screensList.size()];
        newScreens = ActionUtilities.nodesToScreens(ActionUtilities.pruneRootChildren(screensList.toArray(newScreens)));
        return newScreens;
    }

    public static TreePath[] orderPaths(TreePath[] pathsIn, WhiteboardContext context) {
        DisplayNode node;
        if (pathsIn == null || pathsIn.length <= 1 || context.getDataModel().getDisplayModel() == null || context.getDataModel().getDisplayModel().getDisplayRoot() == null) {
            return pathsIn;
        }
        int resultIndex = 0;
        HashMap<Object, Integer> map = new HashMap<Object, Integer>(pathsIn.length, 0.5f);
        for (int i = 0; i < pathsIn.length; ++i) {
            if (pathsIn[i] == null) continue;
            node = (DisplayNode)pathsIn[i].getLastPathComponent();
            map.put(node.getUserObject(), new Integer(i));
        }
        TreePath[] resultPaths = new TreePath[map.size()];
        Enumeration<TreeNode> enumeration = context.getDataModel().getDisplayModel().getDisplayRoot().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DisplayNode)enumeration.nextElement();
            Integer index = (Integer)map.get(node.getUserObject());
            if (index == null) continue;
            resultPaths[resultIndex++] = pathsIn[index];
        }
        if (resultIndex != pathsIn.length) {
            throw new RuntimeException("missed some node in orderPaths");
        }
        return resultPaths;
    }

    public static boolean isUIDInPaths(Long uid, TreePath[] pathsIn) {
        return ActionUtilities.isUIDInScreens(uid, ActionUtilities.pathsToNodes(pathsIn)) != null;
    }

    public static ScreenModel isUIDInScreens(Long uid, WBNode[] nodes) {
        ScreenModel result = null;
        if (nodes == null) {
            return null;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof ScreenModel) || !ActionUtilities.isUIDInScreen(uid, nodes[i])) continue;
            result = (ScreenModel)nodes[i];
            break;
        }
        return result;
    }

    public static boolean isUIDInScreen(Long uid, WBNode node) {
        WBNode child = null;
        boolean result = false;
        if (uid == null || node == null) {
            return false;
        }
        if (uid.equals(node.getObjectID())) {
            return true;
        }
        Iterator iter = node.iterateScreens();
        while (iter.hasNext()) {
            child = (WBNode)iter.next();
            if (child instanceof ScreenModel) {
                result = ActionUtilities.isUIDInScreen(uid, child);
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    public static TreePath[] pruneRootChildren(TreePath[] paths) {
        return ActionUtilities.nodesToPaths(ActionUtilities.pruneRootChildren(ActionUtilities.pathsToNodes(paths)));
    }

    public static WBNode[] pruneRootChildren(WBNode[] nodes) {
        WBNode node;
        int i;
        if (nodes == null) {
            return null;
        }
        HashSet<WBNode> set = new HashSet<WBNode>(nodes.length, 0.5f);
        for (i = 0; i < nodes.length; ++i) {
            set.add(nodes[i]);
        }
        block1: for (i = 0; i < nodes.length; ++i) {
            for (node = nodes[i].getParent(); node != null && !(node instanceof ScreenGroups); node = node.getParent()) {
                if (!set.contains(node)) continue;
                set.remove(nodes[i]);
                continue block1;
            }
        }
        int j = 0;
        WBNode[] result = new WBNode[set.size()];
        for (i = 0; i < nodes.length; ++i) {
            node = nodes[i];
            if (!set.contains(node)) continue;
            result[j++] = node;
            set.remove(node);
        }
        return result;
    }

    public static void selectParticipantsTools(ScreenModel screen, WBNode container, Short clientId) {
        Object[] tools = container.toolList.toArray();
        if (tools != null && tools.length > 0) {
            for (int toolIndex = 0; toolIndex < tools.length; ++toolIndex) {
                short toolID;
                AbstractToolModel tool;
                WBNode node = (WBNode)tools[toolIndex];
                if (node instanceof AbstractToolModel && !(node instanceof GroupToolModel)) {
                    tool = (AbstractToolModel)node;
                    toolID = ObjectUID.decodeClientId(tool.getObjectID());
                    if (toolID != clientId || !tool.isSelectable()) continue;
                    if (tool.getParent() instanceof GroupToolModel) {
                        // empty if block
                    }
                    screen.selectTool(tool);
                    continue;
                }
                if (!(node instanceof GroupToolModel) || node.isBackground()) continue;
                tool = (AbstractToolModel)node;
                toolID = ObjectUID.decodeClientId(tool.getObjectID());
                if (toolID == clientId && tool.isSelectable()) {
                    screen.selectTool(tool);
                    continue;
                }
                ActionUtilities.selectParticipantsTools(screen, node, clientId);
            }
        }
    }

    public static ScreenModel getGotoTarget(WBNode[] screens, int tryIndex, WBNode tryParent, Long watchingUID) {
        WBNode node;
        int i;
        WBNode parent;
        ScreenModel root = null;
        if (screens == null || watchingUID == null) {
            return null;
        }
        WBNode[] nodes = ActionUtilities.pruneRootChildren(screens);
        root = ActionUtilities.isUIDInScreens(watchingUID, nodes);
        if (root == null) {
            return null;
        }
        if (!root.isVisible() && tryParent instanceof ScreenModel) {
            if (((ScreenModel)tryParent).getGroupID() == 0) {
                ScreenRoot screen = root.getContext().getDataModel().getPublicScreens();
                if (screen != null) {
                    return ((ScreenModel)screen).getScreenDelegate();
                }
                return null;
            }
            Short groupId = ShortList.get((short)((ScreenModel)tryParent).getGroupID());
            ScreenRoot screen = root.getContext().getDataModel().getGroupRoot(groupId);
            if (screen != null) {
                return ((ScreenModel)screen).getScreenDelegate();
            }
            return null;
        }
        if (root instanceof ScreenRoot) {
            ScreenRoot screen = root.getContext().getDataModel().getPublicScreens();
            if (screen != null) {
                return ((ScreenModel)screen).getScreenDelegate();
            }
            return null;
        }
        int rootIndex = root.getIndex();
        if (rootIndex < 0) {
            if (tryIndex < 0) {
                return null;
            }
            rootIndex = tryIndex - 1;
        }
        if ((parent = root.getParent()) == null) {
            if (tryParent == null) {
                return null;
            }
            parent = tryParent;
        }
        for (i = rootIndex + 1; i < parent.getChildCount(); ++i) {
            node = parent.getChildAt(i);
            if (!(node instanceof ScreenModel) || ActionUtilities.isUIDInScreens(node.getObjectID(), nodes) != null) continue;
            return (ScreenModel)node;
        }
        rootIndex = root.getIndex();
        if (rootIndex < 0) {
            rootIndex = tryIndex;
        }
        for (i = rootIndex - 1; i >= 0; --i) {
            node = parent.getChildAt(i);
            if (!(node instanceof ScreenModel) || ActionUtilities.isUIDInScreens(node.getObjectID(), nodes) != null) continue;
            return (ScreenModel)node;
        }
        return (ScreenModel)parent;
    }

    public static ScreenNameFormat getScreenNameFormat(ScreenModel screen, WhiteboardContext context) {
        ScreenModel root = null;
        if (screen != null) {
            root = screen.getRoot();
        }
        if (root == null) {
            root = screen;
        }
        if (root == null) {
            return new I18nScreenNameFormat(StringsProperties.ACTIONUTILITIES_DEFAULTUNROOTEDSCREENNAME);
        }
        if (root.isPrivate()) {
            return new I18nScreenNameFormat(StringsProperties.ACTIONUTILITIES_DEFAULTPRIVATESCREENNAME);
        }
        if (context.getDataModel().getPublicScreens() == root) {
            return new PublicScreenNameFormat(StringsProperties.ACTIONUTILITIES_DEFAULTPUBLICSCREENNAME, context.getDefaultPublicScreenName());
        }
        return new SimpleScreenNameFormat(root.getScreenName() + " - ");
    }

    public static ScreenModel getScreenModel(TreePath path) {
        WBNode wbNode = ActionUtilities.getWBNode(path);
        if (wbNode == null || !(wbNode instanceof ScreenModel)) {
            return null;
        }
        return (ScreenModel)wbNode;
    }

    public static WBNode getWBNode(TreePath path) {
        Object obj;
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof WBNode) {
            return (WBNode)obj;
        }
        return null;
    }

    public static ImageToolModel createImageTool(WhiteboardContext context, Image image, String name) {
        return ActionUtilities.createImageTool(context, image, name, false);
    }

    public static ImageToolModel createImageTool(WhiteboardContext context, Image image, String name, boolean asBackground) {
        return ActionUtilities.createImageTool(context, image, name, image.getWidth(null), image.getHeight(null), asBackground);
    }

    public static ImageToolModel createImageTool(WhiteboardContext context, Image image, String name, int width, int height, boolean asBackground) {
        int imageHeight;
        String filename = FileSysUtils.replaceExtension((String)name, (String)"png");
        int thumbWidth = width;
        int thumbHeight = height;
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        int imageWidth = image.getWidth(null);
        double imageRatio = (double)imageWidth / (double)(imageHeight = image.getHeight(null));
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        int y = (height - thumbHeight) / 2;
        Rectangle area = new Rectangle(0, y, thumbWidth, thumbHeight);
        ImageToolModel imageTool = new ImageToolModel(context, ImageSupport.encodeAsPNG((Image)image), filename, filename, area);
        context.getObjectManager().setObjectInMap(imageTool);
        imageTool.setOriginator();
        imageTool.setFrameVisible(false);
        imageTool.setAsBackground(asBackground);
        return imageTool;
    }

    public static Point resolveLocation(Point location, ScreenModel screen, WhiteboardContext context) {
        if (location != null) {
            return location;
        }
        if (screen != null) {
            double pasteOffset = screen.getPasteOffset();
            screen.setPasteOffset(pasteOffset + 10.0);
            return new DPoint(pasteOffset, pasteOffset).getIntLocation();
        }
        int x = (int)context.getScaleX() + 10;
        int y = (int)context.getScaleY() + 10;
        return new Point(x, y);
    }
}

