/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class TriggerTransfer
extends AbstractCommContainer {
    public static final byte FLAG_YELLOW = 1;
    public static final byte FLAG_YELLOW_ON = 2;
    public static final byte FLAG_RED = 4;
    public static final byte FLAG_RED_ON = 8;
    public static final byte EMPTY_STATUS = 5;
    LinkedList triggers = null;

    public TriggerTransfer(WhiteboardContext context) {
        super(context, "_TriggerTransfer");
    }

    public TriggerTransfer(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"TriggerComm", (Throwable)e, (boolean)true);
        }
    }

    public void addTrigger(Short clientId, byte flags) {
        if (this.triggers == null) {
            this.triggers = new LinkedList();
        }
        Iterator iter = this.triggers.iterator();
        while (iter.hasNext()) {
            if (!((TriggerHolder)iter.next()).clientId.equals(clientId)) continue;
            iter.remove();
            break;
        }
        this.triggers.add(new TriggerHolder(clientId, flags));
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        try {
            super.streamToObject(istr);
            int count = WBUtils.readShort(istr, "TriggerTransfer reads count");
            for (int i = 0; i < count; ++i) {
                ClientInfo ci;
                short clientId = WBUtils.readShort(istr, "TriggerTransfer reads clientId");
                byte flags = WBUtils.readByte(istr, "TriggerTransfer reads flags");
                Short clientAddress = this.context.getIDProcessor().getClientAddress(ShortList.get((short)clientId));
                if (clientAddress == null || (ci = this.context.getClientList().get(clientAddress.shortValue())) == null) continue;
                if ((flags & 1) != 0) {
                    ci.setProperty("whiteboardYellowStatus", (flags & 2) != 0);
                }
                if ((flags & 4) == 0) continue;
                ci.setProperty("whiteboardRedStatus", (flags & 8) != 0);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        if (this.triggers == null) {
            return;
        }
        try {
            super.objectToStream(ostr);
            ostr.writeShort(this.triggers.size());
            for (TriggerHolder triggerHolder : this.triggers) {
                ostr.writeShort(triggerHolder.clientId.shortValue());
                ostr.writeByte(triggerHolder.flags);
            }
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"objectToStream", (Throwable)ioe, (boolean)true);
        }
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            int count = WBUtils.readShort(istr, "TriggerTransfer reads count");
            for (int i = 0; i < count; ++i) {
                short clientId = WBUtils.readShort(istr, "TriggerTransfer reads clientId");
                byte flags = WBUtils.readByte(istr, "TriggerTransfer reads flags");
                buf.append(" client: " + clientId + ", status: " + flags);
            }
        }
        catch (Exception ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }

    class TriggerHolder {
        Short clientId;
        byte flags;

        public TriggerHolder(Short clientId, byte flags) {
            this.clientId = clientId;
            this.flags = flags;
        }
    }
}

