/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardChairListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.ParticipantData;
import com.elluminate.groupware.whiteboard.conference.TriggerTransfer;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.ShortList;
import com.elluminate.util.WorkerThread;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StatusIndicators
implements Runnable,
WhiteboardChairListener {
    static final long PENDING_DELAY = 500L;
    static final long QUEUE_DELAY = 500L;
    static final long JITTER_DELAY = 500L;
    static final long TRIGGER_PULSE_STRETCH_TIME = 250L;
    static final long MAX_TIME = 0x3FFFFFFFFFFFFFFFL;
    public static final boolean DEBUG = false;
    public static final int STATUS_EMPTY_STATE = 0;
    static final int STATUS_CHANGED_STATE = 1;
    static final int ACCUMULATE_CHANGE_STATE = 2;
    static final int SEND_STATUS_STATE = 3;
    static final int WAIT_STATUS_STATE = 4;
    static final int DEJITTER_STATUS_STATE = 5;
    volatile LinkedList clientTimerList = new LinkedList();
    volatile LinkedList queueTimerList = new LinkedList();
    volatile HashMap sentMap = new HashMap();
    volatile boolean timerStarted = false;
    volatile boolean timerPaused = false;
    long queueTimer = 0x3FFFFFFFFFFFFFFFL;
    WhiteboardContext context;
    Thread timerThread = null;

    public StatusIndicators(WhiteboardContext context) {
        this.context = context;
    }

    public void noteStatusChange(Short clientId) {
        ParticipantData data = this.context.getDataExporter().getParticipantData(clientId);
        if (data != null && data.isOnline()) {
            this.processStatusChange(clientId, data);
        }
    }

    void processStatusChange(Short clientId, ParticipantData data) {
        switch (data.getStatusState()) {
            case 0: {
                if (data.getCurrentStatus() == 5) break;
                this.moveToState(1, clientId, data);
                this.setClientTimer(clientId, 500L, data);
                break;
            }
            case 1: {
                if (data.getCurrentStatus() != 5) break;
                this.removeClient(clientId);
                this.moveToEmptyState(clientId, data);
                break;
            }
            case 2: {
                if (data.getCurrentStatus() != data.getSentStatus() || data.getCurrentStatus() != 5) break;
                this.removeClient(clientId);
                this.moveToEmptyState(clientId, data);
                break;
            }
            case 3: {
                if (data.getCurrentStatus() == 5) {
                    this.removeClient(clientId);
                    this.moveToEmptyState(clientId, data);
                } else {
                    this.moveToState(4, clientId, data);
                }
            }
            case 4: {
                if (data.getCurrentStatus() == data.getSentStatus()) break;
                if ((data.getCurrentStatus() & 8) == 0) {
                    this.moveToState(5, clientId, data);
                    this.setClientTimer(clientId, 500L, data);
                    break;
                }
                this.moveToState(2, clientId, data);
                this.addQueueElement(clientId, 500L, data);
                break;
            }
            case 5: {
                if (data.getCurrentStatus() != data.getSentStatus()) break;
                this.removeClient(clientId);
                this.moveToState(4, clientId, data);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToEmptyState(Short clientId, ParticipantData data) {
        this.moveToState(0, clientId, data);
        HashMap hashMap = this.sentMap;
        synchronized (hashMap) {
            this.sentMap.remove(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClientTimer(Short clientId, long delay, ParticipantData data) {
        if (clientId == null) {
            return;
        }
        TimerElement timerElement = new TimerElement(clientId, System.currentTimeMillis() + delay, data);
        LinkedList linkedList = this.clientTimerList;
        synchronized (linkedList) {
            this.clientTimerList.addLast(timerElement);
        }
        this.startTimer(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddress(short jinxAddress) {
        Short clientId = this.context.getIDProcessor().getClientId(ShortList.get((short)jinxAddress));
        if (clientId != null) {
            this.removeClient(clientId);
            HashMap hashMap = this.sentMap;
            synchronized (hashMap) {
                this.sentMap.remove(clientId);
            }
        }
    }

    public void removeClient(Short clientId) {
        this.removeClient(clientId, this.clientTimerList);
        this.removeClient(clientId, this.queueTimerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(Short clientId, List list) {
        List list2 = list;
        synchronized (list2) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                TimerElement timerElement = (TimerElement)iter.next();
                if (timerElement != null && timerElement.getClientId() != null && !timerElement.getClientId().equals(clientId)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimer(Short clientId) {
        if (!this.timerStarted || this.timerPaused) {
            this.timerStarted = true;
            if (this.timerThread == null) {
                this.timerThread = new WorkerThread((Runnable)this, "WhiteboardStatus Timer");
                this.timerThread.setDaemon(true);
                this.timerPaused = false;
                this.timerThread.start();
            } else if (this.timerPaused) {
                this.timerPaused = false;
                Thread thread = this.timerThread;
                synchronized (thread) {
                    this.timerThread.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object;
        if (this.timerThread != null) {
            object = this.timerThread;
            synchronized (object) {
                Thread thread = this.timerThread;
                this.timerThread = null;
                this.timerStarted = false;
                this.timerPaused = false;
                thread.notifyAll();
            }
        }
        object = this.queueTimerList;
        synchronized (object) {
            this.queueTimerList.clear();
        }
        object = this.clientTimerList;
        synchronized (object) {
            this.clientTimerList.clear();
        }
        object = this.sentMap;
        synchronized (object) {
            this.sentMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueueElement(Short clientId, long delay, ParticipantData data) {
        if (clientId == null) {
            return;
        }
        if (this.queueTimer == 0x3FFFFFFFFFFFFFFFL) {
            this.queueTimer = System.currentTimeMillis() + delay;
        }
        TimerElement timerElement = new TimerElement(clientId, this.queueTimer, data);
        LinkedList linkedList = this.queueTimerList;
        synchronized (linkedList) {
            this.queueTimerList.addLast(timerElement);
        }
        this.startTimer(clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQueueElement(Short clientId) {
        LinkedList linkedList = this.queueTimerList;
        synchronized (linkedList) {
            this.removeClient(clientId, this.queueTimerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long triggerTime = 0x3FFFFFFFFFFFFFFFL;
        while (this.timerStarted) {
            long nextTime;
            Object object;
            long now = System.currentTimeMillis();
            triggerTime = 0x3FFFFFFFFFFFFFFFL;
            do {
                TimerElement timerElement;
                object = this.clientTimerList;
                synchronized (object) {
                    if (this.clientTimerList.isEmpty()) {
                        break;
                    }
                    timerElement = (TimerElement)this.clientTimerList.removeFirst();
                    triggerTime = timerElement.getTime();
                    if (triggerTime > now) {
                        this.clientTimerList.addFirst(timerElement);
                        break;
                    }
                }
                Short clientId = timerElement.getClientId();
                ParticipantData data = timerElement.getData();
                switch (data.getStatusState()) {
                    case 1: {
                        this.moveToState(2, clientId, data);
                        this.addQueueElement(clientId, 500L, data);
                        break;
                    }
                    case 2: {
                        this.emitQueue();
                        break;
                    }
                    case 5: {
                        this.moveToState(2, clientId, data);
                        this.addQueueElement(clientId, 500L, data);
                        break;
                    }
                }
            } while ((triggerTime = 0x3FFFFFFFFFFFFFFFL) <= now || triggerTime == 0x3FFFFFFFFFFFFFFFL);
            object = this.queueTimerList;
            synchronized (object) {
                if (!this.queueTimerList.isEmpty()) {
                    if (this.queueTimer <= now) {
                        this.emitQueue();
                    }
                } else {
                    this.queueTimer = 0x3FFFFFFFFFFFFFFFL;
                }
                nextTime = triggerTime < this.queueTimer || this.queueTimerList.isEmpty() ? triggerTime : this.queueTimer;
            }
            try {
                now = System.currentTimeMillis();
                if (nextTime >= 0x3FFFFFFFFFFFFFFFL) {
                    this.timerPaused = true;
                }
                if (nextTime - now <= 0L) continue;
                object = this.timerThread;
                synchronized (object) {
                    this.timerThread.wait(nextTime - now);
                }
            }
            catch (InterruptedException ie) {
                WBUtils.timedLog("InterruptedException", ie.toString());
                this.timerStarted = false;
                break;
            }
        }
    }

    private void moveToState(int newState, Short clientId, ParticipantData data) {
        data.setStatusState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitQueue() {
        TriggerTransfer triggerComm = null;
        LinkedList linkedList = this.queueTimerList;
        synchronized (linkedList) {
            if (this.queueTimerList.isEmpty()) {
                return;
            }
            triggerComm = new TriggerTransfer(this.context);
            this.queueTimer = 0x3FFFFFFFFFFFFFFFL;
            Iterator iterQueue = this.queueTimerList.iterator();
            while (iterQueue.hasNext()) {
                TimerElement timerElement = (TimerElement)iterQueue.next();
                iterQueue.remove();
                Short clientId = timerElement.getClientId();
                ParticipantData data = timerElement.getData();
                data.setSentStatus(data.getCurrentStatus());
                triggerComm.addTrigger(clientId, data.getSentStatus());
                this.sentMap.put(clientId, data);
                this.moveToState(3, clientId, data);
            }
        }
        ClientList clients = this.context.getClientList();
        LinkedList<Short> targetList = new LinkedList<Short>();
        if (clients != null) {
            Iterator iter = this.context.getChairManager().chairJinxIterator();
            while (iter.hasNext()) {
                Short jinxAddress = (Short)iter.next();
                targetList.add(jinxAddress);
            }
            short[] targetArray = new short[targetList.size()];
            int index = 0;
            iter = targetList.iterator();
            while (iter.hasNext()) {
                targetArray[index++] = (Short)iter.next();
            }
            this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)triggerComm, targetArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitSentToChair(Short jinxAddress) {
        TriggerTransfer triggerComm;
        HashMap hashMap = this.sentMap;
        synchronized (hashMap) {
            if (this.sentMap.isEmpty()) {
                return;
            }
            triggerComm = new TriggerTransfer(this.context);
            for (ParticipantData data : this.sentMap.values()) {
                data.setSentStatus(data.getCurrentStatus());
                triggerComm.addTrigger(data.getClientId(), data.getSentStatus());
            }
        }
        this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)triggerComm, (short)jinxAddress);
    }

    @Override
    public void onWhiteboardChairChange(Short clientId, Short jinxAddress, boolean add) {
        if (add) {
            this.emitSentToChair(jinxAddress);
        }
    }

    class TimerElement
    implements Comparable {
        private Short clientId;
        private long time;
        private ParticipantData data;

        public TimerElement(Short clientId, long time, ParticipantData data) {
            this.clientId = clientId;
            this.time = time;
            this.data = data;
        }

        public Short getClientId() {
            return this.clientId;
        }

        public long getTime() {
            return this.time;
        }

        public ParticipantData getData() {
            return this.data;
        }

        public int compareTo(Object object) {
            return WBUtils.comparison(this.clientId - (Short)object);
        }

        public String toString() {
            return "TimerElement: client: " + this.clientId + ", time: " + WBUtils.decodeTime(this.time);
        }
    }
}

