/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.conference.AvailableScreenEntry;
import com.elluminate.groupware.whiteboard.conference.ViewedScreen;
import com.elluminate.groupware.whiteboard.conference.ViewedScreens;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class ScreenViewing {
    public static final float FORWARD_FACTOR = 1.0f;
    public static final float BACKWARD_FACTOR = 2.0f;
    private HashMap parentMap = new HashMap();
    private LinkedList viewedScreens = null;

    public void addViewedScreen(Long screenUID, ViewedScreens.ScreenViewerList viewedScreensViewers) {
        if (this.viewedScreens == null) {
            this.viewedScreens = new LinkedList();
        }
        this.viewedScreens.add(new ViewedScreen(screenUID, viewedScreensViewers));
        Collections.sort(this.viewedScreens);
    }

    public void removeViewedScreen(Long screenUID) {
        if (this.viewedScreens == null) {
            throw new RuntimeException("attempt to remove viewed screen when no screens being viewed");
        }
        Iterator iter = this.viewedScreens.iterator();
        while (iter.hasNext()) {
            ViewedScreen viewedScreen = (ViewedScreen)iter.next();
            if (!viewedScreen.screenUID.equals(screenUID)) continue;
            viewedScreen.dispose();
            iter.remove();
            return;
        }
        throw new RuntimeException("screen: " + WBUtils.uniqueIDAsHex(screenUID) + ", to be removed from viewed screen set, is not in the set");
    }

    public void clear() {
        Iterator<Object> iter;
        if (this.viewedScreens != null) {
            iter = this.viewedScreens.iterator();
            while (iter.hasNext()) {
                ViewedScreen viewedScreen = (ViewedScreen)iter.next();
                viewedScreen.dispose();
                iter.remove();
            }
        }
        iter = this.parentMap.entrySet().iterator();
        while (iter.hasNext()) {
            AvailableScreenEntry entry = (AvailableScreenEntry)iter.next();
            AvailableScreenEntry nextEntry = entry.next;
            while (nextEntry != null) {
                entry.next = nextEntry.next;
                nextEntry.dispose();
                nextEntry = entry.next;
            }
            entry.dispose();
            iter.remove();
        }
    }

    public ScreenModel getBestScreen() {
        if (this.viewedScreens == null || this.viewedScreens.isEmpty()) {
            return null;
        }
        ViewedScreen viewedScreen = (ViewedScreen)this.viewedScreens.getFirst();
        if (viewedScreen.target == null) {
            return null;
        }
        return viewedScreen.screen;
    }

    public void addAvailableScreen(ScreenModel screen) {
    }

    public void removeAvailableScreen(ScreenModel screen) {
    }
}

