/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;

public class RecognizeClient
extends AbstractCommContainer {
    Short clientAddress;
    Short clientId;
    String clientName;

    public RecognizeClient(WhiteboardContext context) {
        super(context, "_RecognizeClient");
    }

    public void bindID(Short clientAddress, Short clientId, String clientName) {
        this.clientAddress = clientAddress;
        this.clientId = clientId;
        this.clientName = clientName;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.clientAddress.shortValue());
        ostr.writeShort(this.clientId.shortValue());
        ostr.writeUTF(this.clientName);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        Short clientAddress = ShortList.get((short)WBUtils.readShort(istr, "RecognizeClient reads clientAddress"));
        Short clientId = ShortList.get((short)WBUtils.readShort(istr, "RecognizeClient reads clientId"));
        String clientName = WBUtils.readUTF(istr, "RecognizeClient reads clientName");
        this.context.getIDProcessor().addClient(clientAddress, clientId, clientName);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            short clientAddress = WBUtils.readShort(istr, "RecognizeClient string tests new clientAddress");
            short clientId = WBUtils.readShort(istr, "RecognizeClient string tests old clientId");
            String clientName = WBUtils.readUTF(istr, "RecognizeClient string reads clientName");
            buf.append(" clientAddress=" + clientAddress);
            buf.append(", clientId=" + clientId);
            buf.append(", clientName='" + clientName + "'");
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }
}

