/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import java.util.LinkedList;

public class QueueBuffer {
    private static final boolean DEBUG = false;
    private LinkedList hiPriQueue = new LinkedList();
    private long hiPriDepthSum = 0L;
    private int hiPriDepthMax = 0;
    private int hiPriCallCount = 0;
    private LinkedList loPriQueue = new LinkedList();
    private long loPriDepthSum = 0L;
    private int loPriDepthMax = 0;
    private int loPriCallCount = 0;
    private volatile boolean running = false;
    private boolean wakeEvery = false;
    private boolean wakeOnSwing = false;
    private Runnable runnable = null;
    private long addCount = 0L;
    private Thread worker = null;
    private Runnable runner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            long wakeCount = 0L;
            while (QueueBuffer.this.running) {
                LinkedList linkedList = QueueBuffer.this.hiPriQueue;
                synchronized (linkedList) {
                    while (QueueBuffer.this.running && (QueueBuffer.this.hiPriQueue.isEmpty() && QueueBuffer.this.loPriQueue.isEmpty() || QueueBuffer.this.addCount == wakeCount)) {
                        try {
                            if (!QueueBuffer.this.running) continue;
                            QueueBuffer.this.hiPriQueue.wait();
                        }
                        catch (InterruptedException ie) {}
                    }
                    if (!QueueBuffer.this.running || QueueBuffer.this.hiPriQueue.isEmpty() && QueueBuffer.this.loPriQueue.isEmpty()) continue;
                }
                wakeCount = QueueBuffer.this.addCount;
                if (QueueBuffer.this.wakeOnSwing) {
                    SwingRunnerSupport.invokeLater((Runnable)QueueBuffer.this.runnable);
                    continue;
                }
                QueueBuffer.this.runnable.run();
            }
            return;
        }
    };
    private String name;

    public QueueBuffer(String name, Runnable runnable, boolean wakeEvery, boolean wakeOnSwing) {
        this.name = name;
        this.runnable = runnable;
        this.wakeEvery = wakeEvery;
        this.wakeOnSwing = wakeOnSwing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(Object element, boolean priority) {
        LinkedList linkedList = this.hiPriQueue;
        synchronized (linkedList) {
            if (priority) {
                this.hiPriQueue.addLast(element);
            } else {
                this.loPriQueue.addLast(element);
            }
            ++this.addCount;
            if (!this.running) {
                this.running = true;
                this.worker = new WorkerThread(this.runner, this.name, 5);
                this.worker.setDaemon(true);
                this.worker.start();
            } else {
                this.hiPriQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextElement() {
        Object element = null;
        LinkedList linkedList = this.hiPriQueue;
        synchronized (linkedList) {
            if (this.hiPriQueue.isEmpty() && this.loPriQueue.isEmpty()) {
                this.hiPriQueue.notifyAll();
                return null;
            }
            if (!this.hiPriQueue.isEmpty()) {
                this.hiPriDepthMax = Math.max(this.hiPriDepthMax, this.hiPriQueue.size());
                element = this.hiPriQueue.removeFirst();
                ++this.hiPriCallCount;
                this.hiPriDepthSum += (long)this.hiPriQueue.size();
            } else if (!this.loPriQueue.isEmpty()) {
                this.loPriDepthMax = Math.max(this.loPriDepthMax, this.loPriQueue.size());
                element = this.loPriQueue.removeFirst();
                ++this.loPriCallCount;
                this.loPriDepthSum += (long)this.loPriQueue.size();
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LinkedList linkedList = this.hiPriQueue;
        synchronized (linkedList) {
            this.halt();
            this.hiPriQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        LinkedList linkedList = this.hiPriQueue;
        synchronized (linkedList) {
            if (this.running && this.worker != null) {
                this.running = false;
                this.worker.interrupt();
                this.hiPriQueue.notifyAll();
            }
        }
    }

    public String toString() {
        return this.worker.getName() + ", QueueBuffer.halt:\n     High Pri Max: " + this.hiPriDepthMax + ", High Pri Calls: " + this.hiPriCallCount + ", High Pri Ave Depth: " + (double)this.hiPriDepthSum / Math.max((double)this.hiPriCallCount, 1.0) + "\n     Low Pri Max: " + this.loPriDepthMax + ", Low Pri Calls: " + this.loPriCallCount + ", Low Pri Ave Depth: " + (double)this.loPriDepthSum / Math.max((double)this.loPriCallCount, 1.0);
    }
}

