/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.conference.FollowListener;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DataModelListener;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupManager
implements DataModelListener {
    public static final Short MAIN_GROUP_ID = ShortList.get((short)0);
    private HashMap groupMap = new HashMap();
    private WhiteboardContext context;
    private List<FollowListener> listeners = new ArrayList<FollowListener>();

    public GroupManager(WhiteboardContext context) {
        this.context = context;
        context.getDataModel().addDataModelListener(this);
    }

    public void defineNullGroup() {
        GroupInfo info = !this.context.isClient() ? new GroupInfo(this.context.isFollowDefault() || this.context.isSupervised(), ACLEntry.NULL_GROUP, this.context.getDataModel().getPublicScreens().getObjectID()) : new GroupInfo(false, ACLEntry.NULL_GROUP, this.context.getDataModel().getPrivateScreens().getObjectID());
        this.groupMap.put(ACLEntry.NULL_GROUP, info);
    }

    public GroupInfo getGroupInfo() {
        return this.getGroupInfo(this.context.getIDProcessor().getMyGroupId());
    }

    public GroupInfo getGroupInfo(Short groupId) {
        try {
            GroupInfo info = (GroupInfo)this.groupMap.get(groupId);
            return info;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setFollowInstructor(Short groupId, Long screenUID) {
        try {
            GroupInfo info = (GroupInfo)this.groupMap.get(groupId);
            if (info == null) {
                info = new GroupInfo(true, groupId, screenUID);
                this.groupMap.put(groupId, info);
            }
            boolean followChanged = info.setFollowInstructor(true);
            boolean screenChanged = info.setScreenUID(screenUID);
            for (FollowListener lst : this.listeners) {
                try {
                    if (screenChanged) {
                        lst.onSetScreen(groupId, screenUID);
                    }
                    if (!followChanged) continue;
                    lst.onFollowInstructorChanged(groupId, true);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"setFollowInstructor", (Throwable)t, (boolean)true);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setFollowInstructor", (Throwable)ex, (boolean)true);
        }
    }

    public boolean setScreenUID(Short groupId, Long screenUID) {
        try {
            GroupInfo info = (GroupInfo)this.groupMap.get(groupId);
            if (info == null || info.getScreenUID().equals(screenUID)) {
                return false;
            }
            boolean screenChanged = info.setScreenUID(screenUID);
            for (FollowListener lst : this.listeners) {
                try {
                    if (!screenChanged) continue;
                    lst.onSetScreen(groupId, screenUID);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"setFollowInstructor", (Throwable)t, (boolean)true);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setScreenUID", (Throwable)ex, (boolean)true);
        }
        return true;
    }

    public void clearFollowInstructor(Short groupId) {
        try {
            GroupInfo info = (GroupInfo)this.groupMap.get(groupId);
            if (info == null) {
                info = new GroupInfo(true, groupId, null);
                this.groupMap.put(groupId, info);
            }
            boolean followChanged = info.setFollowInstructor(false);
            for (FollowListener lst : this.listeners) {
                try {
                    if (!followChanged) continue;
                    lst.onFollowInstructorChanged(groupId, false);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"setFollowInstructor", (Throwable)t, (boolean)true);
                }
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"clearFollowInstructor", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFollowListener(FollowListener lst) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ArrayList<FollowListener> copy = new ArrayList<FollowListener>(this.listeners);
            copy.add(lst);
            this.listeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFollowListener(FollowListener lst) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ArrayList<FollowListener> copy = new ArrayList<FollowListener>(this.listeners);
            copy.remove(lst);
            this.listeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupsToStream(WBOutputStream ostr) throws Exception {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ostr.writeShort((short)this.groupMap.size());
            for (Map.Entry entry : this.groupMap.entrySet()) {
                GroupInfo info = (GroupInfo)entry.getValue();
                info.groupInfoToStream(ostr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamToGroups(WBInputStream istr) throws Exception {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            int groupCount = WBUtils.readShort(istr, "GroupManager.streamToGroups reads group count");
            this.groupMap.clear();
            for (int i = 0; i < groupCount; ++i) {
                GroupInfo info = new GroupInfo();
                info.groupInfoFromStream(istr);
                this.groupMap.remove(info.getGroupId());
                this.groupMap.put(info.getGroupId(), info);
            }
        }
    }

    public String streamToGroupString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer("GroupManager:\n");
        try {
            int groupCount = WBUtils.readShort(istr, "GroupManager.streamToGroups reads group count");
            this.groupMap.clear();
            for (int i = 0; i < groupCount; ++i) {
                GroupInfo info = new GroupInfo();
                info.groupInfoFromStream(istr);
                buf.append("\t" + info + "\n");
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToGroupString", (Throwable)ex, (boolean)true);
        }
        return buf.toString();
    }

    @Override
    public void nodeAdded(WBNode addedNode, WBNode parentNode) {
    }

    @Override
    public void nodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
        for (Map.Entry entry : this.groupMap.entrySet()) {
            GroupInfo info = (GroupInfo)entry.getValue();
            if (info == null) continue;
            Short groupId = info.getGroupId();
            this.updateFollowingScreen(info, removedNode, removedIndex, parentNode);
        }
    }

    private void updateFollowingScreen(GroupInfo info, WBNode removedNode, int removedIndex, WBNode parentNode) {
        Object pending = null;
        if (!(removedNode instanceof ScreenModel) || !parentNode.isConferenceNode()) {
            return;
        }
        Long screenUID = info.getScreenUID();
        ScreenModel gotoTarget = null;
        if (screenUID == null || !(removedNode instanceof ScreenModel)) {
            return;
        }
        if (!ActionUtilities.isUIDInScreen(screenUID, removedNode)) {
            return;
        }
        if ((parentNode.getRoot() != null && parentNode.getParent() != null || parentNode instanceof ScreenGroups) && (gotoTarget = ActionUtilities.getGotoTarget(new WBNode[]{removedNode}, removedIndex, parentNode, info.getScreenUID())) != null) {
            this.setScreenUID(info.getGroupId(), gotoTarget.getObjectID());
        }
    }

    public class GroupInfo {
        private boolean followInstructor = false;
        private Long screenUID;
        private Short groupId;

        public GroupInfo() {
            this.groupId = null;
            this.screenUID = null;
        }

        public GroupInfo(boolean followInstructor, Short groupId, Long screenUID) {
            this.followInstructor = followInstructor;
            this.groupId = groupId;
            this.screenUID = screenUID;
        }

        public boolean isFollowInstructor() {
            return this.followInstructor;
        }

        public boolean setFollowInstructor(boolean followInstructor) {
            boolean changed = this.followInstructor != followInstructor;
            this.followInstructor = followInstructor;
            return changed;
        }

        public Short getGroupId() {
            return this.groupId;
        }

        public void setGroupId(Short groupId) {
            this.groupId = groupId;
        }

        public Long getScreenUID() {
            if (this.screenUID == null) {
                if (GroupManager.this.context.getDataModel().getGroupRoot(this.groupId) != null) {
                    return GroupManager.this.context.getDataModel().getGroupRoot(this.groupId).getObjectID();
                }
                return null;
            }
            return this.screenUID;
        }

        public boolean setScreenUID(Long screenUID) {
            boolean changed = screenUID == null ? this.screenUID != null : (this.screenUID == null ? true : !screenUID.equals(this.screenUID));
            this.screenUID = screenUID;
            return changed;
        }

        public void groupInfoToStream(WBOutputStream ostr) throws Exception {
            ostr.writeShort(this.groupId.shortValue());
            ostr.writeBoolean(this.followInstructor);
            ObjectUID.objectUIDToStream(this.screenUID, ostr);
        }

        public void groupInfoFromStream(WBInputStream istr) throws Exception {
            this.groupId = ShortList.get((short)WBUtils.readShort(istr, "GroupInfo reads groupId"));
            this.followInstructor = WBUtils.readBoolean(istr, "GroupInfo reads followInstructor");
            this.screenUID = ObjectUID.objectUIDFromStream(istr);
        }

        public String toString() {
            return "GroupInfo: groupId: " + this.groupId + ", screenUID: " + this.screenUID + ", followInstructor: " + this.followInstructor;
        }
    }
}

