/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.conference.StringsProperties;
import com.elluminate.groupware.whiteboard.conference.UpdateClientIdentification;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.listeners.ClientIDListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ClientIdentification
implements ClientListener {
    static I18n i18n = I18n.create((Object)new Object(){});
    public static final short NULL_CLIENT_SHORT = -1;
    public static final Short NULL_CLIENT = ShortList.get((short)-1);
    public static final short CLIENT_LOCAL_SHORT = 0;
    public static final Short CLIENT_LOCAL = ShortList.get((short)0);
    public static final short SERVER_ID_SHORT = 1;
    public static final Short SERVER_ID = ShortList.get((short)1);
    public static final short RECORDER_ID_SHORT = 2;
    public static final Short RECORDER_ID = ShortList.get((short)2);
    public static final short BASE_CLIENT_ID = 3;
    public static final short START_RESERVED_IDS = -4;
    public static final short LIST_EOL_SHORT = -4;
    public static final Short LIST_EOL = ShortList.get((short)-4);
    public static final short LIST_SPAN_SHORT = -3;
    public static final Short LIST_SPAN = ShortList.get((short)-3);
    public static final String MY_NAME = i18n.getString((PropertiesEnum)StringsProperties.CLIENTIDENTIFICATION_MY_NAME);
    public static final String SERVER_NAME = i18n.getString((PropertiesEnum)StringsProperties.CLIENTIDENTIFICATION_SERVER_NAME);
    public static final String RECORDER_NAME = i18n.getString((PropertiesEnum)StringsProperties.CLIENTIDENTIFICATION_RECORDER_NAME);
    short newClientSequenceNumber = (short)3;
    Short localClientId = CLIENT_LOCAL;
    Short localClientAddress = null;
    HashMap clientByAddressMap = new HashMap();
    HashMap addressByClientMap = new HashMap();
    HashMap nameByClientMap = new HashMap();
    HashMap groupByClientMap = new HashMap();
    HashMap roleByClientMap = new HashMap();
    HashMap reservedAddresses = new HashMap();
    private WhiteboardContext context;
    private LinkedList clientListeners = new LinkedList();

    public ClientIdentification(WhiteboardContext context) {
        this.context = context;
        this.reservedAddresses.put(ShortList.get((short)0), SERVER_ID);
        this.reservedAddresses.put(ShortList.get((short)1), RECORDER_ID);
        this.addClient(ShortList.get((short)0), SERVER_ID, SERVER_NAME);
        this.addClient(ShortList.get((short)1), RECORDER_ID, RECORDER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short addClient(Short clientAddress, Short clientId, String clientName) {
        Short result = clientId;
        Short oldAddress = null;
        boolean reservedAddress = this.reservedAddresses.containsKey(clientAddress);
        if (reservedAddress) {
            result = (Short)this.reservedAddresses.get(clientAddress);
        }
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientAddress == 0 && !this.context.isClient()) {
                this.localClientId = result;
                result = CLIENT_LOCAL;
            } else if (this.context.getClientList() != null && this.context.getClientList().getMyAddress() == clientAddress.shortValue()) {
                this.localClientId = result;
                result = CLIENT_LOCAL;
            }
            if (!reservedAddress) {
                if (this.clientByAddressMap.containsKey(clientAddress)) {
                    Short client = (Short)this.clientByAddressMap.get(clientAddress);
                    this.addressByClientMap.remove(client);
                    this.nameByClientMap.remove(client);
                    this.clientByAddressMap.remove(clientAddress);
                }
                if (result != null) {
                    if (this.addressByClientMap.containsKey(result)) {
                        oldAddress = (Short)this.addressByClientMap.get(result);
                        if (this.clientByAddressMap.remove(oldAddress) == null) {
                            LogSupport.message((Object)this, (String)"addClient", (String)("clientAddress not removed from clientByAddress(2): " + oldAddress));
                        }
                        if (this.addressByClientMap.remove(result) == null) {
                            LogSupport.message((Object)this, (String)"addClient", (String)("client not removed from addressByClient(2): " + result));
                        }
                        if (this.nameByClientMap.remove(result) == null) {
                            LogSupport.message((Object)this, (String)"addClient", (String)("client not removed from nameByClient(2): " + result));
                        }
                    }
                } else {
                    int count = Short.MAX_VALUE;
                    boolean fail = true;
                    do {
                        Short address;
                        short s = this.newClientSequenceNumber;
                        this.newClientSequenceNumber = (short)(s + 1);
                        result = ShortList.get((short)s);
                        if (this.newClientSequenceNumber == -4) {
                            this.newClientSequenceNumber = (short)3;
                        }
                        if ((address = (Short)this.addressByClientMap.get(result)) != null && this.context.getClientList().get(address.shortValue()) != null) continue;
                        fail = false;
                        break;
                    } while (--count > 0);
                    if (fail) {
                        throw new RuntimeException("Full ClientID set. Cannot allocate new clientId.");
                    }
                }
            }
            this.clientByAddressMap.put(clientAddress, result);
            this.addressByClientMap.put(result, clientAddress);
            this.nameByClientMap.remove(result);
            this.nameByClientMap.put(result, clientName);
            this.setGroupId(result);
            this.setRole(result);
            if (this.context.isOnline() && this.context.getChairManager() != null) {
                this.context.getChairManager().updateChair();
            }
        }
        this.context.getACLManager().addClient(clientAddress);
        this.fireClientIDListeners(0, result, clientAddress);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(Short clientAddress) {
        Short client;
        if (this.reservedAddresses.containsKey(clientAddress)) {
            return;
        }
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            client = this.clientOfId((Short)this.clientByAddressMap.get(clientAddress));
            if (client != null) {
                this.addressByClientMap.remove(client);
                this.nameByClientMap.remove(client);
                this.roleByClientMap.remove(client);
                this.clientByAddressMap.remove(clientAddress);
            }
        }
        this.fireClientIDListeners(1, client, clientAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientIDListener(ClientIDListener l) {
        LinkedList linkedList = this.clientListeners;
        synchronized (linkedList) {
            if (!this.clientListeners.contains(l)) {
                this.clientListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientIDListener(ClientIDListener l) {
        LinkedList linkedList = this.clientListeners;
        synchronized (linkedList) {
            this.clientListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireClientIDListeners(int type, Short clientId, Short address) {
        LinkedList linkedList = this.clientListeners;
        synchronized (linkedList) {
            for (ClientIDListener listener : this.clientListeners) {
                listener.onClientID(type, clientId, address);
            }
        }
    }

    public void onAddClient(ClientEvent e) {
    }

    public void onRemoveClient(ClientEvent e) {
        Short clientAddress = ShortList.get((short)e.getAddress());
        this.fireClientIDListeners(2, this.getClientId(clientAddress), clientAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            return this.clientByAddressMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getClientIdEntryIterator() {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            return this.clientByAddressMap.entrySet().iterator();
        }
    }

    public short localToConference(short localClientId) {
        short result = localClientId == 0 ? this.localClientId : localClientId;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short conferenceToLocal(short clientId, short clientAddress) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == 0 && clientId != -32767) {
                Short result = (Short)this.clientByAddressMap.get(ShortList.get((short)clientAddress));
                if (result == null) {
                    throw new RuntimeException("ClientIdentification.conferenceToLocal: unknown address: " + clientAddress);
                }
                return result;
            }
            if (clientId == this.localClientId) {
                return 0;
            }
            return clientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] getDisconnectedclientsArray(ClientList clientList) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            ArrayList<Short> clients = new ArrayList<Short>(clientList.size());
            for (Short address : this.clientByAddressMap.values()) {
                if (clientList.get(address.shortValue()) != null) continue;
                clients.add(address);
            }
            short[] result = new short[clients.size()];
            if (!clients.isEmpty()) {
                Collections.sort(clients);
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (Short)clients.get(i);
                }
            }
            return result;
        }
    }

    public Short getMyId() {
        return this.localClientId;
    }

    public boolean isLocalClient(Short clientId) {
        if (clientId == null) {
            return false;
        }
        return clientId.equals(this.localClientId) || clientId.equals(CLIENT_LOCAL);
    }

    public Short getMyGroupId() {
        if (this.context.getClientList() != null) {
            ClientInfo ci = this.context.getClientList().getMyClient();
            if (ci == null) {
                return ACLEntry.NULL_GROUP;
            }
            return ShortList.get((short)ci.getGroupID());
        }
        return ACLEntry.NULL_GROUP;
    }

    public Short getMyAddress() {
        return this.localClientAddress;
    }

    public String getMyName() {
        return MY_NAME;
    }

    public void setMyAddress(short clientAddress) {
        this.localClientAddress = ShortList.get((short)clientAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getClientId(Short clientAddress) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientAddress == null) {
                return null;
            }
            return this.clientOfId((Short)this.clientByAddressMap.get(clientAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getGroupId(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == null) {
                LogSupport.error((Object)this, (String)"getGroupId", (String)"Null clientId to setGroup");
                return null;
            }
            return (Short)this.groupByClientMap.get(this.clientOfId(clientId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupId(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            ClientInfo clientInfo;
            if (clientId == null) {
                return;
            }
            Short client = this.clientOfId(clientId);
            Short clientAddress = this.getClientAddress(client);
            if (clientAddress == null) {
                return;
            }
            short groupId = clientAddress == 0 || this.context.getClientList() == null ? ACLEntry.NULL_GROUP : ((clientInfo = this.context.getClientList().get(clientAddress.shortValue())) == null ? (short)0 : clientInfo.getGroupID());
            this.groupByClientMap.remove(client);
            this.groupByClientMap.put(client, ShortList.get((short)groupId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRole(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == null) {
                Thread.dumpStack();
                return;
            }
            Short client = this.clientOfId(clientId);
            Short clientAddress = (Short)this.addressByClientMap.get(client);
            if (clientAddress == null) {
                return;
            }
            Role role = (Role)this.roleByClientMap.get(client);
            if (role == null) {
                role = new Role(clientAddress, this.context);
                this.roleByClientMap.put(client, role);
            } else {
                role.defineRole(clientAddress, this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getClientAddress(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == null) {
                return null;
            }
            if (this.getMyAddress() != null && (clientId.equals(CLIENT_LOCAL) || clientId.equals(this.localClientId))) {
                return this.getMyAddress();
            }
            Short address = (Short)this.addressByClientMap.get(this.clientOfId(clientId));
            return address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientName(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == null) {
                return null;
            }
            String name = (String)this.nameByClientMap.get(this.clientOfId(clientId));
            return name;
        }
    }

    public boolean isOnline(Short clientId) {
        try {
            short clientAddress = this.getClientAddress(clientId);
            ClientInfo info = this.context.getClientList().get(clientAddress);
            return info != null && info.getState() == 2;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendParticipantData(short[] addresses) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            UpdateClientIdentification partId = new UpdateClientIdentification(this.context, this.addressByClientMap, this.nameByClientMap);
            this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)partId, addresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientIdentification(HashMap addressByClientMap, HashMap nameByClientMap) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            this.newClientSequenceNumber = 0;
            HashMap<Short, Short> clientBy = new HashMap<Short, Short>(addressByClientMap.size());
            HashMap<Short, Short> addressBy = new HashMap<Short, Short>(addressByClientMap.size());
            this.roleByClientMap.clear();
            for (Map.Entry entry : addressByClientMap.entrySet()) {
                Short clientId = (Short)entry.getKey();
                Short clientAddress = (Short)entry.getValue();
                if (clientAddress.shortValue() == this.context.getClientList().getMyAddress()) {
                    this.localClientId = (Short)entry.getKey();
                    clientId = CLIENT_LOCAL;
                    nameByClientMap.put(clientId, nameByClientMap.get(this.localClientId));
                    addressBy.put(this.localClientId, clientAddress);
                }
                clientBy.put(clientAddress, clientId);
                addressBy.put(clientId, clientAddress);
                this.roleByClientMap.put(clientId, new Role(clientAddress, this.context));
                if (clientId < this.newClientSequenceNumber) continue;
                this.newClientSequenceNumber = (short)(clientId + 1);
            }
            this.clientByAddressMap.clear();
            this.clientByAddressMap = clientBy;
            this.addressByClientMap.clear();
            this.addressByClientMap = addressBy;
            this.nameByClientMap = nameByClientMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role getRole(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == null) {
                LogSupport.error((Object)this, (String)"getRole", (String)"ClientIdentification.getRole, null clientId");
                return null;
            }
            return (Role)this.roleByClientMap.get(this.clientOfId(clientId));
        }
    }

    public boolean isChair(Short clientId) {
        boolean result = false;
        Role role = this.getRole(clientId);
        if (role != null) {
            return role.isChair();
        }
        return result;
    }

    public boolean isServer(Short clientId) {
        Short address = this.getClientAddress(clientId);
        return address != null && address == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short clientOfId(Short clientId) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            if (clientId == null) {
                return null;
            }
            if (clientId.equals(this.localClientId)) {
                return CLIENT_LOCAL;
            }
            return clientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChair(Chair chair) {
        ClientIdentification clientIdentification = this;
        synchronized (clientIdentification) {
            for (Role role : this.roleByClientMap.values()) {
                if (chair != null) {
                    role.setChair(chair.contains(role.getClientAddress().shortValue()));
                    continue;
                }
                role.setChair(this.context.isChair());
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ClientIdentification has entries= " + this.addressByClientMap.size() + "\n");
        for (Map.Entry entry : this.addressByClientMap.entrySet()) {
            buf.append("  client: " + entry.getKey() + ", mapped to address: " + entry.getValue() + "\n");
        }
        for (Map.Entry entry : this.clientByAddressMap.entrySet()) {
            buf.append("  address: " + entry.getKey() + ", mapped to client: " + entry.getValue() + "\n");
        }
        for (Map.Entry entry : this.nameByClientMap.entrySet()) {
            buf.append("  client: " + entry.getKey() + ", has name: " + entry.getValue() + "\n");
        }
        for (Map.Entry entry : this.roleByClientMap.entrySet()) {
            buf.append("  client: " + entry.getKey() + ", has role: " + entry.getValue() + "\n");
        }
        for (Map.Entry entry : this.groupByClientMap.entrySet()) {
            buf.append(" client: " + entry.getKey() + " has groupId: " + entry.getValue() + "\n");
        }
        return buf.toString();
    }

    public class Role {
        boolean chair = false;
        boolean chairOfRecord = false;
        boolean server;
        boolean recorder;
        Short clientAddress;

        public Role(short clientAddress, WhiteboardContext context) {
            this.defineRole(clientAddress, context);
        }

        public void defineRole(short clientAddress, WhiteboardContext context) {
            this.clientAddress = ShortList.get((short)clientAddress);
            this.server = clientAddress == 0;
            boolean bl = this.recorder = clientAddress == 1;
            if (this.server) {
                this.chair = true;
            } else if (context != null && context.getClientList() != null) {
                Chair chair = ChairProtocol.getChair((ClientList)context.getClientList());
                this.chair = chair.contains(clientAddress);
            }
        }

        public boolean isChair() {
            return this.chair;
        }

        public boolean isChairOfRecord() {
            return this.chairOfRecord;
        }

        public void setChair(boolean chair) {
            this.chair = chair;
        }

        public boolean isServer() {
            return this.server;
        }

        public boolean isRecorder() {
            return this.recorder;
        }

        public Short getClientAddress() {
            return this.clientAddress;
        }

        public String toString() {
            return "Role: chair=" + this.chair + ", server=" + this.server + ", recorder=" + this.recorder + ", for address: " + this.clientAddress + "\n";
        }
    }
}

