/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.PenToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class ToolPath
extends AbstractAttribute
implements Cloneable {
    protected short[] path = null;
    protected int originalWidth;
    protected int originalHeight;
    protected Point originalLocation = null;
    protected boolean pathNotNormalized = false;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;

    public ToolPath(WhiteboardContext context) {
        super(context, "Path");
    }

    public ToolPath(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolPath(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ToolPath toolPath = (ToolPath)super.clone();
        if (this.path != null) {
            toolPath.path = (short[])this.path.clone();
        }
        if (this.originalLocation != null) {
            toolPath.originalLocation = new Point(this.originalLocation);
        }
        return toolPath;
    }

    @Override
    public void delete() {
        this.path = null;
        super.delete();
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public short[] getPath() {
        return this.path;
    }

    public void setPath(short[] newPath, int size, boolean creating) {
        this.notifyVisibleChange();
        this.path = new short[size];
        System.arraycopy(newPath, 0, this.path, 0, size);
        this.calculateOriginalSize(creating);
        this.setAttributeChanged();
        this.notifySizingChange();
        this.notifyAttributeChange();
    }

    public int getOriginalWidth() {
        return this.originalWidth;
    }

    public int getOriginalHeight() {
        return this.originalHeight;
    }

    public Point getOriginalLocation() {
        return this.originalLocation;
    }

    /*
     * WARNING - void declaration
     */
    public void calculateOriginalSize(boolean creating) {
        void var5_9;
        void var3_5;
        void var4_7;
        void var2_3;
        if (this.path == null) {
            this.originalWidth = 0;
            this.originalHeight = 0;
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.path.length; i += 2) {
            var2_3 = this.path[i] < var2_3 ? this.path[i] : var2_3;
            var4_7 = this.path[i] > var4_7 ? this.path[i] : var4_7;
            var3_5 = this.path[i + 1] < var3_5 ? this.path[i + 1] : var3_5;
            var5_9 = this.path[i + 1] > var5_9 ? this.path[i + 1] : var5_9;
        }
        this.originalLocation = new Point((int)var2_3, (int)var3_5);
        this.originalWidth = var4_7 - var2_3;
        this.originalHeight = var5_9 - var3_5;
        this.pathNotNormalized = var2_3 != false && var3_5 != false;
        PenToolModel penTool = (PenToolModel)this.parent;
        if (creating || penTool.getBounds().x == 0 && penTool.getBounds().y == 0) {
            penTool.setLocation((double)var2_3, (double)var3_5);
            penTool.setSize((double)(var4_7 - var2_3), (double)(var5_9 - var3_5));
            this.normalizePath();
        }
    }

    public void normalizePath() {
        if (!this.pathNotNormalized) {
            return;
        }
        int minX = this.originalLocation.x;
        int minY = this.originalLocation.y;
        for (int i = 0; i < this.path.length; i += 2) {
            int n = i;
            this.path[n] = (short)(this.path[n] - minX);
            int n2 = i + 1;
            this.path[n2] = (short)(this.path[n2] - minY);
        }
        this.pathNotNormalized = false;
    }

    public void calculateScale() {
        if (!this.hasPath()) {
            return;
        }
        PenToolModel penTool = (PenToolModel)this.parent;
        try {
            this.scaleX = this.getOriginalWidth() == 0 ? 1.0f : (float)(penTool.getSize().getWidth() / (double)this.getOriginalWidth());
        }
        catch (Exception e) {
            this.scaleX = 0.0f;
        }
        try {
            this.scaleY = this.getOriginalHeight() == 0 ? 1.0f : (float)(penTool.getSize().getHeight() / (double)this.getOriginalHeight());
        }
        catch (Exception e) {
            this.scaleY = 0.0f;
        }
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolPath) {
            this.setAttributeNotificationSuppression();
            ToolPath newPath = (ToolPath)newAttribute;
            this.setPath(newPath.getPath(), newPath.getPath().length, false);
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.notifyVisibleChange();
        int size = WBUtils.readInt(istr, "ToolPath size");
        short[] path = new short[size];
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                path[i] = WBUtils.readShort(istr, "ToolPath val");
            }
        }
        this.setPath(path, path.length, false);
        this.notifySizingChange();
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            short[] path = null;
            int size = WBUtils.readInt(istr, "ToolPath size string");
            path = size > 0 ? new short[size] : null;
            for (int i = 0; i < size; ++i) {
                path[i] = WBUtils.readShort(istr, "ToolPath string val");
            }
            return this.getName() + ": Size=" + size + ", path=" + path;
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        int len = this.path == null ? 0 : this.path.length;
        ostr.writeInt(len);
        for (int i = 0; i < len; ++i) {
            ostr.writeShort(this.path[i]);
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        int i;
        String penLen = element.getAttributeValue("len");
        StringBuffer penString = new StringBuffer(element.getText());
        int size = 0;
        if (penLen != null) {
            try {
                size = Integer.parseInt(penLen);
            }
            catch (Exception e) {
                throw new Exception("ToolPath: Invalid len= value: " + e.getMessage());
            }
        } else {
            for (i = 0; i < penString.length(); ++i) {
                if (penString.charAt(i) != ',' && penString.charAt(i) != ';') continue;
                ++size;
            }
            if (size > 0) {
                ++size;
            }
        }
        if (size != 0) {
            short[] path = new short[size];
            int indx = 0;
            for (i = 0; indx < penString.length() && i < size; ++indx, ++i) {
                path[i] = 0;
                while (indx < penString.length() && penString.charAt(indx) != ',' && penString.charAt(indx) != ';') {
                    char c = penString.charAt(indx);
                    if (Character.isDigit(c)) {
                        int digit;
                        switch (c) {
                            case '1': {
                                digit = 1;
                                break;
                            }
                            case '2': {
                                digit = 2;
                                break;
                            }
                            case '3': {
                                digit = 3;
                                break;
                            }
                            case '4': {
                                digit = 4;
                                break;
                            }
                            case '5': {
                                digit = 5;
                                break;
                            }
                            case '6': {
                                digit = 6;
                                break;
                            }
                            case '7': {
                                digit = 7;
                                break;
                            }
                            case '8': {
                                digit = 8;
                                break;
                            }
                            case '9': {
                                digit = 9;
                                break;
                            }
                            default: {
                                digit = 0;
                            }
                        }
                        path[i] = (short)(path[i] * 10 + digit);
                    }
                    ++indx;
                }
            }
            this.setPath(path, path.length, false);
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        WBElement element = new WBElement("Path");
        int pathLength = this.path == null ? 0 : this.path.length;
        element.setAttribute(new Attribute("len", Integer.toString(pathLength)));
        StringBuffer pathString = new StringBuffer(4 * pathLength);
        for (int i = 0; i < pathLength; ++i) {
            if (this.path[i] != 0) {
                pathString.append(Integer.toString(this.path[i]));
            }
            if (i >= this.path.length - 1) continue;
            pathString.append(",");
        }
        element.setText(pathString.toString());
        parent.addContent((Content)element);
        return element;
    }

    @Override
    public String toString() {
        if (this.getPath() != null) {
            return super.toString() + this.getPath().toString();
        }
        return super.toString() + ": NULL PATH";
    }
}

