/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.ToolFontInterface;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class ToolFont
extends AbstractAttribute
implements ToolFontInterface,
Cloneable {
    private CompatibleFont font = null;
    private String fontName;
    private int fontStyle;
    private int fontSize;
    private boolean fontUnderline;

    public ToolFont(WhiteboardContext context) {
        super(context, "ToolFont");
        this.editorUIName = "ToolFontEditorUI";
    }

    public ToolFont(WhiteboardContext context, String toolName, String fontName, int fontStyle, int size, boolean underline) {
        super(context, toolName);
        this.fontName = fontName;
        this.fontStyle = fontStyle;
        this.fontSize = size;
        this.fontUnderline = underline;
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ToolFontEditorUI";
    }

    public ToolFont(WhiteboardContext context, String fontName, int fontStyle, int size) {
        this(context);
        this.font = null;
        this.fontName = fontName;
        this.fontStyle = fontStyle;
        this.fontSize = size;
        this.fontUnderline = false;
    }

    public ToolFont(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolFont(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ToolFont toolFont = (ToolFont)super.clone();
        toolFont.font = null;
        return toolFont;
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public CompatibleFont getFont() {
        if (this.font == null) {
            this.font = new CompatibleFont(this.fontName, this.fontStyle, this.fontSize, this.fontUnderline);
        }
        return this.font;
    }

    @Override
    public void setFont(CompatibleFont font) {
        this.notifyVisibleChange();
        this.font = font;
        this.fontName = font.getName();
        this.fontStyle = font.getStyle();
        this.fontSize = font.getSize();
        this.fontUnderline = font.isUnderline();
        this.setAttributeChanged();
        this.notifySizingChange();
        this.notifyAttributeChange();
    }

    public void setUnderline(boolean underline) {
        this.fontUnderline = underline;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public boolean isUnderline() {
        return this.fontUnderline;
    }

    @Override
    public String toString() {
        return super.toString() + ": Name=" + this.fontName + ", Style=" + this.fontStyle + ", Size=" + this.fontSize + ", Underline=" + this.fontUnderline;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolFont) {
            this.setAttributeNotificationSuppression();
            ToolFont newFont = (ToolFont)newAttribute;
            this.fontName = newFont.getFontName();
            this.fontStyle = newFont.getFontStyle();
            this.fontSize = newFont.fontSize;
            this.fontUnderline = newFont.fontUnderline;
            this.font = null;
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.fontName = WBUtils.readUTF(istr, "ToolFont name");
        this.fontStyle = WBUtils.readInt(istr, "ToolFont style");
        this.fontSize = WBUtils.readInt(istr, "ToolFont size");
        this.fontUnderline = WBUtils.readBoolean(istr, "ToolFont underline");
        this.notifyVisibleChange();
        this.font = null;
        this.notifySizingChange();
        this.notifyAttributeChange();
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            String fontName = WBUtils.readUTF(istr, "ToolFont name string");
            int fontStyle = WBUtils.readInt(istr, "ToolFont style string");
            int fontSize = WBUtils.readInt(istr, "ToolFont size string");
            boolean fontUnderline = WBUtils.readBoolean(istr, "ToolFont underline string");
            return this.getName() + ": Name=" + fontName + ", Style=" + fontStyle + ", Size=" + fontSize + ", Underline=" + fontUnderline;
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.fontName);
        ostr.writeInt(this.fontStyle);
        ostr.writeInt(this.fontSize);
        ostr.writeBoolean(this.fontUnderline);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.fontSize = 18;
        this.fontStyle = 0;
        this.fontName = "Serif";
        this.fontUnderline = false;
        String fontNameString = element.getAttributeValue("name");
        if (fontNameString != null && !fontNameString.equals("")) {
            this.fontName = fontNameString;
        }
        String fontStyleString = element.getAttributeValue("style");
        try {
            if (fontStyleString != null && !fontStyleString.equals("")) {
                this.fontStyle = Integer.valueOf(fontStyleString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid integer value for style: " + fontStyleString);
        }
        String fontSizeString = element.getAttributeValue("size");
        try {
            if (fontSizeString != null && !fontSizeString.equals("")) {
                this.fontSize = Integer.valueOf(fontSizeString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid integer value for size: " + fontStyleString);
        }
        String fontUnderlineString = element.getAttributeValue("underline");
        try {
            if (fontUnderlineString != null && !fontUnderlineString.equals("")) {
                this.fontUnderline = Boolean.valueOf(fontUnderlineString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid boolean value for underline: " + fontUnderlineString);
        }
        this.notifyVisibleChange();
        this.font = null;
        this.notifySizingChange();
        this.notifyAttributeChange();
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        WBElement tf = new WBElement(this.getName());
        if (!this.fontName.equals("Serif")) {
            tf.setAttribute(new Attribute("name", this.fontName));
        }
        if (this.fontStyle != 0) {
            tf.setAttribute(new Attribute("style", Integer.toString(this.fontStyle)));
        }
        tf.setAttribute(new Attribute("size", Integer.toString(this.fontSize)));
        if (this.fontUnderline) {
            tf.setAttribute(new Attribute("underline", Boolean.toString(this.fontUnderline)));
        }
        parent.addContent((Content)tf);
        return null;
    }
}

