/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;

public abstract class AbstractAttributeMap
extends AbstractAttribute {
    private static final String toolName = "ATTRIBUTELIST";
    protected Map attributeMap = new HashMap();
    private Map attributeIdMap = new HashMap();

    public AbstractAttributeMap(WhiteboardContext context) {
        this(context, toolName);
    }

    public AbstractAttributeMap(WhiteboardContext context, String toolName) {
        super(context, toolName);
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public Map getAttributeIdMap() {
        return this.attributeIdMap;
    }

    public void setAttributeMap(Map attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void setAttributeIdMap(Map attributeIdMap) {
        this.attributeIdMap = attributeIdMap;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractAttributeMap attribute = (AbstractAttributeMap)super.clone();
        attribute.attributeMap = new HashMap();
        attribute.attributeMap.putAll(this.attributeMap);
        attribute.attributeIdMap = new HashMap();
        attribute.attributeIdMap.putAll(this.attributeIdMap);
        return attribute;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof AbstractAttributeMap) {
            AbstractAttributeMap newMap = (AbstractAttributeMap)newAttribute;
            this.setAttributeMap(newMap.getAttributeMap());
            this.setAttributeIdMap(newMap.getAttributeIdMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        Map map = this.attributeIdMap;
        synchronized (map) {
            Object[] keys = this.attributeIdMap.keySet().toArray();
            return keys.length + 1;
        }
    }

    public abstract void setAttribute(Object var1);

    public abstract AbstractSubAttribute getAttribute(Object var1);

    public abstract AbstractSubAttribute attributeFactory();

    public abstract Object attributeKeyFactory(AbstractSubAttribute var1);

    public AbstractSubAttribute getAttributeById(int attributeId) {
        return (AbstractSubAttribute)this.attributeIdMap.get(new Integer(attributeId));
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int size = WBUtils.readInt(istr, "attributeMap size");
        if (size > 0) {
            this.notifyVisibleChange();
            this.attributeMap.clear();
            this.attributeIdMap.clear();
            for (int i = 0; i < size; ++i) {
                AbstractSubAttribute sa = this.attributeFactory();
                sa.streamToObject(istr);
                Object key = this.attributeKeyFactory(sa);
                this.attributeMap.put(key, sa);
                this.attributeIdMap.put(new Integer(sa.getSaId()), sa);
            }
            this.notifyAttributeChange();
        }
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int size = WBUtils.readInt(istr, "attributeMap size");
            return this.getName() + ": Size=" + size;
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        Object[] attributes = this.attributeMap.values().toArray();
        int size = attributes.length;
        ostr.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                AbstractSubAttribute sa = (AbstractSubAttribute)attributes[i];
                sa.objectToStream(ostr);
            }
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        List styleRuns = element.getChildren();
        if (styleRuns.size() > 0) {
            this.notifyVisibleChange();
            this.attributeMap.clear();
            this.attributeIdMap.clear();
            for (WBElement tf : styleRuns) {
                AbstractSubAttribute sa = this.attributeFactory();
                sa.elementToObject(tf, progress);
                Object key = this.attributeKeyFactory(sa);
                this.attributeMap.put(key, sa);
                this.attributeIdMap.put(new Integer(sa.getSaId()), sa);
            }
            this.notifyAttributeChange();
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        Object[] attributes = this.attributeMap.values().toArray();
        int size = attributes.length;
        tf.setAttribute(new Attribute("size", Integer.toString(size)));
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                AbstractSubAttribute sa = (AbstractSubAttribute)attributes[i];
                sa.objectToElement(tf, progress);
            }
        }
        parent.addContent((Content)tf);
        return null;
    }

    @Override
    public String toString() {
        String output = this.getName();
        for (AbstractSubAttribute sa : this.attributeMap.values()) {
            output = output + "\n" + sa.toString();
        }
        return output;
    }
}

