/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class WBUtils {
    public static final boolean PROTOCOL_PACKET_BYTES = true;
    public static final boolean STREAM_DATA_WRITES = true;
    public static final boolean STREAM_DATA_READS = true;
    public static final boolean COMM_OBJECT_CREATION = true;
    public static final boolean COMM_OBJECT_STREAMOUT = true;
    public static final boolean COMM_OBJECT_STREAMIN = true;
    public static final boolean debugDataIn = false;
    private static SoftReference simpleFormatter = null;

    public static String uniqueIDAsHex(Long uid) {
        if (uid == null) {
            return "{- null -}";
        }
        return WBUtils.uniqueIDAsHex((long)uid);
    }

    public static String uniqueIDAsHex(long uid) {
        return "{" + ObjectUID.decodeClientId(uid) + ", " + ObjectUID.decodeSequence(uid) + "}";
    }

    public static String uniqueLongID(Long uid) {
        if (uid == null) {
            return " - null - ";
        }
        return WBUtils.uniqueLongID((long)uid);
    }

    public static String uniqueLongID(long uid) {
        return "{" + (uid >> 32 & Integer.MAX_VALUE) + ", " + Long.toHexString(uid & 0xFFFFFFFFL) + "}";
    }

    public static String objectName(UniqueObjectID object, WhiteboardContext context) {
        return WBUtils.objectName(object.getObjectID(), context);
    }

    public static String objectName(Long uid, WhiteboardContext context) {
        StringBuffer name = new StringBuffer(256);
        if (uid != null) {
            try {
                Object obj = context.getObjectManager().getObjectFromMap(uid);
                if (obj != null) {
                    return WBUtils.objectName(obj);
                }
            }
            catch (Exception e) {
                name.append(e.getMessage());
            }
        }
        if (name.length() > 0) {
            name.append(", ");
        }
        name.append("UniqueID: " + WBUtils.uniqueIDAsHex(uid));
        return name.toString();
    }

    public static String objectName(WBNode tn) {
        StringBuffer name = new StringBuffer(128);
        if (tn == null) {
            name.append(" - NULL - ");
        } else {
            name.append(tn.getClass().getName() + " ");
            name.append(WBUtils.objectName((RegisteredTemplate)tn));
            name.append(", ParentUID: " + WBUtils.uniqueIDAsHex(tn.getParentUID()));
        }
        return name.toString();
    }

    public static String objectName(RegisteredTemplate rt) {
        StringBuffer name = new StringBuffer(128);
        name.append(rt.getName());
        if (rt instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)rt;
            name.append("(" + screen.getScreenName() + ")");
        }
        name.append("\n   Template ID: " + rt.getRegisteredID());
        if (rt instanceof UniqueObjectID) {
            UniqueObjectID uoi = (UniqueObjectID)((Object)rt);
            Long uid = uoi.getObjectID();
            name.append(", UniqueID: " + WBUtils.uniqueIDAsHex(uid));
        }
        return name.toString();
    }

    public static String objectName(Object obj) {
        if (obj instanceof AbstractToolModel) {
            return WBUtils.objectName((WBNode)obj);
        }
        if (obj instanceof ScreenGroups) {
            return "ScreenGroup Root";
        }
        if (obj instanceof WBNode) {
            return WBUtils.objectName((WBNode)obj);
        }
        if (obj instanceof RegisteredTemplate) {
            return WBUtils.objectName((RegisteredTemplate)obj);
        }
        if (obj != null) {
            return "Unknown object: " + obj.getClass().getName();
        }
        return "Null Object to objectName";
    }

    public static short readClientId(WBInputStream istr, String who) throws IOException {
        short wireId = WBUtils.readShort(istr, who);
        short address = istr.getAddress() == null ? istr.getContext().getIDProcessor().getMyAddress().shortValue() : istr.getAddress().shortValue();
        return istr.getContext().getIDProcessor().conferenceToLocal(wireId, address);
    }

    public static short readShort(DataInputStream istr, String who) throws IOException {
        short val = istr.readShort();
        return val;
    }

    public static int readInt(DataInputStream istr, String who) throws IOException {
        int val = istr.readInt();
        return val;
    }

    public static byte readByte(DataInputStream istr, String who) throws IOException {
        byte val = istr.readByte();
        return val;
    }

    public static long readLong(DataInputStream istr, String who) throws IOException {
        long val = istr.readLong();
        return val;
    }

    public static float readFloat(DataInputStream istr, String who) throws IOException {
        float val = istr.readFloat();
        return val;
    }

    public static boolean readBoolean(DataInputStream istr, String who) throws IOException {
        boolean val = istr.readBoolean();
        return val;
    }

    public static String readUTF(DataInputStream istr, String who) throws IOException {
        String val = istr.readUTF();
        return val;
    }

    public static int comparison(int value) {
        if (value < 0) {
            return -1;
        }
        if (value > 0) {
            return 1;
        }
        return 0;
    }

    public static int comparison(float value) {
        if (value < 0.0f) {
            return -1;
        }
        if (value > 0.0f) {
            return 1;
        }
        return 0;
    }

    public static void timedLog(String originator, String message) {
        long now = System.currentTimeMillis();
        System.out.println(WBUtils.decodeTime(now) + " " + Thread.currentThread().getName() + " " + originator + ": " + message);
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeTime(long time) {
        String timeString = "";
        long milliseconds = time % 1000L;
        Date date = new Date(time);
        DateFormat formatter = null;
        if (simpleFormatter != null) {
            formatter = (DateFormat)simpleFormatter.get();
        }
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyy MMM dd HH:mm:ss", Locale.US);
            simpleFormatter = new SoftReference<DateFormat>(formatter);
        }
        DateFormat dateFormat = formatter;
        synchronized (dateFormat) {
            formatter.setTimeZone(TimeZone.getDefault());
            timeString = formatter.format(date);
        }
        return timeString + "." + milliseconds;
    }
}

