/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.comm.GoToScreen;
import com.elluminate.groupware.whiteboard.conference.GroupManager;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.util.HashMap;

public class GroupListener
implements ClientGroupListener {
    WhiteboardContext context;
    private HashMap groups = new HashMap();

    public GroupListener(WhiteboardContext context) {
        this.context = context;
        context.getGroupManager().defineNullGroup();
    }

    private ScreenRoot createScreenGroup(ClientGroupEvent event) {
        String groupName = event.getGroup().getName();
        ACLEntry groupEntry = new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ShortList.get((short)event.getGroup().getGroupID()), groupName, ACLEntry.ALL_ROLES);
        ScreenRoot newRoot = new ScreenRoot(groupName, this.context);
        newRoot.setGroupID(event.getGroup().getGroupID());
        this.context.getObjectManager().setObjectInMap(newRoot);
        newRoot.setEditable(false);
        newRoot.setPrivate(false);
        newRoot.setDeletable(false);
        ACLTerm deleteACL = newRoot.getACLTerm("delete");
        deleteACL.setDefaultAllow(false);
        deleteACL.addDenyEntry(ACLTerm.ALL_ENTRY);
        ACLTerm distributionACL = newRoot.getACLTerm("disribution");
        distributionACL.setDefaultAllow(true);
        distributionACL.addAcceptEntry(groupEntry);
        ACLTerm visibleACL = newRoot.getACLTerm("visible");
        visibleACL.setDefaultAllow(false);
        visibleACL.addDefiningEntry(ACLTerm.CHAIR_ENTRY);
        visibleACL.addAcceptEntry(groupEntry);
        visibleACL.addDenyEntry(ACLTerm.ALL_ENTRY);
        newRoot.getACLTerm("edit background").addDefiningEntry(ACLTerm.CHAIR_ENTRY);
        ACLTerm setAccessACL = newRoot.getACLTerm("set access");
        setAccessACL.addDefiningEntry(ACLTerm.CHAIR_ENTRY);
        setAccessACL.addDenyEntry(ACLTerm.ALL_ENTRY);
        ScreenModel baseScreen = new ScreenModel(groupName + " - " + newRoot.getNextScreenSequence(), this.context);
        this.context.getDataModel().setPublicScreenACLs(baseScreen);
        newRoot.add(baseScreen);
        return newRoot;
    }

    public void clientGroupCreated(ClientGroupEvent event) {
        this.context.getACLManager().addGroup(event);
        Short groupId = ShortList.get((short)event.getGroup().getGroupID());
        this.context.getGroupManager().clearFollowInstructor(groupId);
        if (!this.context.isClient()) {
            if (this.groups.containsKey(groupId)) {
                LogSupport.error((Object)this, (String)"clientGroupCreated", (String)("group already exists: " + event.getGroup().getName()));
            } else {
                ScreenRoot newRoot = this.createScreenGroup(event);
                this.groups.put(groupId, newRoot);
                this.context.getDataModel().addScreenGroup(newRoot);
            }
        }
    }

    public void clientGroupDeleted(ClientGroupEvent event) {
        ScreenRoot root;
        this.context.getACLManager().removeGroup(event);
        Short groupId = ShortList.get((short)event.getGroup().getGroupID());
        if (!this.context.isClient() && (root = (ScreenRoot)this.groups.get(groupId)) != null) {
            this.context.getDataModel().removeScreenGroup(root);
            if (this.groups.remove(groupId) == null) {
                LogSupport.message((Object)this, (String)"clientGroupDeleted", (String)("groupId not removed from groups: " + groupId));
            }
            root.delete();
        }
    }

    public void clientGroupRenamed(ClientGroupEvent event) {
        Short groupId = ShortList.get((short)event.getGroup().getGroupID());
        ScreenRoot root = this.context.getDataModel().getGroupRoot(groupId);
        if (root != null) {
            root.setScreenNameFromUi(event.getGroupName());
        }
    }

    public void clientGroupChanged(ClientGroupEvent event) {
        Long rootObjectID = null;
        GroupManager.GroupInfo groupInfo = null;
        Short groupId = ACLEntry.NULL_GROUP;
        ClientList clients = this.context.getClientList();
        ClientGroup main = clients.getClientGroup((short)0);
        if (!this.context.isClient()) {
            ScreenRoot root;
            if (event.getGroup() == main) {
                root = this.context.getDataModel().getPublicScreens();
            } else {
                groupId = ShortList.get((short)event.getGroup().getGroupID());
                root = (ScreenRoot)this.groups.get(groupId);
            }
            groupInfo = this.context.getGroupManager().getGroupInfo(groupId);
            if (groupInfo.isFollowInstructor()) {
                if (root != null) {
                    rootObjectID = groupInfo.getScreenUID();
                }
            } else {
                rootObjectID = root.getObjectID();
            }
            if (rootObjectID != null) {
                GoToScreen gotoScreen = new GoToScreen(this.context, rootObjectID);
                this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)gotoScreen, event.getClient().getAddress());
            }
        }
        Short clientId = this.context.getIDProcessor().getClientId(ShortList.get((short)event.getClient().getAddress()));
        this.context.getIDProcessor().setGroupId(clientId);
        this.context.getACLManager().changeGroup(event);
        if (this.context.getController() != null) {
            Short oldGroupId = event.getPreviousGroup() == null ? ACLEntry.NULL_GROUP : ShortList.get((short)event.getPreviousGroup().getGroupID());
            Short newGroupId = event.getGroup() == null ? ACLEntry.NULL_GROUP : ShortList.get((short)event.getGroup().getGroupID());
            this.context.getController().changeGroup(clientId, newGroupId, oldGroupId);
        }
    }
}

