/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class ButtonBehaviour
implements ActionListener,
MouseListener,
MouseMotionListener,
ItemListener {
    public static final Border lineBorder = BorderFactory.createLineBorder(Color.black);
    public static final Border emptyBorder = BorderFactory.createEmptyBorder();
    public static final Border raisedBorder = BorderFactory.createRaisedBevelBorder();
    public static final Border loweredBorder = BorderFactory.createLoweredBevelBorder();
    public static final Border normalBorder = null;

    public void setButtonBehaviour(AbstractButton button) {
        boolean borderPainted;
        if (!(button instanceof JToggleButton)) {
            borderPainted = false;
        } else {
            boolean bl = borderPainted = button.isEnabled() && button.isSelected();
        }
        if (button.isBorderPainted() != borderPainted) {
            button.setBorderPainted(borderPainted);
            button.setContentAreaFilled(borderPainted);
        }
        button.addMouseListener(this);
        button.addActionListener(this);
        button.addItemListener(this);
    }

    public void setButtonBehaviour(AbstractButton button, boolean focusPainted) {
        this.setButtonBehaviour(button);
    }

    public void setButtonBehaviour(AbstractButton button, Border border) {
        this.setButtonBehaviour(button);
        if (border != normalBorder && button.getBorder() != border) {
            button.setBorder(border);
        }
    }

    public void setButtonBehaviour(AbstractButton button, Border border, boolean focusPainted) {
        this.setButtonBehaviour(button);
        if (border != normalBorder && button.getBorder() != border) {
            button.setBorder(border);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JToggleButton) {
            ButtonBehaviour.showBehaviour((JToggleButton)e.getSource());
        }
    }

    public static void showBehaviour(AbstractButton button) {
        boolean paintBorder;
        Border brdr;
        if (button instanceof JToggleButton && ((brdr = button.getBorder()) == loweredBorder || brdr == raisedBorder)) {
            if (button.isSelected()) {
                if (brdr != loweredBorder) {
                    button.setBorder(loweredBorder);
                }
            } else if (brdr != raisedBorder) {
                button.setBorder(raisedBorder);
            }
        }
        boolean bl = paintBorder = button.isEnabled() && button.isSelected();
        if (button.isBorderPainted() != paintBorder) {
            button.setBorderPainted(paintBorder);
            button.setContentAreaFilled(paintBorder);
        }
    }

    public static void showBehaviours(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            ButtonBehaviour.showBehaviour(enumeration.nextElement());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        AbstractButton button;
        if (e.getSource() instanceof AbstractButton && (button = (AbstractButton)e.getSource()).isBorderPainted() != button.isEnabled()) {
            button.setBorderPainted(button.isEnabled());
            button.setContentAreaFilled(button.isEnabled());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            boolean paintBorder;
            AbstractButton button = (AbstractButton)e.getSource();
            if (!(button instanceof JToggleButton)) {
                paintBorder = button.contains(e.getX(), e.getY()) && button.isBorderPainted();
            } else {
                boolean bl = paintBorder = button.isEnabled() && button.isSelected();
            }
            if (button.isBorderPainted() != paintBorder) {
                button.setBorderPainted(paintBorder);
                button.setContentAreaFilled(paintBorder);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseEntered(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseEntered(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src instanceof AbstractButton) {
            ButtonBehaviour.showBehaviour((AbstractButton)src);
        }
    }
}

