/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard;

import com.elluminate.util.I18n;
import com.elluminate.util.io.FileSysUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractWBFileFilter
extends FileFilter
implements PropertyChangeListener {
    private I18n i18n = null;
    private String ext = "*";
    private String description = null;
    protected boolean multiMode = false;
    protected JComponent accessory = null;

    public AbstractWBFileFilter(String extension) {
        this.ext = extension;
        String className = this.getClass().getName();
        int lastPeriodIndex = className.lastIndexOf(".");
        this.i18n = I18n.create((Object)this);
        String desc = className.substring(lastPeriodIndex + 1);
        this.description = this.i18n.getStringLegacy(desc + ".description");
    }

    public AbstractWBFileFilter(I18n i18n, String extension) {
        this.description = i18n.getStringLegacy(this.getClass().getName() + ".description");
        this.ext = extension;
    }

    public AbstractWBFileFilter(String description, String extension) {
        this.description = description;
        this.ext = extension;
    }

    public void setAccessory(JComponent accessory) {
        this.accessory = accessory;
    }

    @Override
    public boolean accept(File f) {
        return f == null ? false : FileSysUtils.isTraversableDirectory((File)f) || this.ext.equals("*") || this.ext.equalsIgnoreCase(FileSysUtils.getExtension((File)f));
    }

    public String getSuffix() {
        return this.ext;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String d) {
        this.description = d;
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void addChoosableFileFilter(JFileChooser chooser) {
        chooser.addChoosableFileFilter(this);
        chooser.addPropertyChangeListener("fileFilterChanged", this);
        chooser.setAccessory(this.getAccessory());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("fileFilterChanged")) {
            JFileChooser chooser = (JFileChooser)evt.getSource();
            if (evt.getNewValue() == this) {
                if (chooser.getAccessory() != this.getAccessory()) {
                    if (chooser.getAccessory() != null) {
                        chooser.getAccessory().setVisible(false);
                    }
                    if (this.getAccessory() != null) {
                        chooser.setAccessory(this.getAccessory());
                        chooser.getAccessory().setVisible(true);
                    }
                    chooser.invalidate();
                }
                chooser.setMultiSelectionEnabled(this.multiMode);
            }
        }
    }
}

