/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture.mrfclient;

import com.elluminate.groupware.module.contentcapture.mrfclient.MRFTranscriber;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;

public class MRFClientApp {
    private long date;
    private String[] feeds = null;
    private String host;
    private String mrfPath;
    private String port;
    private String sessionName;
    private MRFTranscriber transcriber = null;

    public MRFClientApp(String host, String port, String mrfPath, String sessionName, long date, int width, int height) {
        this.host = host;
        this.port = port;
        this.mrfPath = mrfPath;
        this.sessionName = sessionName;
        this.date = date;
        try {
            this.transcriber = new MRFTranscriber(host, port, mrfPath, sessionName, date, this.feeds, width, height);
        }
        catch (Exception ex) {
            MRFClientApp.fatalError(ex.getMessage());
        }
    }

    public void start() {
        if (this.transcriber != null) {
            try {
                this.transcriber.start();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                MRFClientApp.fatalError("Starting and running transcription");
            }
            this.transcriber.stop();
        }
    }

    public void stop() {
        if (this.transcriber != null) {
            this.transcriber.stop();
        }
    }

    public static void main(String[] args) {
        MRFClientApp.getInstance(args);
    }

    public static MRFClientApp getInstance(String[] args) {
        MRFClientApp mrfClientApp = null;
        long date = System.currentTimeMillis();
        String[] feeds = null;
        int height = 0;
        String host = "localhost";
        String mrfPath = null;
        String port = "8081";
        String sessionName = "Unknown";
        int width = 0;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-host")) {
                host = args[++argIndex];
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-port")) {
                port = args[++argIndex];
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-path")) {
                mrfPath = args[++argIndex];
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-session")) {
                sessionName = args[++argIndex];
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-width")) {
                width = Integer.parseInt(args[++argIndex]);
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-height")) {
                height = Integer.parseInt(args[++argIndex]);
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-date")) {
                date = Long.parseLong(args[++argIndex]);
                continue;
            }
            if (args[argIndex].toLowerCase(Locale.ENGLISH).equals("-feeds")) {
                StringTokenizer tokens = new StringTokenizer(args[++argIndex], ",");
                LinkedList<String> list = new LinkedList<String>();
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken());
                }
                if (list.size() <= 0) continue;
                feeds = new String[list.size()];
                feeds = list.toArray(feeds);
                continue;
            }
            MRFClientApp.fatalError("Unknown argument: " + args[argIndex]);
        }
        if (mrfPath == null) {
            MRFClientApp.fatalError("-path path, must be specified.");
        } else {
            mrfClientApp = new MRFClientApp(host, port, mrfPath, sessionName, date, width, height);
        }
        return mrfClientApp;
    }

    public void exit(int code) {
        this.stop();
        System.exit(code);
    }

    private static void fatalError(String message) {
        if (message != null) {
            System.err.println("Error: " + message);
        }
        System.err.println("Command-line: [-host hostname] [-port portNumber] -path mrfPath [-feeds \"feed, list,...\" [-session sessionName] [-date millisecondsDate]");
    }
}

