/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.groupware.module.contentcapture.ComponentRepaintManager;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

@Singleton
public class SwingCaptureRepaintManager
extends RepaintManager {
    private static SwingCaptureRepaintManager myRepaintManager;
    private static ComponentRepaintManager componentRepaintManager;
    private static ContentCaptureProvider contentCaptureProvider;

    @Inject
    public static void initContentCapture(ContentCaptureProvider contentCaptureProviderArg) {
        contentCaptureProvider = contentCaptureProviderArg;
        ComponentRepaintManager.initContentCaptureProvider(contentCaptureProvider);
    }

    SwingCaptureRepaintManager() {
    }

    public SwingCaptureRepaintManager getRepaintManager() {
        if (myRepaintManager == null) {
            myRepaintManager = new SwingCaptureRepaintManager();
        }
        return myRepaintManager;
    }

    @Override
    public void paintDirtyRegions() {
        if (contentCaptureProvider.get().isCapturingData() && contentCaptureProvider.get().isEchoingData() || !contentCaptureProvider.get().isCapturingData()) {
            super.paintDirtyRegions();
        }
    }

    @Override
    public void addDirtyRegion(final JComponent c, final int x, final int y, final int width, final int height) {
        if (contentCaptureProvider.get().isEchoingData() || contentCaptureProvider.get().alwaysEcho(c)) {
            super.addDirtyRegion(c, x, y, width, height);
        }
        if (contentCaptureProvider.get().isCapturingData()) {
            if (SwingUtilities.isEventDispatchThread()) {
                componentRepaintManager.addDirtyRegion(c, x, y, width, height);
            } else {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        componentRepaintManager.addDirtyRegion(c, x, y, width, height);
                    }
                });
            }
        }
    }

    static {
        componentRepaintManager = ComponentRepaintManager.getInstance();
    }
}

