/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.CaptureTile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class CaptureTileCache {
    public static final boolean DEBUG_TILE_CACHE = System.getProperty("debugtilecache", null) != null;
    private Hashtable<Integer, CRCMapEntry> crcTileMap = new Hashtable();
    private HashMap<Integer, CaptureTile> tileMap = new HashMap();

    public synchronized void addCaptureTile(CaptureTile tile) {
        CRCMapEntry entry;
        CaptureTile oldTile = this.tileMap.get(tile.getTileNumber());
        if (oldTile != null) {
            Integer oldCRC = oldTile.getTileCRC();
            boolean updateCRC = true;
            if (oldCRC != null) {
                boolean bl = updateCRC = !oldCRC.equals(tile.getTileCRC());
                if (updateCRC) {
                    this.removeCRCEntry(oldCRC, tile.getTileNumber());
                } else {
                    return;
                }
            }
        }
        if ((entry = this.crcTileMap.get(tile.getTileCRC())) == null) {
            entry = new CRCMapEntry(tile);
            tile.getCompressedTile();
            this.crcTileMap.put(tile.getTileCRC(), entry);
        } else {
            entry.addCaptureTile(tile);
        }
        this.tileMap.put(tile.getTileNumber(), tile);
        if (DEBUG_TILE_CACHE) {
            System.out.println("CaptureTileCache.addTile: " + Integer.toHexString(tile.getTileNumber()) + ":" + tile.getTileTime() + ":" + tile.getLoc() + ":" + tile.getTileCRC());
        }
    }

    public synchronized void clear() {
        this.tileMap.clear();
        this.crcTileMap.clear();
    }

    public synchronized boolean contains(Integer tileNumber) {
        return this.tileMap.get(tileNumber) != null;
    }

    public synchronized CaptureTile getCaptureTile(Integer tileNumber) {
        return this.tileMap.get(tileNumber);
    }

    public synchronized Set getCaptureTileSet(Integer crc) {
        CRCMapEntry entry = this.crcTileMap.get(crc);
        if (entry == null) {
            return null;
        }
        return entry.tileNumberSet;
    }

    private synchronized void removeCRCEntry(Integer crc, Integer tileNumber) {
        CRCMapEntry entry;
        if (crc != null && (entry = this.crcTileMap.get(crc)) != null) {
            entry.removeCaptureTile(tileNumber);
            this.tileMap.remove(tileNumber);
            if (entry.isEmpty()) {
                this.crcTileMap.remove(crc);
            }
        }
    }

    public synchronized void removeCaptureTile(Integer tileNumber) {
        CaptureTile tile;
        if (DEBUG_TILE_CACHE) {
            System.out.println("CaptureTileCache.removeCaptureTile: " + Integer.toHexString(tileNumber));
        }
        if ((tile = this.tileMap.get(tileNumber)) == null) {
            return;
        }
        Integer crc = tile.getTileCRC();
        this.removeCRCEntry(crc, tileNumber);
    }

    class CRCMapEntry {
        private static final int INITIAL_CAPACITY = 10;
        private static final float LOAD_FACTOR = 0.75f;
        CaptureTile tileTemplate;
        HashSet<Integer> tileNumberSet = new HashSet(10, 0.75f);
        float peakEntries = 0.0f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CRCMapEntry(CaptureTile tileTemplate) {
            CRCMapEntry cRCMapEntry = this;
            synchronized (cRCMapEntry) {
                this.tileTemplate = tileTemplate;
                this.tileNumberSet.add(tileTemplate.getTileNumber());
            }
        }

        public CaptureTile getCaptureTile() {
            return this.tileTemplate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Integer tileNumber) {
            CRCMapEntry cRCMapEntry = this;
            synchronized (cRCMapEntry) {
                return this.tileNumberSet.contains(tileNumber);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            CRCMapEntry cRCMapEntry = this;
            synchronized (cRCMapEntry) {
                return this.tileNumberSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addCaptureTile(CaptureTile tile) {
            CRCMapEntry cRCMapEntry = this;
            synchronized (cRCMapEntry) {
                boolean added = this.tileNumberSet.add(tile.getTileNumber());
                if ((float)this.tileNumberSet.size() > this.peakEntries) {
                    this.peakEntries = this.tileNumberSet.size();
                }
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeCaptureTile(Integer tileNumber) {
            CRCMapEntry cRCMapEntry = this;
            synchronized (cRCMapEntry) {
                boolean removed = this.tileNumberSet.remove(tileNumber);
                if ((float)Math.max(this.tileNumberSet.size(), 10) < 0.75f * this.peakEntries) {
                    this.tileNumberSet = new HashSet<Integer>(this.tileNumberSet);
                    this.peakEntries = this.tileNumberSet.size();
                }
                return removed;
            }
        }
    }
}

