/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.messaging;

import com.elluminate.classroom.client.messaging.MessageType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class MessagePublisherMetadata {
    private static final String NULL_NAME = "Publisher must contain a unique name (non-null or empty)";
    private static final String NULL_TYPES = "msgTypes can not be null or empty";
    private String moduleName;
    private String moduleDisplayName;
    private String displayName;
    private String uniqueName;
    private Icon publisherIcon;
    private List<MessageType> msgTypes;

    public void setPublisherUniqueName(String uniqueName) {
        if (uniqueName == null || uniqueName.equals("")) {
            throw new IllegalArgumentException(NULL_NAME);
        }
        this.uniqueName = uniqueName;
    }

    public void setPublisherDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setPublisherIcon(Icon icon) {
        this.publisherIcon = icon;
    }

    public void setModuleName(String modName) {
        this.moduleName = modName;
    }

    public void setModuleDisplayName(String modDisplayName) {
        this.moduleDisplayName = modDisplayName;
    }

    public void setPublisherSupportedMessageTypes(List<MessageType> msgTypes) {
        if (msgTypes == null || msgTypes.size() == 0) {
            throw new IllegalArgumentException(NULL_TYPES);
        }
        this.msgTypes = this.cleanMessageTypes(msgTypes);
    }

    private List<MessageType> cleanMessageTypes(List<MessageType> types) {
        ArrayList<MessageType> replyTypes = new ArrayList<MessageType>();
        for (MessageType type : types) {
            if (type == null) continue;
            replyTypes.add(type);
        }
        if (replyTypes.size() == 0) {
            throw new IllegalArgumentException(NULL_TYPES);
        }
        return replyTypes;
    }

    public String getPublisherUniqueName() {
        return this.uniqueName;
    }

    public String getPublisherDisplayName() {
        return this.displayName == null || this.displayName.equals("") ? this.uniqueName : this.displayName;
    }

    public Icon getPublisherIcon() {
        return this.publisherIcon;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleDisplayName() {
        return this.moduleDisplayName;
    }

    public List<MessageType> getMessageTypes() {
        return new ArrayList<MessageType>(this.msgTypes);
    }
}

