/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.messaging;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.Message;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.google.inject.Inject;

public class MessagePublisher {
    private static final String MISSING_PUB_INFO = MessagePublisherMetadata.class.getName() + " has not been initialized";
    private static final String EMPTY_MSG = "Message text is a required field";
    private MessagePublisherMetadata publisherInfo;
    private final MessageRouter router;
    private Imps imps;

    @Inject
    public MessagePublisher(MessageRouter providedRouter) {
        this.router = providedRouter;
    }

    @Inject
    public void initImps(Imps i) {
        this.imps = i;
    }

    public void setPublisherMetadata(MessagePublisherMetadata data) {
        this.publisherInfo = data;
    }

    public MessagePublisherMetadata getMessagePublisherMetadata() {
        return this.publisherInfo;
    }

    public void sendTextMessage(String msg, MessageType type, boolean isMe) {
        long time = 1000L;
        try {
            SessionTimeAPI sessionTime = (SessionTimeAPI)this.imps.findBest(SessionTimeAPI.class);
            if (sessionTime != null && sessionTime.isSessionTimeValid()) {
                time = sessionTime.getSessionTime();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sendTextMessage(msg, type, time, isMe);
    }

    public void sendTextMessage(String msg, MessageType type) {
        this.sendTextMessage(msg, type, false);
    }

    public void sendTextMessage(String msg, MessageType type, long sessionTime, boolean isMe) {
        if (this.publisherInfo == null) {
            throw new IllegalStateException(MISSING_PUB_INFO);
        }
        if (msg == null) {
            throw new IllegalArgumentException(EMPTY_MSG);
        }
        Message message = new Message(sessionTime, type, this.publisherInfo);
        message.setText(msg);
        message.setSentByMe(isMe);
        this.router.send(message);
    }

    public void sendTextMessage(String msg, MessageType type, long sessionTime) {
        this.sendTextMessage(msg, type, sessionTime, false);
    }

    public void sendMessageWithExtraInfo(String text, ExtraInfo info, MessageType type, boolean isMe) {
        long time = 1000L;
        try {
            SessionTimeAPI sessionTime = (SessionTimeAPI)this.imps.findBest(SessionTimeAPI.class);
            if (sessionTime != null && sessionTime.isSessionTimeValid()) {
                time = sessionTime.getSessionTime();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sendMessageWithExtraInfo(text, info, type, time, isMe);
    }

    public void sendMessageWithExtraInfo(String text, ExtraInfo info, MessageType type) {
        this.sendMessageWithExtraInfo(text, info, type, false);
    }

    public void sendMessageWithExtraInfo(String text, ExtraInfo info, MessageType type, long sessionTime, boolean isMe) {
        if (this.publisherInfo == null) {
            throw new IllegalStateException(MISSING_PUB_INFO);
        }
        if (text == null) {
            throw new IllegalArgumentException(EMPTY_MSG);
        }
        Message theMessage = new Message(sessionTime, type, this.publisherInfo);
        theMessage.setText(text);
        theMessage.setExtraInfo(info);
        theMessage.setSentByMe(isMe);
        this.router.send(theMessage);
    }

    public void sendMessageWithExtraInfo(String text, ExtraInfo info, MessageType type, long sessionTime) {
        this.sendMessageWithExtraInfo(text, info, type, sessionTime, false);
    }
}

