/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.app;

import com.elluminate.classroom.client.GeneralPrefsOwner;
import com.elluminate.classroom.client.app.StringsProperties;
import com.elluminate.extra.ExTRA;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExtraPrefsPanel
extends AbstractPreferencesPanel {
    private static I18n i18n;
    private static Map<String, ExTRA.SendPolicy> descToPolicy;
    private static Map<ExTRA.SendPolicy, String> policyToDesc;
    private JLabel emailLabel;
    private JTextField email;
    private JLabel policyLabel;
    private JComboBox policy;

    @Inject
    public ExtraPrefsPanel(GeneralPrefsOwner owner) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_TITLE));
    }

    public boolean hasStore() {
        return true;
    }

    public Object getStore(boolean temp) {
        return new ExTRAStore(temp);
    }

    protected void createContent() {
        this.setLayout(new GridBagLayout());
        this.emailLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_EMAILLABEL));
        this.email = new JTextField();
        this.email.setEditable(true);
        this.email.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtraPrefsPanel.this.setModified(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtraPrefsPanel.this.setModified(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExtraPrefsPanel.this.setModified(true);
            }
        });
        this.policyLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_POLICYLABEL));
        this.policy = new JComboBox();
        this.policy.addItem(policyToDesc.get(ExTRA.SendPolicy.UNDEFINED));
        this.policy.addItem(policyToDesc.get(ExTRA.SendPolicy.ALWAYS));
        this.policy.addItem(policyToDesc.get(ExTRA.SendPolicy.QUERY));
        this.policy.addItem(policyToDesc.get(ExTRA.SendPolicy.NEVER));
        this.policy.setEditable(false);
        this.policy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExtraPrefsPanel.this.setModified(true);
            }
        });
        this.add(this.emailLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.email, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.policyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.policy, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void populate(Object store) {
        ExTRAStore real = (ExTRAStore)store;
        this.policy.setSelectedItem(policyToDesc.get(real.getPolicy()));
        this.email.setText(real.getEmail());
    }

    protected void apply(Object store) {
        if (this.policy != null) {
            ExTRAStore real = (ExTRAStore)store;
            real.setPolicy(descToPolicy.get((String)this.policy.getSelectedItem()));
            real.setEmail(this.email.getText());
        }
    }

    static {
        descToPolicy = new HashMap<String, ExTRA.SendPolicy>();
        policyToDesc = new HashMap<ExTRA.SendPolicy, String>();
        i18n = I18n.create(ExtraPrefsPanel.class);
        policyToDesc.put(ExTRA.SendPolicy.UNDEFINED, i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_POLICYBLANK));
        policyToDesc.put(ExTRA.SendPolicy.ALWAYS, i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_POLICYALWAYS));
        policyToDesc.put(ExTRA.SendPolicy.QUERY, i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_POLICYQUERY));
        policyToDesc.put(ExTRA.SendPolicy.NEVER, i18n.getString((PropertiesEnum)StringsProperties.EXTRAPREFS_POLICYNEVER));
        for (ExTRA.SendPolicy p : policyToDesc.keySet()) {
            String d = policyToDesc.get(p);
            descToPolicy.put(d, p);
        }
    }

    class ExTRAStore {
        ExTRA.SendPolicy policy = ExTRA.getSendPolicy();
        String email = ExTRA.getEmail();
        List<ExTRA> extras = ExTRA.getHistory();
        boolean temp;

        public ExTRAStore(boolean temp) {
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
            if (!this.temp) {
                ExTRA.setEmail((String)email);
            }
        }

        public ExTRA.SendPolicy getPolicy() {
            return this.policy;
        }

        public void setPolicy(ExTRA.SendPolicy policy) {
            this.policy = policy;
            if (!this.temp) {
                ExTRA.setSendPolicy((ExTRA.SendPolicy)policy);
            }
        }
    }
}

