/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.Client;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.MessageListener;
import com.elluminate.jinx.VCRFile;
import com.elluminate.jinx.client.PlaybackConnector;
import com.elluminate.jinx.client.PlaybackException;
import com.elluminate.jinx.client.PlaybackListener;
import com.elluminate.util.event.DataProvider;
import com.elluminate.util.event.URLFillErrorListener;
import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.LogSupport;
import java.net.URL;

public class PlaybackClient
extends Client {
    private static final String OBFUSCATE_ANNO = "com.elluminate.vclass.obfuscateNames";
    private boolean active = false;
    private boolean obfuscateNames = false;
    private PlaybackConnector pc = new PlaybackConnector();

    public Connection.Type getConnectionType() {
        return Connection.Type.PLAYBACK_CLIENT;
    }

    public void dispose() {
        if (this.pc != null) {
            ExTRASupport.removeExceptionListener((ExTRASupport.ExceptionListener)this.pc);
            this.pc.dispose();
            this.pc = null;
        }
    }

    public boolean isPlayback() {
        return true;
    }

    public boolean isObfuscatingNames() {
        return this.obfuscateNames;
    }

    public void setObfuscatingNames() {
        this.obfuscateNames = true;
    }

    public void play(URL source, URLFillErrorListener ufel) throws PlaybackException {
        if (this.active) {
            return;
        }
        this.pc.setSource(source, ufel);
        this.connector = this.pc;
        ExTRASupport.addExceptionListener((ExTRASupport.ExceptionListener)this.pc);
        this.setConferenceName(this.pc.getConferenceName());
        String obfuscateStr = this.pc.getAnnotation(OBFUSCATE_ANNO);
        this.obfuscateNames = obfuscateStr != null;
        try {
            this.connector.addMessageListener((byte)0, (MessageListener)this);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"play", (Throwable)ex, (boolean)true);
            this.connector = null;
            return;
        }
        this.connector.addConnectionListener((ConnectionListener)this);
        this.active = true;
    }

    public void play() {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.play();
        }
    }

    public void pause() {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.pause();
        }
    }

    public void stop() {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.stop();
        }
    }

    public void reset() {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.reset();
        }
    }

    public void setRate(float rate) {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.setRate(rate);
        }
    }

    public void setCompressionEnabled(boolean enabled) {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.setCompression(enabled);
        }
    }

    public boolean isCompressionEnabled() {
        PlaybackConnector con = this.pc;
        if (con == null) {
            return false;
        }
        return con.isCompressing();
    }

    public DataProvider getRecordingIndexProvider() {
        PlaybackConnector con = this.pc;
        if (con == null) {
            return null;
        }
        return con.getRecordingIndexProvider();
    }

    public VCRFile.IndexEntry[] getRecordingIndex() {
        PlaybackConnector con = this.pc;
        if (con == null) {
            return null;
        }
        return con.getRecordingIndex();
    }

    public void addURLFillErrorListener(URLFillErrorListener l) {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.addURLFillErrorListener(l);
        }
    }

    public void removeURLFillErrorListener(URLFillErrorListener l) {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.removeURLFillErrorListener(l);
        }
    }

    public String getAnnotation(String name) {
        PlaybackConnector con = this.pc;
        if (con == null) {
            return null;
        }
        return con.getAnnotation(name);
    }

    public void addPlaybackListener(PlaybackListener lst) {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.addPlaybackListener(lst);
        }
    }

    public void removePlaybackListener(PlaybackListener lst) {
        PlaybackConnector con = this.pc;
        if (con != null) {
            con.removePlaybackListener(lst);
        }
    }
}

