/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.AttachableClient;
import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.ConnectionClass;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.NetworkTransceiver;
import com.elluminate.jinx.Transceiver;
import com.elluminate.jinx.client.CallStatusListener;
import com.elluminate.jinx.client.Caller;
import com.elluminate.jinx.client.ClientAuthenticator;
import com.elluminate.jinx.client.Dialer;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.URLString;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.TooManyListenersException;

public class OnlineClient
extends AttachableClient {
    private ConnectionClass cls = ConnectionClass.LAN;
    private NetworkTransceiver tx = null;
    private Dialer redialer = null;

    public void setConnectionClass(ConnectionClass cls) {
        if (this.tx != null) {
            this.tx.setConnectionSpeed(cls.getXmitBandwidth(), cls.getRecvBandwidth());
        }
        if (this.redialer != null) {
            this.redialer.setConnectionClass(cls);
        }
        this.cls = cls;
    }

    public ConnectionClass getConnectionClass() {
        return this.cls;
    }

    public long getLastMessageInterval() {
        if (this.tx == null) {
            return -1L;
        }
        return this.tx.getLastMessageInterval();
    }

    public void call(URLString url, ClientAuthenticator auth) throws MalformedURLException, IOException, JinxConnectionException {
        this.call(url, null, -1L, -1L, null, auth, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Caller call(URLString url, Caller[] callers, long bestTimeout, long anyTimeout, CallStatusListener listener, ClientAuthenticator auth, SSLTargetQuery query) throws MalformedURLException, IOException, JinxConnectionException {
        Dialer dialer = new Dialer();
        ConferenceName cName = new ConferenceName(url.getName());
        this.setConferenceName(cName);
        dialer.setURL(url);
        dialer.setAuthenticator(auth);
        dialer.setConnectionClass(this.cls);
        dialer.setTargetQuery(query);
        if (listener != null) {
            try {
                dialer.addCallStatusListener(listener);
            }
            catch (TooManyListenersException ex) {
                LogSupport.exception((Object)((Object)this), (String)"call", (Throwable)ex, (boolean)true);
            }
        }
        if (bestTimeout > 0L && anyTimeout > bestTimeout) {
            dialer.setTimeouts(bestTimeout, anyTimeout);
        }
        try {
            this.connect(dialer, callers);
            this.redialer = dialer;
        }
        finally {
            if (listener != null) {
                dialer.removeCallStatusListener(listener);
            }
        }
        return dialer.getCaller();
    }

    public boolean canRedial() {
        return this.redialer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redial(CallStatusListener listener, Caller[] callers) throws MalformedURLException, IOException, JinxConnectionException {
        if (this.redialer == null) {
            throw new JinxConnectionException("No previous connection to reconnect.");
        }
        if (listener != null) {
            try {
                this.redialer.addCallStatusListener(listener);
            }
            catch (TooManyListenersException ex) {
                LogSupport.exception((Object)((Object)this), (String)"call", (Throwable)ex, (boolean)true);
            }
        }
        try {
            this.connect(this.redialer, callers);
        }
        finally {
            if (listener != null) {
                this.redialer.removeCallStatusListener(listener);
            }
        }
    }

    private void connect(Dialer dialer, Caller[] callers) throws IOException, JinxConnectionException {
        this.tx = dialer.connect(callers);
        this.attach((Transceiver)this.tx);
        this.tx.enable();
    }

    public void hangup() {
        super.hangup();
        this.tx = null;
    }
}

