/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.client.Caller;
import com.elluminate.jinx.client.StringsProperties;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointCaller;
import com.elluminate.net.EndpointSecurity;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.net.InetAddress;

public class DirectCaller
extends Caller
implements Runnable {
    private Thread thread;
    protected String method;

    public DirectCaller() {
        this.method = this.i18n.getString((PropertiesEnum)StringsProperties.DIRECTCALLER_METHOD);
    }

    @Override
    protected void startCall() {
        this.thread = new WorkerThread((Runnable)this, "Caller");
        this.thread.start();
    }

    @Override
    public void run() {
        Endpoint ep = null;
        String why = null;
        try {
            InetAddress addr = InetAddress.getByName(this.host);
            ep = EndpointCaller.direct((String)this.url.getHost(), (int)this.url.getPort());
            if (DebugFlags.CALLER.show()) {
                LogSupport.message((Object)this, (String)"run", (String)("call to " + this.getTarget() + " connected..."));
            }
            if (!ep.getInetAddress().equals(addr) || ep.getPort() != this.port) {
                why = this.i18n.getString((PropertiesEnum)StringsProperties.CALLER_REDIRECTED, new Object[]{ep.getInetAddress().toString(), Integer.toString(ep.getPort())});
                ep.close();
                ep = null;
            } else {
                if (this.url.getProtocol().equals("ssljinx")) {
                    ep = EndpointSecurity.secureClient((Endpoint)ep, (String)this.url.getHost(), (int)this.url.getPort());
                    EndpointSecurity.verifyDestination((Endpoint)ep, (String)this.url.getHost(), (SSLTargetQuery)this.targetQuery);
                }
                this.sayHello(ep);
            }
        }
        catch (IOException ex) {
            if (ep != null) {
                ep.closeForce();
            }
            ep = null;
            this.finish(ex);
            return;
        }
        this.finish(ep, why);
    }

    @Override
    public String getTarget() {
        if (this.host == null) {
            return "none";
        }
        Integer iPort = new Integer(this.port);
        return this.i18n.getString((PropertiesEnum)StringsProperties.DIRECTCALLER_TARGET, new Object[]{this.method, this.host, iPort});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String desc;
        Object object = this.getLock();
        synchronized (object) {
            desc = this.isDone() ? (this.getEndpoint() != null ? this.i18n.getString((PropertiesEnum)StringsProperties.DIRECTCALLER_SUCCESSDESC, new Object[]{this.getTarget()}) : this.i18n.getString((PropertiesEnum)StringsProperties.DIRECTCALLER_FAILEDDESC, new Object[]{this.getTarget(), this.getReason()})) : this.i18n.getString((PropertiesEnum)StringsProperties.DIRECTCALLER_WORKINGDESC, new Object[]{this.getTarget()});
        }
        return desc;
    }
}

