/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.moduleloading.states.ModulesState;
import com.elluminate.framework.moduleloading.states.ModulesStateListener;
import com.elluminate.framework.moduleloading.states.ModulesStateSrc;
import com.elluminate.groupware.module.contentcapture.ContentCaptureIO;
import com.elluminate.groupware.module.contentcapture.ContentCaptureImpl;
import com.elluminate.groupware.module.contentcapture.ContentCaptureStubImpl;
import com.elluminate.groupware.module.contentcapture.SwingCaptureRepaintManager;
import com.elluminate.util.ApplicationProperties;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import javax.swing.RepaintManager;

@Singleton
public class ContentCaptureProviderImpl
implements ContentCaptureProvider,
ModulesStateListener {
    private static ContentCapture contentCaptureInstance = null;
    private ModulesStateSrc modulesStateSrc;
    private ModulesState startupState;
    private ModulesState stopState;
    private ApplicationProperties appProps;
    private Injector injector;

    @Inject
    public ContentCaptureProviderImpl(ApplicationProperties appProps, ModulesStateSrc modulesStateSrc, Injector injector) {
        this.appProps = appProps;
        this.modulesStateSrc = modulesStateSrc;
        this.injector = injector;
    }

    public void init() {
        if (this.appProps.containsKey("multimedia")) {
            contentCaptureInstance = (ContentCapture)this.injector.getInstance(ContentCaptureImpl.class);
            contentCaptureInstance.processArguments(this.appProps);
            ContentCapture.setInstance((ContentCapture)contentCaptureInstance);
            ContentCaptureIO.initContentCapture(contentCaptureInstance);
            this.startupState = this.modulesStateSrc.getState("attach", ModulesState.Status.EXITING);
            this.stopState = this.modulesStateSrc.getState("stop", ModulesState.Status.EXITING);
            this.modulesStateSrc.addStateListener((ModulesStateListener)this);
            SwingCaptureRepaintManager.initContentCapture(this);
            RepaintManager.setCurrentManager(new SwingCaptureRepaintManager());
        } else {
            contentCaptureInstance = (ContentCapture)this.injector.getInstance(ContentCaptureStubImpl.class);
            ContentCapture.setInstance((ContentCapture)contentCaptureInstance);
        }
    }

    public void moduleStateChanged(ModulesState state) {
        if (state.equals((Object)this.startupState)) {
            contentCaptureInstance.start();
        } else if (state.equals((Object)this.stopState)) {
            contentCaptureInstance.shutdown();
        }
    }

    public ContentCapture get() {
        if (contentCaptureInstance == null) {
            throw new RuntimeException("ContentCapture injected before it is created");
        }
        return contentCaptureInstance;
    }
}

