/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.CaptureClientConnection;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureIOPacketUtils;
import com.elluminate.groupware.module.contentcapture.CaptureClientConnectionImpl;
import com.elluminate.groupware.module.contentcapture.ClientWork;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public class ContentCaptureIO
extends Thread {
    public static final int DEFAULT_CAPTURE_PORT = 8081;
    public static final int MAX_WORKERS = 5;
    public static final int INPUT_BUFFER_SIZE = 4096;
    public static final int OUTPUT_BUFFER_SIZE = 65536;
    public static final int BUFFER_PAD = 2048;
    private static int capturePort = -1;
    private static DateFormat formatDate = new SimpleDateFormat("yyyy MMM dd HH:mm:ss", Locale.US);
    private static ServerSocketChannel ssc = null;
    private static Selector selector = null;
    private static Object ioLock = new Object(){};
    private static ContentCaptureIO instance = null;
    private static boolean running = false;
    private static Hashtable<SelectionKey, CaptureClientConnection> selectionMap = new Hashtable();
    private Hashtable<CaptureClientConnection, LinkedList> connectionWorkQueues = new Hashtable();
    private LinkedList<CaptureClientConnection> connectionWork = new LinkedList();
    private SocketChannel socketChannel = null;
    private Object workerLock = new Object(){};
    private LinkedList<WorkerThread> waitingThreads = new LinkedList();
    private LinkedList<WorkerThread> workingThreads = new LinkedList();
    private int workerNumber = 1;
    private ThreadGroup threadGroup = new ThreadGroup("Connection Worker Pool");
    private static ContentCapture contentCapture;

    public static void initContentCapture(ContentCapture localContentCapture) {
        contentCapture = localContentCapture;
    }

    private ContentCaptureIO() {
        this.setDaemon(true);
        this.setName("ContentCaptureIO Selector Thread");
    }

    public static ContentCaptureIO getInstance() {
        if (instance == null) {
            instance = new ContentCaptureIO();
        }
        return instance;
    }

    public int busyConnectionCount() {
        return this.connectionWork.size();
    }

    public static boolean isRunning() {
        return running && instance != null;
    }

    public static int getCapturePort() {
        return capturePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCapturePort(int newCapturePort, int searchLimit) {
        capturePort = newCapturePort == 0 ? 8081 : newCapturePort;
        if (capturePort == newCapturePort) {
            return;
        }
        Object object = ioLock;
        synchronized (object) {
            try {
                if (instance == null) {
                    ContentCaptureIO.getInstance();
                }
                if (selector == null) {
                    selector = Selector.open();
                }
                if (ssc != null) {
                    for (SelectionKey key : selector.keys()) {
                        if (key.channel() != ssc) continue;
                        key.channel().close();
                        key.cancel();
                        selector.wakeup();
                    }
                }
                for (int i = searchLimit; i > 0; --i) {
                    try {
                        ssc = ServerSocketChannel.open();
                        ssc.socket().bind(new InetSocketAddress(capturePort));
                        ssc.configureBlocking(false);
                        break;
                    }
                    catch (IOException ex) {
                        ++capturePort;
                        if (i > 1) continue;
                        throw ex;
                    }
                }
                ssc.register(selector, 16);
                if (!running) {
                    running = true;
                    instance.start();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void setDefaultCapturePort() {
        ContentCaptureIO.setCapturePort(8081, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRun() {
        running = false;
        Object object = ioLock;
        synchronized (object) {
            if (this.socketChannel != null) {
                try {
                    this.socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (selector != null && selector.isOpen()) {
                selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (ssc != null) {
            Object object = ioLock;
            synchronized (object) {
                for (SelectionKey key : selector.keys()) {
                    if (key.channel() == null || !key.channel().isOpen()) continue;
                    try {
                        key.channel().close();
                    }
                    catch (IOException ioe) {}
                }
            }
            try {
                ssc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueWork(SelectionKey key) throws IOException {
        CaptureClientConnection connection = selectionMap.get(key);
        if (connection == null) {
            throw new RuntimeException("ContentCaptureIO.queueWork, cannot find Connection for key: " + key.hashCode());
        }
        while (this.isPacketAvailable(connection)) {
            ClientWork work = new ClientWork(connection, this.getPacket(connection));
            Object object = this.workerLock;
            synchronized (object) {
                LinkedList<ClientWork> workQueue = this.connectionWorkQueues.get(connection);
                if (workQueue == null) {
                    WorkerThread worker;
                    workQueue = new LinkedList<ClientWork>();
                    this.connectionWorkQueues.put(connection, workQueue);
                    this.connectionWork.addFirst(connection);
                    workQueue.addLast(work);
                    if (this.waitingThreads.isEmpty() && this.workingThreads.size() < 5) {
                        worker = new WorkerThread("ContentCaptureIO worker " + this.workerNumber++);
                        this.workingThreads.add(worker);
                        worker.start();
                    } else if (!this.waitingThreads.isEmpty()) {
                        worker = this.waitingThreads.removeFirst();
                        this.workingThreads.addFirst(worker);
                        WorkerThread workerThread = worker;
                        synchronized (workerThread) {
                            worker.notify();
                        }
                    }
                } else {
                    workQueue.addLast(work);
                }
            }
        }
    }

    private boolean isPacketAvailable(CaptureClientConnection connection) throws IOException {
        short packetLength = 0;
        ByteBuffer buffer = connection.getInputBuffer();
        int read = 0;
        do {
            if ((read = connection.getChannel().read(buffer)) >= 0) continue;
            throw new EOFException("EOF on socket: " + connection.getChannel().hashCode());
        } while (read > 0);
        if (buffer.position() > 2) {
            int oldPosition = buffer.position();
            buffer.position(0);
            packetLength = buffer.getShort();
            buffer.position(oldPosition);
            if (buffer.position() >= packetLength) {
                return true;
            }
        }
        return false;
    }

    private byte[] getPacket(CaptureClientConnection connection) {
        ByteBuffer buffer = connection.getInputBuffer();
        int oldPosition = buffer.position();
        buffer.position(0);
        short packetLength = buffer.getShort();
        byte[] packet = new byte[packetLength - 2];
        buffer.get(packet);
        int newPosition = buffer.position();
        buffer.compact();
        buffer.position(oldPosition - newPosition);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (running) {
            int selectionCount;
            try {
                selectionCount = selector.select();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                running = false;
                break;
            }
            if (selectionCount == 0) continue;
            Object object = ioLock;
            synchronized (object) {
                Set<SelectionKey> selectedKeys = selector.selectedKeys();
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext() && running) {
                    SelectionKey key = iter.next();
                    try {
                        if (key.isAcceptable()) {
                            this.acceptConnection(key);
                        }
                        if (key.isReadable()) {
                            this.queueWork(key);
                        }
                        if (key.isWritable()) {
                            this.performOutput(key);
                        }
                    }
                    catch (IOException ioe) {
                        key.cancel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    iter.remove();
                }
            }
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOutput(SelectionKey key) throws IOException {
        byte[] data;
        CaptureClientConnection connection = selectionMap.get(key);
        if (connection == null) {
            throw new RuntimeException("ContentCaptureIO.queueWork, cannot find Connection for key: " + key.hashCode());
        }
        ByteBuffer buffer = connection.getOutputBuffer();
        if (buffer.hasRemaining()) {
            connection.bytesWritten((long)connection.getChannel().write(buffer));
            if (buffer.hasRemaining()) {
                SelectionKey selectionKey = key;
                synchronized (selectionKey) {
                    key.interestOps(key.interestOps() | 4);
                }
                return;
            }
        } else {
            this.stopOutput(key);
        }
        buffer.clear();
        connection.accountBlockData();
        while (connection.hasData() && buffer.position() < buffer.limit() - 2048 && (data = connection.getData((long)(buffer.limit() - 2048 - buffer.position()))) != null) {
            buffer.put(data);
            connection.bytesWritten((long)data.length);
            if (!connection.needsAck()) continue;
            int nextAckNumber = connection.setAckPoint();
            buffer.put(ContentCaptureIOPacketUtils.encodeRequestAck((int)nextAckNumber));
            break;
        }
        buffer.flip();
        if (buffer.hasRemaining()) {
            connection.getChannel().write(connection.getOutputBuffer());
        }
        if (buffer.hasRemaining() || connection.hasData()) {
            if (connection.ackWindowClosed()) {
                this.stopOutput(key);
            }
            return;
        }
        buffer.clear();
        buffer.flip();
        this.stopOutput(key);
    }

    private void acceptConnection(SelectionKey key) {
        try {
            if (key.channel() != null) {
                this.socketChannel = ssc.accept();
                if (this.socketChannel != null) {
                    this.socketChannel.configureBlocking(false);
                    CaptureClientConnectionImpl connection = new CaptureClientConnectionImpl(this.socketChannel, contentCapture);
                    this.socketChannel.register(selector, 5, connection);
                    selectionMap.put(this.socketChannel.keyFor(selector), connection);
                    contentCapture.get().addClient((CaptureClientConnection)connection);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SelectionKey getSelectionKey(SocketChannel sc) {
        return selector != null ? sc.keyFor(selector) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startOutput(SocketChannel sc) {
        if (!sc.isOpen()) {
            return;
        }
        SelectionKey key = ContentCaptureIO.getSelectionKey(sc);
        if (key == null || !key.isValid()) {
            try {
                sc.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return;
        }
        SelectionKey selectionKey = key;
        synchronized (selectionKey) {
            try {
                if ((key.interestOps() & 4) == 0) {
                    key.interestOps(key.interestOps() | 4);
                    selector.wakeup();
                }
            }
            catch (CancelledKeyException cke) {
                try {
                    sc.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopOutput(SelectionKey key) {
        SelectionKey selectionKey = key;
        synchronized (selectionKey) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
        }
    }

    private static String keyIsOps(int opsProvided) {
        StringBuffer buf = new StringBuffer("Ops: " + opsProvided + ", ");
        int[] ops = new int[]{16, 8, 1, 4};
        String[] opsName = new String[]{"Accept", "Connect", "Read", "Write"};
        for (int i = 0; i < ops.length; ++i) {
            if ((opsProvided & ops[i]) == 0) continue;
            buf.append(opsName[i]);
            if ((opsProvided &= ~ops[i]) == 0) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeTime(long time) {
        String timeString = "";
        long milliseconds = time % 1000L;
        Date date = new Date(time);
        DateFormat dateFormat = formatDate;
        synchronized (dateFormat) {
            formatDate.setTimeZone(TimeZone.getDefault());
            timeString = formatDate.format(date);
        }
        return timeString + "." + milliseconds;
    }

    public static void logDebugOutput(String module, SelectableChannel sc, SelectionKey key, String text, long timeIn) {
        long time = timeIn != 0L ? timeIn : System.currentTimeMillis();
        String logTime = ContentCaptureIO.decodeTime(time);
        String keyString = key != null ? "" + key + ": interestOps: " + ContentCaptureIO.keyIsOps(key.interestOps()) + ", readyOps: " + ContentCaptureIO.keyIsOps(key.readyOps()) : "null";
        System.err.println(logTime + ": module: " + module + ": channel : " + sc + ": key: " + keyString + ": " + text);
        System.err.flush();
    }

    class WorkerThread
    extends Thread {
        boolean running;
        boolean waiting;

        public WorkerThread(String threadName) {
            super(ContentCaptureIO.this.threadGroup, threadName);
            this.running = true;
            this.waiting = false;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopWorker() {
            this.running = false;
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.waiting) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClientWork work = null;
            CaptureClientConnection connection = null;
            do {
                Object object = ContentCaptureIO.this.workerLock;
                synchronized (object) {
                    if (connection != null || !ContentCaptureIO.this.connectionWork.isEmpty()) {
                        if (connection == null) {
                            connection = (CaptureClientConnection)ContentCaptureIO.this.connectionWork.removeFirst();
                        }
                        LinkedList workQueue = (LinkedList)ContentCaptureIO.this.connectionWorkQueues.get(connection);
                        work = (ClientWork)workQueue.removeFirst();
                        if (workQueue.isEmpty()) {
                            ContentCaptureIO.this.connectionWorkQueues.remove(connection);
                            connection = null;
                        }
                        work.getClientConnection().processChannelInput(work.getPacket());
                    }
                }
                if (connection != null || !ContentCaptureIO.this.connectionWork.isEmpty()) continue;
                object = this;
                synchronized (object) {
                    Object object2 = ContentCaptureIO.this.workerLock;
                    synchronized (object2) {
                        ContentCaptureIO.this.workingThreads.remove(this);
                        ContentCaptureIO.this.waitingThreads.addFirst(this);
                    }
                    try {
                        this.waiting = true;
                        this.wait();
                        if (!this.running) {
                            return;
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
            } while (this.running);
        }
    }
}

