/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module;

import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.module.PermissionFeatureDebug;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class PermissionMetaDataListener
implements MetaDataListener,
ParticipantSelectionListener,
CRPermissionChangeListener {
    private ThreadLocal<Boolean> remoteEventThreadLocal = new ThreadLocal();
    private String permissionName;
    private ParticipantSelectorAPI selector;
    private TelephonyAPI telephonyAPI;
    private CRSession session;
    private BooleanFeature booleanFeature;
    private FeatureBroker broker;
    private Boolean supportsBridge = false;

    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    public void supportsBridge(boolean supports) {
        this.supportsBridge = supports;
        if (this.telephonyAPI != null && this.supportsBridge.booleanValue()) {
            this.telephonyAPI.addPropertyChangeListener("TelephonyAPI.audioMode", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PermissionMetaDataListener.this.updateFeatures();
                }
            });
        }
    }

    public void initImps(Imps imps) {
        if (imps != null) {
            this.selector = (ParticipantSelectorAPI)imps.findBest(ParticipantSelectorAPI.class);
            if (this.selector != null) {
                this.selector.addSelectionListener((ParticipantSelectionListener)this);
            }
            this.telephonyAPI = (TelephonyAPI)imps.findBest(TelephonyAPI.class);
        }
    }

    public void initSession(CRSession session) {
        this.session = session;
        if (session != null) {
            session.addPermissionChangeListener(this.permissionName, (CRPermissionChangeListener)this);
            session.addPermissionChangeListener("ChairPermission", (CRPermissionChangeListener)this);
        }
    }

    public PermissionMetaDataListener(String permissionName, BooleanFeature booleanFeature) {
        this.permissionName = permissionName;
        this.booleanFeature = booleanFeature;
        if (booleanFeature != null) {
            booleanFeature.addValueChangeListener((MetaDataListener)this);
        }
    }

    public void metaDataChanged(MetaDataEvent event) {
        ClientInfo[] clients;
        Boolean isRemoteEvent = this.remoteEventThreadLocal.get();
        if (PermissionFeatureDebug.TRACE.show()) {
            LogSupport.message((Object)this, (String)"metaDataChanged", (String)("isRemoteEvent = " + isRemoteEvent));
        }
        if (isRemoteEvent != null && isRemoteEvent.booleanValue()) {
            this.remoteEventThreadLocal.remove();
            return;
        }
        this.remoteEventThreadLocal.set(false);
        Object source = event.getSource();
        boolean oldValue = (Boolean)event.getOldValue();
        boolean newValue = (Boolean)event.getNewValue();
        if (PermissionFeatureDebug.TRACE.show()) {
            LogSupport.message((Object)this, (String)"metaDataChanged", (String)("oldValue:" + oldValue + " newValue:" + newValue + " source = " + source));
        }
        if ((clients = this.getSelectedClients()) != null) {
            for (ClientInfo ci : clients) {
                CRPermission p = this.session.getPermission(this.permissionName, ci.getAddress());
                if (p == null || newValue == p.getValue()) continue;
                if (PermissionFeatureDebug.TRACE.show()) {
                    LogSupport.message((Object)this, (String)"metaDataChanged", (String)("newValue:" + newValue + ", permisson: " + p.getID() + " " + p.getValue() + " " + p.getDefault()));
                }
                this.session.setPermissionValue(this.permissionName, ci.getAddress(), newValue);
            }
        }
    }

    public void participantSelectionChanged() {
        this.updateFeatures();
    }

    private ClientInfo[] getSelectedClients() {
        List selectedClients = this.selector != null ? this.selector.getSelectedClients() : new ArrayList();
        ClientInfo[] info = new ClientInfo[selectedClients.size()];
        return selectedClients.toArray(info);
    }

    private boolean isTeleconferee() {
        boolean isTeleconferee = false;
        List participantList = this.selector != null ? this.selector.getSelectedParticipants() : new ArrayList();
        CRParticipant[] selected = participantList.toArray(new CRParticipant[participantList.size()]);
        if (this.telephonyAPI != null) {
            for (int i = 0; !isTeleconferee && i < selected.length; ++i) {
                isTeleconferee = this.telephonyAPI.getAudioMode(selected[i].getID()) == 2;
            }
        }
        return isTeleconferee;
    }

    private boolean hasABridge() {
        boolean hasABridge = false;
        List participantList = this.selector != null ? this.selector.getSelectedParticipants() : new ArrayList();
        CRParticipant[] selected = participantList.toArray(new CRParticipant[participantList.size()]);
        if (this.telephonyAPI != null) {
            for (int i = 0; !hasABridge && i < selected.length; ++i) {
                hasABridge = this.telephonyAPI.isBridge(selected[i].getID());
            }
        }
        return hasABridge;
    }

    private synchronized void updateFeatures() {
        if (PermissionFeatureDebug.TRACE.show()) {
            LogSupport.message((Object)this, (String)"updateFeatures", (String)("updating " + this.booleanFeature));
        }
        if (this.booleanFeature == null) {
            return;
        }
        boolean isChair = this.session != null && this.session.getMe() != null ? this.session.getMe().isChair() : false;
        CRPermission permission = null;
        Boolean hasPermission = null;
        boolean isEnabled = false;
        ClientInfo[] clients = this.getSelectedClients();
        if (clients != null && clients.length == 1) {
            isEnabled = true;
            permission = this.session.getPermission(this.permissionName, clients[0].getAddress());
            if (permission != null) {
                hasPermission = permission.getValue();
            }
        }
        if (PermissionFeatureDebug.TRACE.show()) {
            LogSupport.message((Object)this, (String)"updateFeatures", (String)("[" + this.permissionName + "] isChair = " + isChair + " isEnabled = " + isEnabled + " hasPermission = " + hasPermission));
        }
        boolean disableAudio = this.permissionName.equals("AudioPermission") && this.isTeleconferee();
        this.booleanFeature.setEnabled(isChair && isEnabled && !disableAudio);
        boolean hasBridge = this.hasABridge();
        boolean problemWithBridge = this.supportsBridge == false && hasBridge;
        this.broker.setFeaturePublished((Feature)this.booleanFeature, isChair && !problemWithBridge);
        if (hasPermission != null) {
            this.booleanFeature.setValue((Object)hasPermission);
        }
    }

    public void onPermissionValueChange(CRPermissionChangeEvent event) {
        CRPermission permission = (CRPermission)event.getSource();
        String key = permission.getName();
        Boolean isRemoteEvent = this.remoteEventThreadLocal.get();
        if (PermissionFeatureDebug.TRACE.show()) {
            LogSupport.message((Object)this, (String)"onPermissionValueChange", (String)("isRemoteEvent = " + isRemoteEvent));
        }
        if (isRemoteEvent != null && !isRemoteEvent.booleanValue()) {
            this.remoteEventThreadLocal.remove();
            return;
        }
        this.remoteEventThreadLocal.set(true);
        if (!key.equals("ChairPermission") && !key.equals(this.permissionName)) {
            return;
        }
        this.updateFeatures();
    }

    public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
    }
}

