/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.groupware.imps.ParticipantSelectionAPI;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class ParticipantSelectionIMPS
implements ParticipantSelectionAPI,
ParticipantSelectorAPI {
    private Map<Short, CRParticipant> selectedParticipantsMap = new LinkedHashMap<Short, CRParticipant>();
    private List<CRRoom> selectedRooms;
    private final Object lock = new Object();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Set<ParticipantSelectionListener> selectionListeners = new CopyOnWriteArraySet<ParticipantSelectionListener>();
    private Logger logger;

    public String getProvider() {
        return "LegacyAppShell";
    }

    public byte getTier() {
        return 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedParticipants(List<CRParticipant> selectedParticipants) {
        int was = 0;
        int now = 0;
        boolean isSelectionChanged = false;
        Object object = this.lock;
        synchronized (object) {
            was = this.selectedParticipantsMap.size();
            int n = now = selectedParticipants == null ? 0 : selectedParticipants.size();
            if (was == now) {
                if (selectedParticipants != null) {
                    for (CRParticipant p : selectedParticipants) {
                        if (this.selectedParticipantsMap.containsKey(p.getID())) continue;
                        isSelectionChanged = true;
                        break;
                    }
                }
            } else {
                isSelectionChanged = true;
            }
            if (isSelectionChanged) {
                this.selectedParticipantsMap.clear();
                if (selectedParticipants != null) {
                    for (CRParticipant p : selectedParticipants) {
                        this.selectedParticipantsMap.put(p.getID(), p);
                    }
                }
            }
        }
        if (isSelectionChanged) {
            this.changeSupport.firePropertyChange("selectedParicipantCount", was, now);
            for (ParticipantSelectionListener lst : this.selectionListeners) {
                try {
                    lst.participantSelectionChanged();
                }
                catch (Throwable t) {
                    this.logger.exception((Object)this, "setSelectedParticipants", t, true);
                }
            }
        }
    }

    public void setSelectedRooms(List<CRRoom> selectedRooms) {
        int was = this.selectedRooms == null ? 0 : this.selectedRooms.size();
        int now = selectedRooms == null ? 0 : selectedRooms.size();
        this.selectedRooms = selectedRooms;
        this.changeSupport.firePropertyChange("selectedRoomCount", was, now);
        for (ParticipantSelectionListener lst : this.selectionListeners) {
            try {
                lst.participantSelectionChanged();
            }
            catch (Throwable t) {
                this.logger.exception((Object)this, "setSelectedRooms", t, true);
            }
        }
    }

    @Inject
    protected void initIMPS(Imps imps) {
        imps.provideAPI(ParticipantSelectionAPI.class, (ImpsAPI)this);
        imps.provideAPI(ParticipantSelectorAPI.class, (ImpsAPI)this);
    }

    @Inject
    protected void initLogger(Logger logger) {
        this.logger = logger;
    }

    public int getSelectedParticipantCount() {
        return this.selectedParticipantsMap.size();
    }

    public Short[] getSelectedParticipantIds() {
        Set<Short> idList = this.selectedParticipantsMap.keySet();
        Short[] ids = new Short[idList.size()];
        idList.toArray(ids);
        return ids;
    }

    public List<CRParticipant> getSelectedParticipants() {
        Collection<CRParticipant> sp = this.selectedParticipantsMap.values();
        if (sp == null) {
            return new ArrayList<CRParticipant>(0);
        }
        ArrayList<CRParticipant> pList = new ArrayList<CRParticipant>(sp);
        return Collections.unmodifiableList(pList);
    }

    public List<ClientInfo> getSelectedClients() {
        Collection<CRParticipant> sp = this.selectedParticipantsMap.values();
        ClientList clients = null;
        int size = sp == null ? 0 : sp.size();
        ArrayList<ClientInfo> cl = new ArrayList<ClientInfo>(size);
        if (sp != null) {
            for (CRParticipant part : sp) {
                ClientInfo ci;
                if (clients == null) {
                    clients = part.getSession().getConnection().getClientList();
                }
                if ((ci = clients.get(part.getID())) == null) continue;
                cl.add(ci);
            }
        }
        return cl;
    }

    public int getSelectedRoomCount() {
        List<CRRoom> sr = this.selectedRooms;
        return sr == null ? 0 : sr.size();
    }

    public Short[] getSelectedRoomIds() {
        List<CRRoom> sr = this.selectedRooms;
        ArrayList<Short> idList = new ArrayList<Short>();
        if (sr != null) {
            for (CRRoom room : sr) {
                idList.add(room.getID());
            }
        }
        Short[] ids = new Short[idList.size()];
        idList.toArray(ids);
        return ids;
    }

    public List<CRRoom> getSelectedRooms() {
        List<CRRoom> sr = this.selectedRooms;
        if (sr == null) {
            return new ArrayList<CRRoom>(0);
        }
        return Collections.unmodifiableList(sr);
    }

    public List<ClientGroup> getSelectedGroups() {
        List<CRRoom> sr = this.selectedRooms;
        ClientList clients = null;
        int size = sr == null ? 0 : sr.size();
        ArrayList<ClientGroup> gl = new ArrayList<ClientGroup>(size);
        if (sr != null) {
            for (CRRoom room : sr) {
                ClientGroup cg;
                if (clients == null) {
                    clients = room.getSession().getConnection().getClientList();
                }
                if ((cg = clients.getClientGroup(room.getID())) == null) continue;
                gl.add(cg);
            }
        }
        return gl;
    }

    public boolean isSelectionEmpty() {
        List<CRRoom> sr = this.selectedRooms;
        return this.selectedParticipantsMap.size() <= 0 && (sr == null || sr.size() <= 0);
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(lst);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(prop, lst);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(prop, lst);
    }

    public void addSelectionListener(ParticipantSelectionListener lst) {
        this.selectionListeners.add(lst);
    }

    public void removeSelectionListener(ParticipantSelectionListener lst) {
        this.selectionListeners.remove(lst);
    }
}

