/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.app;

import com.elluminate.classroom.client.ApplicationUIProxy;
import com.elluminate.classroom.moduleloading.LoadingStatus;
import com.elluminate.classroom.swing.MainFrame;
import com.elluminate.classroom.swing.SwingApplicationUI;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.moduleloading.ModuleContainer;
import com.elluminate.framework.moduleloading.ModuleLocator;
import com.elluminate.framework.moduleloading.locator.ClassPathModuleLocator;
import com.elluminate.framework.moduleloading.states.ModulesStateSrc;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.imps.ParticipantSelectionAPI;
import com.elluminate.groupware.module.ClientModule;
import com.elluminate.groupware.module.ParticipantSelectionIMPS;
import com.elluminate.groupware.module.contentcapture.ContentCaptureProviderImpl;
import com.elluminate.gui.swing.DialogParentProviderImpl;
import com.elluminate.jinx.provider.ConnectionProvider;
import com.elluminate.jinx.provider.ConnectionProviderImpl;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.Preferences;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.VersionManager;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.log.Logger;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;

public class ClientCoreBindings
extends AbstractModule {
    private LoadingStatus loadingStatus = new LoadingStatus();
    private final Object uiProxyInstanceLock = new Object();
    private ApplicationUIProxy uiProxyInstance = null;

    ClientCoreBindings() {
    }

    protected void configure() {
        this.bind(ModuleLocator.class).to(ClassPathModuleLocator.class).in(Singleton.class);
        ConnectionProviderImpl cp = new ConnectionProviderImpl();
        this.bind(ConnectionProviderImpl.class).toInstance((Object)cp);
        this.bind(ConnectionProvider.class).toInstance((Object)cp);
        VersionManager ver = new VersionManager();
        this.bind(VersionManager.class).toInstance((Object)ver);
        this.bind(ComponentRegistrar.class).toInstance((Object)ver);
        Preferences prefs = new Preferences();
        this.bind(Preferences.class).toInstance((Object)prefs);
        this.bind(SwingRunner.class).toInstance((Object)SwingRunnerSupport.getInstance());
        this.bind(Key.get((TypeLiteral)new TypeLiteral<ModuleContainer<ClientModule>>(){})).in(Singleton.class);
        this.bind(ModulesStateSrc.class).to(Key.get((TypeLiteral)new TypeLiteral<ModuleContainer<ClientModule>>(){})).in(Singleton.class);
        this.bind(CRSession.class).in(Singleton.class);
        this.bind(ParticipantSelectionAPI.class).to(ParticipantSelectionIMPS.class).in(Singleton.class);
        this.bind(ThrowableListener.class).to(LoggingThrowableHandler.class);
        this.bind(ContentCaptureProvider.class).to(ContentCaptureProviderImpl.class);
        this.bind(LoadingStatus.class).toInstance((Object)this.loadingStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provides
    ApplicationUIProxy provideApplicationUIProxy(Provider<MainFrame> mfProvider, DialogParentProviderImpl parentProvider, MembersInjector<SwingApplicationUI> injector) {
        Object object = this.uiProxyInstanceLock;
        synchronized (object) {
            if (this.uiProxyInstance == null) {
                AppUIRunner uiProv = null;
                try {
                    uiProv = new AppUIRunner(mfProvider, parentProvider, injector);
                    SwingRunnerSupport.getInstance().invokeAndWait((Runnable)uiProv);
                }
                catch (InterruptedException intx) {
                    // empty catch block
                }
                if (uiProv != null) {
                    this.uiProxyInstance = uiProv.uiProxy;
                }
            }
            return this.uiProxyInstance;
        }
    }

    private class AppUIRunner
    implements Runnable {
        Provider<MainFrame> mfProvider;
        DialogParentProviderImpl parentProvider;
        MembersInjector<SwingApplicationUI> injector;
        ApplicationUIProxy uiProxy;

        AppUIRunner(Provider<MainFrame> mfp, DialogParentProviderImpl pp, MembersInjector<SwingApplicationUI> inj) {
            this.mfProvider = mfp;
            this.parentProvider = pp;
            this.injector = inj;
            this.uiProxy = null;
        }

        @Override
        public void run() {
            SwingApplicationUI ui = new SwingApplicationUI((MainFrame)this.mfProvider.get(), this.parentProvider);
            this.injector.injectMembers((Object)ui);
            this.uiProxy = ui;
        }
    }

    @Singleton
    public static class LoggingThrowableHandler
    implements ThrowableListener {
        private Logger logger;

        @Inject
        public void initLogger(Logger logger) {
            this.logger = logger;
        }

        public void exceptionThrown(Exception e) {
            this.logger.exception((Object)this, "exceptionThrown", (Throwable)e, true);
        }

        public void errorThrown(Error e) {
            this.logger.exception((Object)this, "errorThrown", (Throwable)e, true);
        }
    }
}

