/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.xml;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.dataModel.MediaItem;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.groupware.whiteboard.xml.WBJDOMFactory;
import com.elluminate.groupware.whiteboard.xml.WBSAXBuilder;
import com.elluminate.groupware.whiteboard.xml.WhiteboardDataFileException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.ProcessingInstruction;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class WhiteboardDataFile {
    private Document jdoc = null;
    private WBSAXBuilder builder = null;
    private WhiteboardContext context;
    private WBJDOMFactory factory = null;
    private int depth;
    private int progressValue = 0;
    private boolean proxiesEncountered = false;
    private boolean continueOperation = true;
    private HashSet mediaSet = new HashSet();

    public WhiteboardDataFile(WhiteboardContext context) {
        this.context = context;
    }

    public synchronized boolean readDataStream(BufferedInputStream stream) throws Exception, WhiteboardDataFileException {
        if (stream == null) {
            throw new WhiteboardDataFileException("No stream supplied.");
        }
        if (this.jdoc != null) {
            throw new WhiteboardDataFileException("Existing JDOM document.");
        }
        this.builder = new WBSAXBuilder(false);
        this.factory = new WBJDOMFactory();
        this.builder.setFactory((JDOMFactory)this.factory);
        this.jdoc = this.builder.build(stream);
        return true;
    }

    public synchronized int getMaxInstances() {
        return this.factory.getInstanceCount();
    }

    public boolean writeData(File file, ScreenModel[] writeRoots, ProgressUpdate progress) throws Exception, WhiteboardDataFileException {
        if (file == null) {
            throw new WhiteboardDataFileException("No file selected.");
        }
        if (writeRoots == null) {
            throw new WhiteboardDataFileException("Null whiteboard tree.");
        }
        this.jdoc = new Document((Element)this.treeToJDOM(writeRoots, progress));
        progress.setFilename(" - writing data to file -");
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        FileOutputStream out = new FileOutputStream(file);
        fmt.output(this.jdoc, (OutputStream)out);
        out.close();
        progress.setMaximum(progress.getValue());
        return true;
    }

    public String writeToString(ScreenModel[] writeRoots, ProgressUpdate progress) throws Exception, WhiteboardDataFileException {
        if (writeRoots == null) {
            throw new WhiteboardDataFileException("Null whiteboard tree.");
        }
        this.jdoc = new Document((Element)this.treeToJDOM(writeRoots, progress));
        progress.setFilename(" - writing data to file -");
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        StringWriter out = new StringWriter();
        fmt.output(this.jdoc, (Writer)out);
        String str = out.toString();
        out.close();
        progress.setMaximum(progress.getValue());
        return str;
    }

    public WBElement getRootElement() {
        return this.jdoc == null ? null : (WBElement)this.jdoc.getRootElement();
    }

    public boolean addProcessingInstruction(String instruction, Map valueMap) {
        if (this.jdoc == null) {
            return false;
        }
        this.jdoc.addContent((Content)new ProcessingInstruction(instruction, valueMap));
        return true;
    }

    public List getChildren(Object node, String elementName) {
        if (!(node instanceof WBElement)) {
            return null;
        }
        WBElement eNode = (WBElement)((Object)node);
        return eNode.getChildren(elementName);
    }

    public void treeOutputter(DefaultMutableTreeNode root) {
        if (this.jdoc != null) {
            this.processElement((WBElement)this.jdoc.getRootElement(), root);
        }
    }

    protected void processElement(WBElement el, DefaultMutableTreeNode dmtn) {
        DefaultMutableTreeNode dmtnLocal = new DefaultMutableTreeNode(el.getName());
        String elText = el.getTextNormalize();
        if (elText != null && !elText.equals("")) {
            dmtnLocal.add(new DefaultMutableTreeNode(elText));
        }
        this.processAttributes(el, dmtnLocal);
        Iterator iter = el.getChildren().iterator();
        while (iter.hasNext() && this.continueOperation) {
            WBElement nextEl = (WBElement)((Object)iter.next());
            this.processElement(nextEl, dmtnLocal);
        }
        dmtn.add(dmtnLocal);
    }

    protected void processAttributes(WBElement el, DefaultMutableTreeNode dmtn) {
        Iterator atts = el.getAttributes().iterator();
        while (atts.hasNext() && this.continueOperation) {
            Attribute att = (Attribute)atts.next();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode("@" + att.getName());
            node.add(new DefaultMutableTreeNode(att.getValue()));
            dmtn.add(node);
        }
    }

    private WBElement treeToJDOM(WBNode[] treeRoots, ProgressUpdate progress) throws Exception {
        int i;
        this.proxiesEncountered = false;
        int children = 0;
        for (i = 0; i < treeRoots.length; ++i) {
            children += this.countChildren(treeRoots[i]);
        }
        progress.setMaximum((int)((double)children * 1.2));
        this.progressValue = 0;
        progress.setValue(this.progressValue);
        WBElement whiteboardModel = new WBElement("Whiteboard");
        for (i = 0; i < treeRoots.length && this.continueOperation; ++i) {
            if (treeRoots[i] instanceof ScreenRoot || treeRoots[i] instanceof WhiteboardModel) {
                Iterator iter = treeRoots[i].iterateScreens();
                while (iter.hasNext() && this.continueOperation) {
                    Object obj = iter.next();
                    if (!(obj instanceof RegisteredTemplate)) continue;
                    if (!(obj instanceof WBNodeProxy)) {
                        RegisteredTemplate treeNode = (RegisteredTemplate)obj;
                        this.depth = Integer.MAX_VALUE;
                        WBElement element = this.processChildren((WBNode)treeNode, null, 1, progress);
                        if (element == null) continue;
                        whiteboardModel.addContent((Content)element);
                        continue;
                    }
                    this.proxiesEncountered = true;
                }
                continue;
            }
            if (!(treeRoots[i] instanceof ScreenModel)) continue;
            this.depth = 1;
            whiteboardModel = this.processChildren(treeRoots[i], whiteboardModel, 1, progress);
        }
        this.context.getMediaCache().emitMediaCache(whiteboardModel, this.mediaSet, progress);
        if (this.proxiesEncountered) {
            // empty if block
        }
        return whiteboardModel;
    }

    private int countChildren(WBNode root) {
        int children = root.getToolCount() + 1;
        if (root.isContainer()) {
            Iterator iter = root.iterateContainer();
            while (iter.hasNext()) {
                children += this.countChildren((WBNode)iter.next());
            }
        }
        return children;
    }

    private WBElement processChildren(WBNode treeRoot, WBElement root, int descent, ProgressUpdate progress) throws Exception {
        Iterator iter;
        LinkedList<Iterator> oldIterators = new LinkedList<Iterator>();
        if (treeRoot instanceof ScreenModel && (!((ScreenModel)treeRoot).canSave() || descent > this.depth)) {
            return root;
        }
        this.progressValue += treeRoot.getToolCount();
        progress.setValue(++this.progressValue);
        if (treeRoot instanceof ScreenModel) {
            progress.setFilename(((ScreenModel)treeRoot).getScreenName());
            oldIterators.add(((ScreenModel)treeRoot).iterateTools());
            do {
                iter = (Iterator)oldIterators.removeFirst();
                while (iter.hasNext()) {
                    WBNode node = (WBNode)iter.next();
                    if (!(node instanceof WBNodeProxy)) {
                        WBImage wbImage;
                        if (node instanceof GroupToolModel) {
                            oldIterators.add(iter);
                            iter = ((GroupToolModel)node).iterateTools();
                            continue;
                        }
                        if (!(node instanceof ImageToolModel) || (wbImage = ((ImageToolModel)node).getImage()) == null || wbImage.getMediaData() == null) continue;
                        MediaItem mediaItem = this.context.getMediaCache().getMediaItem(wbImage.getMediaData().getMediaID());
                        this.mediaSet.add(mediaItem);
                        continue;
                    }
                    this.proxiesEncountered = true;
                }
            } while (!oldIterators.isEmpty());
        }
        WBElement thisElement = treeRoot.objectToElement(root, progress);
        if (root == null) {
            root = thisElement;
        } else if (thisElement == null) {
            WBUtils.timedLog("WhiteboardDataFile", "processChildren, objectToElement returns null");
        } else {
            root.addContent((Content)thisElement);
        }
        iter = treeRoot.iterateScreens();
        while (iter.hasNext() && this.continueOperation) {
            Object obj = iter.next();
            if (!(obj instanceof RegisteredTemplate) || obj instanceof WBNodeProxy) continue;
            RegisteredTemplate treeNode = (RegisteredTemplate)obj;
            this.processChildren((WBNode)treeNode, thisElement, descent + 1, progress);
        }
        return root;
    }

    public synchronized WhiteboardModel processJDOM(WhiteboardDataFile jdom, WhiteboardContext context, ProgressUpdate progress) throws Exception {
        WBElement rootElement = jdom.getRootElement();
        String elementName = rootElement.getName();
        if (elementName.equalsIgnoreCase("Whiteboard")) {
            RegisteredTemplate obj = context.getTemplateRegistry().templateFactory(elementName, rootElement, progress);
            if (!(obj instanceof WhiteboardModel)) {
                throw new Exception("Top of JDOM is not a Whiteboard: " + WBUtils.objectName(obj));
            }
            WhiteboardModel newRoot = (WhiteboardModel)obj;
            return newRoot;
        }
        throw new Exception("File is not a WhiteboardDataFile.");
    }

    public void endOperation() {
        this.continueOperation = false;
    }
}

