/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.BoxUIInterface;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class RectangleToolModel
extends AbstractToolModel
implements Cloneable {
    static final String WBD_NAME = "RectangleTool";
    static final String RECTANGLE_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.BoxUI";
    protected ToolColor fillColor = null;
    protected boolean filled = false;

    public RectangleToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public RectangleToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.color.setAlternateName("BorderColor");
        this.color.setQuickAttribute(true);
        this.stroke.setQuickAttribute(true);
        this.fillColor = new ToolColor(context, "FillColor");
        this.fillColor.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FILLCOLOR));
        this.fillColor.setPanelKey("shapeProperties");
        this.fillColor.setColor(Color.white, 0);
        this.registerIfClass("RectangleToolModel");
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        if (this.fillColor != null) {
            this.addAttribute(this.fillColor);
        }
    }

    public RectangleToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"JDOM constructor", (Throwable)ex, (boolean)true);
        }
    }

    public RectangleToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"stream constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public boolean hasReciprocalAction() {
        return false;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        RectangleToolModel rectangleToolModel;
        try {
            rectangleToolModel = (RectangleToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            rectangleToolModel = new RectangleToolModel(this.context);
        }
        rectangleToolModel.initialized = false;
        rectangleToolModel.toolRect.setSize(1.0, 1.0);
        return rectangleToolModel;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RectangleToolModel rectangleToolModel = (RectangleToolModel)super.clone();
        if (this.fillColor != null) {
            rectangleToolModel.fillColor = (ToolColor)this.fillColor.clone();
        }
        rectangleToolModel.registerIfClass("RectangleToolModel");
        return rectangleToolModel;
    }

    protected void setFilled(boolean filled) {
        this.filled = filled;
        if (this.fillColor != null) {
            if (filled) {
                this.fillColor.setMasterColor(this.color);
            } else {
                this.fillColor.setMasterColor(this.fillColor);
            }
        }
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        switch (e.getID()) {
            case 501: {
                this.initialized = true;
                this.toolRect.setSize(1.0, 1.0, false);
                this.setLocation(e.getX(), e.getY());
                break;
            }
            case 506: {
                int x = e.getX() - this.getLocation().getIntLocation().x;
                int y = e.getY() - this.getLocation().getIntLocation().y;
                if (e.isShiftDown()) {
                    int max = Math.max(Math.abs(x), Math.abs(y));
                    x = x <= 0 ? -max : max;
                    y = y <= 0 ? -max : max;
                }
                this.setSize(x, y);
                break;
            }
            case 502: {
                response = 2;
                break;
            }
        }
        return response;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 0;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null && this.context.getController() != null) {
            this.toolUI = this.toolUIFactory(RECTANGLE_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public void delete() {
        this.fillColor = null;
        super.delete();
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        RectangleToolModel tool = (RectangleToolModel)super.streamToObject(istr);
        tool.setFilled(false);
        return tool;
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        RectangleToolModel tool = (RectangleToolModel)super.elementToObject(element, progress);
        this.setFilled(false);
        return tool;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        return element;
    }

    @Override
    public void render(Graphics g) {
        ((BoxUIInterface)((Object)this.getUI())).draw(g, this);
    }

    public ToolColor getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Object color) {
        if (this.fillColor != null) {
            this.fillColor.setColor(color);
            this.notifyVisibleChange();
        }
    }
}

