/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.EllipseUIInterface;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class EllipseToolModel
extends AbstractToolModel
implements Cloneable {
    static final String WBD_NAME = "EllipseTool";
    static final String ELLIPSE_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.EllipseUI";
    protected ToolColor fillColor = null;
    protected boolean filled = false;

    public EllipseToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public EllipseToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.color.setAlternateName("BorderColor");
        this.fillColor = new ToolColor(context, "FillColor");
        this.fillColor.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FILLCOLOR));
        this.fillColor.setPanelKey("shapeProperties");
        this.fillColor.setColor(Color.white, 0);
        this.color.setQuickAttribute(true);
        this.stroke.setQuickAttribute(true);
        this.registerIfClass("EllipseToolModel");
    }

    public EllipseToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public EllipseToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"StreamToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public boolean hasReciprocalAction() {
        return false;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        EllipseToolModel ellipseToolModel;
        try {
            ellipseToolModel = (EllipseToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            ellipseToolModel = new EllipseToolModel(this.context);
        }
        ellipseToolModel.initialized = false;
        ellipseToolModel.toolRect.setSize(1.0, 1.0);
        return ellipseToolModel;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    protected void setFilled(boolean filled) {
        this.filled = filled;
        if (this.fillColor != null) {
            if (filled) {
                this.fillColor.setMasterColor(this.color);
            } else {
                this.fillColor.setMasterColor(this.fillColor);
            }
        }
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        switch (e.getID()) {
            case 501: {
                this.toolRect.setSize(1.0, 1.0, false);
                this.initialized = true;
                this.setLocation(e.getX(), e.getY());
                break;
            }
            case 506: {
                int x = e.getX() - this.getLocation().getIntLocation().x;
                int y = e.getY() - this.getLocation().getIntLocation().y;
                if (e.isShiftDown()) {
                    int max = Math.max(Math.abs(x), Math.abs(y));
                    x = x <= 0 ? -max : max;
                    y = y <= 0 ? -max : max;
                }
                this.setSize(x, y);
                break;
            }
            case 502: {
                response = 2;
                break;
            }
        }
        return response;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 0;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null) {
            this.toolUI = this.toolUIFactory(ELLIPSE_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EllipseToolModel ellipseToolModel = (EllipseToolModel)super.clone();
        if (this.fillColor != null) {
            ellipseToolModel.fillColor = (ToolColor)this.fillColor.clone();
        }
        ellipseToolModel.registerIfClass("EllipseToolModel");
        return ellipseToolModel;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        if (this.fillColor != null) {
            this.addAttribute(this.fillColor);
        }
    }

    @Override
    public void delete() {
        this.fillColor = null;
        super.delete();
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        return super.streamToString(istr);
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        return element;
    }

    @Override
    public void render(Graphics g) {
        ((EllipseUIInterface)((Object)this.getUI())).draw(g, this);
    }

    public ToolColor getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Object color) {
        if (this.fillColor != null) {
            this.fillColor.setColor(color);
            this.notifyVisibleChange();
        }
    }
}

