/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WBCursorUtils;
import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributePlaceholder;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.attributes.ToolRectangle;
import com.elluminate.groupware.whiteboard.attributes.ToolStroke;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DDimension;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.TemplateClassLoader;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.VisibleNotifyObject;
import com.elluminate.groupware.whiteboard.interfaces.VisibleObject;
import com.elluminate.groupware.whiteboard.listeners.VisibleAttributeChangeListener;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.AsyncToolFactoryListener;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.platform.Platform;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jdom.Attribute;

public abstract class AbstractToolModel
extends WBNode
implements Cloneable,
VisibleObject,
VisibleNotifyObject {
    private static final boolean IS_WINDOWS = Platform.getPlatform() == 1;
    protected AsyncToolFactoryListener asyncContext = null;
    protected ActionEvent asyncEvent = null;
    protected static final I18n I18N = I18n.create((Object)new Object(){});
    public static final int ZORDER_ANY = -4;
    public static final int ZORDER_FIRST = -3;
    public static final int ZORDER_LAST = -2;
    public static final int ZORDER_BACKGROUND = -1;
    public static final int RESPOND_CONTINUE = 0;
    public static final int RESPOND_INSTALL_DONE = 1;
    public static final int RESPOND_INSTALL_NEW = 2;
    public static final int RESPOND_ABORT = 3;
    public static final int RESPOND_RELEASE_KEYBOARD = 4;
    public static final int RESPOND_ACQUIRE_KEYBOARD = 5;
    public static final int RESPOND_INSTALL = 6;
    public static final int RESPOND_NEW = 7;
    public static final int RESPOND_INSTALL_REGENERATE = 8;
    public static final int RESPOND_INSTALL_COPY = 9;
    public static final String BUTTON_STATE_DEFAULT = "default";
    public static final String BUTTON_STATE_DISABLED = "disabled";
    public static final String BUTTON_STATE_ARMED = "armed";
    public static final String BUTTON_STATE_ROLLOVER = "rollover";
    public static final String BUTTON_STATE_SELECTED = "selected";
    private static final List<String> ALLOWED_BUTTON_STATES = Arrays.asList("default", "disabled", "armed", "rollover", "selected");
    private static HashMap cursorMap = new HashMap();
    private static TemplateClassLoader loader = null;
    protected AttributePlaceholder coordinates = null;
    protected ToolRectangle toolRect = null;
    protected ToolRectangle editStartRect = null;
    protected Rectangle visibleBounds = new Rectangle();
    protected ToolStroke stroke = null;
    protected ToolColor color = null;
    protected AbstractUI toolUI = null;
    protected Object uiData = null;
    protected boolean hasFrame = true;
    protected boolean invalidUI = true;
    protected boolean selected = false;
    protected boolean editing = false;
    private boolean beingCreated = false;
    protected boolean wantMouse = false;
    protected boolean wantKeyboard = false;
    protected boolean deselectOnDelete = false;
    protected boolean initialized = false;
    protected Cursor cursor = null;
    protected int zOrder = -4;
    protected boolean controllerPaneSelectable = true;
    protected boolean objectExplorerSelectable = true;
    protected String actionName = null;
    protected String displayName;
    protected boolean toolNeedsInking = false;
    private Color selectionRectangleColor = Color.black;
    private String contentType;
    private boolean uiComponentActive = false;

    public AbstractToolModel(WhiteboardContext context, String name) {
        super(context);
        this.coordinates = new AttributePlaceholder(context, "coordinates");
        this.toolRect = new ToolRectangle(context, true);
        this.stroke = new ToolStroke(context, "ToolStroke");
        this.stroke.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_STROKE));
        this.stroke.setPanelKey("shapeProperties");
        this.color = new ToolColor(context, "ToolColor");
        this.color.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_STROKECOLOR));
        this.color.setPanelKey("shapeProperties");
        this.setAsTool(true);
        this.setName(name);
        try {
            this.setDisplayName(I18N.getStringLegacy(this.getName() + ".displayName"));
        }
        catch (Exception ex) {
            System.out.println("Cannot find display name for: " + this.getName());
            this.setDisplayName(this.getName());
        }
        this.registerIfClass("AbstractToolModel");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractToolModel abstractTool = (AbstractToolModel)super.clone();
        abstractTool.toolUI = null;
        abstractTool.uiData = null;
        abstractTool.invalidUI = true;
        abstractTool.visibleBounds = new Rectangle(this.visibleBounds);
        abstractTool.toolRect = (ToolRectangle)this.toolRect.clone();
        abstractTool.stroke = this.stroke == null ? null : (ToolStroke)this.stroke.clone();
        abstractTool.color = this.color == null ? null : (ToolColor)this.color.clone();
        abstractTool.coordinates = this.coordinates == null ? null : (AttributePlaceholder)this.coordinates.clone();
        abstractTool.setOriginator();
        abstractTool.setDisplayPeer(null);
        return abstractTool;
    }

    protected void registerIfClass(String currentClass) {
        if (this.getClass().getName().endsWith("." + currentClass)) {
            this.registerAttributes();
        }
    }

    public boolean canSizeTool() {
        return true;
    }

    public boolean visibleBorder() {
        return this.stroke == null || this.color == null ? false : this.hasFrame && this.color.getAlpha() > 0;
    }

    protected void registerAttributes() {
        this.setContext(this.context);
        this.addAttribute(this.toolRect);
        if (this.coordinates != null) {
            this.addAttribute(this.coordinates);
        }
        if (this.stroke != null) {
            this.addAttribute(this.stroke);
        }
        if (this.color != null) {
            this.addAttribute(this.color);
        }
    }

    public void setUIData(Object data) {
        this.uiData = data;
    }

    public Object getUIData() {
        return this.uiData;
    }

    public boolean isUIInvalid() {
        return this.invalidUI;
    }

    public void setUIInvalid(boolean invalid) {
        this.invalidUI = invalid;
    }

    public boolean doesToolNeedInking() {
        return this.toolNeedsInking;
    }

    public boolean deselectOnDelete() {
        return this.deselectOnDelete;
    }

    @Override
    public void createPeer() {
        this.createPeer(this);
    }

    public void createPeer(WBNode node) {
        DisplayNode previousPeer = null;
        ScreenModel parentScreen = node.findScreenParent();
        if (parentScreen != null && parentScreen.getToolTreeModel() != null) {
            int index;
            DisplayNode parentPeer;
            if (node.getParent() instanceof ScreenModel && node.getParent().isConferenceNode()) {
                if (parentScreen.getToolTreeModel() == null) {
                    return;
                }
                parentPeer = (DisplayNode)parentScreen.getToolTreeModel().getRoot();
            } else {
                parentPeer = node.getParent().getDisplayPeer();
            }
            if (parentPeer == null) {
                return;
            }
            DisplayModel toolDisplayModel = parentScreen.getToolTreeModel();
            for (index = node.getIndex() - 1; previousPeer == null && index >= 0; --index) {
                previousPeer = node.getParent() instanceof GroupToolModel ? node.getParent().getChildAt(index).getDisplayPeer() : ((WBNode)((ScreenModel)node.getParent()).getToolAt(index)).getDisplayPeer();
            }
            if (node.getDisplayPeer() == null) {
                node.setDisplayPeer(new DisplayNode(node));
            } else {
                node.getDisplayPeer().setUserObject(node);
            }
            if (node.getDisplayPeer().getParent() == null) {
                index = previousPeer != null ? parentPeer.getIndex(previousPeer) + 1 : 0;
                toolDisplayModel.insertNodeInto(node.getDisplayPeer(), parentPeer, index);
                Iterator iter = node.iterateTools();
                while (iter.hasNext()) {
                    Object object = iter.next();
                    if (object instanceof WBNodeProxy) continue;
                    this.createPeer((WBNode)object);
                }
            }
        }
    }

    public int getToolXOffset() {
        int toolX = this.getBounds().width > 0 ? this.getBounds().x : this.getBounds().x + this.getBounds().width;
        return toolX;
    }

    public int getToolYOffset() {
        int toolY = this.getBounds().height > 0 ? this.getBounds().y : this.getBounds().y + this.getBounds().height;
        return toolY;
    }

    @Override
    public void add(WBNode node) {
        throw new RuntimeException("AbstractToolModel.add: not permitted");
    }

    @Override
    public void add(WBNode node, Object oldNode) {
        throw new RuntimeException("AbstractToolModel.add: not permitted");
    }

    @Override
    public void insert(WBNode node, int index) {
        throw new RuntimeException("AbstractToolModel.insert: not permitted");
    }

    @Override
    public void remove(WBNode node) {
        throw new RuntimeException("AbstractToolModel.remove: not permitted");
    }

    @Override
    public void delete() {
        if (this.context.getController() != null) {
            this.context.getController().unsetToolSlipTool(this);
        }
        this.notifyVisibleChange();
        super.delete();
        this.uiData = null;
    }

    @Override
    public Rectangle getBounds() {
        return this.toolRect.getBounds();
    }

    @Override
    public Rectangle getVBounds() {
        if (this.invalidUI) {
            this.evaluateBounds();
        }
        return this.visibleBounds;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
        this.cursor = null;
    }

    public void setBounds(Rectangle rect) {
        this.toolRect.setBounds(rect);
    }

    @Override
    public DDimension getSize() {
        return this.toolRect.getSize();
    }

    public Dimension getIntSize() {
        return this.toolRect.getSize().getIntSize();
    }

    @Override
    public void setSize(DDimension dDim) {
        this.toolRect.setSize(dDim);
    }

    public void setSize(double width, double height) {
        this.toolRect.setSize(width, height);
    }

    public DPoint getCentroid() {
        return this.toolRect.getCentroid();
    }

    @Override
    public DPoint getLocation() {
        return this.toolRect.getLocation();
    }

    public DPoint getNormalLocation() {
        return this.toolRect.getNormalLocation();
    }

    public DDimension getNormalSize() {
        return this.toolRect.getNormalSize();
    }

    public void setLocation(double x, double y) {
        this.setLocation(new DPoint(x, y));
    }

    @Override
    public void setLocation(DPoint dP) {
        if (!dP.equals(this.toolRect.getLocation())) {
            this.toolRect.setLocation(dP);
        }
    }

    public void setRect(double x, double y, double w, double h) {
        this.toolRect.setOriginator(this.getOriginator());
        this.toolRect.setLocation(x, y, false);
        this.setSize(w, h);
    }

    public ToolRectangle getRect() {
        return this.toolRect;
    }

    public boolean wantsMouse(MouseEvent e) {
        return this.wantMouse;
    }

    public Cursor getCursor() {
        Image cursorImage = null;
        if (this.cursor == null) {
            String cursorName;
            block14: {
                cursorName = this.getName();
                if (this.actionName instanceof String) {
                    cursorName = cursorName + "." + this.actionName;
                }
                this.cursor = (Cursor)cursorMap.get(cursorName);
                if (this.cursor != null) {
                    return this.cursor;
                }
                try {
                    boolean useWinRsrc = false;
                    if (IS_WINDOWS) {
                        useWinRsrc = true;
                        try {
                            cursorImage = I18N.getImage(cursorName + ".win.cursorIcon");
                        }
                        catch (Throwable t) {
                            useWinRsrc = false;
                            LogSupport.message((Object)this, (String)"getCursor", (String)("Getting windows-specific cursor failed: " + t));
                        }
                    }
                    if (cursorImage == null) {
                        useWinRsrc = false;
                        cursorImage = I18N.getImage(cursorName + ".cursorIcon");
                    }
                    if (cursorImage == null) break block14;
                    String hotspotString = null;
                    if (useWinRsrc) {
                        try {
                            hotspotString = I18N.getStringLegacy(cursorName + ".win.cursorHotSpot");
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (hotspotString == null) {
                        hotspotString = I18N.getStringLegacy(cursorName + ".cursorHotSpot");
                    }
                    StringTokenizer tokenizer = new StringTokenizer(hotspotString);
                    int x = Integer.parseInt(tokenizer.nextToken(","));
                    int y = Integer.parseInt(tokenizer.nextToken());
                    Point hotspot = new Point(x, y);
                    String tkName = I18N.getStringLegacy(cursorName + ".cursorName");
                    this.cursor = WBCursorUtils.createCustomCursor(cursorImage, hotspot, tkName);
                }
                catch (Exception ex1) {
                    LogSupport.error((Object)this, (String)"getCursor", (String)("Failed to load cursor " + cursorName + ": " + ex1));
                }
            }
            if (this.cursor == null) {
                this.cursor = Cursor.getPredefinedCursor(1);
            }
            cursorMap.put(cursorName, this.cursor);
        }
        return this.cursor;
    }

    public int receivedClick(MouseEvent e) {
        return 0;
    }

    public void mouseEvent(MouseEvent e, Component component) {
    }

    public boolean wantsKeyboard() {
        return this.wantKeyboard;
    }

    public int keyEvent(KeyEvent e, Component componeent) {
        return 0;
    }

    public int continuedResponse() {
        return 3;
    }

    public Point streamToPoint(DataInputStream istr) {
        try {
            short x = WBUtils.readShort(istr, "Point x");
            short y = WBUtils.readShort(istr, "Point y");
            return new Point(x, y);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToPoint", (Throwable)ioe, (boolean)true);
            return null;
        }
    }

    public void pointToStream(Point point, DataOutputStream ostr) {
        try {
            ostr.writeShort(point.x);
            ostr.writeShort(point.y);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"pointToStream", (Throwable)ioe, (boolean)true);
        }
    }

    public Dimension streamToDimension(DataInputStream istr) {
        try {
            short width = WBUtils.readShort(istr, "Dimension width");
            short height = WBUtils.readShort(istr, "Dimension height");
            return new Dimension(width, height);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"streamToDimension", (Throwable)ioe, (boolean)true);
            return null;
        }
    }

    public void dimensionToStream(Dimension dim, DataOutputStream ostr) {
        try {
            ostr.writeShort(dim.width);
            ostr.writeShort(dim.height);
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"dimensionToStream", (Throwable)ioe, (boolean)true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        this.setSuppressAttributeNotification();
        super.streamToObject(istr);
        this.toolRect.streamToObject(istr);
        this.initialized = true;
        this.evaluateBounds();
        this.clearSuppressAttributeNotification();
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer msg = new StringBuffer();
        msg.append(super.streamToString(istr));
        msg.append(this.toolRect.streamToString(istr));
        return msg.toString();
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        this.toolRect.objectToStream(ostr);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.setSuppressAttributeNotification();
        super.elementToObject(element, progress);
        this.initialized = true;
        this.clearSuppressAttributeNotification();
        this.evaluateBounds();
        this.context.getObjectManager().setObjectInMap(this);
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        parent.setAttribute(new Attribute("id", Integer.toString(ObjectUID.decodeSequence(this.getObjectID()))));
        super.objectToElement(parent, progress);
        return null;
    }

    public void scaleTool(double scaleWidth, double scaleHeight) {
        if (scaleWidth == 1.0 && scaleHeight == 1.0) {
            return;
        }
        this.notifyVisibleChange();
        this.toolRect.getSize().scale(scaleWidth, scaleHeight);
        this.evaluateBounds();
        this.notifySizingChange();
    }

    public void moveTool(double dX, double dY) {
        if (dX == 0.0 && dY == 0.0) {
            return;
        }
        this.notifyVisibleChange();
        this.setLocation(this.getLocation().getX() + dX, this.getLocation().getY() + dY);
        this.notifySizingChange();
    }

    @Override
    public Icon getIcon() {
        return this.getIcon(false);
    }

    public String getToolTip() {
        return this.getToolTip(false);
    }

    public boolean hasReciprocalAction() {
        return false;
    }

    public Icon getIcon(boolean reciprocal) {
        try {
            if (reciprocal) {
                return I18N.getIcon(this.getName() + ".reciprocal.icon");
            }
            return I18N.getIcon(this.getName() + ".icon");
        }
        catch (Exception ex) {
            try {
                return I18N.getIcon("AbstractToolModel.defaultIcon");
            }
            catch (Exception ex1) {
                return null;
            }
        }
    }

    public String getToolTip(boolean reciprocal) {
        try {
            if (reciprocal) {
                return I18N.getStringLegacy(this.getName() + ".reciprocal.toolTip");
            }
            return I18N.getStringLegacy(this.getName() + ".toolTip");
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getToolTip(String action, boolean reciprocal) {
        try {
            if (reciprocal) {
                return I18N.getStringLegacy(this.getName() + "." + action + ".reciprocal.toolTip");
            }
            return I18N.getStringLegacy(this.getName() + "." + action + ".toolTip");
        }
        catch (Exception e) {
            return this.getToolTip(reciprocal);
        }
    }

    public Icon getButtonIcon(String action, boolean reciprocal) {
        try {
            if (reciprocal) {
                return I18N.getIcon(this.getName() + "." + action + ".reciprocal.icon");
            }
            return I18N.getIcon(this.getName() + "." + action + ".icon");
        }
        catch (Exception ex) {
            return this.getIcon(reciprocal);
        }
    }

    public Icon getButtonStateIcon(String action, String btnState, boolean reciprocal) {
        if (!ALLOWED_BUTTON_STATES.contains(btnState)) {
            throw new IllegalArgumentException("Invalid button state: " + btnState);
        }
        try {
            String key = this.getName() + (BUTTON_STATE_DEFAULT.equals(btnState) ? "" : "." + btnState) + (action == null ? "" : "." + action);
            if (reciprocal) {
                return I18N.getIcon(key + ".reciprocal.icon");
            }
            return I18N.getIcon(key + ".icon");
        }
        catch (Exception ex) {
            if (BUTTON_STATE_DEFAULT.equals(btnState)) {
                return this.getButtonIcon(action, reciprocal);
            }
            return null;
        }
    }

    public Cursor getDrawingCursor() {
        return this.getCursor();
    }

    public String getActionName() {
        return this.actionName;
    }

    public Cursor getBehaviourCursor(MouseEvent e) {
        return null;
    }

    public boolean isLink(MouseEvent e) {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isAsync(String action) {
        return false;
    }

    public AbstractToolModel toolFactory(AsyncToolFactoryListener context, ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        if (this.isAsync(e.getActionCommand())) {
            if (this.asyncContext != null) {
                return null;
            }
            this.asyncContext = context;
            this.asyncEvent = e;
        }
        return this.toolFactory(screen, container, e, reciprocal);
    }

    public abstract AbstractToolModel toolFactory(ScreenModel var1, WBNode var2, ActionEvent var3, boolean var4);

    public abstract AbstractToolModel toolFactory(ScreenModel var1, WBNode var2, boolean var3, AbstractToolModel var4);

    public AbstractToolModel toolFactory(ExternalDataBean toolData, ScreenModel screen, WBNode container, boolean reciprocal) {
        return null;
    }

    public abstract boolean createOnlyToScreen();

    public boolean unselectOnCreation() {
        return true;
    }

    public abstract int creationMouseEvent(MouseEvent var1);

    public abstract int creationKeyEvent(KeyEvent var1);

    public void endCreating() {
        this.setRevision((short)0);
        this.setOriginator();
        this.beingCreated = false;
    }

    public void toolComplete() {
    }

    public void quiesceTool() {
    }

    public boolean isCreating() {
        return this.beingCreated;
    }

    public void setCreating(boolean beingCreated) {
        this.beingCreated = beingCreated;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && !this.isDeleted();
    }

    protected void fireAttributeChange() {
        if (this.isAttributeNotificationSuppressed()) {
            return;
        }
        if (this.context.getBean() != null && this.getRoot() != null) {
            this.context.getBean().setDocumentChanged(true);
        }
        if (this.context != null && this.context.getController() != null) {
            if (this.parent != null && this.parent instanceof VisibleAttributeChangeListener) {
                ((VisibleAttributeChangeListener)((Object)this.parent)).onVisibleAttributeChange(this);
            } else {
                this.context.getController().repaint(this);
            }
        }
    }

    @Override
    public void notifyVisibleChange() {
        if (this.isInitialized() || this.isCreating()) {
            if (this.getDisplayPeer() != null && this.getDisplayPeer().getDisplayModel() != null) {
                this.getDisplayPeer().getDisplayModel().nodeChanged(this.getDisplayPeer());
            }
            this.fireAttributeChange();
        }
    }

    @Override
    public void notifySizingChange() {
        if (this.isInitialized() || this.isCreating()) {
            this.setUIInvalid(true);
            this.evaluateBounds();
            if (this.isAttributeNotificationSuppressed()) {
                return;
            }
            this.fireAttributeChange();
        }
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public void setZOrder(int zOrder) {
        this.zOrder = zOrder;
    }

    protected void evaluateBounds() {
        double lineWidth = this.stroke.getWidth();
        double delta = lineWidth / 2.0;
        double x = Math.min(this.toolRect.getLocation().getX(), this.toolRect.getLocation().getX() + this.toolRect.getSize().getWidth());
        double y = Math.min(this.toolRect.getLocation().getY(), this.toolRect.getLocation().getY() + this.toolRect.getSize().getHeight());
        double width = Math.abs(this.toolRect.getSize().getWidth());
        double height = Math.abs(this.toolRect.getSize().getHeight());
        if (!this.visibleBorder()) {
            delta = 1.0;
        } else if (this.stroke.getLineJoin() == 0) {
            delta = Math.max(delta, (double)this.stroke.getMiterLimit());
        }
        switch (this.stroke.getCap()) {
            case 2: {
                delta *= 1.5;
                break;
            }
        }
        this.visibleBounds.x = (int)(x - delta);
        this.visibleBounds.y = (int)(y - delta);
        this.visibleBounds.width = (int)(width + 2.0 * delta);
        this.visibleBounds.height = (int)(height + 2.0 * delta);
    }

    public abstract AbstractUI getUI();

    public Color getSelectionRectangleColor() {
        return this.selectionRectangleColor;
    }

    public List getActiveAttributes() {
        ArrayList<AbstractAttribute> attributes = new ArrayList<AbstractAttribute>();
        for (AbstractAttribute attribute : this.attributeList) {
            if (!attribute.isDisplayEditorOnActivation()) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public void setSelectionRectangleColor(Color selectionRectangleColor) {
        if (!this.selectionRectangleColor.equals(selectionRectangleColor)) {
            this.selectionRectangleColor = selectionRectangleColor;
            this.notifyVisibleChange();
        }
    }

    public AbstractUI toolUIFactory(String uiName) {
        String message = null;
        try {
            Class myClass;
            Object object;
            if (loader == null) {
                loader = new TemplateClassLoader();
            }
            if ((object = (myClass = loader.loadClass(uiName, true)).newInstance()) instanceof AbstractUI) {
                return (AbstractUI)object;
            }
        }
        catch (ClassNotFoundException ex) {
            message = ex.getMessage();
            LogSupport.exception((Object)this, (String)"toolUIFactory", (Throwable)ex, (boolean)true);
        }
        catch (IllegalAccessException ex) {
            message = ex.getMessage();
            LogSupport.exception((Object)this, (String)"toolUIFactory", (Throwable)ex, (boolean)true);
        }
        catch (InstantiationException ex) {
            message = ex.getMessage();
            LogSupport.exception((Object)this, (String)"toolUIFactory", (Throwable)ex, (boolean)true);
        }
        throw new RuntimeException("Cannot intantiate UI class: " + uiName + "\n\t" + message);
    }

    public ToolColor getColor() {
        return this.color;
    }

    public void setColor(Object color) {
        this.color.setColor(color);
        this.notifyVisibleChange();
    }

    public ToolStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Object str) {
        this.notifyVisibleChange();
        this.stroke.setStroke(str);
        this.notifySizingChange();
    }

    @Override
    public void render(Graphics g, Graphics unmodifiedG) {
        this.render(g);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public boolean isEditable() {
        return false;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
        if (this.toolRect != null) {
            if (editing) {
                this.setOriginator();
                this.toolRect.clearAttributeChanged();
                this.toolRect.setAttributeNotificationSuppression();
                try {
                    this.editStartRect = (ToolRectangle)this.toolRect.clone();
                }
                catch (Exception exception) {}
            } else {
                this.toolRect.clearAttributeNotificationSuppression(false);
                this.editStartRect = null;
            }
        } else {
            LogSupport.error((Object)this, (String)"setEditing", (String)("Null toolRect for: " + this));
        }
    }

    public ToolRectangle getEditStartRect() {
        return this.editStartRect;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setUiComponentActive(boolean uiComponentActive) {
        this.uiComponentActive = uiComponentActive;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isControllerPaneSelectable() {
        return this.controllerPaneSelectable;
    }

    public boolean isObjectExplorerSelectable() {
        return this.objectExplorerSelectable;
    }

    public boolean isUiComponentActive() {
        return this.uiComponentActive;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isSelectable() {
        return this.objectExplorerSelectable || this.controllerPaneSelectable;
    }

    public boolean isInBackground() {
        WBNode toolParent;
        for (toolParent = this; toolParent != null && !toolParent.isBackground() && !(toolParent instanceof ScreenModel); toolParent = toolParent.getParent()) {
        }
        return toolParent.isBackground();
    }

    public boolean validate(WBNode parent) {
        boolean valid = true;
        if (this.getParent() != parent) {
            Validator.log(this.getName() + " has getParent() != real parent: '" + WBUtils.objectName(this.getParent()) + "' != '" + WBUtils.objectName(parent));
            valid = Validator.setValid(valid, false);
        }
        if (this.iterateTools() != null) {
            valid &= AbstractToolModel.validateChildren(this, this.iterateTools());
        }
        return valid & super.validate();
    }

    @Override
    public String toString() {
        String moreData = super.toString();
        moreData = moreData + "location (" + this.getLocation().getX() + ", " + this.getLocation().getY() + "), size( " + this.getSize().getWidth() + ", " + this.getSize().getHeight() + ")";
        return moreData;
    }

    private static boolean validateChildren(AbstractToolModel parent, Iterator iter) {
        boolean valid = true;
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof AbstractToolModel)) continue;
            AbstractToolModel tool = (AbstractToolModel)object;
            valid &= tool.validate(parent);
        }
        return valid;
    }

    public int creationInputTextChanged(InputMethodEvent event) {
        return 0;
    }
}

