/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.NodeList;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.util.log.LogSupport;

public class WBNodeProxy
extends WBNode
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte SET_AS_TOOL = 1;
    private static final byte NODE_REPARENTING = 2;
    private static final byte SET_AS_BACKGROUND = 4;
    private NodeList parentList = null;

    public WBNodeProxy(WhiteboardContext context) {
        super(context);
    }

    public WBNodeProxy(WhiteboardContext context, WBNode node) {
        this(context);
        this.setObjectID(node.getObjectID());
        this.setRevision(node.getRevision());
        this.setOriginator(node.getOriginator());
        this.setAsTool(node.isTool());
        this.setAsBackground(node.isBackground());
        this.setNodeReparenting(node.isReparenting());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WBNodeProxy proxy = (WBNodeProxy)super.clone();
        proxy.setObjectID(this.getObjectID());
        proxy.setRevision(this.getRevision());
        proxy.setOriginator(null);
        return proxy;
    }

    public NodeList getParentList() {
        return this.parentList;
    }

    public void setParentList(NodeList parentList) {
        this.parentList = parentList;
    }

    @Override
    public void add(WBNode node) {
        throw new RuntimeException("Should not add to WBNodeProxy.");
    }

    @Override
    public void add(WBNode node, Object oldNode) {
        throw new RuntimeException("Should not add to WBNodeProxy.");
    }

    @Override
    public void insert(WBNode node, int index) {
        throw new RuntimeException("Should not insert to WBNodeProxy.");
    }

    @Override
    public void remove(WBNode node) {
        throw new RuntimeException("Should not remove from WBNodeProxy.");
    }

    @Override
    public void createPeer() {
    }

    @Override
    public int getIndex(WBNode node) {
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean proxyReparentsNode(WBNode parent, int reparentingIndex, int proxyCount) {
        WBNode node = null;
        try {
            node = (WBNode)this.context.getObjectManager().getObjectFromMap(this.getObjectID());
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"proxyReparentsNode", (Throwable)ex, (boolean)true);
        }
        if (node != null && !node.isProxy()) {
            if (parent.isProxy()) {
                LogSupport.error((Object)this, (String)"proxyReparentsNode", (String)("WBNodeProxy.proxyReparentsNode cannot reparent a WBNodeProxy: " + node));
                Thread.dumpStack();
                return true;
            }
            node.setNodeReparenting(true);
            node.setNodeReplacingProxy(false);
            node.setOriginator(this.getOriginator());
            node.setModifiedById(this.getOriginator());
            if (this.getParent() == null) {
                if (node instanceof AbstractToolModel) {
                    if (node.getParent() instanceof GroupToolModel && proxyCount == node.getParent().getToolCount() && parent == node.getParent().getParent() && reparentingIndex > node.getParent().getIndex()) {
                        ++reparentingIndex;
                    }
                    ((AbstractToolModel)node).setZOrder(reparentingIndex);
                }
                parent.insert(node, reparentingIndex);
            } else {
                AbstractToolModel tool = (AbstractToolModel)node;
                if (tool.isSelected()) {
                    tool.getScreenParent().deSelectTool(tool);
                }
                parent.add(node, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        WBNodeProxy proxy = new WBNodeProxy(istr.getContext());
        proxy.setOriginator(istr.getOriginatorId());
        byte flags = WBUtils.readByte(istr, "WBNodeProxy reads flags");
        proxy.setAsTool((flags & 1) != 0);
        proxy.setNodeReparenting((flags & 2) != 0);
        proxy.setAsBackground((flags & 4) != 0);
        proxy.setObjectID(ObjectUID.objectUIDFromStream(istr));
        return proxy;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        WBNodeProxy.nodeToStream(ostr, this);
    }

    public static void nodeToStream(WBOutputStream ostr, WBNode node) throws Exception {
        byte flags = (byte)((node.isTool() ? 1 : 0) + (node.isReparenting() ? 2 : 0) + (node.isBackground() ? 4 : 0));
        ostr.writeByte(flags);
        ObjectUID.objectUIDToStream(node.getObjectID(), ostr);
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            byte flags = WBUtils.readByte(istr, "WBNodeProxy reads flags");
            Long objectId = ObjectUID.objectUIDFromStream(istr);
            return "WBNodeProxy(" + WBUtils.objectName(objectId, istr.getContext()) + ")";
        }
        catch (Exception e) {
            return "WBNodeProxy - Exception: " + e.getMessage();
        }
    }

    @Override
    public String toString() {
        return "WBNodeProxy: (" + this.isTool() + ") uid=" + WBUtils.uniqueIDAsHex(this.getObjectID()) + ", parent: " + this.getParent();
    }

    @Override
    public boolean isProxy() {
        return true;
    }
}

