/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributePlaceholder;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActivityDisplay;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ModifiedByInformation;
import com.elluminate.groupware.whiteboard.dataModel.NodeList;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeContainer;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import com.elluminate.groupware.whiteboard.interfaces.AttributeList;
import com.elluminate.groupware.whiteboard.interfaces.JDOMTransferrable;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.groupware.whiteboard.interfaces.WBNodeInterface;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.groupware.whiteboard.tools.PointerToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.ShortList;
import com.elluminate.util.StringComparator;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public abstract class WBNode
extends RegisteredTemplate
implements ACLList,
AttributeList,
Cloneable,
JDOMTransferrable,
ModifiedByInformation,
UniqueObjectID,
WBNodeInterface {
    private Long objectUID = null;
    private short revision = 0;
    private Short modifiedById = ClientIdentification.CLIENT_LOCAL;
    public WBNode parent;
    private Long parentUID = null;
    private ScreenModel root = null;
    protected NodeList screenList = null;
    protected NodeList toolList = null;
    protected NodeList childList = null;
    protected List attributeList = WhiteboardContext.EMPTY_ARRAYLIST;
    protected TreeMap aclMap = null;
    private boolean suppressAttributeNotify = false;
    private DisplayNode displayPeer = null;
    private boolean nodeIsTool = false;
    private boolean nodeIsBackground = false;
    protected boolean nodeIsContainer = false;
    private boolean nodeReplacingProxy = false;
    protected boolean reparentNode = false;
    private boolean deleted = false;
    private boolean inConference = false;
    private boolean needsProcessDeferredProxies = false;
    protected int nodeIndex = -1;
    protected Long assignedObjectUID = null;
    private int hashCode = 0;
    protected boolean autoDeleteChildren = false;
    protected boolean deleteOnDisconnect = false;
    private boolean notifyingDisplayNodeChange = false;
    int propagateDepth = 0;

    public WBNode(WhiteboardContext context) {
        this.context = context;
        this.setOriginator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        NodeList nodeList;
        WBNode wbTreeNode = (WBNode)super.clone();
        wbTreeNode.childList = null;
        wbTreeNode.screenList = null;
        wbTreeNode.toolList = null;
        wbTreeNode.objectUID = null;
        wbTreeNode.assignedObjectUID = null;
        this.context.getObjectManager().setObjectInMap(wbTreeNode);
        wbTreeNode.revision = 0;
        wbTreeNode.parent = null;
        wbTreeNode.setInConference(false);
        wbTreeNode.setRoot(null);
        wbTreeNode.reparentNode = false;
        wbTreeNode.nodeIndex = -1;
        wbTreeNode.nodeReplacingProxy = false;
        wbTreeNode.suppressAttributeNotify = false;
        wbTreeNode.setDisplayPeer(null);
        if (this.screenList != null) {
            nodeList = this.screenList;
            synchronized (nodeList) {
                wbTreeNode.screenList = new NodeList(this, this.screenList.size());
                for (Object object : this.screenList) {
                    if (object instanceof WBNode) {
                        WBNode node = (WBNode)object;
                        wbTreeNode.add((WBNode)node.clone());
                        continue;
                    }
                    if (!(object instanceof WBNodeProxy)) continue;
                    wbTreeNode.add((WBNodeProxy)((WBNodeProxy)object).clone());
                }
            }
        }
        if (this.toolList != null) {
            nodeList = this.toolList;
            synchronized (nodeList) {
                wbTreeNode.toolList = new NodeList(this, this.toolList.size());
                for (WBNode tool : this.toolList) {
                    if (tool instanceof PointerToolModel) continue;
                    wbTreeNode.add((WBNode)tool.clone());
                }
            }
        }
        if (this.childList != null) {
            wbTreeNode.childList = this.childList == this.screenList ? wbTreeNode.screenList : wbTreeNode.toolList;
        }
        wbTreeNode.attributeList = WhiteboardContext.EMPTY_ARRAYLIST;
        wbTreeNode.aclMap = null;
        wbTreeNode.setRoot(null);
        return wbTreeNode;
    }

    public boolean equals(Object o) {
        boolean equals = o instanceof WBNode && this.assignedObjectUID.equals(((WBNode)o).assignedObjectUID);
        return equals;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            throw new RuntimeException("use of WBNode hash code prior to initialization.");
        }
        return this.hashCode;
    }

    public boolean isConferenceNode() {
        return this.inConference && !this.isDeleted();
    }

    public void setInConference(boolean inConference) {
        this.inConference = inConference;
    }

    public boolean isContainer() {
        return this.nodeIsContainer;
    }

    public boolean isTool() {
        return this.nodeIsTool;
    }

    public void setAsTool(boolean nodeIsTool) {
        this.nodeIsTool = nodeIsTool;
    }

    public boolean isBackground() {
        return this.nodeIsBackground;
    }

    public void setAsBackground(boolean nodeIsBackgroundSource) {
        this.nodeIsBackground = nodeIsBackgroundSource;
    }

    public boolean isReparenting() {
        return this.reparentNode;
    }

    public void setNodeReparenting(boolean reparentNode) {
        this.reparentNode = reparentNode;
    }

    public void clearNodeReparenting() {
        Iterator iter = this.iterateTools();
        while (iter.hasNext()) {
            ((WBNode)iter.next()).clearNodeReparenting();
        }
        iter = this.iterateScreens();
        while (iter.hasNext()) {
            ((WBNode)iter.next()).clearNodeReparenting();
        }
    }

    public NodeList getScreenList() {
        return this.screenList;
    }

    @Override
    public short getRevision() {
        return this.revision;
    }

    @Override
    public Short getModfiedById() {
        return this.modifiedById;
    }

    @Override
    public void setModifiedById(Short modifiedById) {
        this.modifiedById = modifiedById;
        if (this.context.isClient() && !this.context.isPlayback() && this.context.getBean() != null) {
            ((ActivityDisplay)((Object)this.context.getBean())).noteActivity(modifiedById, this);
        }
    }

    public int getIndex() {
        if (this.getParent() == null) {
            return -1;
        }
        return this.getParent().getIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndex(WBNode node) {
        if (node.isTool()) {
            if (this.toolList == null) {
                return -1;
            }
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                return this.toolList.indexOf(node);
            }
        }
        if (this.screenList == null) {
            return -1;
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            return this.screenList.indexOf(node);
        }
    }

    public void incrementRevision() {
        this.setRevision((short)(this.getRevision() + 1));
    }

    @Override
    public void setRevision(short revision) {
        this.revision = revision;
    }

    public boolean isNodeReplacingProxy() {
        return this.nodeReplacingProxy;
    }

    public void setNodeReplacingProxy(boolean nodeReplacingProxy) {
        this.nodeReplacingProxy = nodeReplacingProxy;
    }

    public DisplayNode getDisplayPeer() {
        return this.displayPeer;
    }

    public void setDisplayPeer(DisplayNode displayPeer) {
        this.displayPeer = displayPeer;
    }

    public abstract void createPeer();

    public void removePeer() {
        this.removePeer(this);
    }

    public void createChildPeers(Iterator iter) {
        while (iter.hasNext()) {
            WBNode node = (WBNode)iter.next();
            if (node.getDisplayPeer() == null) {
                node.createPeer();
            }
            if (node.isReparenting()) continue;
            this.createChildPeers(node.iterateContainer());
        }
    }

    private void removePeer(WBNode node) {
        if (node.getDisplayPeer() != null) {
            DisplayModel displayModel = node.getDisplayPeer().getDisplayModel();
            if (displayModel != null) {
                displayModel.removeNodeFromParent(node.getDisplayPeer());
            }
            node.getDisplayPeer().setParent(null);
            if (!node.isReparenting()) {
                Enumeration<TreeNode> enumeration = node.getDisplayPeer().children();
                while (enumeration.hasMoreElements()) {
                    DisplayNode peer = (DisplayNode)enumeration.nextElement();
                    if (peer.whiteboardPeer() == null) continue;
                    this.removePeer(peer.whiteboardPeer());
                }
                node.setDisplayPeer(null);
            }
        }
    }

    public boolean isAttributeNotificationSuppressed() {
        return this.suppressAttributeNotify;
    }

    public void setSuppressAttributeNotification() {
        this.suppressAttributeNotify = true;
    }

    public void clearSuppressAttributeNotification() {
        this.suppressAttributeNotify = false;
    }

    protected void addAttribute(RegisteredTemplate attribute) {
        if (this.attributeList == WhiteboardContext.EMPTY_ARRAYLIST) {
            this.attributeList = new ArrayList(5);
        }
        this.attributeList.add(attribute);
        attribute.setTemplate(this.context);
        if (attribute instanceof AbstractAttribute) {
            AbstractAttribute ta = (AbstractAttribute)attribute;
            ta.setParent(this);
        }
    }

    @Override
    public List getAttributeList() {
        return this.attributeList;
    }

    @Override
    public AbstractAttribute getAttribute(Short registeredId) {
        AbstractAttribute attribute2 = null;
        for (AbstractAttribute attribute2 : this.attributeList) {
            if (!attribute2.getRegisteredID().equals(registeredId)) continue;
            return attribute2;
        }
        return null;
    }

    @Override
    public void onAttributeChange(AbstractAttribute attribute) {
        if (!this.isAttributeNotificationSuppressed()) {
            this.incrementRevision();
            if (this.isConferenceNode()) {
                this.context.getDataExporter().addToConference(attribute);
            }
        }
    }

    public void notifyDisplayNodeChange() {
        if (!this.notifyingDisplayNodeChange) {
            this.notifyingDisplayNodeChange = true;
            if (this.getDisplayPeer() != null && this.getDisplayPeer().getDisplayModel() != null) {
                this.getDisplayPeer().getDisplayModel().nodeChanged(this.getDisplayPeer());
            }
            this.notifyingDisplayNodeChange = false;
        }
    }

    @Override
    public ACLTerm getACLTerm(String name) {
        if (this.aclMap == null) {
            return null;
        }
        return (ACLTerm)this.aclMap.get(name);
    }

    @Override
    public void addACLTerm(ACLTerm aclTerm) {
        if (this.aclMap == null) {
            this.aclMap = new TreeMap(new StringComparator());
        }
        this.aclMap.put(aclTerm.getName(), aclTerm);
    }

    @Override
    public void removeACLTerm(String name) {
        if (this.aclMap != null) {
            this.aclMap.remove(name);
        }
    }

    @Override
    public ACLList getACLParent() {
        return this.parent instanceof ACLList ? this.parent : null;
    }

    protected void reEvaluateACLs() {
        if (this.aclMap != null) {
            for (Object object : this.aclMap.values()) {
                if (!(object instanceof ACLTerm)) continue;
                ((ACLTerm)object).reEvaluateTerm(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WBNode getChildAt(int childIndex) {
        Object object;
        if (this.childList == null) {
            return null;
        }
        NodeList nodeList = this.childList;
        synchronized (nodeList) {
            object = this.childList.get(childIndex);
        }
        if (object instanceof WBNode) {
            return (WBNode)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getToolCount() {
        if (this.toolList == null) {
            return 0;
        }
        NodeList nodeList = this.toolList;
        synchronized (nodeList) {
            return this.toolList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScreenCount() {
        if (this.screenList == null) {
            return 0;
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            return this.screenList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRealScreenCount() {
        if (this.screenList == null) {
            return 0;
        }
        int count = 0;
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            for (int i = 0; i < this.screenList.size(); ++i) {
                if (!(this.screenList.get(i) instanceof ScreenModel)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPositionInRealScreenCount(ScreenModel toFind) {
        if (this.screenList == null) {
            return -1;
        }
        int index = 0;
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            for (int i = 0; i < this.screenList.size(); ++i) {
                Object screen = this.screenList.get(i);
                if (screen instanceof ScreenModel) {
                    ++index;
                }
                if (screen == toFind) break;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getToolAt(int index) {
        if (this.toolList == null) {
            return null;
        }
        NodeList nodeList = this.toolList;
        synchronized (nodeList) {
            return this.toolList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getScreenAt(int index) {
        if (this.screenList == null) {
            return null;
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            return this.screenList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount() {
        if (this.childList == null) {
            return 0;
        }
        NodeList nodeList = this.childList;
        synchronized (nodeList) {
            return this.childList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(WBNode node) {
        if (node != null) {
            if (node.isTool()) {
                if (this.toolList == null) {
                    return -1;
                }
                NodeList nodeList = this.toolList;
                synchronized (nodeList) {
                    return this.toolList.size();
                }
            }
            if (this.screenList == null) {
                return -1;
            }
            NodeList nodeList = this.screenList;
            synchronized (nodeList) {
                return this.screenList.size();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int firstNonBackground(int defaultIndex) {
        if (this.toolList != null) {
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                for (int newIndex = 0; newIndex < this.toolList.size(); ++newIndex) {
                    AbstractToolModel tool;
                    Object obj = this.toolList.get(newIndex);
                    if (!(obj instanceof AbstractToolModel) || (tool = (AbstractToolModel)this.toolList.get(newIndex)).getZOrder() == -1) continue;
                    return newIndex;
                }
            }
        }
        return defaultIndex;
    }

    public ScreenModel findScreenParent() {
        for (WBNode node = this; node != null; node = node.getBoardParent()) {
            if (!(node instanceof ScreenModel)) continue;
            return (ScreenModel)node;
        }
        return null;
    }

    @Override
    public WBNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(WBNode parent) {
        this.parent = parent;
        try {
            if (this.context.getBean() != null && parent != null && (parent instanceof ScreenRoot || parent.getRoot() != null || parent.getScreenParent() != null && parent.getScreenParent().getRoot() != null)) {
                this.context.getBean().setDocumentChanged(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this instanceof ScreenRoot) {
            this.setRoot((ScreenRoot)this);
        } else if (parent != null) {
            this.setRoot(parent.getRoot());
            this.setInConference(parent.isConferenceNode());
            this.propagateInConference(this);
            if (this.getRoot() instanceof ScreenRoot && this.originator != null) {
                this.context.getDataExporter().addToConference((RegisteredTemplate)this, this.originator);
                this.context.getDataModel().fireNodeAdded(this, parent);
                this.processDeferredProxies();
            }
        } else if (this.context.getController() != null && this instanceof AbstractToolModel) {
            this.context.getController().unsetToolSlipTool((AbstractToolModel)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDeferredProxies() {
        if (this.needsProcessDeferredProxies) {
            NodeList nodeList;
            ArrayList<WBNodeProxy> proxies = new ArrayList<WBNodeProxy>();
            if (this.toolList != null) {
                nodeList = this.toolList;
                synchronized (nodeList) {
                    for (WBNode child : this.toolList) {
                        if (!child.isProxy()) continue;
                        proxies.add((WBNodeProxy)child);
                    }
                }
            }
            if (this.screenList != null) {
                nodeList = this.screenList;
                synchronized (nodeList) {
                    for (WBNode child : this.screenList) {
                        if (!child.isProxy()) continue;
                        proxies.add((WBNodeProxy)child);
                    }
                }
            }
            for (WBNodeProxy proxy : proxies) {
                proxy.proxyReparentsNode(this, -1, Short.MAX_VALUE);
            }
            this.needsProcessDeferredProxies = false;
        }
    }

    public void setRoot(ScreenModel root) {
        this.root = root;
        this.propagateRooting();
    }

    public ScreenModel getRoot() {
        return this.root;
    }

    private void unRootTree(WBNodeContainer container) {
        if (container instanceof WBNode) {
            LinkedList<WBNode> nodes = new LinkedList<WBNode>();
            nodes.add((WBNode)((Object)container));
            while (!nodes.isEmpty()) {
                WBNode node = (WBNode)nodes.removeFirst();
                this.unrootNodeList(node.screenList, nodes);
                this.unrootNodeList(node.toolList, nodes);
                node.root = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unrootNodeList(NodeList list, LinkedList<WBNode> queue) {
        if (list != null) {
            NodeList nodeList = list;
            synchronized (nodeList) {
                for (WBNode child : list) {
                    if (child instanceof WBNodeContainer) {
                        queue.addLast(child);
                        continue;
                    }
                    child.root = null;
                }
            }
        }
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Iterator iterateScreens() {
        return this.screenList == null ? WhiteboardContext.EMPTY_NODELIST.iterator() : this.screenList.iterator();
    }

    public Iterator iterateTools() {
        return this.toolList == null ? WhiteboardContext.EMPTY_NODELIST.iterator() : this.toolList.iterator();
    }

    public Iterator iterateContainer() {
        return !this.isContainer() || this.childList == null ? WhiteboardContext.EMPTY_NODELIST.iterator() : this.childList.iterator();
    }

    public void propagateRooting() {
        this.propagateRooting(this);
    }

    public void propagateRooting(WBNode node) {
        WBNode child;
        Iterator iter;
        if (node instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)node;
            iter = screen.iterateTools();
            while (iter.hasNext()) {
                child = (WBNode)iter.next();
                child.setRoot(node.getRoot());
                child.setOriginator(node.getOriginator());
                if (child.isContainer()) {
                    ++this.propagateDepth;
                }
                if (this.propagateDepth > 30) {
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                this.propagateRooting(child);
                --this.propagateDepth;
            }
        }
        iter = node.iterateContainer();
        boolean depth = false;
        if (iter != null) {
            while (iter.hasNext()) {
                child = (WBNode)iter.next();
                child.setRoot(node.getRoot());
                child.setOriginator(node.getOriginator());
                if (!child.isContainer()) continue;
                ++this.propagateDepth;
                if (this.propagateDepth > 30) {
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                this.propagateRooting(child);
                --this.propagateDepth;
            }
        }
    }

    public void propagateInConference() {
        this.propagateInConference(this);
    }

    public void propagateInConference(WBNode node) {
        WBNode child;
        Iterator iter;
        if (node instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)node;
            iter = screen.iterateTools();
            while (iter.hasNext()) {
                child = (WBNode)iter.next();
                child.setInConference(this.isConferenceNode());
                if (!child.isContainer()) continue;
                this.propagateInConference(child);
            }
        }
        if ((iter = node.iterateContainer()) != null) {
            while (iter.hasNext()) {
                child = (WBNode)iter.next();
                child.setInConference(this.isConferenceNode());
                if (!child.isContainer()) continue;
                this.propagateInConference(child);
            }
        }
    }

    public abstract void add(WBNode var1);

    public abstract void add(WBNode var1, Object var2);

    public abstract void insert(WBNode var1, int var2);

    @Override
    public abstract void remove(WBNode var1);

    public boolean isParentOf(Object node) {
        if (node instanceof WBNode) {
            while (node instanceof WBNode) {
                if (((WBNode)node).getParent() == this) {
                    return true;
                }
                node = ((WBNode)node).getParent();
            }
        }
        return false;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        int i2;
        Object[] children;
        this.deleted = true;
        if (this.autoDeleteChildren && this instanceof WBNodeContainer) {
            this.unRootTree((WBNodeContainer)((Object)this));
        }
        if (this.screenList != null) {
            NodeList nodeList = this.screenList;
            synchronized (nodeList) {
                children = this.screenList.toArray();
            }
            for (i2 = 0; i2 < children.length; ++i2) {
                this.remove((WBNode)children[i2]);
                ((WBNode)children[i2]).delete();
            }
        }
        if (this.toolList != null) {
            NodeList i2 = this.toolList;
            synchronized (i2) {
                children = this.toolList.toArray();
            }
            for (i2 = 0; i2 < children.length; ++i2) {
                this.remove((WBNode)children[i2]);
                ((WBNode)children[i2]).delete();
            }
        }
        Iterator iter = this.attributeList.iterator();
        while (iter.hasNext()) {
            AbstractAttribute attribute = (AbstractAttribute)iter.next();
            iter.remove();
            attribute.delete();
        }
        super.delete();
        this.parent = null;
        this.root = null;
        if (this.getObjectID() != null) {
            this.context.getObjectManager().removeObject(this);
        }
        this.attributeList = WhiteboardContext.EMPTY_ARRAYLIST;
    }

    public boolean autoDeletesChildren() {
        return this.autoDeleteChildren;
    }

    public boolean shouldDeleteOnDisconnect() {
        return this.deleteOnDisconnect;
    }

    public void determineNodeReparenting() {
        if (this.getParent() != null) {
            if (this instanceof AbstractToolModel && ((AbstractToolModel)this).isSelected()) {
                AbstractToolModel tool = (AbstractToolModel)this;
                tool.getScreenParent().deSelectTool(tool);
            }
            this.setNodeReparenting(true);
            this.setNodeReplacingProxy(false);
        } else {
            this.setNodeReparenting(false);
        }
    }

    public void removeFromConference() {
        if (this.attributeList != null) {
            Iterator iter = this.attributeList.iterator();
            while (iter.hasNext()) {
                ((AbstractAttribute)iter.next()).removeFromConference();
            }
        }
        this.setInConference(false);
    }

    @Override
    public Long getObjectID() {
        return this.objectUID;
    }

    @Override
    public void setObjectID(Long uid) {
        if (uid == null && this.getParent() != null) {
            throw new RuntimeException("setting UID null on connected node: " + this.toString());
        }
        this.objectUID = uid;
        if (uid != null) {
            if (this.assignedObjectUID != null) {
                throw new RuntimeException("Re-use of previously used WBNode: " + this.toString());
            }
            this.hashCode = ObjectUID.objectUIDHash(uid);
            this.assignedObjectUID = uid;
        }
    }

    public Long getParentUID() {
        return this.getBoardParent() == null ? this.parentUID : this.getBoardParent().getObjectID();
    }

    public void setParentUID(Long parentUID) {
        this.parentUID = parentUID;
    }

    public WBNode getBoardParent() {
        return this instanceof ScreenRoot ? null : this.getParent();
    }

    public ScreenModel getScreenParent() {
        WBNode myParent = this.getBoardParent();
        while (myParent != null) {
            if (myParent instanceof ScreenModel) {
                return (ScreenModel)myParent;
            }
            if (myParent instanceof GroupToolModel) {
                myParent = ((GroupToolModel)myParent).getBoardParent();
                continue;
            }
            return null;
        }
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getDisplayName() {
        return this.toString();
    }

    public String toString() {
        String objectId = WBUtils.uniqueIDAsHex(this.assignedObjectUID);
        return this.getName() + " " + objectId + ", revision: " + this.getRevision() + WBUtils.uniqueIDAsHex(this.getParentUID()) + (this.isDeleted() ? " - Deleted -" : "") + "\n";
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        Short modifier = ClientIdentification.NULL_CLIENT;
        if (WhiteboardDebug.TRANSMISSIONS.show()) {
            System.out.println("WBNode - receive: " + this);
        }
        super.streamToObject(istr);
        modifier = ShortList.get((short)WBUtils.readClientId(istr, "Template reads ModifiedById"));
        if (!this.context.isClient()) {
            modifier = istr.getOriginatorId();
        }
        this.setModifiedById(modifier);
        Long objId = ObjectUID.objectUIDFromStream(istr);
        if (objId == null) {
            Validator.log("Null UID for " + this.getName());
        }
        this.setObjectID(objId);
        Long parentUID = ObjectUID.objectUIDFromStream(istr);
        this.setParentUID(parentUID);
        this.parent = null;
        this.nodeIndex = -1;
        short revision = WBUtils.readShort(istr, "WBNode reads revision");
        this.setAsTool(WBUtils.readBoolean(istr, "WBNode reads nodeIsTool"));
        this.setAsBackground(WBUtils.readBoolean(istr, "WBNode reads nodeIsBackground"));
        if (this.screenList != null) {
            this.screenList.streamToObject(istr, this);
            if (!this.screenList.isEmpty()) {
                this.needsProcessDeferredProxies = true;
            }
        }
        if (this.toolList != null) {
            this.toolList.streamToObject(istr, this);
            if (!this.toolList.isEmpty()) {
                this.needsProcessDeferredProxies = true;
            }
        }
        for (AbstractAttribute attribute : this.attributeList) {
            attribute.setOriginator(ClientIdentification.NULL_CLIENT);
            attribute.setAttributeNotificationSuppression();
            attribute.streamToObject(istr);
            attribute.setModifiedById(this.getModfiedById());
            attribute.clearAttributeNotificationSuppression(true);
        }
        if (this.aclMap != null && !this.aclMap.isEmpty()) {
            for (Object obj : this.aclMap.values()) {
                if (!(obj instanceof ACLTerm)) continue;
                ((ACLTerm)obj).streamToObject(istr);
            }
        }
        this.setRevision(revision);
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int index = -1;
            StringBuffer msg = new StringBuffer();
            msg.append(super.streamToString(istr));
            int modifiedById = -1;
            modifiedById = WBUtils.readClientId(istr, "Template reads ModifiedById");
            if (!this.context.isClient()) {
                modifiedById = istr.getOriginatorId().shortValue();
            }
            msg.append(", modified by: " + modifiedById);
            Long objectID = ObjectUID.objectUIDFromStream(istr);
            Long parentId = ObjectUID.objectUIDFromStream(istr);
            short revision = WBUtils.readShort(istr, this.getName() + " reads revision");
            boolean nodeIsTool = WBUtils.readBoolean(istr, this.getName() + " reads nodeIsTool");
            if (parentId != null) {
                index = WBUtils.readShort(istr, this.getName() + " reads index");
            }
            msg.append(this.getName() + ": " + "ObjectID: " + WBUtils.uniqueIDAsHex(objectID) + ", ParentID: " + WBUtils.uniqueIDAsHex(parentId) + ", Revision: " + revision + ", nodeIsTool: " + nodeIsTool + "\n");
            if (this.screenList != null) {
                msg.append(this.screenList.streamToString(istr));
            }
            if (this.toolList != null) {
                msg.append(this.toolList.streamToString(istr));
            }
            Iterator<Object> iter = this.attributeList.iterator();
            while (iter.hasNext()) {
                msg.append(", ");
                msg.append(((AbstractAttribute)iter.next()).streamToString(istr));
            }
            if (this.aclMap != null && !this.aclMap.isEmpty()) {
                for (Object obj : this.aclMap.values()) {
                    if (!(obj instanceof ACLTerm)) continue;
                    msg.append(", ");
                    msg.append(((ACLTerm)obj).streamToString(istr));
                }
            }
            return msg.toString();
        }
        catch (Exception ex) {
            return "streamToObjectID: " + ex.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        if (WhiteboardDebug.TRANSMISSIONS.show()) {
            System.out.println("WBNode - send: " + this);
        }
        super.objectToStream(ostr);
        ostr.writeShort(this.modifiedById.shortValue());
        ObjectUID.objectUIDToStream(this.getObjectID(), ostr);
        ObjectUID.objectUIDToStream(this.getParentUID(), ostr);
        ostr.writeShort(this.revision);
        ostr.writeBoolean(this.isTool());
        ostr.writeBoolean(this.isBackground());
        if (this.screenList != null) {
            this.screenList.objectToStream(ostr);
        }
        if (this.toolList != null) {
            this.toolList.objectToStream(ostr);
        }
        for (AbstractAttribute attribute : this.attributeList) {
            attribute.objectToStream(ostr);
        }
        if (this.aclMap != null && !this.aclMap.isEmpty()) {
            for (Object obj : this.aclMap.values()) {
                if (!(obj instanceof ACLTerm)) continue;
                ((ACLTerm)obj).objectToStream(ostr);
            }
        }
    }

    protected void objectIDToStream(WBOutputStream ostr) throws Exception {
        if (this.getRegisteredID() == 0) {
            LogSupport.error((Object)this, (String)"objectIDToStream", (String)" ***************** Streamout of Unregistered template");
        }
        ostr.writeShort(this.getRegisteredID().shortValue());
        ObjectUID.objectUIDToStream(this.getObjectID(), ostr);
        ObjectUID.objectUIDToStream(this.getParentUID(), ostr);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.setSuppressAttributeNotification();
        for (Object obj : this.attributeList) {
            if (!(obj instanceof AbstractAttribute)) continue;
            AbstractAttribute ta = (AbstractAttribute)obj;
            if (ta.usesHeader() && !(ta instanceof AttributePlaceholder)) {
                ta.setAttributeNotificationSuppression();
                ta.elementToObject(element, progress);
                ta.clearAttributeNotificationSuppression(true);
                continue;
            }
            if (ta instanceof AttributePlaceholder) continue;
            WBElement attrElement2 = null;
            for (WBElement attrElement2 : element.getChildren()) {
                String childName = attrElement2.getName().toLowerCase(Locale.ENGLISH);
                if (WhiteboardDebug.ELEMENT_PROC.show()) {
                    LogSupport.message((Object)this, (String)"elementToObject", (String)("Element is: " + childName + ", looking at: " + ta.getName() + ", alt: " + ta.getAlternateName()));
                }
                if (childName.equals(ta.getName()) || childName.equals(ta.getAlternateName())) break;
                attrElement2 = null;
            }
            if (attrElement2 != null) {
                if (progress != null) {
                    progress.setValue(attrElement2);
                }
                ta.elementToObject(attrElement2, progress);
                continue;
            }
            if (WhiteboardDebug.ELEMENT_PROC.show()) {
                Iterator it = element.getChildren().iterator();
                while (it.hasNext()) {
                    LogSupport.message((Object)this, (String)"elementToObject", (String)("Child: " + ((WBElement)((Object)it.next())).getName()));
                }
            }
            if (ta.isOptional()) continue;
            LogSupport.error((String)("elementToToolHeader(" + this.getName() + "): No XML ELEMENT for Attribute: " + ta.getName()));
        }
        this.clearSuppressAttributeNotification();
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        for (Object obj : this.attributeList) {
            AbstractAttribute ta;
            if (!(obj instanceof AbstractAttribute) || (ta = (AbstractAttribute)obj) instanceof AttributePlaceholder) continue;
            ta.objectToElement(parent, progress);
        }
        return null;
    }

    public void addMediaRequest(Short clientId) {
        for (AbstractAttribute attribute : this.attributeList) {
            attribute.setOriginator(this.getOriginator());
            attribute.addMediaRequest(clientId);
        }
    }

    public void merge(WBNode newNode) {
        WBNode wbNode;
        int index;
        WBNode newChild;
        Iterator iter;
        if (newNode.screenList != null) {
            iter = newNode.screenList.iterator();
            while (iter.hasNext()) {
                newChild = (WBNode)iter.next();
                iter.remove();
                index = this.screenList.indexOf(newChild);
                if (index >= 0) {
                    wbNode = (WBNode)this.screenList.get(index);
                    if (!wbNode.isProxy()) continue;
                    this.add(newChild, (WBNode)this.screenList.get(index));
                    continue;
                }
                this.add(newChild);
            }
        }
        if (newNode.toolList != null) {
            iter = newNode.toolList.iterator();
            while (iter.hasNext()) {
                newChild = (WBNode)iter.next();
                iter.remove();
                index = this.toolList.indexOf(newChild);
                if (index >= 0) {
                    wbNode = (WBNode)this.toolList.get(index);
                    if (!wbNode.isProxy()) continue;
                    this.add(newChild, (WBNode)this.toolList.get(index));
                    continue;
                }
                this.add(newChild);
            }
        }
        this.setSuppressAttributeNotification();
        for (AbstractAttribute myAttribute : this.attributeList) {
            AbstractAttribute newAttribute;
            if (myAttribute == null || (newAttribute = newNode.getAttribute(myAttribute.getRegisteredID())) == null) continue;
            newAttribute.setOriginator(newNode.getOriginator());
            myAttribute.merge(newAttribute);
        }
        this.clearSuppressAttributeNotification();
        this.setRevision(newNode.getRevision());
        if (this.getDisplayPeer() != null && this.getDisplayPeer().getDisplayModel() != null) {
            this.getDisplayPeer().getDisplayModel().nodeChanged(this.getDisplayPeer());
        }
        newNode.setObjectID(null);
        newNode.delete();
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        try {
            if (this.getObjectID() == null) {
                Validator.log(this.getClass().getName() + " has a null ObjectID: " + this.toString());
                valid = Validator.setValid(valid, false);
            }
            if (this.context.getObjectManager().getObjectFromMap(this.getObjectID()) == null) {
                Validator.log(this.getClass().getName() + " is not in ObjectMap: " + WBUtils.objectName(this));
                valid = Validator.setValid(valid, false);
            }
        }
        catch (Exception e) {
            Validator.log(this.getClass().getName() + ": Exception: " + e.getMessage() + ", checking ObjectMap for: " + WBUtils.objectName(this));
            valid = Validator.setValid(valid, false);
        }
        if (this.isReparenting()) {
            Validator.log(this + ": is flagged as reparenting");
            valid = Validator.setValid(valid, false);
        }
        try {
            if (!this.isTool() && this instanceof AbstractToolModel) {
                Validator.log(this.getClass().getName() + ": is an AbstractToolModel not flagged as a tool");
                valid = Validator.setValid(valid, false);
            }
        }
        catch (Exception ex) {
            Validator.log("Exception checking isTool in: " + this.toString());
            valid = Validator.setValid(valid, false);
        }
        try {
            if (!(this.getRoot() instanceof ScreenRoot)) {
                Validator.log(this.getClass().getName() + " does not have a valid ScreenRoot: " + WBUtils.objectName(this) + ", root: " + this.getRoot());
                valid = Validator.setValid(valid, false);
            }
        }
        catch (Exception ex1) {
            Validator.log("Exception checking getRoot in: " + this.toString());
            valid = Validator.setValid(valid, false);
        }
        try {
            if (this instanceof ScreenRoot) {
                if (this.getParent() == null) {
                    Validator.log(this.getClass().getName() + " has a null parent: " + WBUtils.objectName(this));
                    valid = Validator.setValid(valid, false);
                }
            } else if (this.getParent() == null) {
                Validator.log(this.getClass().getName() + " has a null parent: " + WBUtils.objectName(this));
                valid = Validator.setValid(valid, false);
            } else if (this.getIndex() < 0) {
                Validator.log(this.getClass().getName() + "'s parent does not have child: " + WBUtils.objectName(this));
                valid = Validator.setValid(valid, false);
            }
        }
        catch (Exception ex2) {
            Validator.log("Exception checking ScreenRoot and parentage in: " + this.toString());
            valid = Validator.setValid(valid, false);
        }
        try {
            int childIndex = 0;
            if (this.screenList != null) {
                for (WBNode child : this.screenList) {
                    if (child.getIndex() != childIndex) {
                        Validator.log(this.getClass().getName() + " child: " + child.getIndex() + " should have index: " + childIndex + ": " + WBUtils.objectName(child));
                        valid = Validator.setValid(valid, false);
                    }
                    ++childIndex;
                    valid &= child.validate();
                }
            }
        }
        catch (Exception ex3) {
            Validator.log(this.getClass().getName() + " check getIndex: " + this.toString());
            valid = Validator.setValid(valid, false);
        }
        try {
            for (Object obj : this.attributeList) {
                if (!(obj instanceof AbstractAttribute)) continue;
                valid &= ((AbstractAttribute)obj).validate(this);
            }
        }
        catch (Exception ex4) {
            Validator.log(this.getClass().getName() + " check attributeList: " + this.toString());
            valid = Validator.setValid(valid, false);
        }
        try {
            if (this.aclMap != null) {
                for (Map.Entry entry : this.aclMap.entrySet()) {
                    String aclName = (String)entry.getKey();
                    ACLTerm aclTerm = (ACLTerm)entry.getValue();
                    if (!aclTerm.getName().equals(aclName)) {
                        Validator.log(this.getClass().getName() + " aclTerm: " + aclTerm.getName() + ", known as: " + aclName + ", in the aclMap.");
                        valid = Validator.setValid(valid, false);
                    }
                    if (aclTerm.getParent() != this) {
                        Validator.log(this.getClass().getName() + " aclTerm: " + aclTerm.getName() + " believes its parent is not this node.");
                        valid = Validator.setValid(valid, false);
                    }
                    valid &= aclTerm.validate(this);
                }
            }
        }
        catch (Exception ex5) {
            Validator.log(this.getClass().getName() + " check ACLS: " + this.toString());
            valid = Validator.setValid(valid, false);
        }
        return valid & super.validate();
    }

    public String display(String indent) {
        WBNode node;
        StringBuffer buf = new StringBuffer();
        buf.append(indent + this.getClass().getName() + WBUtils.uniqueIDAsHex(this.getObjectID()) + ", index: " + this.getIndex() + "\n");
        if (this.getDisplayPeer() != null) {
            if (this.getDisplayPeer().getParent() != null) {
                buf.append(indent + "  DisplayPeer index: " + this.getDisplayPeer().getParent().getIndex(this.getDisplayPeer()) + "\n");
            } else {
                buf.append(indent + "  DisplayPeer has no parent" + "\n");
            }
        }
        Iterator iter = this.iterateScreens();
        while (iter.hasNext()) {
            node = (WBNode)iter.next();
            buf.append(node.display(indent + "    "));
        }
        iter = this.iterateTools();
        while (iter.hasNext()) {
            node = (WBNode)iter.next();
            buf.append(node.display(indent + "    "));
        }
        return buf.toString();
    }

    public boolean isPartOfBackGround() {
        if (this.isBackground()) {
            return true;
        }
        if (this instanceof ScreenModel) {
            return false;
        }
        if (this instanceof AbstractToolModel) {
            if (this.getParent() == null) {
                return false;
            }
            return this.getParent().isPartOfBackGround();
        }
        return false;
    }

    public boolean isProxy() {
        return false;
    }
}

