/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ViewerExpansions {
    DisplayModel displayModel = null;
    LinkedList expansions = null;

    public ViewerExpansions(DisplayNode displayNode) {
        if (displayNode == null || displayNode.getDisplayModel() == null) {
            return;
        }
        this.displayModel = displayNode.getDisplayModel();
        if (this.displayModel.getViewersCount() == 0) {
            return;
        }
        TreePath path = new TreePath(this.displayModel.getPathToRoot(displayNode));
        this.expansions = new LinkedList();
        JTree[] trees = this.displayModel.getViewers();
        for (int i = 0; i < trees.length; ++i) {
            Enumeration<TreePath> enumeration = trees[i].getExpandedDescendants(path);
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                this.expansions.add(new Expansion(trees[i], enumeration.nextElement()));
            }
        }
    }

    public void applyExpansions() {
        if (this.expansions == null) {
            return;
        }
        Iterator iter = this.expansions.iterator();
        while (iter.hasNext()) {
            ((Expansion)iter.next()).applyExpansion();
        }
    }

    public class Expansion {
        JTree viewer;
        TreePath path;

        public Expansion(JTree viewer, TreePath path) {
            this.viewer = viewer;
            this.path = path;
        }

        public void applyExpansion() {
            this.viewer.expandPath(this.path);
        }
    }
}

