/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;

public class Validator {
    public static boolean logging = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(String prefixArg, WhiteboardContext context) {
        boolean valid = true;
        String prefix = prefixArg;
        boolean prefixEmitted = false;
        Debug.lockEnter(null, (String)"Validator.validate", (String)"DataModel", (Object)context.getDataModel());
        try {
            DataModel dataModel = context.getDataModel();
            synchronized (dataModel) {
                Object obj;
                Iterator iter;
                if (logging) {
                    iter = context.getDataModel().getRoot().iterateScreens();
                    while (iter.hasNext()) {
                        obj = iter.next();
                        if (obj instanceof ScreenRoot) {
                            valid &= ((ScreenRoot)obj).validate();
                            continue;
                        }
                        Validator.log("ScreenGroup child is not a ScreenRoot: " + WBUtils.objectName(obj));
                        valid = Validator.setValid(valid, false);
                    }
                }
                valid &= context.getDataExporter().validate();
                if (context.getDataModel().getDisplayModel() != null) {
                    valid &= context.getDataModel().getDisplayModel().validate();
                }
                boolean oldLogging = logging;
                logging = true;
                StringBuffer buf = new StringBuffer();
                buf.append(context.toString());
                iter = context.getDataModel().getRoot().iterateScreens();
                while (iter.hasNext()) {
                    obj = iter.next();
                    if (!(obj instanceof ScreenRoot)) continue;
                    buf.append(((ScreenRoot)obj).display(Validator.getParticipant(context) + " - "));
                }
                buf.append(context.getDataExporter().exportStatus());
                buf.append(context.getMediaCache().toString());
                buf.append(context.getACLManager().toString());
                buf.append(context.getIDProcessor().toString());
                buf.append("\n ObjectMap: \n" + context.getObjectManager().toString());
                if (buf.length() > 0) {
                    Validator.log(buf.toString());
                }
                logging = oldLogging;
            }
        }
        catch (Exception ex) {
            LogSupport.exception(Validator.class, (String)"validate", (Throwable)ex, (boolean)true);
        }
        Debug.lockLeave(null, (String)"Validator.validate", (String)"DataModel", (Object)context.getDataModel());
        if (!valid) {
            Thread.dumpStack();
        }
        return valid;
    }

    public void enableLogging(boolean loggingArg) {
        logging = loggingArg;
    }

    public static boolean setValid(boolean valid, boolean newValid) {
        if (!newValid) {
            Thread.dumpStack();
        }
        return valid & newValid;
    }

    public static void logAlways(String msg) {
        LogSupport.message((String)msg);
    }

    public static void log(String msg) {
        if (!logging) {
            return;
        }
        Validator.logAlways(msg);
    }

    public static String getParticipant(WhiteboardContext context) {
        return context == null || context.getClientList() == null ? "Offline" : context.getClientList().getMyName();
    }
}

