/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.dataModel.GeometryUtils;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.util.Debug;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ToolSelectionEntry {
    public static final int SELECTION_LINE_WIDTH = 1;
    private static Rectangle visibleSelectionArea = new Rectangle();
    private static Rectangle drawingRectangle = new Rectangle();
    private static Rectangle screenRectangle = new Rectangle();
    private static Rectangle paintRectangle = new Rectangle();
    static Cursor[] cursors;
    static final int HIT_BOX_SIZE = 4;
    static final int SELECTION_BOX_OVERSIZE = 2;
    public static final int EXTERIOR = -1;
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_MIDDLE = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int MIDDLE_LEFT = 3;
    public static final int MIDDLE_RIGHT = 4;
    public static final int LOWER_LEFT = 5;
    public static final int LOWER_MIDDLE = 6;
    public static final int LOWER_RIGHT = 7;
    public static final int IN_BOUNDARY = 8;
    public static final int INTERIOR = 9;
    public static final int TOP_EDGE = 10;
    public static final int LEFT_EDGE = 11;
    public static final int RIGHT_EDGE = 12;
    public static final int BOTTOM_EDGE = 13;
    static final int DESIRED_DASH_LENGTH = 7;
    public static final int[] NORMAL_TABLE;
    public static final int[] VERT_FLIP_TABLE;
    public static final int[] HORZ_FLIP_TABLE;
    public static final int[] BOTH_FLIP_TABLE;

    public static Rectangle calculateRectangle(AbstractToolModel tool, Rectangle area) {
        Rectangle visibleArea = area == null ? new Rectangle() : area;
        int x = tool.getVBounds().x;
        int y = tool.getVBounds().y;
        int width = tool.getVBounds().width;
        int height = tool.getVBounds().height;
        visibleArea.x = x - 4 - 1;
        visibleArea.y = y - 4 - 1;
        visibleArea.width = width + 8 + 2;
        visibleArea.height = height + 8 + 2;
        return visibleArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintSelectionRect(Graphics g, AbstractToolModel tool) {
        Debug.lockEnter(null, (String)"ToolSelectionEntry.paintSelectionRect", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
        Rectangle rectangle = visibleSelectionArea;
        synchronized (rectangle) {
            paintRectangle.setBounds(0, 0, 4, 4);
            Dimension screenSize = tool.getContext().getController().getScreen().getScreenSize();
            screenRectangle.setBounds(0, 0, screenSize.width, screenSize.height);
            try {
                if (tool.getVBounds().x <= g.getClipBounds().x && tool.getVBounds().y <= g.getClipBounds().y && tool.getVBounds().x + tool.getVBounds().width >= g.getClipBounds().x + g.getClipBounds().width && tool.getVBounds().y + tool.getVBounds().height >= g.getClipBounds().y + g.getClipBounds().height) {
                    return;
                }
                ToolSelectionEntry.calculateRectangle(tool, visibleSelectionArea);
                if (GeometryUtils.intersects(g.getClipBounds(), visibleSelectionArea)) {
                    Color selectionRectColor = tool.getSelectionRectangleColor();
                    g.setColor(selectionRectColor);
                    if (tool instanceof GroupToolModel) {
                        ToolSelectionEntry.paintDragOutline(g, visibleSelectionArea);
                    } else {
                        g.drawRect(ToolSelectionEntry.visibleSelectionArea.x + 2, ToolSelectionEntry.visibleSelectionArea.y + 2, ToolSelectionEntry.visibleSelectionArea.width - 4, ToolSelectionEntry.visibleSelectionArea.height - 4);
                    }
                    for (int hitType = 0; hitType <= 7; ++hitType) {
                        ToolSelectionEntry.calculateHitBox(hitType, paintRectangle);
                        if (!GeometryUtils.intersects(paintRectangle, screenRectangle)) continue;
                        g.setColor(Color.white);
                        g.fillRect(ToolSelectionEntry.paintRectangle.x, ToolSelectionEntry.paintRectangle.y, 4, 4);
                        g.setColor(Color.black);
                        g.drawRect(ToolSelectionEntry.paintRectangle.x, ToolSelectionEntry.paintRectangle.y, 4, 4);
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Debug.lockLeave(null, (String)"ToolSelectionentry.paintSelectionRect", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
    }

    private static void calculateHitBox(int hitType, Rectangle rectangle) {
        switch (hitType) {
            case 0: 
            case 3: 
            case 5: {
                rectangle.x = ToolSelectionEntry.visibleSelectionArea.x;
                break;
            }
            case 1: 
            case 6: {
                rectangle.x = ToolSelectionEntry.visibleSelectionArea.x - 2 + ToolSelectionEntry.visibleSelectionArea.width / 2;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                rectangle.x = ToolSelectionEntry.visibleSelectionArea.x - 4 + ToolSelectionEntry.visibleSelectionArea.width;
                break;
            }
        }
        switch (hitType) {
            case 0: 
            case 1: 
            case 2: {
                rectangle.y = ToolSelectionEntry.visibleSelectionArea.y;
                break;
            }
            case 3: 
            case 4: {
                rectangle.y = ToolSelectionEntry.visibleSelectionArea.y - 2 + ToolSelectionEntry.visibleSelectionArea.height / 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                rectangle.y = ToolSelectionEntry.visibleSelectionArea.y - 4 + ToolSelectionEntry.visibleSelectionArea.height;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int getHitType(Point point, AbstractToolModel tool) {
        block35: {
            int n;
            Debug.lockEnter(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
            try {
                Rectangle rectangle = visibleSelectionArea;
                // MONITORENTER : rectangle
                ToolSelectionEntry.calculateRectangle(tool, visibleSelectionArea);
                if (point.x >= ToolSelectionEntry.visibleSelectionArea.x && point.y >= ToolSelectionEntry.visibleSelectionArea.y && point.x <= ToolSelectionEntry.visibleSelectionArea.x + ToolSelectionEntry.visibleSelectionArea.width && point.y <= ToolSelectionEntry.visibleSelectionArea.y + ToolSelectionEntry.visibleSelectionArea.height) break block35;
                n = -1;
                // MONITOREXIT : rectangle
            }
            catch (Throwable throwable) {
                Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                throw throwable;
            }
            Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
            return n;
        }
        if (point.x > ToolSelectionEntry.visibleSelectionArea.x + 4 && point.y > ToolSelectionEntry.visibleSelectionArea.y + 4 && point.x < ToolSelectionEntry.visibleSelectionArea.x + ToolSelectionEntry.visibleSelectionArea.width - 4 && point.y < ToolSelectionEntry.visibleSelectionArea.y + ToolSelectionEntry.visibleSelectionArea.height - 4) {
            int n = tool.wantsMouse(null) ? 9 : 8;
            // MONITOREXIT : rectangle
            Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
            return n;
        }
        if (tool.canSizeTool()) {
            if (point.x < ToolSelectionEntry.visibleSelectionArea.x + 4) {
                if (point.y < ToolSelectionEntry.visibleSelectionArea.y + 4) {
                    int n = 0;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                if (point.y > ToolSelectionEntry.visibleSelectionArea.y - 4 + ToolSelectionEntry.visibleSelectionArea.height) {
                    int n = 5;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                if (point.y > ToolSelectionEntry.visibleSelectionArea.y - 2 + ToolSelectionEntry.visibleSelectionArea.height / 2 && point.y < ToolSelectionEntry.visibleSelectionArea.y + 2 + ToolSelectionEntry.visibleSelectionArea.height / 2) {
                    int n = 3;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                int n = 11;
                // MONITOREXIT : rectangle
                Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                return n;
            }
            if (point.y < ToolSelectionEntry.visibleSelectionArea.y + 4) {
                if (point.x > ToolSelectionEntry.visibleSelectionArea.x - 2 + ToolSelectionEntry.visibleSelectionArea.width / 2 && point.x < ToolSelectionEntry.visibleSelectionArea.x + 2 + ToolSelectionEntry.visibleSelectionArea.width / 2) {
                    int n = 1;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                if (point.x > ToolSelectionEntry.visibleSelectionArea.x - 4 + ToolSelectionEntry.visibleSelectionArea.width) {
                    int n = 2;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                int n = 10;
                // MONITOREXIT : rectangle
                Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                return n;
            }
            if (point.x > ToolSelectionEntry.visibleSelectionArea.x - 4 + ToolSelectionEntry.visibleSelectionArea.width) {
                if (point.y > ToolSelectionEntry.visibleSelectionArea.y - 4 + ToolSelectionEntry.visibleSelectionArea.height / 2 && point.y < ToolSelectionEntry.visibleSelectionArea.y + 4 + ToolSelectionEntry.visibleSelectionArea.height / 2) {
                    int n = 4;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                if (point.y > ToolSelectionEntry.visibleSelectionArea.y - 4 + ToolSelectionEntry.visibleSelectionArea.height) {
                    int n = 7;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                int n = 12;
                // MONITOREXIT : rectangle
                Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                return n;
            }
            if (point.y > ToolSelectionEntry.visibleSelectionArea.y - 4 + ToolSelectionEntry.visibleSelectionArea.height) {
                if (point.x > ToolSelectionEntry.visibleSelectionArea.x - 4 + ToolSelectionEntry.visibleSelectionArea.width / 2 && point.x < ToolSelectionEntry.visibleSelectionArea.x + 4 + ToolSelectionEntry.visibleSelectionArea.width / 2) {
                    int n = 6;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                if (point.x > ToolSelectionEntry.visibleSelectionArea.x - 4 + ToolSelectionEntry.visibleSelectionArea.width) {
                    int n = 7;
                    // MONITOREXIT : rectangle
                    Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                    return n;
                }
                int n = 13;
                // MONITOREXIT : rectangle
                Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
                return n;
            }
        }
        int n = 8;
        // MONITOREXIT : rectangle
        Debug.lockLeave(null, (String)"ToolSelectionEntry.getHitType", (String)"visibleSelectionArea", (Object)visibleSelectionArea);
        return n;
    }

    public static Cursor getCursor(int hitType, AbstractToolModel tool) {
        if (hitType == 9 && tool.wantsMouse(null) && tool.getCursor() != null) {
            return tool.getCursor();
        }
        if (hitType < 0 || hitType > 13) {
            return Cursor.getDefaultCursor();
        }
        return cursors[hitType];
    }

    public static void paintDragOutline(Graphics g, Rectangle rectangle) {
        int dashStart;
        int i;
        float dashLength;
        int x1 = rectangle.x;
        int y1 = rectangle.y;
        int width = rectangle.width;
        int height = rectangle.height;
        int dashes = width / 7;
        if (dashes < 2) {
            g.drawLine(x1, y1, width + x1, y1);
            g.drawLine(x1, height + y1, width + x1, height + y1);
        } else {
            if (dashes % 2 == 0) {
                ++dashes;
            }
            dashLength = (float)width / (float)dashes;
            for (i = 0; i < dashes; i += 2) {
                dashStart = (int)(dashLength * (float)i) + x1;
                g.drawLine(dashStart, y1, (int)(dashLength + (float)dashStart), y1);
                g.drawLine(dashStart, height + y1, (int)(dashLength + (float)dashStart), height + y1);
            }
        }
        dashes = height / 7;
        if (dashes < 2) {
            g.drawLine(x1, y1, x1, height + y1);
            g.drawLine(width + x1, y1, width + x1, height + y1);
        } else {
            if (dashes % 2 == 0) {
                ++dashes;
            }
            dashLength = (float)height / (float)dashes;
            for (i = 0; i < dashes; i += 2) {
                dashStart = (int)(dashLength * (float)i) + y1;
                g.drawLine(x1, dashStart, x1, (int)(dashLength + (float)dashStart));
                g.drawLine(width + x1, dashStart, width + x1, (int)(dashLength + (float)dashStart));
            }
        }
    }

    static {
        NORMAL_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        VERT_FLIP_TABLE = new int[]{5, 6, 7, 3, 4, 0, 1, 2, 8, 9, 13, 11, 12, 10};
        HORZ_FLIP_TABLE = new int[]{2, 1, 0, 4, 3, 7, 6, 5, 8, 9, 10, 12, 11, 13};
        BOTH_FLIP_TABLE = new int[]{7, 6, 5, 4, 3, 2, 1, 0, 8, 9, 13, 12, 11, 10};
        cursors = new Cursor[14];
        ToolSelectionEntry.cursors[0] = Cursor.getPredefinedCursor(6);
        ToolSelectionEntry.cursors[1] = Cursor.getPredefinedCursor(8);
        ToolSelectionEntry.cursors[2] = Cursor.getPredefinedCursor(7);
        ToolSelectionEntry.cursors[3] = Cursor.getPredefinedCursor(10);
        ToolSelectionEntry.cursors[4] = Cursor.getPredefinedCursor(11);
        ToolSelectionEntry.cursors[5] = Cursor.getPredefinedCursor(4);
        ToolSelectionEntry.cursors[6] = Cursor.getPredefinedCursor(9);
        ToolSelectionEntry.cursors[7] = Cursor.getPredefinedCursor(5);
        ToolSelectionEntry.cursors[8] = Cursor.getPredefinedCursor(13);
        ToolSelectionEntry.cursors[9] = Cursor.getPredefinedCursor(12);
        ToolSelectionEntry.cursors[10] = Cursor.getPredefinedCursor(8);
        ToolSelectionEntry.cursors[11] = Cursor.getPredefinedCursor(10);
        ToolSelectionEntry.cursors[12] = Cursor.getPredefinedCursor(11);
        ToolSelectionEntry.cursors[13] = Cursor.getPredefinedCursor(9);
    }
}

