/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectionManager {
    private WhiteboardContext context;
    private ScreenModel screen;
    private ArrayList selectedTools = WhiteboardContext.EMPTY_ARRAYLIST;

    public SelectionManager(WhiteboardContext context, ScreenModel screen) {
        this.context = context;
        this.screen = screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSelectedToolList() {
        ArrayList arrayList = this.selectedTools;
        synchronized (arrayList) {
            if (this.selectedTools == WhiteboardContext.EMPTY_ARRAYLIST) {
                this.selectedTools = new ArrayList();
            }
            return this.selectedTools;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ArrayList arrayList = this.selectedTools;
        synchronized (arrayList) {
            return this.selectedTools.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(AbstractToolModel tool) {
        ArrayList arrayList = this.selectedTools;
        synchronized (arrayList) {
            return this.selectedTools.contains(tool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedToolCount() {
        ArrayList arrayList = this.selectedTools;
        synchronized (arrayList) {
            return this.selectedTools.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        ArrayList arrayList = this.selectedTools;
        synchronized (arrayList) {
            return this.selectedTools.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectTool(AbstractToolModel tool) {
        Object object = this.selectedTools;
        synchronized (object) {
            if (this.selectedTools == WhiteboardContext.EMPTY_ARRAYLIST) {
                this.selectedTools = new ArrayList();
            }
            if (this.selectedTools.contains(tool)) {
                return true;
            }
        }
        object = this.context.getDataModel();
        synchronized (object) {
            WBNode parent;
            Object[] tools;
            ArrayList arrayList = this.selectedTools;
            synchronized (arrayList) {
                tools = this.selectedTools.toArray();
            }
            if (tool instanceof GroupToolModel) {
                for (int i = tools.length - 1; i >= 0; --i) {
                    parent = ((WBNode)tools[i]).getBoardParent();
                    if (!(parent instanceof GroupToolModel)) continue;
                    while (parent instanceof GroupToolModel) {
                        if (parent == tool) {
                            this.deSelectTool((AbstractToolModel)tools[i]);
                        }
                        parent = parent.getBoardParent();
                    }
                }
            }
            parent = tool.getBoardParent();
            while (parent instanceof GroupToolModel) {
                this.deSelectTool((GroupToolModel)parent);
                parent = parent.getBoardParent();
            }
            ArrayList arrayList2 = this.selectedTools;
            synchronized (arrayList2) {
                this.selectedTools.add(tool);
                tool.setSelected(true);
            }
            this.screen.notifySelectionChange(tool, true);
            this.context.fireSelection(tool, true);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deSelectTool(AbstractToolModel tool) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean deselected;
            ArrayList arrayList = this.selectedTools;
            synchronized (arrayList) {
                deselected = this.selectedTools.remove(tool);
            }
            if (deselected) {
                tool.setSelected(false);
                this.screen.notifySelectionChange(tool, false);
                this.context.fireSelection(tool, false);
            }
            return deselected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deSelectAllTools() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            int limit;
            ArrayList arrayList = this.selectedTools;
            synchronized (arrayList) {
                limit = this.selectedTools.size();
            }
            if (limit > 0) {
                Object[] tools;
                ArrayList arrayList2 = this.selectedTools;
                synchronized (arrayList2) {
                    tools = this.selectedTools.toArray();
                }
                for (int i = 0; i < tools.length; ++i) {
                    if (!(tools[i] instanceof AbstractToolModel)) continue;
                    this.deSelectTool((AbstractToolModel)tools[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAllTools(boolean selectInBackground) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Object[] tools = this.screen.toolList.toArray();
            for (int i = 0; i < tools.length; ++i) {
                if (!(tools[i] instanceof AbstractToolModel) || !((AbstractToolModel)tools[i]).isSelectable() || (!this.context.isChair() || !selectInBackground) && ((AbstractToolModel)tools[i]).isInBackground()) continue;
                this.selectTool((AbstractToolModel)tools[i]);
            }
        }
    }
}

