/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.ScreenName;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.StringsProperties;
import com.elluminate.groupware.whiteboard.dataModel.ViewerExpansions;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class ScreenRoot
extends ScreenModel
implements Cloneable {
    static I18n i18n = I18n.create((Object)new Object(){});
    short groupId = 0;
    short nextScreenSequence = 1;
    private static Icon SCREEN_GROUP_ICON;
    private static Icon SCREEN_ROOT_ICON;
    private Icon screenGroupSmallIcon;

    public ScreenRoot(WhiteboardContext context) {
        this(context, "ScreenRoot");
    }

    public ScreenRoot(String screenName, WhiteboardContext context) {
        this(context);
        this.setScreenNameLocal(screenName, false);
    }

    public ScreenRoot(WhiteboardContext context, String templateName) {
        super(context, templateName);
        this.registerIfClass("ScreenRoot");
        this.setScreenSize(0, 0);
        this.setRootACLs();
        this.icon = null;
        try {
            this.smallIcon = i18n.getIcon((PropertiesEnum)StringsProperties.SCREENROOT_SMALLICON);
            this.screenGroupSmallIcon = i18n.getIcon((PropertiesEnum)StringsProperties.SCREENROOT_SCREENGROUPSMALLICON);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setRootACLs() {
        this.setScreenACLs();
        this.deleteACL.addAcceptEntry(ACLTerm.CHAIR_ENTRY);
        this.accessibleACL.addDenyEntry(ACLTerm.NOT_ACCESSIBLE_ENTRY);
        this.accessibleACL.addDenyEntry(ACLTerm.RECORDER_ENTRY);
    }

    public ScreenRoot(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ScreenRoot", (Throwable)e, (boolean)true);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ScreenRoot screenRoot = (ScreenRoot)super.clone();
        screenRoot.registerIfClass("ScreenRoot");
        return screenRoot;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
    }

    @Override
    public boolean isEditable() {
        boolean edit = super.isEditable();
        if (edit) {
            return edit;
        }
        return super.canDelete();
    }

    @Override
    public void setScreenSize(Dimension size) {
        this.setScreenSize(0, 0);
    }

    @Override
    public void setScreenSize(int width, int height) {
        super.setScreenSize(0, 0);
    }

    @Override
    public ScreenModel getScreenDelegate() {
        if (this.getChildCount() == 0) {
            return this;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!(this.getChildAt(i) instanceof ScreenModel)) continue;
            return (ScreenModel)this.getChildAt(i);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenName(String name) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean oldPeer;
            boolean bl = oldPeer = this.getDisplayPeer() != null;
            if (!oldPeer && name.equals(this.getScreenName())) {
                return;
            }
            super.setScreenName(name);
            if (oldPeer) {
                this.createPeer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAttributeChange(AbstractAttribute attribute) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            super.onAttributeChange(attribute);
            if (attribute instanceof ScreenName && this.getDisplayPeer() != null) {
                this.createPeer();
            }
        }
    }

    public int getNextScreenSequence() {
        short s = this.nextScreenSequence;
        this.nextScreenSequence = (short)(s + 1);
        return s;
    }

    @Override
    public void createPeer() {
        ViewerExpansions expansions = null;
        if (this.getParent() == null) {
            return;
        }
        DisplayNode parentPeer = this.getParent().getDisplayPeer();
        if (parentPeer != null && (this.isVisible() || this.canSetAccess())) {
            DisplayModel displayModel = parentPeer.getDisplayModel();
            if (this.getDisplayPeer() == null) {
                this.setDisplayPeer(new DisplayNode(this));
            }
            expansions = new ViewerExpansions(this.getDisplayPeer());
            this.insertGroupInDisplay(displayModel);
            this.createChildPeers(this.iterateScreens());
            if (expansions != null) {
                expansions.applyExpansions();
            }
        }
    }

    void insertGroupInDisplay(DisplayModel displayModel) {
        if (displayModel != null) {
            int oldIndex;
            int insertIndex = 0;
            Enumeration<TreeNode> enumeration = displayModel.getDisplayRoot().children();
            while (enumeration.hasMoreElements()) {
                DisplayNode testNode = (DisplayNode)enumeration.nextElement();
                ScreenRoot testScreen = (ScreenRoot)testNode.getUserObject();
                if (testScreen == this) continue;
                int compare = this.compareTo(testScreen);
                if (compare <= 0) break;
                ++insertIndex;
            }
            boolean parented = this.getDisplayPeer().getParent() != null;
            int n = oldIndex = !parented ? Integer.MAX_VALUE : this.getDisplayPeer().getParent().getIndex(this.getDisplayPeer());
            if (parented && insertIndex != oldIndex) {
                displayModel.removeNodeFromParent(this.getDisplayPeer());
            } else if (parented) {
                return;
            }
            displayModel.insertNodeInto(this.getDisplayPeer(), displayModel.getDisplayRoot(), insertIndex);
        }
    }

    @Override
    public Icon getIcon() {
        if (!this.context.isShowThumbnails()) {
            return this.getSmallIcon();
        }
        this.icon = this.getGroupID() == 0 ? SCREEN_ROOT_ICON : SCREEN_GROUP_ICON;
        return this.icon;
    }

    @Override
    public Icon getSmallIcon() {
        this.icon = this.getGroupID() == 0 ? this.smallIcon : this.screenGroupSmallIcon;
        return this.icon;
    }

    public static Icon getStaticIcon() {
        return SCREEN_ROOT_ICON;
    }

    @Override
    public String getDisplayName() {
        return this.getScreenName();
    }

    @Override
    public short getGroupID() {
        return this.groupId;
    }

    public void setGroupID(short groupId) {
        this.groupId = groupId;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeShort(this.groupId);
        ostr.writeShort(this.nextScreenSequence);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.groupId = WBUtils.readShort(istr, "ScreenRoot reads GroupId");
        this.nextScreenSequence = WBUtils.readShort(istr, "ScreenRoot reads nextScreenSequence");
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            short groupId = WBUtils.readShort(istr, "ScreenRoot reads GroupId");
            this.nextScreenSequence = WBUtils.readShort(istr, "ScreenRoot reads nextScreenSequence");
            buf.append("  GroupId: " + groupId + ", nextScreenSequence: " + this.nextScreenSequence);
        }
        catch (Exception ex) {
            buf.append("Exception reading groupId: " + ex.getMessage());
        }
        return buf.toString();
    }

    @Override
    public boolean validate() {
        return super.validate();
    }

    public void setNextScreenSequence(short publicPageCount) {
        this.nextScreenSequence = publicPageCount;
    }

    static {
        try {
            SCREEN_GROUP_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.SCREENROOT_SCREENGROUPICON);
        }
        catch (Throwable ignored) {
            SCREEN_GROUP_ICON = null;
        }
        try {
            SCREEN_ROOT_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.SCREENROOT_ICON);
        }
        catch (Throwable ignored) {
            SCREEN_ROOT_ICON = null;
        }
    }
}

