/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.attributes.AltText;
import com.elluminate.groupware.whiteboard.attributes.PresentersNote;
import com.elluminate.groupware.whiteboard.attributes.ScreenName;
import com.elluminate.groupware.whiteboard.attributes.ScreenSize;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ACLChangeListener;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.GeometryUtils;
import com.elluminate.groupware.whiteboard.dataModel.ImageWriterGraphics;
import com.elluminate.groupware.whiteboard.dataModel.NodeList;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenChangeEvent;
import com.elluminate.groupware.whiteboard.dataModel.ScreenResolver;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.SelectionManager;
import com.elluminate.groupware.whiteboard.dataModel.StringsProperties;
import com.elluminate.groupware.whiteboard.dataModel.ThumbnailResolver;
import com.elluminate.groupware.whiteboard.dataModel.ToolSelectionEntry;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeContainer;
import com.elluminate.groupware.whiteboard.dataModel.WBNodeProxy;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.interfaces.VisibleNotifyObject;
import com.elluminate.groupware.whiteboard.interfaces.VisibleObject;
import com.elluminate.groupware.whiteboard.interfaces.WBNodeInterface;
import com.elluminate.groupware.whiteboard.listeners.ScreenChangeListener;
import com.elluminate.groupware.whiteboard.listeners.VisibleAttributeChangeListener;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Content;

public class ScreenModel
extends WBNode
implements ACLList,
Cloneable,
Comparable,
ScreenResolver,
WBNodeContainer,
VisibleAttributeChangeListener,
VisibleNotifyObject {
    private static I18n i18n = I18n.create((Object)new Object(){});
    public static final String VISIBLE_ACL = "visible";
    public static final String DISTRIBUTION_ACL = "disribution";
    public static final String SET_ACCESS_ACL = "set access";
    public static final String CREATE_ACL = "create";
    public static final String DELETE_ACL = "delete";
    public static final String COPY_ACL = "copy";
    public static final String SAVE_ACL = "save";
    public static final String PRINT_ACL = "print";
    public static final String DELETE_OTHERS_TOOLS_ACL = "delete others' tools";
    public static final String ACCESS_TOOLS_ACL = "access tools";
    public static final String DELETE_OWN_TOOLS_ACL = "delete own tools";
    public static final String EDIT_BACKGROUND_ACL = "edit background";
    public static final String ACCESSIBLE_ACL = "accessible";
    private static final String WBD_NAME = "Screen";
    private static final int SLOP_WIDTH = 4;
    private static final int SLOP_HEIGHT = 4;
    private static final long THUMBNAIL_QUALITY_TIME = 300L;
    private static Icon SCREEN_MODEL_ICON;
    private static final int THUMBNAIL_REPAINT_EXCEPTION_LIMIT = 10;
    private ScreenName screenName = null;
    private ScreenSize screenSize = null;
    private PresentersNote presentersNotes = null;
    private AltText altText = null;
    private Short[] distributionList = new Short[]{ShortList.get((short)0)};
    private boolean evaluateDistributionList = true;
    private LinkedList screenChangeListeners = new LinkedList();
    private DisplayModel displayModel = null;
    private SelectionManager selectionManager;
    private LinkedList selectionListeners = new LinkedList();
    protected Icon icon = null;
    protected ACLTerm accessibleACL = null;
    protected ACLTerm copyACL = null;
    protected ACLTerm createACL = null;
    protected ACLTerm accessToolsACL = null;
    protected ACLTerm deleteACL = null;
    protected ACLTerm deleteOthersToolsACL = null;
    protected ACLTerm deleteOwnToolsACL = null;
    protected ACLTerm distributionACL = null;
    protected ACLTerm editBackgroundACL = null;
    protected ACLTerm printACL = null;
    protected ACLTerm saveACL = null;
    protected ACLTerm setAccessACL = null;
    protected ACLTerm visibleACL = null;
    private LinkedList aclChangeListeners = new LinkedList();
    private boolean editable = true;
    private boolean deletable = true;
    private boolean privateFlag = true;
    private double pasteOffset = 0.0;
    private int pasteGeneration = 0;
    private int backgroundCount = 0;
    private int foregroundCount = 0;
    private SoftReference<BufferedImage> screenImageRef = null;
    private long lastThumbnailTime = 0L;
    private ThumbnailIcon thumbnailIcon = null;
    private Color thumbnailBorderColor = null;
    private LightweightTimer delayedThumbnailIconTimer = null;
    private int lastThumbnailQuality = -1;
    protected Icon smallIcon = null;

    public ScreenModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public ScreenModel(WhiteboardContext context, String templateName) {
        super(context);
        this.setAsTool(false);
        this.nodeIsContainer = true;
        this.screenName = new ScreenName(context);
        this.screenSize = new ScreenSize(context, true);
        this.presentersNotes = new PresentersNote(context);
        this.altText = new AltText(context);
        this.toolList = new NodeList((WBNode)this, 0);
        this.childList = this.screenList = new NodeList((WBNode)this, 0);
        this.setName(templateName);
        this.setACLs();
        this.selectionManager = new SelectionManager(context, this);
        this.screenSize.setSize(1014, 835);
        this.registerIfClass("ScreenModel");
        this.distributionACL.setDenySelf(true);
        this.autoDeleteChildren = true;
        this.icon = null;
        try {
            this.smallIcon = i18n.getIcon((PropertiesEnum)StringsProperties.SCREENMODEL_SMALLICON);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ScreenModel(String screenName, WhiteboardContext context) {
        this(context);
        this.screenName.setOriginator();
        this.screenName.setScreenName(screenName);
    }

    public ScreenModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ScreenModel", (Throwable)e, (boolean)true);
        }
    }

    public ScreenModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ScreenModel", (Throwable)e, (boolean)true);
        }
    }

    public ScreenModel(WhiteboardContext context, ScreenName screenName) {
        this(context);
        this.screenName.merge(screenName);
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        DisplayModel displayModel = this.displayModel;
        this.displayModel = null;
        LinkedList oldScreenChangeListeners = this.screenChangeListeners;
        this.screenChangeListeners = new LinkedList();
        ScreenModel screenModel = (ScreenModel)super.clone();
        this.screenChangeListeners = oldScreenChangeListeners;
        this.displayModel = displayModel;
        screenModel.screenName = (ScreenName)this.screenName.clone();
        screenModel.screenSize = (ScreenSize)this.screenSize.clone();
        screenModel.reEvaluateACLs();
        screenModel.presentersNotes = (PresentersNote)this.presentersNotes.clone();
        screenModel.altText = (AltText)this.altText.clone();
        screenModel.displayModel = null;
        screenModel.selectionManager = new SelectionManager(this.context, screenModel);
        screenModel.registerIfClass("ScreenModel");
        screenModel.setOriginator();
        screenModel.cloneACLs(this);
        screenModel.pasteOffset = 0.0;
        screenModel.delayedThumbnailIconTimer = null;
        screenModel.lastThumbnailQuality = 0;
        screenModel.icon = null;
        screenModel.thumbnailIcon = null;
        return screenModel;
    }

    public synchronized ScreenModel proxySelectedTools() {
        try {
            ScreenModel proxy = new ScreenModel(this.getName(), this.context);
            proxy.setScreenNameLocal(this.getScreenName(), this.screenName.isASystemGeneratedScreenName());
            proxy.setScreenSize(this.getScreenSize());
            this.context.getObjectManager().setObjectInMap(proxy);
            proxy.toolList.addAll((Collection)this.getSelectedToolList());
            ACLTerm saveACL = proxy.getACLTerm(SAVE_ACL);
            saveACL.clearAll();
            saveACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, null, ACLEntry.ALL_ROLES));
            return proxy;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"proxySelectedTools()", (Throwable)ex, (boolean)true);
            return null;
        }
    }

    protected void registerIfClass(String currentClass) {
        if (this.getClass().getName().endsWith(currentClass)) {
            this.registerAttributes();
        }
    }

    public void setScreenACLs() {
        this.reEvaluateACLs();
    }

    protected void registerAttributes() {
        this.setContext(this.context);
        this.addAttribute(this.screenSize);
        this.addAttribute(this.screenName);
        this.addAttribute(this.presentersNotes);
        this.addAttribute(this.altText);
    }

    private void setACLs() {
        this.accessibleACL = new ACLTerm(ACCESSIBLE_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyAccessibleACL(state);
            }
        };
        this.copyACL = new ACLTerm(COPY_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyCopyACL(state);
            }
        };
        this.createACL = new ACLTerm(CREATE_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyCreateACL(state);
            }
        };
        this.deleteACL = new ACLTerm(DELETE_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyDeleteACL(state);
            }
        };
        this.accessToolsACL = new ACLTerm(ACCESS_TOOLS_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyDeleteOthersToolsACL(state);
            }
        };
        this.deleteOthersToolsACL = new ACLTerm(DELETE_OTHERS_TOOLS_ACL, this, this.context, false){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyDeleteOthersToolsACL(state);
            }
        };
        this.deleteOwnToolsACL = new ACLTerm(DELETE_OWN_TOOLS_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyDeleteOwnToolsACL(state);
            }
        };
        this.distributionACL = new ACLTerm(DISTRIBUTION_ACL, this, this.context, false){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyDistributionACL(state);
            }
        };
        this.editBackgroundACL = new ACLTerm(EDIT_BACKGROUND_ACL, this, this.context, false){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyEditBackgroundACL(state);
            }
        };
        this.printACL = new ACLTerm(PRINT_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyPrintACL(state);
            }
        };
        this.saveACL = new ACLTerm(SAVE_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifySaveACL(state);
            }
        };
        this.setAccessACL = new ACLTerm(SET_ACCESS_ACL, this, this.context, false){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifySetAccessACL(state);
            }
        };
        this.visibleACL = new ACLTerm(VISIBLE_ACL, this, this.context, true){

            @Override
            public void notifyACLChange(Boolean state) {
                ScreenModel.this.notifyVisibleACL(state);
            }
        };
    }

    private void cloneACLs(ScreenModel oldScreen) {
        this.setACLs();
        this.accessibleACL.setTerm(oldScreen.accessibleACL);
        this.copyACL.setTerm(oldScreen.copyACL);
        this.createACL.setTerm(oldScreen.createACL);
        this.accessToolsACL.setTerm(oldScreen.accessToolsACL);
        this.deleteACL.setTerm(oldScreen.deleteACL);
        this.deleteOthersToolsACL.setTerm(oldScreen.deleteOthersToolsACL);
        this.deleteOwnToolsACL.setTerm(oldScreen.deleteOwnToolsACL);
        this.distributionACL.setTerm(oldScreen.distributionACL);
        this.editBackgroundACL.setTerm(oldScreen.editBackgroundACL);
        this.printACL.setTerm(oldScreen.printACL);
        this.saveACL.setTerm(oldScreen.saveACL);
        this.setAccessACL.setTerm(oldScreen.setAccessACL);
        this.visibleACL.setTerm(oldScreen.visibleACL);
    }

    @Override
    public String toString() {
        return this.screenName.getScreenName() + ": " + super.toString();
    }

    public double getPasteOffset() {
        if (this.pasteGeneration != this.context.getToolClipboardGeneration()) {
            this.pasteOffset = 0.0;
        }
        return this.pasteOffset;
    }

    public void setPasteOffset(double pasteOffset) {
        this.pasteOffset = pasteOffset;
        this.pasteGeneration = this.context.getToolClipboardGeneration();
    }

    @Override
    public ScreenModel getScreen() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenModel getFirstScreen() {
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            for (int i = 0; i < this.screenList.size(); ++i) {
                Object object = this.screenList.get(i);
                if (!(object instanceof ScreenModel)) continue;
                return (ScreenModel)object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenModel getLastScreen() {
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            for (int i = this.screenList.size() - 1; i >= 0; --i) {
                Object object = this.screenList.get(i);
                if (!(object instanceof ScreenModel)) continue;
                return (ScreenModel)object;
            }
        }
        return null;
    }

    public int compareTo(Object other) {
        if (other instanceof ScreenModel) {
            return this.toString().compareToIgnoreCase(((ScreenModel)other).toString());
        }
        throw new ClassCastException("Cannot compare ScreenModel to: " + other);
    }

    public String getScreenName() {
        return this.screenName.getScreenName();
    }

    public ScreenName getScreenNameAttribute() {
        return this.screenName;
    }

    public void setScreenNameLocal(String name) {
        this.screenName.setOriginator();
        this.setScreenName(name);
    }

    public void setScreenNameLocal(String name, boolean isSystemGeneratedName) {
        this.screenName.setOriginator();
        if (isSystemGeneratedName) {
            this.setScreenName(name);
        } else {
            this.setScreenNameFromUi(name);
        }
        this.context.getDataModel().normalizeScreenNames(this.getRoot());
    }

    public void setScreenName(String name) {
        this.screenName.setScreenName(name);
        if (this.context.getController() != null && this.context.getController().getScreen() == this) {
            this.context.getController().screenNameChanged(this);
        }
        if (this.displayModel != null) {
            DisplayNode peer = this.displayModel.getDisplayRoot();
            peer.setUserObject(name);
            this.displayModel.nodeChanged(peer);
        }
    }

    public void setScreenNameFromUi(String name) {
        this.screenName.setASystemGeneratedScreenName(false);
        this.setScreenName(name);
    }

    public void setScreenName(String name, boolean systemGeneratedName) {
        this.screenName.setASystemGeneratedScreenName(systemGeneratedName);
        this.setScreenName(name);
    }

    public boolean getDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public boolean canCopy() {
        return this.copyACL.allows();
    }

    public boolean canCreate() {
        return this.createACL.allows();
    }

    public boolean canDelete() {
        return this.deletable && this.deleteACL.allows();
    }

    public boolean canDeleteOthersTools() {
        return this.deleteOthersToolsACL.allows();
    }

    public boolean canAccessTools() {
        return this.accessToolsACL.allows();
    }

    public boolean canDeleteOwnTools() {
        return this.deleteOwnToolsACL.allows();
    }

    public boolean canPrint() {
        return this.printACL.allows();
    }

    public boolean canSave() {
        return this.saveACL.allows() || !this.isConferenceNode();
    }

    public boolean canSetAccess() {
        return this.setAccessACL.allows();
    }

    public boolean canEditBackground() {
        return this.editBackgroundACL.allows();
    }

    public boolean canLoad() {
        return true;
    }

    public boolean isVisible() {
        return this.visibleACL.allows();
    }

    public boolean isEditable() {
        return this.editable && this.canDelete();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isPrivate() {
        if (this.getRoot() == null) {
            return this.privateFlag;
        }
        return this.getRoot().privateFlag;
    }

    public void setPrivate(boolean privateFlag) {
        this.privateFlag = privateFlag;
        this.evaluateDistributionList = true;
    }

    public PresentersNote getPresentersNotes() {
        return this.presentersNotes;
    }

    public void setPresentersNotes(List<String> presentersNotes, String slideName) {
        if (presentersNotes != null) {
            this.presentersNotes.setPresenterNotes(presentersNotes);
        }
    }

    public String getAltTextText() {
        return this.altText.getAltText();
    }

    public void setAltTextText(String theAltText) {
        this.altText.setAltText(theAltText);
    }

    public void publishPresentersNotes() {
        this.presentersNotes.submitToNotesEditor();
    }

    public Dimension getScreenSize() {
        return this.screenSize.getSize();
    }

    public void setScreenSizeLocal(Dimension size) {
        this.screenSize.setOriginator();
        this.setScreenSize(size);
    }

    public void setScreenSize(Dimension size) {
        this.setScreenSize(size.width, size.height);
    }

    public void setScreenSize(int width, int height) {
        this.screenSize.setSize(width, height);
    }

    public ScreenModel getScreenDelegate() {
        return this;
    }

    public ScreenModel getScreenGroup() {
        return this.getRoot() == null ? this : this.getRoot();
    }

    public short getGroupID() {
        Short groupId = this.context.getIDProcessor().getGroupId(this.getCreator());
        if (groupId == null) {
            return 0;
        }
        return groupId;
    }

    public Short getCreator() {
        return ShortList.get((short)ObjectUID.decodeClientId(this.getObjectID()));
    }

    public Short[] getDistribution() {
        if (this.evaluateDistributionList && this.context.isOnline()) {
            Short[] distribution = null;
            distribution = this.context.isClient() ? (this.context.isPlayback() ? WhiteboardContext.NO_CLIENTS : ((distribution = this.distributionACL.getOtherValidClients()).length > 0 ? WhiteboardContext.SERVER_CLIENT : WhiteboardContext.NO_CLIENTS)) : this.distributionACL.getOtherValidClients();
            this.evaluateDistributionList = false;
            if (this.distributionList.length != 0 || distribution.length > 0) {
                // empty if block
            }
            this.distributionList = distribution;
        }
        return this.distributionList;
    }

    public boolean canDistributeTo(short clientId) {
        Short[] distribution = this.getDistribution();
        if (distribution != null) {
            for (int i = 0; i < distribution.length; ++i) {
                if (clientId != distribution[i]) continue;
                return true;
            }
        }
        return false;
    }

    public int getBackgroundToolCount() {
        return this.backgroundCount;
    }

    public int getForegroundToolCount() {
        return this.foregroundCount;
    }

    public boolean hasBackgroundTools() {
        return this.getBackgroundToolCount() > 0;
    }

    public boolean hasForegroundTools() {
        return this.getForegroundToolCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractToolModel getFirstForegroundTool() {
        if (this.toolList != null) {
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                for (WBNode node : this.toolList) {
                    if (!(node instanceof AbstractToolModel) || node.isBackground()) continue;
                    return (AbstractToolModel)node;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractToolModel getLastForegroundTool() {
        if (this.isDeleted()) {
            // empty if block
        }
        if (this.toolList != null) {
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                for (int index = this.toolList.size() - 1; index >= 0; --index) {
                    WBNode node = (WBNode)this.toolList.get(index);
                    if (!(node instanceof AbstractToolModel) || node.isBackground()) continue;
                    return (AbstractToolModel)node;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractToolModel[] getForegroundTools() {
        ArrayList<AbstractToolModel> foregroundTools = new ArrayList<AbstractToolModel>(Math.max(16, this.foregroundCount));
        if (this.toolList != null) {
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                for (WBNode node : this.toolList) {
                    if (!(node instanceof AbstractToolModel) || node.isBackground()) continue;
                    foregroundTools.add((AbstractToolModel)node);
                }
            }
        }
        AbstractToolModel[] result = new AbstractToolModel[foregroundTools.size()];
        return foregroundTools.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZOrder(AbstractToolModel tool, int index) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                if (index < 0 || index > this.toolList.size()) {
                    throw new RuntimeException("setZorder to index out-of-range");
                }
                if (this.toolList.indexOf(tool) == index) {
                    return;
                }
                this.toolList.remove(tool);
                this.toolList.add(index, tool);
            }
            tool.notifyVisibleChange();
        }
    }

    public String getTitle() {
        return this.screenName.getScreenName();
    }

    @Override
    public void setParent(WBNode parent) {
        super.setParent(parent);
        if (parent != null) {
            this.reEvaluateACLs();
        }
    }

    @Override
    protected void reEvaluateACLs() {
        this.evaluateDistributionList = true;
        super.reEvaluateACLs();
    }

    public DisplayModel getToolTreeModel() {
        return this.displayModel;
    }

    public void setToolTreeModel(DisplayModel displayModel) {
        this.displayModel = displayModel;
    }

    @Override
    public synchronized Icon getIcon() {
        if (!this.context.isShowThumbnails()) {
            return this.getSmallIcon();
        }
        if (this.thumbnailIcon == null) {
            this.thumbnailIcon = new ThumbnailIcon();
            this.icon = this.thumbnailIcon;
        }
        if (this.delayedThumbnailIconTimer == null) {
            this.delayedThumbnailIconTimer = new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ScreenModel.this.icon = ScreenModel.this.getThumbnailIcon(ScreenModel.this.thumbnailIcon.getQuality() + 1);
                            ScreenModel.this.notifyDisplayNodeChange();
                        }
                    });
                }
            });
        }
        if (!this.delayedThumbnailIconTimer.isScheduled() && this.thumbnailIcon.getQuality() < 4) {
            switch (this.thumbnailIcon.getQuality()) {
                case 1: {
                    this.thumbnailIcon.setQuality(3);
                    this.delayedThumbnailIconTimer.scheduleIn(300L);
                    break;
                }
                case 2: {
                    this.thumbnailIcon.setQuality(3);
                    this.delayedThumbnailIconTimer.scheduleIn(300L);
                    break;
                }
                case 3: {
                    this.thumbnailIcon.setQuality(4);
                    this.delayedThumbnailIconTimer.scheduleIn(300L);
                    break;
                }
            }
        }
        if (this.icon == null) {
            this.icon = ScreenModel.getStaticIcon();
        }
        return this.icon;
    }

    public synchronized Icon getThumbnailIcon(int quality) {
        if (this.thumbnailIcon == null) {
            this.thumbnailIcon = new ThumbnailIcon();
        }
        this.thumbnailIcon.setQuality(quality);
        return this.thumbnailIcon;
    }

    @Override
    public String getDisplayName() {
        return this.getScreenName();
    }

    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    public static Icon getStaticIcon() {
        return SCREEN_MODEL_ICON;
    }

    public BufferedImage getScreenImage() {
        boolean resolve = this.screenImageRef == null;
        final BufferedImage[] screenImage = new BufferedImage[1];
        BufferedImage bufferedImage = screenImage[0] = resolve ? null : this.screenImageRef.get();
        if (!resolve || screenImage[0] == null || screenImage[0].getWidth() != this.getScreenSize().width || screenImage[0].getHeight() != this.getScreenSize().height) {
            Runnable screenRenderer = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataModel dataModel = ScreenModel.this.context.getDataModel();
                    synchronized (dataModel) {
                        if (ScreenModel.this.getTools() != null) {
                            Iterator tools = ScreenModel.this.getTools().realIterator();
                            screenImage[0] = ImageWriterGraphics.processToolToImage(null, tools, 0, 0, ScreenModel.this.getScreenSize().width, ScreenModel.this.getScreenSize().height, true, screenImage[0], null);
                        }
                        ScreenModel.this.screenImageRef = new SoftReference<BufferedImage>(screenImage[0]);
                    }
                }
            };
            try {
                SwingRunnerSupport.invokeAndWait((Runnable)screenRenderer);
            }
            catch (InterruptedException intx) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to render image", intx);
            }
        }
        return screenImage[0];
    }

    @Override
    public void notifyDisplayNodeChange() {
        super.notifyDisplayNodeChange();
        if (this.getToolTreeModel() != null) {
            this.getToolTreeModel().nodeChanged(this.getToolTreeModel().getDisplayRoot());
        }
    }

    public void notifyAccessibleACL(Boolean state) {
        this.notifyACLChildren(this.accessibleACL, state);
    }

    public void notifyCopyACL(Boolean state) {
        this.notifyACLChildren(this.copyACL, state);
    }

    public void notifyCreateACL(Boolean state) {
        this.notifyACLChildren(this.createACL, state);
    }

    public void notifyAccessToolsACL(Boolean state) {
        this.notifyACLChildren(this.accessToolsACL, state);
    }

    public void notifyDistributionACL(Boolean state) {
        this.evaluateDistributionList = true;
        this.notifyACLChildren(this.distributionACL, state);
    }

    public void notifyDeleteACL(Boolean state) {
        this.notifyACLChildren(this.deleteACL, state);
    }

    public void notifyDeleteOthersToolsACL(Boolean state) {
        this.notifyACLChildren(this.deleteOthersToolsACL, state);
    }

    public void notifyDeleteOwnToolsACL(Boolean state) {
        this.notifyACLChildren(this.deleteOwnToolsACL, state);
    }

    public void notifyEditBackgroundACL(Boolean state) {
        this.notifyACLChildren(this.editBackgroundACL, state);
        if (!this.selectionManager.isEmpty() && !this.canEditBackground()) {
            AbstractToolModel[] tools = new AbstractToolModel[this.selectionManager.getSelectedToolCount()];
            tools = this.selectionManager.getSelectedToolList().toArray(tools);
            for (int i = 0; i < tools.length; ++i) {
                if (!tools[i].isInBackground()) continue;
                this.selectionManager.deSelectTool(tools[i]);
            }
        }
    }

    public void notifyPrintACL(Boolean state) {
        this.notifyACLChildren(this.printACL, state);
    }

    public void notifySaveACL(Boolean state) {
        this.notifyACLChildren(this.saveACL, state);
    }

    public void notifySetAccessACL(Boolean state) {
        this.notifyACLChildren(this.setAccessACL, state);
    }

    public void notifyVisibleACL(Boolean state) {
        this.notifyACLChildren(this.visibleACL, state);
        if (this.isVisible() || this.canSetAccess()) {
            if (this.getDisplayPeer() == null) {
                this.createPeer();
            }
        } else if (this.getDisplayPeer() != null) {
            this.removePeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyACLChildren(ACLTerm aclTerm, Boolean state) {
        ArrayList<ACLTerm> update = null;
        if (this.screenList == null) {
            return;
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            Iterator iter = this.screenList.realIterator();
            while (iter.hasNext()) {
                ScreenModel screen = (ScreenModel)iter.next();
                if (!screen.isDeleted()) {
                    ACLTerm childACLTerm = screen.getACLTerm(aclTerm.getName());
                    if (childACLTerm != null && childACLTerm.isEmpty()) {
                        if (update == null) {
                            update = new ArrayList<ACLTerm>();
                        }
                        update.add(childACLTerm);
                        continue;
                    }
                    if (childACLTerm != null) continue;
                    LogSupport.error((Object)this, (String)"notifyACLChildren", (String)("notifyACLChildren: term: '" + aclTerm.getName() + "', finds screen: " + WBUtils.objectName(this) + ", with child screens without: " + aclTerm.getName()));
                    Thread.dumpStack();
                    continue;
                }
                LogSupport.error((Object)this, (String)"notifyACLChildren", (String)("Acting on a deleted node, still in screenList: " + Validator.validate("ScreenModel.notifyACLChildren", this.context)));
            }
        }
        if (update != null) {
            for (ACLTerm term : update) {
                term.reEvaluateTerm(state);
            }
        }
        this.fireACLChangeListeners(aclTerm);
    }

    public void addACLChangeListener(ACLChangeListener l) {
        if (!this.aclChangeListeners.contains(l)) {
            this.aclChangeListeners.add(l);
        }
    }

    public void removeACLChangeListener(ACLChangeListener l) {
        this.aclChangeListeners.remove(l);
    }

    private void fireACLChangeListeners(ACLTerm aclTerm) {
        ACLChangeListener[] listeners = new ACLChangeListener[this.aclChangeListeners.size()];
        listeners = this.aclChangeListeners.toArray(listeners);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].onACLChange(aclTerm);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void add(WBNode node) {
        if (!this.isDeleted()) {
            this.insert(node, -1);
        }
    }

    @Override
    public void add(WBNode node, Object oldNode) {
        if (this.isDeleted()) {
            // empty if block
        }
        int index = -1;
        if (oldNode instanceof WBNodeProxy) {
            index = ((WBNodeProxy)oldNode).getIndex();
            if (index >= 0) {
                try {
                    node.setNodeReplacingProxy(true);
                    if (node.isTool()) {
                        this.replaceTool((AbstractToolModel)node, index);
                    } else {
                        this.replaceScreen((ScreenModel)node, index);
                    }
                    return;
                }
                catch (Exception ex) {
                    return;
                }
            }
            Validator.logAlways("ScreenModel.add(new, old): proxy node cannot be found: " + WBUtils.objectName(oldNode));
        } else if (oldNode != null) {
            Validator.logAlways("ScreenModel.add: oldNode is not a proxy: " + WBUtils.objectName(oldNode) + "\n     newNode: " + WBUtils.objectName(node));
        }
        this.insert(node, index);
        node.setNodeReplacingProxy(false);
    }

    @Override
    public void insert(WBNode node, int index) {
        if (node.isProxy()) {
            this.insertProxy(node, index);
            node.setRoot(this.getRoot());
        } else if (node instanceof ScreenModel) {
            ScreenModel screen = (ScreenModel)node;
            if (screen.getObjectID() == null) {
                this.context.getObjectManager().setObjectInMap(screen);
            }
            this.addScreen(screen, index);
        } else if (node instanceof AbstractToolModel) {
            AbstractToolModel tool = (AbstractToolModel)node;
            if (tool.getObjectID() == null) {
                this.context.getObjectManager().setObjectInMap(tool);
            }
            this.addTool(tool);
        } else {
            throw new RuntimeException("ScreenModel.add: supplied node is wrong type: " + node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertProxy(WBNode node, int index) {
        NodeList list = node.isTool() ? this.toolList : this.screenList;
        NodeList nodeList = list;
        synchronized (nodeList) {
            if (index < 0 || index >= list.size()) {
                list.add(node);
            } else {
                list.add(index, node);
            }
        }
        node.setParent(this);
    }

    @Override
    public void remove(WBNode node) {
        if (node instanceof ScreenModel) {
            this.context.getDataExporter().removeTransitRefs(node.getObjectID());
            this.removeScreen((ScreenModel)node);
        } else if (node instanceof AbstractToolModel) {
            this.removeTool((AbstractToolModel)node);
        } else if (node.isProxy()) {
            this.removeProxy((WBNodeProxy)node);
        } else {
            throw new RuntimeException("ScreenModel.remove: supplied node is wrong type: " + node);
        }
        this.context.fireDeletion(node.getObjectID());
    }

    @Override
    public void delete() {
        super.delete();
        for (ACLTerm term : this.aclMap.values()) {
            term.delete();
        }
        this.aclMap.clear();
        this.toolList = null;
        this.screenChangeListeners = null;
        this.displayModel = null;
        this.removePeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIndex(WBNode node) {
        if (this.isDeleted()) {
            // empty if block
        }
        if (node.isTool()) {
            if (this.toolList == null) {
                return -1;
            }
            NodeList nodeList = this.toolList;
            synchronized (nodeList) {
                return this.toolList.indexOf(node);
            }
        }
        if (this.screenList == null) {
            return -1;
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            return this.screenList.indexOf(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScreen(ScreenModel screen, int index) {
        if (screen == this) {
            Thread.currentThread();
            Thread.dumpStack();
        }
        screen.determineNodeReparenting();
        if (screen.isReparenting() && screen.getParent() != null) {
            if (screen.isPrivate() != this.isPrivate()) {
                screen.setNodeReparenting(false);
                screen.getBoardParent().remove(screen);
                DataModel.propagateScreenACLs(screen, this.isPrivate());
                this.insert(screen, index);
                return;
            }
            screen.getBoardParent().remove(screen);
        }
        if (this.screenList == WhiteboardContext.EMPTY_ARRAYLIST) {
            this.screenList = new NodeList(this);
        }
        if (screen.getObjectID() == null) {
            this.context.getObjectManager().setObjectInMap(screen);
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            if (index < 0 || index >= this.screenList.size()) {
                this.screenList.add(screen);
            } else {
                this.screenList.add(index, screen);
            }
        }
        screen.setParent(this);
        screen.setNodeReparenting(false);
        screen.createPeer();
        if (screen.isConferenceNode() && this.context != null && this.context.getController() != null) {
            this.context.getController().evaluateScreenChange();
        }
        this.context.getDataModel().normalizeScreenNames(screen.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScreen(ScreenModel screen) {
        NodeList nodeList;
        int index = -1;
        try {
            nodeList = this.screenList;
            synchronized (nodeList) {
                index = this.screenList.indexOf(screen);
            }
        }
        catch (Exception ex) {
            Validator.log("ScreenModel.removeScreen cannot index: " + screen);
        }
        if (screen.isConferenceNode()) {
            this.context.getDataExporter().removeFromConference(screen);
        }
        nodeList = this.screenList;
        synchronized (nodeList) {
            this.screenList.remove(screen);
        }
        screen.setParent(null);
        if (this.getDisplayPeer() != null && this.getDisplayPeer().getDisplayModel() != null) {
            screen.removePeer();
        }
        this.context.getDataModel().fireNodeRemoved(screen, index, this);
        this.context.getDataModel().normalizeScreenNames(screen.getRoot());
        screen.setRoot(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceScreen(ScreenModel screen, int index) {
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            if (index >= this.screenList.size()) {
                this.screenList.add(screen);
            } else {
                WBNode oldScreen = (WBNode)this.screenList.get(index);
                oldScreen.setParent(null);
                if (this.getDisplayPeer() != null && this.getDisplayPeer().getDisplayModel() != null) {
                    oldScreen.removePeer();
                }
                this.screenList.set(index, screen);
            }
        }
        screen.setParent(this);
        screen.setRoot(this.getRoot());
        screen.createPeer();
        this.context.getDataModel().normalizeScreenNames(this.getRoot());
    }

    @Override
    public void createPeer() {
        DisplayNode previousPeer = null;
        if (this.getParent() == null) {
            return;
        }
        DisplayNode parentPeer = this.getParent().getDisplayPeer();
        if (parentPeer != null && (this.isVisible() || this.canSetAccess())) {
            int index;
            for (index = this.getIndex() - 1; previousPeer == null && index >= 0; --index) {
                previousPeer = this.getParent().getChildAt(index).getDisplayPeer();
            }
            if (this.getDisplayPeer() == null) {
                this.setDisplayPeer(new DisplayNode(this));
            }
            if (this.getDisplayPeer().getParent() == null) {
                index = previousPeer != null ? parentPeer.getIndex(previousPeer) + 1 : 0;
                parentPeer.getDisplayModel().insertNodeInto(this.getDisplayPeer(), parentPeer, index);
                this.createChildPeers(this.iterateScreens());
                this.createChildPeers(this.iterateTools());
                this.context.getController().createdPeer(this);
            }
        }
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTool(AbstractToolModel tool) {
        NodeList nodeList;
        int zOrder;
        if (this.toolList == null) {
            return;
        }
        tool.determineNodeReparenting();
        if (tool.isReparenting() && tool.getBoardParent() != null) {
            ScreenModel screen = tool.getScreenParent();
            if (screen.isPrivate() != this.isPrivate()) {
                tool.setNodeReparenting(false);
                tool.getBoardParent().remove(tool);
                this.addTool(tool);
                return;
            }
            tool.getBoardParent().remove(tool);
        }
        if ((zOrder = tool.getZOrder()) < 0) {
            switch (zOrder) {
                case -1: {
                    zOrder = 0;
                    nodeList = this.toolList;
                    synchronized (nodeList) {
                        if (!tool.isPartOfBackGround()) {
                            WBNode node;
                            Iterator iter = this.toolList.iterator();
                            while (iter.hasNext() && (node = (WBNode)iter.next()).isBackground()) {
                                ++zOrder;
                            }
                        }
                        break;
                    }
                }
                case -3: {
                    zOrder = this.firstNonBackground(this.getToolCount());
                    break;
                }
                default: {
                    zOrder = this.getToolCount();
                }
            }
        }
        if (zOrder > this.getToolCount()) {
            zOrder = this.getToolCount();
        }
        if (tool.getObjectID() == null) {
            this.context.getObjectManager().setObjectInMap(tool);
        }
        nodeList = this.toolList;
        synchronized (nodeList) {
            this.toolList.add(zOrder, tool);
        }
        tool.setParent(this);
        tool.setNodeReparenting(false);
        tool.createPeer();
        if (tool instanceof VisibleObject) {
            this.noteScreenModified(tool);
        }
        if (tool.isBackground()) {
            ++this.backgroundCount;
        } else {
            ++this.foregroundCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTool(AbstractToolModel tool) {
        int index;
        tool.removePeer();
        tool.notifyVisibleChange();
        if (tool.isSelected()) {
            this.deSelectTool(tool);
        }
        if (tool.isConferenceNode()) {
            this.context.getDataExporter().removeFromConference(tool, tool.getOriginator());
        }
        NodeList nodeList = this.toolList;
        synchronized (nodeList) {
            index = this.toolList.indexOf(tool);
            this.toolList.remove(tool);
        }
        if (tool.isBackground()) {
            --this.backgroundCount;
        } else {
            --this.foregroundCount;
        }
        tool.setParent(null);
        this.noteScreenModified(tool);
        tool.setRoot(null);
        this.context.getDataModel().fireNodeRemoved(tool, index, this);
        if (tool.isContainer()) {
            ArrayList<WBNode> removedTools = new ArrayList<WBNode>();
            WBNode node2 = null;
            NodeList nodeList2 = tool.toolList;
            synchronized (nodeList2) {
                for (WBNode node2 : tool.toolList) {
                    if (node2.isProxy()) {
                        removedTools.add(node2);
                        continue;
                    }
                    AbstractToolModel curTool = (AbstractToolModel)node2;
                    if (!curTool.isPartOfBackGround()) continue;
                    removedTools.add(curTool);
                }
            }
            for (WBNode curTool : removedTools) {
                if (curTool.isProxy()) {
                    this.removeProxy((WBNodeProxy)curTool);
                    continue;
                }
                this.removeTool((AbstractToolModel)curTool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceTool(AbstractToolModel tool, int index) {
        WBNode oldTool;
        NodeList nodeList = this.toolList;
        synchronized (nodeList) {
            oldTool = (WBNode)this.toolList.get(index);
        }
        if (!oldTool.isProxy()) {
            LogSupport.error((Object)this, (String)"replaceTool", (String)("replaceTool: oldTool is not a proxy: " + oldTool + ", newTool: " + tool));
        }
        oldTool.setParent(null);
        oldTool.setRoot(null);
        oldTool.removePeer();
        if (oldTool.isBackground()) {
            --this.backgroundCount;
        } else if (oldTool instanceof AbstractToolModel) {
            --this.foregroundCount;
        }
        nodeList = this.toolList;
        synchronized (nodeList) {
            this.toolList.set(index, tool);
        }
        if (tool instanceof BackgroundTool) {
            ++this.backgroundCount;
        } else {
            ++this.foregroundCount;
        }
        tool.setParent(this);
        tool.createPeer();
        if (tool instanceof VisibleObject) {
            this.noteScreenModified(tool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProxy(WBNodeProxy proxy) {
        if (proxy.isConferenceNode()) {
            this.context.getDataExporter().removeFromConference(proxy, proxy.getOriginator());
        }
        NodeList nodeList = this.screenList;
        synchronized (nodeList) {
            if (this.screenList.remove(proxy)) {
                return;
            }
        }
        nodeList = this.toolList;
        synchronized (nodeList) {
            this.toolList.remove(proxy);
        }
    }

    public NodeList getTools() {
        return this.toolList;
    }

    private void noteScreenModified(VisibleObject object) {
        this.flushThumbnails();
        if (this.getRoot() != null) {
            this.fireChangeListeners(new ScreenChangeEvent(this, object));
        }
        this.notifyDisplayNodeChange();
    }

    private void fireChangeListeners(ScreenChangeEvent sce) {
        if (this.screenChangeListeners == null) {
            return;
        }
        Object[] l = this.screenChangeListeners.toArray();
        for (int i = l.length - 1; i >= 0; --i) {
            ((ScreenChangeListener)l[i]).onScreenChange(sce);
        }
    }

    public void addScreenUIListener(ScreenChangeListener l) {
        if (!this.screenChangeListeners.contains(l)) {
            this.screenChangeListeners.add(l);
        }
    }

    public void removeScreenUIListener(ScreenChangeListener l) {
        if (this.screenChangeListeners == null) {
            return;
        }
        this.screenChangeListeners.remove(l);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        this.setSuppressAttributeNotification();
        super.streamToObject(istr);
        this.privateFlag = WBUtils.readBoolean(istr, "ScreenModel reads privateFlag");
        this.editable = WBUtils.readBoolean(istr, "ScreenModel reads editable");
        this.deletable = WBUtils.readBoolean(istr, "ScreenModel reads deletable");
        this.clearSuppressAttributeNotification();
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer msg = new StringBuffer();
        try {
            msg.append(super.streamToString(istr) + ", ScreenName: ");
            msg.append(", Private: " + WBUtils.readBoolean(istr, "ScreenModel reads privateFlag"));
            msg.append(", Editable: " + WBUtils.readBoolean(istr, "ScreenModel reads editable"));
            msg.append(", Deletable: " + WBUtils.readBoolean(istr, "ScreenModel reads deletable"));
            return msg.toString();
        }
        catch (IOException ioe) {
            LogSupport.exception((Object)this, (String)"StreamToString", (Throwable)ioe, (boolean)true);
            return this.getName() + " IOException: " + ioe.getMessage() + "\n" + msg.toString();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeBoolean(this.privateFlag);
        ostr.writeBoolean(this.editable);
        ostr.writeBoolean(this.deletable);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        Iterator iter = this.toolList.realIterator();
        while (iter.hasNext()) {
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            WBElement toolElement = tool.objectToElement(element, progress);
            if (toolElement == null) continue;
            element.addContent((Content)toolElement);
        }
        return element;
    }

    @Override
    public void onVisibleAttributeChange(VisibleObject object) {
        AbstractToolModel tool;
        this.flushThumbnails();
        this.fireChangeListeners(new ScreenChangeEvent(this, object));
        if (object instanceof AbstractToolModel && (tool = (AbstractToolModel)object).getObjectID() != null && this.selectionManager.getSelectedToolList().contains(tool)) {
            this.fireChangeListeners(new ScreenChangeEvent(this, ToolSelectionEntry.calculateRectangle(tool, null)));
        }
        this.notifyDisplayNodeChange();
    }

    public synchronized void flushThumbnails() {
        if (this.thumbnailIcon == null) {
            this.thumbnailIcon = new ThumbnailIcon();
        }
        this.thumbnailIcon.setQuality(1);
        this.lastThumbnailQuality = 0;
        this.screenImageRef = null;
    }

    public ArrayList getSelectedToolList() {
        return this.selectionManager.getSelectedToolList();
    }

    public boolean selectedToolListIsEmpty() {
        return this.selectionManager.isEmpty();
    }

    public int getSelectedToolCount() {
        return this.selectionManager.getSelectedToolCount();
    }

    public Iterator getSelectedToolListIterator() {
        return this.selectionManager.iterator();
    }

    public boolean selectTool(AbstractToolModel tool) {
        if (!tool.isBackground()) {
            this.context.setSelectMode();
            return this.selectionManager.selectTool(tool);
        }
        return false;
    }

    public boolean deSelectTool(AbstractToolModel tool) {
        this.context.setSelectMode();
        return this.selectionManager.deSelectTool(tool);
    }

    public void deSelectAllTools() {
        this.selectionManager.deSelectAllTools();
    }

    public void selectAllTools(boolean selectInBackground) {
        this.selectionManager.selectAllTools(selectInBackground);
    }

    public boolean isSelected(AbstractToolModel tool) {
        return this.selectionManager.isSelected(tool);
    }

    public AbstractToolModel[] findTools(Point point) {
        return this.findTools(new Rectangle(point.x - 2, point.y - 2, 4, 4));
    }

    public AbstractToolModel[] findTools(Rectangle rectangle) {
        List list = this.findToolSet(rectangle);
        AbstractToolModel[] tools = new AbstractToolModel[list.size()];
        if (list.size() > 0) {
            tools = list.toArray(tools);
        }
        list.clear();
        return tools;
    }

    public List findToolSet(Point point) {
        return this.findToolSet(new Rectangle(point.x - 2, point.y - 2, 4, 4));
    }

    public List findToolSet(Rectangle rectangle) {
        ArrayList<AbstractToolModel> list = new ArrayList<AbstractToolModel>();
        Iterator iter = this.iterateTools();
        while (iter.hasNext()) {
            AbstractToolModel tool;
            Object object = iter.next();
            if (!(object instanceof AbstractToolModel) || !GeometryUtils.intersects(rectangle, (tool = (AbstractToolModel)object).getVBounds())) continue;
            list.add(tool);
        }
        return list;
    }

    public void notifySelectionChange(AbstractToolModel tool, boolean select) {
        if (!this.selectionListeners.isEmpty()) {
            ToolSelectionListener[] selectionListener = new ToolSelectionListener[this.selectionListeners.size()];
            selectionListener = this.selectionListeners.toArray(selectionListener);
            for (int i = 0; i < selectionListener.length; ++i) {
                if (select) {
                    selectionListener[i].onSelectTool(tool);
                    continue;
                }
                selectionListener[i].onDeSelectTool(tool);
            }
        }
        this.fireChangeListeners(new ScreenChangeEvent(this, ToolSelectionEntry.calculateRectangle(tool, null)));
    }

    public void addToolSelectionListener(ToolSelectionListener l) {
        if (!this.selectionListeners.contains(l)) {
            this.selectionListeners.add(l);
        }
    }

    public void removeToolSelectionListener(ToolSelectionListener l) {
        this.selectionListeners.remove(l);
    }

    public static int toolCount(ScreenModel screen) {
        int count = screen.getToolCount();
        Iterator iter = screen.iterateScreens();
        while (iter.hasNext()) {
            Object childScreen = iter.next();
            if (!(childScreen instanceof ScreenModel)) continue;
            count += ScreenModel.toolCount((ScreenModel)childScreen);
        }
        return count;
    }

    private static int countTools(Iterator tools) {
        int count = 0;
        while (tools.hasNext()) {
            ++count;
            Object thisTool = tools.next();
            if (!(thisTool instanceof GroupToolModel)) continue;
            count += ScreenModel.countTools(((GroupToolModel)thisTool).iterateTools());
        }
        return count;
    }

    @Override
    public void notifyVisibleChange() {
        this.flushThumbnails();
        this.notifyDisplayNodeChange();
    }

    @Override
    public void notifySizingChange() {
        this.flushThumbnails();
        if (this.context.getController() != null && this.context.getController().getScreen() == this) {
            this.context.getController().setSize();
        }
        this.notifyDisplayNodeChange();
    }

    public boolean isAccessible() {
        return this.accessibleACL.allows();
    }

    public boolean isPublishedTo(short client) {
        return true;
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        if (this.screenName == null) {
            Validator.log("ScreenModel has no ScreenName: " + WBUtils.objectName(this));
            valid = Validator.setValid(valid, false);
        }
        if (this.screenSize == null) {
            Validator.log("ScreenModel has no ScreenSize: " + WBUtils.objectName(this));
            valid = Validator.setValid(valid, false);
        }
        if (this.toolList == null) {
            Validator.log("ScreenModel has no ToolList: " + WBUtils.objectName(this));
            valid = Validator.setValid(valid, false);
        }
        if (this.distributionList == null) {
            Validator.log("ScreenModel has no distributionList: " + WBUtils.objectName(this));
            valid = Validator.setValid(valid, false);
        }
        if (this.screenChangeListeners == null && this.context.getController() != null && this.context.getController().getScreen() == this) {
            Validator.log("ScreenModel is viewed by controller but has no listeners: " + WBUtils.objectName(this));
            valid = Validator.setValid(valid, false);
        }
        Iterator toolIterator = this.iterateTools();
        int toolIndex = 0;
        while (toolIterator.hasNext()) {
            WBNode tool = (WBNode)toolIterator.next();
            if (tool.getIndex() != toolIndex) {
                Validator.log("ToolChild: " + tool.getIndex() + ", should have index: " + toolIndex);
                valid = Validator.setValid(valid, false);
            }
            ++toolIndex;
            if (tool instanceof AbstractToolModel) {
                valid &= ((AbstractToolModel)tool).validate(this);
                continue;
            }
            if (tool.isProxy()) {
                valid &= tool.validate();
                continue;
            }
            Validator.log("Tool: " + tool + " is not an AbstractToolModel or a WBNodeProxy");
            valid = Validator.setValid(valid, false);
        }
        return valid & super.validate();
    }

    @Override
    public String display(String indent) {
        StringBuffer buf = new StringBuffer();
        buf.append(indent + this.getScreenName() + "\n");
        buf.append(super.display(indent) + "\n");
        return buf.toString();
    }

    public boolean isSubScreen() {
        return this.parent instanceof ScreenModel && !(this.parent instanceof ScreenRoot);
    }

    static {
        try {
            SCREEN_MODEL_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.SCREENMODEL_ICON);
        }
        catch (Throwable ignored) {
            SCREEN_MODEL_ICON = null;
        }
    }

    final class BreadthFirstEnumeration
    implements Enumeration {
        LinkedList linkedList = new LinkedList();

        public BreadthFirstEnumeration(WBNode rootNode) {
            this.linkedList.add(rootNode);
        }

        @Override
        public boolean hasMoreElements() {
            return !this.linkedList.isEmpty();
        }

        public Object nextElement() {
            WBNode node = (WBNode)this.linkedList.getFirst();
            this.linkedList.remove(0);
            Iterator iter = node.iterateScreens();
            while (iter.hasNext()) {
                this.linkedList.add((WBNodeInterface)iter.next());
            }
            return node;
        }
    }

    class ThumbnailIcon
    implements Icon {
        private boolean isChanged = true;
        private int quality = 1;
        private int thumbnailBorderSize = 1;
        private int thumbnailHeight = 0;
        private BufferedImage thumbnailImage = null;
        private int thumbnailRepaintExceptionCount = 0;
        private double thumbnailScale = 1.0;
        private boolean thumbnailSizeChanged = true;
        private int thumbnailWidth = 0;
        ThumbnailResolver thumbnailResolver = new ThumbnailResolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolve() {
                boolean mustResolve;
                ThumbnailResolver thumbnailResolver = ThumbnailIcon.this.thumbnailResolver;
                synchronized (thumbnailResolver) {
                    mustResolve = ThumbnailIcon.this.thumbnailImage == null || ThumbnailIcon.this.isChanged || ThumbnailIcon.this.quality > ScreenModel.this.lastThumbnailQuality;
                }
                if (mustResolve) {
                    ThumbnailIcon.this.thumbnailImage = ThumbnailIcon.this.getThumbnail(64, 64, Color.black, ThumbnailIcon.this.quality);
                }
                thumbnailResolver = ThumbnailIcon.this.thumbnailResolver;
                synchronized (thumbnailResolver) {
                    this.abandonResolving();
                    ThumbnailIcon.this.isChanged = false;
                    ThumbnailIcon.this.thumbnailSizeChanged = false;
                }
                this.repaint();
            }
        };

        private void calculateSizes(int width, int height, Color borderColor) {
            int newThumbnailWidth;
            int newThumbnailHeight;
            int screenWidth = ScreenModel.this.getScreenSize().width;
            int screenHeight = ScreenModel.this.getScreenSize().height;
            if (screenWidth <= 0 || screenHeight <= 0) {
                return;
            }
            this.thumbnailBorderSize = borderColor instanceof Color ? 1 : 0;
            double scaleHeight = (double)(height - this.thumbnailBorderSize) / (double)screenHeight;
            double scaleWidth = (double)(width - this.thumbnailBorderSize) / (double)screenWidth;
            if (scaleHeight < scaleWidth) {
                newThumbnailHeight = height;
                newThumbnailWidth = this.thumbnailBorderSize + (int)((double)screenWidth * scaleHeight);
                this.thumbnailScale = scaleHeight;
            } else {
                newThumbnailWidth = width;
                newThumbnailHeight = this.thumbnailBorderSize + (int)((double)screenHeight * scaleWidth);
                this.thumbnailScale = scaleWidth;
            }
            this.thumbnailSizeChanged = this.thumbnailSizeChanged || newThumbnailHeight != this.thumbnailHeight || newThumbnailWidth != this.thumbnailWidth;
            this.isChanged |= this.thumbnailSizeChanged;
            this.thumbnailHeight = newThumbnailHeight;
            this.thumbnailWidth = newThumbnailWidth;
        }

        @Override
        public int getIconHeight() {
            this.calculateSizes(64, 64, Color.black);
            return this.thumbnailHeight;
        }

        @Override
        public int getIconWidth() {
            this.calculateSizes(64, 64, Color.black);
            return this.thumbnailWidth;
        }

        public int getQuality() {
            return this.quality;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getThumbnail(int width, int height, Color borderColor, int quality) {
            this.calculateSizes(width, height, borderColor);
            if (ScreenModel.this.getScreenSize().width <= 0 || ScreenModel.this.getScreenSize().height <= 0) {
                return null;
            }
            BufferedImage screenImage = ScreenModel.this.getScreenImage();
            if (quality > ScreenModel.this.lastThumbnailQuality) {
                ScreenModel.this.lastThumbnailQuality = quality;
                if (screenImage != null) {
                    ThumbnailResolver thumbnailResolver = this.thumbnailResolver;
                    synchronized (thumbnailResolver) {
                        if (quality == 2 || quality == 1) {
                            this.thumbnailImage = ImageSupport.getScaledInstance((Image)screenImage, (int)(this.thumbnailWidth - this.thumbnailBorderSize * 2), (int)(this.thumbnailHeight - this.thumbnailBorderSize * 2), (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR, (quality == 2 ? 1 : 0) != 0);
                        } else {
                            Image img = screenImage.getScaledInstance(this.thumbnailWidth - this.thumbnailBorderSize * 2, this.thumbnailHeight - this.thumbnailBorderSize * 2, 16);
                            if (this.thumbnailImage == null || this.thumbnailWidth != this.thumbnailImage.getWidth() || this.thumbnailHeight != this.thumbnailImage.getHeight()) {
                                this.thumbnailImage = new BufferedImage(this.thumbnailWidth, this.thumbnailHeight, 2);
                            }
                            Graphics2D g2 = this.thumbnailImage.createGraphics();
                            g2.drawImage(img, 0, 0, null);
                            g2.dispose();
                        }
                    }
                }
            }
            ScreenModel.this.thumbnailBorderColor = borderColor;
            return this.thumbnailImage;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            block6: {
                BufferedImage tmpThumbnailImage = null;
                this.resolveIcon(c, x, y);
                try {
                    tmpThumbnailImage = this.thumbnailImage;
                    if (tmpThumbnailImage == null) {
                        ScreenModel.getStaticIcon().paintIcon(c, g, x, y);
                    } else if (this.thumbnailBorderSize > 0) {
                        Graphics localGraphics = g.create();
                        localGraphics.setColor(ScreenModel.this.thumbnailBorderColor);
                        localGraphics.fillRect(x, y, this.thumbnailWidth, this.thumbnailHeight);
                        localGraphics.drawImage(this.thumbnailImage, x + this.thumbnailBorderSize, y + this.thumbnailBorderSize, c);
                        localGraphics.dispose();
                    } else {
                        g.drawImage(tmpThumbnailImage, x, y, c);
                    }
                    this.thumbnailRepaintExceptionCount = 0;
                }
                catch (Exception e) {
                    if (this.thumbnailRepaintExceptionCount++ >= 10) break block6;
                    c.repaint();
                }
            }
        }

        private void resolveIcon(Component c, int x, int y) {
            if (!this.isChanged()) {
                return;
            }
            this.thumbnailResolver.addReference(c, x, y);
            if (this.thumbnailResolver.isResolving()) {
                return;
            }
            ScreenModel.this.context.addThumbnailResolver(this.thumbnailResolver);
        }

        public void setIsChanged(boolean isChanged) {
            if (this.isChanged != isChanged) {
                this.thumbnailResolver.repaint();
            }
            this.isChanged = isChanged;
        }

        public void setQuality(int quality) {
            this.setIsChanged(this.isChanged | this.quality < quality);
            this.quality = quality;
        }
    }
}

