/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.conference.RefCount;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import com.elluminate.groupware.whiteboard.dataModel.MediaEvent;
import com.elluminate.groupware.whiteboard.dataModel.MediaID;
import com.elluminate.groupware.whiteboard.dataModel.MediaItem;
import com.elluminate.groupware.whiteboard.dataModel.MediaListener;
import com.elluminate.groupware.whiteboard.dataModel.MediaListenersListener;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.StringsProperties;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.DeferredImageContent;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.image.gif.ImageObject;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;

public class MediaCache {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static int BYTES_PER_PIXEL = 4;
    public static final boolean DEBUG = false;
    public static final String MEDIA_CACHE_SIZE_PROP = "cacheSize";
    public static final String GLOBAL_MEDIA_CACHE_SIZE_PROP = "globalMediaCacheSize";
    public static final String MEDIA_INSTANCE_SIZE_PROP = "mediaBufferSize";
    public static final String GLOBAL_MEDIA_INSTANCE_SIZE_PROP = "globalMediaBufferSize";
    public static final String CRC_STRING = "CRC";
    public static final String LENGTH_STRING = "size";
    public static final String MEDIA_CACHE_NAME = "_MediaCache";
    public static final String MEDIA_ELEMENT_NAME = "Media";
    private HashMap mediaCache = new HashMap();
    private HashMap mediaListeners = new HashMap();
    private ArrayList mediaAddRemoveListeners = null;
    private ArrayList mediaListenersListener = new ArrayList();
    private LinkedList mediaLRUList = new LinkedList();
    private long maxImageCache = 20000000L;
    private long maxImageInstance = 20000000L;
    private long cacheSize = 0L;
    private long instanceSize = 0L;
    private CPropertyChangeSupport changeSupport = new CPropertyChangeSupport((Object)this);
    private HashMap screenUIDHashSetByMediaID = new HashMap();
    private HashMap mediaIDHashSetByScreenUID = new HashMap();
    private HashMap screenUIDByRefObject = new HashMap();
    private HashMap refObjectHashSetByScreenUID = new HashMap();
    private WhiteboardContext context = null;

    public MediaCache(WhiteboardContext context) {
        this.context = context;
    }

    public long getMaxImageCache() {
        return this.maxImageCache;
    }

    public void setMaxImageInstance(long maxImageInstance) {
        this.setMaxImageInstance(maxImageInstance, true);
    }

    public void setMaxImageInstance(long maxImageInstance, boolean notify) {
        long oldMaxInstance = this.maxImageInstance;
        this.maxImageInstance = maxImageInstance;
        if (notify && this.context.getClientList() != null) {
            this.context.getClientList().setProperty(GLOBAL_MEDIA_INSTANCE_SIZE_PROP, new Long(maxImageInstance).longValue());
        }
        if (notify) {
            this.changeSupport.firePropertyChange(GLOBAL_MEDIA_INSTANCE_SIZE_PROP, oldMaxInstance, maxImageInstance);
        }
        this.cleanMediaInstances();
    }

    public long getMaxImageInstance() {
        return this.maxImageInstance;
    }

    public void setMaxImageCache(long maxImageCache) {
        this.setMaxImageCache(maxImageCache, true);
    }

    public void setMaxImageCache(long maxImageCache, boolean notify) {
        long oldMaxCache = this.maxImageCache;
        this.maxImageCache = maxImageCache;
        if (notify && this.context.getClientList() != null) {
            this.context.getClientList().setProperty(GLOBAL_MEDIA_CACHE_SIZE_PROP, new Long(maxImageCache).longValue());
        }
        if (notify) {
            this.changeSupport.firePropertyChange(GLOBAL_MEDIA_CACHE_SIZE_PROP, oldMaxCache, maxImageCache);
        }
    }

    public boolean isCacheFull() {
        return this.cacheSize > this.maxImageCache;
    }

    public boolean willExceedCache(int imageSize) {
        return this.cacheSize + (long)imageSize > this.maxImageCache;
    }

    public int spaceRemaining(int imageSize) {
        return (int)(this.maxImageCache - (this.cacheSize + (long)imageSize));
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public long getInstanceSize() {
        return this.instanceSize;
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(lst);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(prop, lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(prop, lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaData add(MediaData mediaData, Long screenUID) {
        MediaItem item;
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            item = (MediaItem)this.mediaCache.get(mediaData.getMediaID());
            if (item == null) {
                item = new MediaItem(mediaData);
                this.mediaCache.put(mediaData.getMediaID(), item);
                if (mediaData.getMedia() != null) {
                    this.updateCacheSize(mediaData, true);
                }
            }
        }
        item.addScreen(screenUID);
        this.noteMediaReference(mediaData);
        return item.getMediaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaData define(MediaData mediaData, Short originator) {
        MediaItem item;
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            if (!this.mediaCache.containsKey(mediaData.getMediaID())) {
                item = new MediaItem(mediaData);
                this.mediaCache.put(mediaData.getMediaID(), item);
            } else {
                item = (MediaItem)this.mediaCache.get(mediaData.getMediaID());
                if (item.getMediaData().getMedia() != null) {
                    return item.getMediaData();
                }
                item.setMediaData(mediaData);
            }
        }
        this.updateCacheSize(mediaData, true);
        MediaEvent event = new MediaEvent(item, 1, originator);
        this.fireMediaListeners(event);
        this.noteMediaReference(mediaData);
        return item.getMediaData();
    }

    public void registerMediaScreenReference(Long referenceUID, boolean hasReference, ScreenModel screen, MediaID mediaID) {
        if (referenceUID == null || screen == null || mediaID == null) {
            return;
        }
        Long screenUID = screen.getObjectID();
        Long mediaIDLong = mediaID.getMediaIDLong();
        if (hasReference) {
            this.screenUIDByRefObject.put(referenceUID, screenUID);
            HashSet<Long> hashSet = (HashSet<Long>)this.mediaIDHashSetByScreenUID.get(screenUID);
            if (hashSet == null) {
                hashSet = new HashSet<Long>();
                this.mediaIDHashSetByScreenUID.put(screenUID, hashSet);
            }
            hashSet.add(mediaIDLong);
            hashSet = (HashSet<Long>)this.screenUIDHashSetByMediaID.get(mediaIDLong);
            if (hashSet == null) {
                hashSet = new HashSet<Long>();
                this.screenUIDHashSetByMediaID.put(mediaIDLong, hashSet);
            }
            hashSet.add(screenUID);
            hashSet = (HashSet<Long>)this.refObjectHashSetByScreenUID.get(screenUID);
            if (hashSet == null) {
                hashSet = new HashSet<Long>();
                this.refObjectHashSetByScreenUID.put(screenUID, hashSet);
            }
            hashSet.add(referenceUID);
        } else {
            this.screenUIDByRefObject.remove(referenceUID);
            HashSet hashSet = (HashSet)this.mediaIDHashSetByScreenUID.get(screenUID);
            if (hashSet != null) {
                hashSet.remove(mediaIDLong);
                if (hashSet.isEmpty()) {
                    this.mediaIDHashSetByScreenUID.remove(screenUID);
                }
            }
            if ((hashSet = (HashSet)this.screenUIDHashSetByMediaID.get(mediaIDLong)) != null) {
                hashSet.remove(screenUID);
                if (hashSet.isEmpty()) {
                    this.screenUIDHashSetByMediaID.remove(mediaIDLong);
                }
            }
            if ((hashSet = (HashSet)this.refObjectHashSetByScreenUID.get(screenUID)) != null) {
                hashSet.remove(referenceUID);
                if (hashSet.isEmpty()) {
                    this.refObjectHashSetByScreenUID.remove(screenUID);
                }
            }
        }
    }

    public HashSet getScreenUIDSet(Long mediaID) {
        HashSet screenUIDs = (HashSet)this.screenUIDHashSetByMediaID.get(mediaID);
        if (screenUIDs == null) {
            screenUIDs = new HashSet();
        }
        return screenUIDs;
    }

    public boolean isMediaSaveable(MediaID mediaId) {
        ArrayList listeners;
        boolean canPublish = true;
        MediaItem mediaItem = this.getMediaItem(mediaId);
        if (mediaItem != null && mediaItem.calculateScreenUIDs() && (listeners = (ArrayList)this.mediaListeners.get(mediaId)) != null) {
            for (Object object : listeners) {
                ScreenModel screen;
                WBImage wbImage;
                if (!(object instanceof WBImage) || (wbImage = (WBImage)object).getParent() == null || (screen = wbImage.getParent().getScreenParent()) == null || !screen.isConferenceNode()) continue;
                canPublish &= screen.canSave();
            }
        }
        return canPublish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MediaData mediaData, Long screenUID) {
        boolean result = false;
        MediaItem item = null;
        boolean updateSize = false;
        MediaEvent event = null;
        Cloneable cloneable = this.mediaCache;
        synchronized (cloneable) {
            item = (MediaItem)this.mediaCache.get(mediaData.getMediaID());
            if (item != null) {
                if (event != null) {
                    this.fireMediaListeners(event);
                    HashMap hashMap = this.mediaCache;
                    synchronized (hashMap) {
                        this.mediaListeners.remove(mediaData.getMediaID());
                    }
                }
                if (item.removeScreen(screenUID) <= 0) {
                    updateSize = mediaData.getMedia() != null;
                    event = new MediaEvent(item, 2, null);
                    this.mediaCache.remove(mediaData.getMediaID());
                }
                result = true;
            }
        }
        if (updateSize) {
            this.updateCacheSize(mediaData, false);
        }
        try {
            this.context.getDataExporter().doneDataInTransit(mediaData.getMediaID().getMediaIDLong(), null, null, false, null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        cloneable = this.mediaLRUList;
        synchronized (cloneable) {
            this.mediaLRUList.remove(mediaData);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneUnreferenced() {
        MediaItem[] items;
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            items = new MediaItem[this.mediaCache.size()];
            int entryCount = 0;
            Iterator iter = this.mediaCache.values().iterator();
            while (iter.hasNext()) {
                items[entryCount++] = (MediaItem)iter.next();
            }
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getRefCount() != 0 || items[i].getMediaData().getMedia() == null || items[i].getMediaData().getMedia().length <= 0) continue;
            this.remove(items[i].getMediaData(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInTransit(MediaID mediaID) {
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            MediaItem item = (MediaItem)this.mediaCache.get(mediaID);
            if (item != null) {
                return item.isInTransit();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrementInTransit(MediaID mediaID) {
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            MediaItem item = (MediaItem)this.mediaCache.get(mediaID);
            if (item != null) {
                return item.decrementInTransit();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementInTransit(MediaID mediaID) {
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            MediaItem item = (MediaItem)this.mediaCache.get(mediaID);
            if (item != null) {
                item.incrementInTransit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheSize(MediaData mediaData, boolean add) {
        long oldCacheSize;
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            oldCacheSize = this.cacheSize;
            this.cacheSize = add ? (this.cacheSize += (long)mediaData.getMedia().length) : (this.cacheSize -= (long)mediaData.getMedia().length);
        }
        this.changeSupport.firePropertyChange(MEDIA_CACHE_SIZE_PROP, oldCacheSize, this.cacheSize);
    }

    public void addMediaListener(MediaListener l, MediaData mediaData) {
        ArrayList<MediaListener> listeners = (ArrayList<MediaListener>)this.mediaListeners.get(mediaData.getMediaID());
        if (listeners == null) {
            listeners = new ArrayList<MediaListener>();
            this.mediaListeners.put(mediaData.getMediaID(), listeners);
        }
        listeners.add(l);
        this.fireMediaListenersListeners(mediaData, l, true);
        this.getMediaItem(mediaData.getMediaID()).setCalculateScreenUIDs(true);
    }

    public void removeMediaListener(MediaListener l, MediaData mediaData) {
        ArrayList listeners;
        if (mediaData == null) {
            System.out.println("MediaCache, remove listener for null data: " + mediaData);
        }
        if ((listeners = (ArrayList)this.mediaListeners.get(mediaData.getMediaID())) != null) {
            listeners.remove(l);
            if (listeners.isEmpty() && this.mediaListeners.remove(mediaData.getMediaID()) == null) {
                LogSupport.message((Object)this, (String)"removeMediaListeners", (String)("mediaId not removed from mediaListeners: " + mediaData.getMediaID()));
            }
        }
        this.fireMediaListenersListeners(mediaData, l, false);
        MediaItem item = this.getMediaItem(mediaData.getMediaID());
        if (item != null) {
            item.setCalculateScreenUIDs(true);
        }
    }

    public void addMediaListenerListener(MediaListenersListener l) {
        if (!this.mediaListenersListener.contains(l)) {
            this.mediaListenersListener.add(l);
        }
    }

    public void removeMediaListenerListener(MediaListenersListener l) {
        this.mediaListenersListener.remove(l);
    }

    void fireMediaListenersListeners(MediaData mediaData, MediaListener l, boolean added) {
        Iterator iter = this.mediaListenersListener.iterator();
        while (iter.hasNext()) {
            ((MediaListenersListener)iter.next()).onMediaListenersChange(mediaData, l, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaListener(MediaListener l) {
        if (this.mediaAddRemoveListeners == null) {
            this.mediaAddRemoveListeners = new ArrayList();
        }
        ArrayList arrayList = this.mediaAddRemoveListeners;
        synchronized (arrayList) {
            this.mediaAddRemoveListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaListener(MediaListener l) {
        if (this.mediaAddRemoveListeners != null) {
            ArrayList arrayList = this.mediaAddRemoveListeners;
            synchronized (arrayList) {
                this.mediaAddRemoveListeners.remove(l);
                if (this.mediaAddRemoveListeners.isEmpty()) {
                    this.mediaAddRemoveListeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMediaListeners(MediaEvent event) {
        ArrayList listeners = (ArrayList)this.mediaListeners.get(event.getMediaItem().getMediaData().getMediaID());
        if (this.mediaAddRemoveListeners != null) {
            MediaListener[] addRemoveListeners;
            ArrayList arrayList = this.mediaAddRemoveListeners;
            synchronized (arrayList) {
                addRemoveListeners = new MediaListener[this.mediaAddRemoveListeners.size()];
                addRemoveListeners = this.mediaAddRemoveListeners.toArray(addRemoveListeners);
            }
            for (int i = 0; i < addRemoveListeners.length; ++i) {
                if (!addRemoveListeners[i].onMedia(event)) continue;
                ArrayList arrayList2 = this.mediaAddRemoveListeners;
                synchronized (arrayList2) {
                    this.mediaAddRemoveListeners.remove(addRemoveListeners[i]);
                    continue;
                }
            }
            ArrayList arrayList3 = this.mediaAddRemoveListeners;
            synchronized (arrayList3) {
                if (this.mediaAddRemoveListeners.isEmpty()) {
                    this.mediaAddRemoveListeners = null;
                }
            }
        }
        if (listeners != null) {
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                if (!((MediaListener)iter.next()).onMedia(event)) continue;
                iter.remove();
            }
            if (listeners.isEmpty() && this.mediaListeners.remove(event.getMediaItem().getMediaData().getMediaID()) == null) {
                LogSupport.message((Object)this, (String)"fireMediaListeners", (String)("mediaId not removed from mediaListeners: " + event.getMediaItem().getMediaData().getMediaID()));
            }
        }
    }

    public int getRefCount(MediaID mediaID) {
        MediaItem item = this.getMediaItem(mediaID);
        if (item != null) {
            return item.getRefCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaItem getMediaItem(MediaID mediaID) {
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            return (MediaItem)this.mediaCache.get(mediaID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaData newMediaData(byte[] imageData) {
        MediaItem mediaItem = null;
        MediaData mediaData = null;
        MediaID id = new MediaID(imageData);
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            mediaItem = (MediaItem)this.mediaCache.get(id);
            mediaData = mediaItem == null ? new MediaData(this.context, imageData) : mediaItem.getMediaData();
        }
        return mediaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(MediaID mediaID) {
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            return this.mediaCache.containsKey(mediaID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitDefinedMedia(WBOutputStream ostr) {
        LinkedList<MediaExchangeEntry> list = new LinkedList<MediaExchangeEntry>();
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            for (Map.Entry entry : this.mediaCache.entrySet()) {
                MediaID id = (MediaID)entry.getKey();
                MediaItem item = (MediaItem)entry.getValue();
                if (!item.isDefined()) continue;
                MediaExchangeEntry mediaEntry = new MediaExchangeEntry(id, item.getRefCount());
                list.add(mediaEntry);
            }
        }
        try {
            ostr.writeShort(list.size());
            for (MediaExchangeEntry mediaEntry : list) {
                mediaEntry.objectToStream(ostr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashMap readDefinedMedia(WBInputStream istr) {
        HashMap<MediaID, RefCount> map = new HashMap<MediaID, RefCount>();
        try {
            int entryCount = istr.readShort();
            for (int i = 0; i < entryCount; ++i) {
                MediaExchangeEntry entry = new MediaExchangeEntry(istr);
                map.put(entry.getMediaID(), entry.getRefCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteMediaReference(MediaData mediaData) {
        LinkedList linkedList = this.mediaLRUList;
        synchronized (linkedList) {
            if ((this.mediaLRUList.isEmpty() || mediaData != this.mediaLRUList.getFirst()) && mediaData != null && mediaData.getMediaID() != null) {
                this.mediaLRUList.remove(mediaData);
                this.mediaLRUList.addFirst(mediaData);
                this.cleanMediaInstances();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMediaInstances() {
        long oldInstanceSize = this.instanceSize;
        LinkedList linkedList = this.mediaLRUList;
        synchronized (linkedList) {
            if (this.mediaLRUList.isEmpty()) {
                return;
            }
            this.instanceSize = this.calculateInstanceSize();
            if (this.instanceSize > this.maxImageInstance) {
                long lowerBound = 2L * this.maxImageInstance / 3L;
                ListIterator lIter = this.mediaLRUList.listIterator(this.mediaLRUList.size());
                while (lIter.hasPrevious() && this.instanceSize > lowerBound) {
                    MediaData data = (MediaData)lIter.previous();
                    if (data.getMediaInstance() == null) continue;
                    if (data.getMediaInstance().get() instanceof ImageObject) {
                        ImageObject imageObject = (ImageObject)data.getMediaInstance().get();
                        this.instanceSize -= (long)(imageObject.getPixelSum() * BYTES_PER_PIXEL);
                        imageObject.flush();
                        data.setMediaInstance(null);
                        continue;
                    }
                    if (!(data.getMediaInstance().get() instanceof Image)) continue;
                    ((Image)data.getMediaInstance().get()).flush();
                }
            }
        }
        this.changeSupport.firePropertyChange(MEDIA_INSTANCE_SIZE_PROP, oldInstanceSize, this.instanceSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateInstanceSize() {
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            this.instanceSize = 0L;
            for (MediaItem mediaItem : this.mediaCache.values()) {
                SoftReference instance = mediaItem.getMediaData().getMediaInstance();
                if (instance == null) continue;
                if (instance.get() instanceof ImageObject) {
                    ImageObject imageObject = (ImageObject)instance.get();
                    this.instanceSize += (long)(imageObject.getPixelSum() * BYTES_PER_PIXEL);
                }
                this.instanceSize += (long)mediaItem.getMediaData().getMediaID().getLength();
            }
        }
        return this.instanceSize;
    }

    public boolean instanceTooBig(int pixelSum) {
        return (long)(pixelSum * BYTES_PER_PIXEL) >= this.maxImageInstance;
    }

    public void elementToMediaCache(WBElement mediaElement, ProgressUpdate progress) throws Exception {
        block3: {
            Iterator iter = mediaElement.getChildren().iterator();
            try {
                while (iter.hasNext()) {
                    WBElement element = (WBElement)((Object)iter.next());
                    if (element == null || !element.getName().equals(MEDIA_ELEMENT_NAME)) continue;
                    int length = element.getAttribute(LENGTH_STRING).getIntValue();
                    long crc = element.getAttribute(CRC_STRING).getLongValue();
                    byte[] bytes = StringUtils.bytesFromHex((String)element.getText());
                    iter.remove();
                    MediaData mediaData = new MediaData(this.context, bytes);
                    this.define(mediaData, null);
                }
            }
            catch (DataConversionException ex) {
                if (this.context.getController() == null) break block3;
                ModalDialog.showMessageDialog((Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.MEDIACACHE_BADMEDIA), (String)i18n.getString((PropertiesEnum)StringsProperties.MEDIACACHE_BADMEDIATITLE), (int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitMediaCache(WBElement whiteboardModel, Set mediaSet, ProgressUpdate progress) throws Exception {
        MediaItem[] mediaItems;
        int count;
        WBElement imElement = null;
        if (mediaSet != null) {
            Set set = mediaSet;
            synchronized (set) {
                count = mediaSet.size();
                mediaItems = new MediaItem[count];
                mediaItems = mediaSet.toArray(mediaItems);
            }
        } else {
            count = 0;
            mediaItems = new MediaItem[]{};
        }
        WBElement element = new WBElement(MEDIA_CACHE_NAME);
        progress.incrementMaximum(count);
        for (MediaItem mediaItem : mediaItems) {
            if (mediaItem == null || mediaItem.getMediaData() == null) continue;
            MediaID mediaID = mediaItem.getMediaData().getMediaID();
            if (mediaItem.isDefined() && this.isMediaSaveable(mediaID) && mediaItem.getRefCount() > 0 && mediaID.getLength() > 0) {
                imElement = new WBElement(MEDIA_ELEMENT_NAME);
                if (mediaItem.getMediaData() != null) {
                    imElement.setAttribute(new Attribute(LENGTH_STRING, Integer.toString(mediaID.getLength())));
                    imElement.setAttribute(new Attribute(CRC_STRING, Long.toString(mediaID.getCRC())));
                    imElement.addContent((Content)new DeferredImageContent(mediaItem.getMediaData().getMedia()));
                }
                element.addContent((Content)imElement);
            }
            progress.setValue(progress.getValue() + 1);
        }
        whiteboardModel.addContent((Content)element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Long screenUID;
        int lineLimit;
        HashSet hashSet;
        Iterator iter2;
        StringBuffer buf;
        HashMap hashMap = this.mediaCache;
        synchronized (hashMap) {
            buf = new StringBuffer();
            buf.append("MediaCache(" + this.mediaCache.size() + "):\n");
            for (Map.Entry entry : this.mediaCache.entrySet()) {
                buf.append("   " + (MediaItem)entry.getValue());
            }
        }
        buf.append("MediaListeners(" + this.mediaListeners.size() + "):\n");
        for (Map.Entry entry : this.mediaListeners.entrySet()) {
            ArrayList listeners = (ArrayList)entry.getValue();
            iter2 = listeners.iterator();
            buf.append("media: " + entry.getKey() + ", listeners:\n");
            while (iter2.hasNext()) {
                buf.append("           " + (MediaListener)iter2.next() + "\n");
            }
        }
        buf.append("\nMediaIDHashSetByScreenUID(" + this.mediaIDHashSetByScreenUID.size() + "):\n");
        for (Map.Entry entry : this.mediaIDHashSetByScreenUID.entrySet()) {
            hashSet = (HashSet)entry.getValue();
            buf.append("screenUID: " + WBUtils.uniqueIDAsHex((Long)entry.getKey()) + " mediaIDs: \n");
            for (Long mediaID : hashSet) {
                buf.append("  " + this.getMediaItem(new MediaID(mediaID)));
            }
        }
        buf.append("\nScreenUIDHashSetByMediaID(" + this.screenUIDHashSetByMediaID.size() + "):\n");
        for (Map.Entry entry : this.screenUIDHashSetByMediaID.entrySet()) {
            Long mediaID;
            hashSet = (HashSet)entry.getValue();
            mediaID = (Long)entry.getKey();
            buf.append("mediaID: " + this.getMediaItem(new MediaID(mediaID)) + " screenUIDs:  ");
            iter2 = hashSet.iterator();
            lineLimit = 0;
            while (iter2.hasNext()) {
                screenUID = (Long)iter2.next();
                buf.append(WBUtils.uniqueIDAsHex(screenUID));
                if (iter2.hasNext() && lineLimit < 12) {
                    buf.append(", ");
                    ++lineLimit;
                    continue;
                }
                buf.append("\n  ");
                lineLimit = 0;
            }
        }
        buf.append("\nRefObjectHashSetByScreenUID(" + this.refObjectHashSetByScreenUID.size() + "):\n");
        for (Map.Entry entry : this.refObjectHashSetByScreenUID.entrySet()) {
            hashSet = (HashSet)entry.getValue();
            buf.append("screenUID: " + WBUtils.uniqueIDAsHex((Long)entry.getKey()) + ",  refObjects:\n");
            iter2 = hashSet.iterator();
            lineLimit = 0;
            while (iter2.hasNext()) {
                buf.append("  " + WBUtils.uniqueIDAsHex((Long)iter2.next()));
                if (iter2.hasNext() && lineLimit < 12) {
                    buf.append(", ");
                    ++lineLimit;
                    continue;
                }
                buf.append("\n  ");
                lineLimit = 0;
            }
        }
        buf.append("\nScreenUIDByRefObject(" + this.screenUIDByRefObject.size() + "):\n");
        for (Map.Entry entry : this.screenUIDByRefObject.entrySet()) {
            screenUID = (Long)entry.getValue();
            buf.append("refObject: " + WBUtils.uniqueIDAsHex((Long)entry.getKey()) + " screenUID: " + WBUtils.uniqueIDAsHex(screenUID) + "\n");
        }
        buf.append("\n");
        return buf.toString();
    }

    class MediaExchangeEntry {
        private MediaID mediaID;
        private RefCount refCount;

        public MediaExchangeEntry(MediaID mediaID, int refCount) {
            this.mediaID = mediaID;
            this.refCount = new RefCount(refCount);
        }

        public MediaExchangeEntry(WBInputStream istr) {
            try {
                this.mediaID = MediaID.streamToObject(istr);
                this.refCount = new RefCount(istr.readShort());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.mediaID.toString() + ", ref: " + this.refCount;
        }

        public MediaID getMediaID() {
            return this.mediaID;
        }

        public RefCount getRefCount() {
            return this.refCount;
        }

        public void objectToStream(WBOutputStream ostr) {
            try {
                this.mediaID.objectToStream(ostr);
                ostr.writeShort(this.refCount.getRefCount());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

